/*
 * $Log:   V:/Flite/archives/TrueFFS5/Src/FLIOCTL.H_V  $
 * 
 *    Rev 1.2   Feb 14 2001 02:16:16   oris
 * Updated inquire capabilities ioctl.
 *
 *    Rev 1.1   Feb 13 2001 01:49:06   oris
 * Added the following new IO Controls:
 *   FL_IOCTL_FORMAT_VOLUME2,
 *   FL_IOCTL_FORMAT_PARTITION,
 *   FL_IOCTL_BDTL_HW_PROTECTION,
 *   FL_IOCTL_BINARY_HW_PROTECTION,
 *   FL_IOCTL_OTP,
 *   FL_IOCTL_CUSTOMER_ID,
 *   FL_IOCTL_UNIQUE_ID,
 *   FL_IOCTL_NUMBER_OF_PARTITIONS,
 *   FL_IOCTL_SUPPORTED_FEATURES,
 *   FL_IOCTL_SET_ENVIRONMENT_VARIABLES,
 *   FL_IOCTL_PLACE_EXB_BY_BUFFER,
 *   FL_IOCTL_WRITE_IPL,
 *   FL_IOCTL_DEEP_POWER_DOWN_MODE,
 * and BDK_GET_INFO type in FL_IOCTL_BDK_OPERATION
 *
 *    Rev 1.0   Feb 04 2001 11:38:18   oris
 * Initial revision.
 *
 */
/***********************************************************************************/
/*                        M-Systems Confidential                                   */
/*           Copyright (C) M-Systems Flash Disk Pioneers Ltd. 1995-99              */
/*                         All Rights Reserved                                     */
/***********************************************************************************/
/*                            NOTICE OF M-SYSTEMS OEM                              */
/*                           SOFTWARE LICENSE AGREEMENT                            */
/*                                                                                 */
/*      THE USE OF THIS SOFTWARE IS GOVERNED BY A SEPARATE LICENSE                 */
/*      AGREEMENT BETWEEN THE OEM AND M-SYSTEMS. REFER TO THAT AGREEMENT           */
/*      FOR THE SPECIFIC TERMS AND CONDITIONS OF USE,                              */
/*      OR CONTACT M-SYSTEMS FOR LICENSE ASSISTANCE:                               */
/*      E-MAIL = info@m-sys.com                                                    */
/***********************************************************************************/

#ifndef FLIOCTL_H
#define FLIOCTL_H





#define FL_IOCTL_START   0

/* In every call to flIOctl function, the irFlags field in the structure
   IOreq should hold one of the following: */
typedef enum {                          /* Status code for operation.
					   A zero value indicates success,
					   other codes are the extended
					   DOS codes. */
             flOK                  = 0,
             flBadFunction         = 1,
             flFileNotFound        = 2,
             flPathNotFound        = 3,
             flTooManyOpenFiles    = 4,
             flNoWriteAccess       = 5,
             flBadFileHandle       = 6,
             flDriveNotAvailable   = 9,
             flNonFATformat        = 10,
             flFormatNotSupported  = 11,
             flNoMoreFiles         = 18,
             flWriteProtect        = 19,
             flBadDriveHandle      = 20,
             flDriveNotReady       = 21,
             flUnknownCmd          = 22,
             flBadFormat           = 23,
             flBadLength           = 24,
             flDataError           = 25,
             flUnknownMedia        = 26,
             flSectorNotFound      = 27,
             flOutOfPaper          = 28,
             flWriteFault          = 29,
             flReadFault           = 30,
             flGeneralFailure      = 31,
             flDiskChange          = 34,
             flVppFailure          = 50,
             flBadParameter        = 51,
             flNoSpaceInVolume     = 52,
             flInvalidFATchain     = 53,
             flRootDirectoryFull   = 54,
             flNotMounted          = 55,
	         flPathIsRootDirectory = 56,
             flNotADirectory       = 57,
             flDirectoryNotEmpty   = 58,
             flFileIsADirectory    = 59,
             flAdapterNotFound     = 60,
             flFormattingError     = 62,
             flNotEnoughMemory     = 63,
             flVolumeTooSmall      = 64,
             flBufferingError      = 65,
             flFileAlreadyExists   = 80,
             flIncomplete          = 100,
             flTimedOut            = 101,
             flTooManyComponents   = 102
  }  FLStatus;

typedef enum{FL_IOCTL_GET_INFO = FL_IOCTL_START,
             FL_IOCTL_DEFRAGMENT,
             FL_IOCTL_WRITE_PROTECT,
             FL_IOCTL_MOUNT_VOLUME,
             FL_IOCTL_FORMAT_VOLUME,
             FL_IOCTL_BDK_OPERATION,
             FL_IOCTL_DELETE_SECTORS,
             FL_IOCTL_READ_SECTORS,
             FL_IOCTL_WRITE_SECTORS,
             FL_IOCTL_FORMAT_PHYSICAL_DRIVE,
             FL_IOCTL_FORMAT_LOGICAL_DRIVE,
             FL_IOCTL_BDTL_HW_PROTECTION,
             FL_IOCTL_BINARY_HW_PROTECTION,
             FL_IOCTL_OTP,
             FL_IOCTL_CUSTOMER_ID,
             FL_IOCTL_UNIQUE_ID,
             FL_IOCTL_NUMBER_OF_PARTITIONS,
             FL_IOCTL_INQUIRE_CAPABILITIES,
             FL_IOCTL_SET_ENVIRONMENT_VARIABLES,
             FL_IOCTL_PLACE_EXB_BY_BUFFER,
             FL_IOCTL_WRITE_IPL,
             FL_IOCTL_DEEP_POWER_DOWN_MODE 
} flIOctlFunctionNo;





/* In every call to flIOctl function, the irData field in the structure
   IOreq should point to the structure defined below. The fields
   inputRecord and outputRecord should point to structures which are
   specific to each IOctl function as defined in this file. */
typedef struct {
  void  *inputRecord;
  void  *outputRecord;
} flIOctlRecord;


/* General output record that returns only status. */
typedef struct {
  FLStatus status;
} flOutputStatusRecord;



/* Input and output records for the different IOCTL functions: */
/* =========================================================== */

/* Get disk information (FL_IOCTL_GET_INFO) */
/* Input record: NULL */
/* Output record: */
typedef struct {
  unsigned long logicalSectors;     /*  number of logical sectors */
  unsigned long bootAreaSize;       /*  boot area size              */
  unsigned long  baseAddress;       /*  physical base address       */
  unsigned short flashType;         /*  JEDEC id of the flash       */
  unsigned long physicalSize;       /*  physical size of the media  */
  unsigned short physicalUnitSize;  /*  Erasable block size         */
  char DOCType;                     /*  DiskOnChip type (MDoc/Doc2000) */
  char lifeTime;                    /*  Life time indicator for the media (1-10)     */
                                    /*  1 - the media is fresh,                 */
                                    /*  10 - the media is close to its end of life */

  char driverVer[10];               /*  driver version (NULL terminated string) */
  char OSAKVer[10];                 /*  OSAK version that driver is based on (NULL terminated string) */
  unsigned long cylinders;              /*  Media.....                          */
  unsigned long heads;		    	/*            geometry......		*/
  unsigned long sectors; 	    	/*    			parameters.	*/
} VolumeInfoRecord;

typedef struct {
  VolumeInfoRecord info;  /* VolumeInfoRecord is defined in blockdev.h */
  FLStatus status;
} flDiskInfoOutput;
/* Output record: flOutputStatusRecord */
/*************************************************************************/

/* Defragment volume (FL_IOCTL_DEFRAGMENT) */
/* Input record: */
typedef struct {
  long requiredNoOfSectors;   /* Minimum number of sectors to make available.
                                  if -1 then a quick garbage collection operation
                                 is invoked. */
} flDefragInput;
/* Outout record: */
typedef struct {
  long actualNoOfSectors;     /* Actual number of sectors available */
  FLStatus status;
} flDefragOutput;

/*************************************************************************/

/* Write protection (FL_IOCTL_WRITE_PROTECT) */
/* Input record: */
typedef struct {
  unsigned char type;        /*  type of operation: FL_PROTECT\FL_UNPROTECT */
  long password[2];          /*  password  */
} flWriteProtectInput;
#define FL_PROTECT   0
#define FL_UNPROTECT 1
#define FL_UNLOCK    2
/* Output record: flOutputStatusRecord */

/*************************************************************************/
/* Mount volume (FL_IOCTL_MOUNT_VOLUME) */
/* Input record: */
typedef struct {
  unsigned char type;        /*  type of operation: FL_MOUNT\FL_DISMOUNT */
} flMountInput;
#define FL_MOUNT          0
#define FL_DISMOUNT        1
/* Output record: flOutputStatusRecord */
/*************************************************************************/
typedef struct {
DWORD   length;
        /* The size of the usable storage space. The size will be
           rounded upwards to a multiplication of a block size.
           The size of the last partition will calculated automatically,
           but if the requested size is greater then the remaining space
           an error code will be returned,. Requesting zero size for any
	   partition but the last will generate an flBadParameters status. */

unsigned        noOfSpareUnits;
        /* BDTL needs at least one spare erase unit in order to function
           as a read/write media. It is possible to specify more than one
           spare unit, which takes more media space. The advantage of
           specifying more than one spare unit is that if one of the flash
           erase units becomes bad and inerasable in the future, then one
           of the spare units can replace it. In that case, a second spare
           unit enables TrueFFS to continue its read/write functionality,
           whereas if no second spare unit is available the media goes into
           read-only mode. The standard value used is 1 */

unsigned char   flags;

#define TL_FORMAT_COMPRESSION  1  /* Add ZIP format on the media      */
#define TL_FORMAT_FAT          2  /* Add FAT format on the media      */
#define TL_OLD_FORMAT          4  /* Format with 1 sector per cluster */

unsigned char            volumeId[4];  /* DOS partition identification number		  */

unsigned char  *     volumeLabel;  /*DOS partition label string. If NULL, no label */

unsigned char	noOfFATcopies;
        /* It is customary to format DOS media with two FAT copies. The
           first copy is always used, but more copies make it possible
           to recover if the FAT becomes corrupted (a rare occurrence).
           On the other hand, this slows down performance and uses media
           space. The standard value used is 2. */
    /* The key for the protection*/
unsigned char   protectionKey[8];   /* The key for the protection*/
unsigned char   protectionType;
       /* PROTECTABLE          - Can recieve protection           */
       /* READ_PROTECTED       - Protect against read operations  */
       /* WRITE_PROTECTED      - Protect against write operations */
       /* LOCK_ENABLED         - Enables the hardware lock signal */
       /* PROTECTABLE          - This partition can be protected  */
       /* CHANGABLE_PROTECTION - protection type can be changed */

} BDTLPartitionFormatParams;

/*------------------------------------------------*/
/* User binary Partition Format Parameters record */
/*------------------------------------------------*/

typedef struct {
DWORD length;	/* Required number of good blocks in the  partition.*/

unsigned char sign[4];	/* signature of the binary  partition to format. */

unsigned char signOffset;
	/* offset of the signature. This value should  always be 8, but it
	   can also accept 0 for backwards compatibility reasons. Note that
	   if the offset is 0 EDC\ECC is neutralized */
unsigned char   protectionKey[8];   /* The key for the protection*/
unsigned char   protectionType;   /* Protection attributes */
#define PROTECTABLE           1  /* partition can recieve protection */
#define READ_PROTECTED        2  /* partition is read protected      */
#define WRITE_PROTECTED       4  /* partition is write protected     */
#define LOCK_ENABLED          8  /* HW lock signal is enabled        */
#define LOCK_ASSERTED         16 /* HW lock signal is asserted       */
#define KEY_INSERTED          32 /* key is inserted (not currently   */
#define CHANGEABLE_PROTECTION 64 /* changeable protection area type   */


} BinaryPartitionFormatParams;
/* Output record: flOutputStatusRecord */
/*************************************************************************/
/* Format volume (FL_IOCTL_FORMAT_PHYSICAL_DRIVE) */
/* Input record: */


typedef struct {

/*****************************/
/* Device formatting section */
/*****************************/

unsigned        percentUse;
     	/* BDTL performance depends on how full the flash media is,
		   becoming slower as the media becomes closer to 100% full.
		   It is possible to avoid the worst-case performance
		   (at 100% full) by formatting the media to less than 100%
		   capacity, thus guaranteeing free space at all times. This
		   of course sacrifices some capacity. The standard value
		   used is 98 */

unsigned char             noOfBDTLPartitions;
		/* Indicates the number of BDTL partitions (1 to 4). 0 will
           cause a single STD_BDTL_PARAMS BDTL partition */

unsigned char             noOfBinaryPartitions;
       /* Indicates the number of binary partitions (up to 3). 0 will
	      cause formatting with no binary partition. This value is ignored
	  unless the TL_BINARY_FORMAT flag is set in the irFlags f the ioreq */

BDTLPartitionFormatParams   BDTLPartitionInfo[4];
       /* BDTL partition information array  */

BinaryPartitionFormatParams binaryPartitionInfo[3];

       /* Binary partition information array*/

/***********************************/
/* Special format features section */
/***********************************/

unsigned char            cascadedDeviceNo;
	/* Reserved for individual cascaded device formatting 0..n. For
	   this value to have any affect the TL_SINGLE_CHIP_FORMATTING flag
	   should be set in the flags field.*/

unsigned char            noOfCascadedDevices;
	/* This field must be supplied in order to perform a format of
	   a single chip that will be eventualy assembeled as a cascaded
	   device. The field should specify the number of DiskOnChips
	   that will be eventualy cascaded on the targe plaform */

FLStatus (*progressCallback)(int totalUnitsToFormat,
			     int totalUnitsFormattedSoFar);
	/* Progress callback routine, will be called if not NULL.
	   The callback routine is called after erasing each unit,
	   and its parameters are the total number of erase units
	   to format and the number erased so far.
	   The callback routine returns a Status value. A value of
	   OK (0) allows formatting to continue. Any other value
	   will abort the formatting with the returned status code. */

/* Note the following section is not used by for DiskOnChips */
/*************************************************************/

DWORD        	vmAddressingLimit;
	    /* A part of the FTL Virtual Map always resides in RAM. The
	       RAM part is the one that is used to address the part of
	       the media below the VM addressing limit. Reading and
		   writing to this part is usually faster to some degree.
		   The downside is that the bigger the limit, the more RAM
		   size is required.
		   To get the extra RAM requirement in bytes, divide the
		   limit by 128 or by 256, depending on whether you
		   specified in #2.9 more than 32 or not, respectively.
		   The minimum VM limit is 0.
		   The standard value to use is 0x10000 (first 64 KBytes) */

unsigned	    embeddedCISlength;
		/* Length in bytes of CIS to embed after the unit header */


char embeddedCIS[0x100];
		/* The unit header is structured as a beginning of a PCMCIA
		   'tuple' chain (a CIS). The unit header contains a
		   data-organization tuple, which points past the end of the
		   unit header to a location which usually just contains
		   hex FF's which mark an 'end-of-tuple-chain'. Optionally,
		   it is possible to embed an entire CIS chain at this
		   location. If so, 'embeddedCISlength' marks the length in
		   bytes */
} UserFormatParams2;
typedef struct {
  byte formatType;   /* type of format*/

#define    TL_QUICK_MOUNT_FORMAT       1   /* Add the quick mount format     */
#define    TL_SINGLE_FLOOR_FORMATTING  4   /* Format a single device from cacaded bunch*/
#define    TL_LEAVE_BINARY_AREA        8   /* Leave the previous binary area */


  UserFormatParams2 fp;              /* Format parameters structure */
} flUserFormatPhysicalInput;
/*************************************************************************/

#define BDK_SIGNATURE_NAME              4
#define BDK_MAX_BUFFER									0x400
typedef struct {
unsigned char oldSign[BDK_SIGNATURE_NAME];
unsigned char newSign[BDK_SIGNATURE_NAME];
unsigned char signOffset;
unsigned long startingBlock;
unsigned long length;
unsigned char flags;
unsigned char bdkBuffer[BDK_MAX_BUFFER];
} UserBDKStruct;

typedef struct {
  unsigned char type;  /* type of operation: BDK_INIT_READ\BDK_READ\BDK_INIT_WRITE\ */
                       /* BDK_WRITE\BDK_ERASE\BDK_CREATE\BDK_GET_INFO               */
  UserBDKStruct bdkStruct; /* parameters for BDK operations (defined in docbdk.h)       */
} flUserBDKOperationInput;

typedef struct {
  flOutputStatusRecord statusRec;					/* The status of the operation*/
  UserBDKStruct bdkStruct; /* parameters for BDK operations (defined in docbdk.h)       */
} flUserBDKOperationOutput;

#define BDK_INIT_READ   0
#define BDK_READ        1
#define BDK_INIT_WRITE  2
#define BDK_WRITE       3
#define BDK_ERASE       4
#define BDK_CREATE      5
#define BDK_GET_INFO    6
/* Output record: flOutputStatusRecord */
/*************************************************************************/
/* BDK and BDTL protection operations: (FL_IOCTL_BINARY_HW_PROTECTION) */
/*                                     (FL_IOCTL_BDTL_HW_PROTECTION)   */
/*   insert key \ remove key \ identify \ change key \                 */
/*   change protection type \ change lock status                       */
/* Input record: */
typedef struct {
   unsigned char protectionType; /* Protection attributes */
#define PROTECTABLE           1  /* partition can recieve protection */
#define READ_PROTECTED        2  /* partition is read protected      */
#define WRITE_PROTECTED       4  /* partition is write protected     */
#define LOCK_ENABLED          8  /* HW lock signal is enabled        */
#define LOCK_ASSERTED         16 /* HW lock signal is asserted       */
#define KEY_INSERTED          32 /* key is inserted (not currently   */
#define CHANGEABLE_PROTECTION 64 /* changeable protection area type   */

   unsigned char key[8];             /* The new key to the change Key call         */
   unsigned char type;                     /* Operation type see list bellow             */
} flProtectionInput;
#define PROTECTION_INSERT_KEY   0
#define PROTECTION_REMOVE_KEY   1
#define PROTECTION_GET_TYPE     2
#define PROTECTION_DISABLE_LOCK 3
#define PROTECTION_ENABLE_LOCK  4
#define PROTECTION_CHANGE_KEY   5
#define PROTECTION_CHANGE_TYPE  6

/* Output record: */
typedef struct {
   byte protectionType;    /* see above */
   FLStatus status;
} flProtectionOutput;

/*************************************************************************/
/* One Time Programing operations: (FL_IOCTL_OTP */
/*   OTP size \ OTP read \ OTP write and lock    */
/* Input record: */
#define OTP_SIZE        1
#define OTP_READ        2
#define OTP_WRITE_LOCK        3


typedef struct {
long          length;                /* Length to read\write\size                                  */
long          usedSize;         /* The written size of the area \ Area offset */
unsigned char lockedFlag;       /* The area condition LOCKED_OTP (flflash.h)  */
unsigned char buffer[0x1800];                /* pointer to user buffer                                           */
int           type;                        /* defined bellow                             */
} UserOtpInput;

typedef struct {
long          length;                /* Length to read\write\size                                  */
long          usedSize;         /* The written size of the area \ Area offset */
unsigned char lockedFlag;       /* The area condition LOCKED_OTP */
#define LOCKED_OTP 1

unsigned char buffer[0x1800];                /* pointer to user buffer                                           */
flOutputStatusRecord      statusRec;                        /* defined bellow                             */
} UserOtpOutput;

/*************************************************************************/
/* Read customer ID (FL_IOCTL_CUSTOMER_ID) */
/* Input record: NULL */
/* Output record: */
typedef struct {
  unsigned char id[4];
  FLStatus status;
} flCustomerIdOutput;

/*************************************************************************/
/* Read unique ID (FL_IOCTL_UNIQUE_ID) */
/* Input record: NULL */
/* Output record: */
typedef struct {
  unsigned char id[16];
  FLStatus status;
} flUniqueIdOutput;
/*************************************************************************/
/* Read unique ID (FL_IOCTL_NUMBER_OF_PARTITIONS) */
/* Input record: NULL */
/* Output record: */
typedef struct {
  unsigned char noOfPartitions;
  FLStatus status;
} flCountPartitionsOutput;
/*************************************************************************/
/* Quary the device h/w and s/w capabilities (FL_IOCTL_INQUIRE_CAPABILITIES) */
/* Input record:   */
/* capabilities flags */
typedef enum{
   CAPABILITY_NOT_SUPPORTED           = 0,
   CAPABILITY_SUPPORTED               = 1,
   SUPPORT_UNERASABLE_BBT             = 2,
   SUPPORT_MULTIPLE_BDTL_PARTITIONS   = 3,
   SUPPORT_MULTIPLE_BINARY_PARTITIONS = 4,
   SUPPORT_HW_PROTECTION              = 5,
   SUPPORT_HW_LOCK_KEY                = 6,
   SUPPORT_CUSTOMER_ID                = 7,
   SUPPORT_UNIQUE_ID                  = 8,
   SUPPORT_DEEP_POWER_DOWN_MODE       = 9,
   SUPPORT_OTP_AREA                   = 10
}FLCapability;

typedef struct temp{
   FLCapability  capability;  
} flCapabilityInput;

typedef struct {
   FLCapability  capability;  
	 FLStatus status;
}flCapabilityOutput;
/*************************************************************************/
/* Set environment variables values (FL_IOCTL_SET_ENVIRONMENT_VARIABLES) */

/* Input record:  */
typedef enum {        /* Variable type code for flSetEnv routin */
      FL_IS_RAM_CHECK_ENABLED = 1,
      FL_NFTL_CACHE_ENABLED   = 2,
      FL_DOC_8BIT_ACCESS      = 3,
      FL_MULTI_DOC_ENABLED    = 4,
      FL_SET_POLICY           = 5,
      FL_SET_MAX_CHAIN        = 6
} FLEnvVars;


typedef struct {
  FLEnvVars      varName;  /* Enum describing the variable */
  int            varValue; /* New variable value           */
} flEnvVarsInput;
/* Output record: */
typedef struct {
  int   prevValue;   /* The previous value of the variable */
  FLStatus status;
} flEnvVarsOutput;

/*************************************************************************/
/* Write IPL area for doc2400 family (FL_IOCTL_WRITE_IPL) */
/* Input record:  */

#define IPL_MAX_SIZE			0x1000L
typedef struct {
	unsigned short   bufLen;       /* IPL data buffer length */
  unsigned char  buf[IPL_MAX_SIZE];       /* IPL data buffer        */
} flUserIplInput;

/* Output record: flOutputStatusRecord */
/*************************************************************************/
/* Place the device into and out of the power down mode (FL_IOCTL_DEEP_POWER_DOWN_MODE) */
typedef struct {
unsigned char state; /* DEEP_POWER_DOWN - low power consumption      */
                     /* otherwise       - regular power consumption  */
} flPowerDownInput;
#define DEEP_POWER_DOWN 1
/* Output record: flOutputStatusRecord */
/*************************************************************************/
/* Delete logical sectors (FL_IOCTL_DELETE_SECTORS) */
/* Input record: */
typedef struct {
  long firstSector;                /* First logical sector to delete */
  long numberOfSectors;                /* Number of sectors to delete */
} flDeleteSectorsInput;
/* Output record: flOutputStatusRecord */
/*************************************************************************/
/* read & write logical sectors (FL_IOCTL_READ_SECTORS & FL_IOCTL_WRITE_SECTORS) */
/* Input record: */
typedef struct {
  long firstSector;                  /* first logical sector */
  long numberOfSectors;         /* Number of sectors to read\write */
  char  *buf;               /* Data to read\write */
} flReadWriteInput;
/* Output record: */
typedef struct {
  long numberOfSectors;         /* Actual Number of sectors read\written */
  FLStatus status;
} flReadWriteOutput;
/*************************************************************************/
/* Place EXB file by buffers (FL_IOCTL_PLACE_EXB_BY_BUFFER) */
/* input record */
#define EXB_MAX_LEN 0x200L

typedef struct {
  unsigned char buf[EXB_MAX_LEN];  /* buffer of EXB file */
  unsigned long bufLen;     /* buffer length      */
  unsigned char exbFlags;   /*  EXB flags  */
#define	INSTALL_FIRST	1
#define EXB_IN_ROM      2
#define	QUIET		4
#define INT15_DISABLE   8
#define FLOPPY          0x10
#define SIS5598         0x20
#define EBDA_SUPPORT    0x40
#define NO_PNP_HEADER   0x80
#define LEAVE_EMPTY     0x100
                
  unsigned long exbWindow; /* explicitly set device window. 0 will automatcly set window */
} flUserPlaceExbInput;



#endif
