
/*
 * $Log:   V:/getparm.c_v  $
 * 
 *    Rev 3.2   12 Apr 1995 17:29:32   amirban
 * Hex values
 * 
 *    Rev 3.1   23 Feb 1995 18:33:38   amirban
 * Code unification
 * 
 *    Rev 3.0   05 Sep 1993 14:56:40   amirban
 * Initial revision.
 */

#include <string.h>
#include <stdlib.h>
#include "ioctltst.h"
#include "getparm.h"


char *getParm(char *arg, const char *parm)
{
  strupr(arg);
  int len = strlen(parm);

  if (memcmp(arg,parm,len)) {
	if (!(parm[len - 1] == '=' && arg[len - 1] == ':' &&
	  memcmp(arg,parm,len-1) == 0))
	  return NULL;
  }
  else if (parm[len - 1] != ':' && arg[len])
    return NULL;

  return arg + len;
}


long int getNumber(const char far*arg, unsigned radix)
{
  char *endPtr;
  long int num = 0;
  if ( (*arg == '0') && (*(arg+1) == 'X')) {
    arg+=2;
    while ( ((*arg >= '0') && (*arg <= '9')) || ((*arg >= 'A') && (*arg <= 'H')))
    {
     num *= 16;
     if ((*arg >= '0') && (*arg <= '9'))
	num += *arg - '0';
     else
	num += *arg - 'A' + 10;
     arg++;
    }
  }
  else
  {
    num = strtol(arg,&endPtr,radix);
    if (*endPtr == 'K') {
      num *= 0x400;
      endPtr++;
    }
    else if (*endPtr == 'M') {
      num *= 0X100000l;
      endPtr++;
    }
  }

  return num;
}


long int getDrive(const char far*arg, unsigned radix)
{
	switch (arg[0])
	{
	case 'C':
		return 0x80;
	case 'D':
		return 0x81;
	case 'E':
		return 0x82;
	case 'F':
		return 0x83;
	case 'G':
		return 0x84;
	case 'H':
		return 0x85;
	case 'I':
		return 0x86;
	case 'J':
		return 0x87;
	default:
		return 0x00;
    }
}





void Print_Ver(void)
{
  system("cls");

	PRINTF("\n                     I O C T L T S T - utility for DOS");
	PRINTF("\n                      %s, Last Update: %s", VERSION, DATE );
	PRINTF("\n                    %s", COPYRIGHT );
	PRINTF("\n                 ----------------------------------------\n\n");
}

void printHelp(void)
{
  PRINTF(" Usage: IOCTLtst /D:[drive]  /C:[command]  [/S:[sectors]] [/F:[first]]\n");
  PRINTF("                                           [/T:[type]]    [/P:[protection]]\n");
  PRINTF("                                           [/K:[key]]     [/B:[batch]]\r\n\n");
  PRINTF("   drive      - Drive letter of the Device, such as C, D, E, etc...\r\n");
  PRINTF("   command    - IOCTL command:GETINFO,  DELSECT, BDTLHW,   BINHW, DEFRAG\n");
  PRINTF("                              HWOTP,   CUSTOMER, UNIQUE,  DEEPOWER\r\n");
  PRINTF("   first      - first sector, used for DELSECT\r\n");
  PRINTF("   sectors    - Number of sectors, used for DELSECT, DEFRAG\r\n");
  PRINTF("   protection - Protection attributes (or with the following options\r\n");
  PRINTF("                1-PROTECTABLE, 2-READ_PROTECTED, 4-WRITE_PROTECTED,\r\n");
  PRINTF("                8-LOCK_ENABLED, 16-LOCK_ASSERTED, 32-KEY_INSERTED, \r\n");
  PRINTF("                64-CHANGEABLE_PROTECTION\r\n");
  PRINTF("   type       - Type of protection operation: 0-PROTECTION_INSERT_KEY,\r\n");
  PRINTF("                1-PROTECTION_REMOVE_KEY, 2-PROTECTION_GET_TYPE,\r\n");
  PRINTF("                3-PROTECTION_DISABLE_LOCK, 4-PROTECTION_ENABLE_LOCK,\r\n");
  PRINTF("                5-PROTECTION_CHANGE_KEY, 6-PROTECTION_CHANGE_TYPE.\r\n");
  PRINTF("   key        - An 8 byte protection key.\r\n");
  PRINTF("   batch      - Batch test.\r\n");
}




void PrintFLStatus(const FLStatus bStat)
{
	PRINTF("Return Status is ") ;
	switch(bStat)
	{
	case flOK:
		PRINTF("OK\n") ;
		break ;
	case flBadFunction:
		PRINTF("BadFunction\n") ;
		break ;
	case flFileNotFound:
		PRINTF("FileNotFound\n") ;
		break ;
	case flPathNotFound:
		PRINTF("PathNotFound\n") ;
		break ;
	case flTooManyOpenFiles:
		PRINTF("TooManyOpenFiles\n") ;
		break ;
	case flNoWriteAccess:
		PRINTF("NoWriteAccess\n") ;
		break ;
	case flBadFileHandle:
		PRINTF("BadFileHandle\n") ;
		break ;
	case flDriveNotAvailable:
		PRINTF("DriveNotAvailable\n") ;
		break ;
	case flNonFATformat:
		PRINTF("NonFATformat\n") ;
		break ;
	case flFormatNotSupported:
		PRINTF("FormatNotSupported\n") ;
		break ;
	case flNoMoreFiles:
		PRINTF("NoMoreFiles\n") ;
		break ;
	case flWriteProtect:
		PRINTF("WriteProtect\n") ;
		break ;
	case flBadDriveHandle:
		PRINTF("BadDriveHandle\n") ;
		break ;
	case flDriveNotReady:
		PRINTF("DriveNotReady\n") ;
		break ;
	case flUnknownCmd:
		PRINTF("UnknownCmd\n") ;
		break ;
	case flBadFormat:
		PRINTF("BadFormat\n") ;
		break ;
	case flBadLength:
		PRINTF("BadLength\n") ;
		break ;
	case flDataError:
		PRINTF("DataError\n") ;
		break ;
	case flUnknownMedia:
		PRINTF("UnknownMedia\n") ;
		break ;
	case flSectorNotFound:
		PRINTF("SectorNotFound\n") ;
		break ;
	case flOutOfPaper:
		PRINTF("OutOfPaper\n") ;
		break ;
	case flWriteFault:
		PRINTF("WriteFault\n") ;
		break ;
	case flReadFault:
		PRINTF("ReadFault\n") ;
		break ;
	case flGeneralFailure:
		PRINTF("GeneralFailure\n") ;
		break ;
	case flDiskChange:
		PRINTF("DiskChange\n") ;
		break ;
	case flVppFailure:
		PRINTF("VppFailure\n") ;
		break ;
	case flBadParameter:
		PRINTF("BadParameter\n") ;
		break ;
	case flNoSpaceInVolume:
		PRINTF("NoSpaceInVolume\n") ;
		break ;
	case flInvalidFATchain:
		PRINTF("InvalidFATchain\n") ;
		break ;
	case flRootDirectoryFull:
		PRINTF("RootDirectoryFull\n") ;
		break ;
	case flNotMounted:
		PRINTF("NotMounted\n") ;
		break ;
	case flPathIsRootDirectory:
		PRINTF("PathIsRootDirectory\n") ;
		break ;
	case flNotADirectory:
		PRINTF("NotADirectory\n") ;
		break ;
	case flDirectoryNotEmpty:
		PRINTF("DirectoryNotEmpty\n") ;
		break ;
	case flFileIsADirectory:
		PRINTF("FileIsADirectory\n") ;
		break ;
	case flAdapterNotFound:
		PRINTF("AdapterNotFound\n") ;
		break ;
	case flFormattingError:
		PRINTF("FormattingError\n") ;
		break ;
	case flNotEnoughMemory:
		PRINTF("NotEnoughMemory\n") ;
		break ;
	case flVolumeTooSmall:
		PRINTF("VolumeTooSmall\n") ;
		break ;
	case flBufferingError:
		PRINTF("BufferingError\n") ;
		break ;
	case flFileAlreadyExists:
		PRINTF("FileAlreadyExists\n") ;
		break ;
	case flIncomplete:
		PRINTF("Incomplete\n") ;
		break ;
	case flTimedOut:
		PRINTF("TimedOut\n") ;
		break ;
	case flTooManyComponents:
		PRINTF("TooManyComponents\n") ;
		break ;
	case flTooManyDrives:
		PRINTF("TooManyDrives\n") ;
		break ;
	case flTooManyBinaryPartitions:
		PRINTF("TooManyBinaryPartitions\n") ;
		break ;
	case flPartitionNotFound:
		PRINTF("PartitionNotFound\n") ;
		break ;
	case flFeatureNotSupported:
		PRINTF("FeatureNotSupported\n") ;
		break ;
	case flWrongVersion:
		PRINTF("WrongVersion\n") ;
		break ;
	case flTooManyBadBlocks:
		PRINTF("TooManyBadBlocks\n") ;
		break ;
	case flNotProtected:
		PRINTF("NotProtected\n") ;
		break ;
	case flUnchangeableProtection:
		PRINTF("UnchangableProection\n") ;
		break ;
	case flBadBBT:
		PRINTF("BadBBT\n") ;
		break ;
//	case flInterleaveError:
//		PRINTF("InterlreavError\n") ;
//		break ;
	case flWrongKey:
		PRINTF("WrongKey\n") ;
		break ;
	case flHWProtection:
		PRINTF("HWProtection\n") ;
		break ;
	case flTimeOut:
		PRINTF("TimeOut\n") ;
		break ;
	case flBadDownload:
		PRINTF("BadDownload\n") ;
		break ;
	default:
		PRINTF("Unknow status\n") ;
		break ;
	}

        PRINTF("\n");
}


