#include "ioctltst.h"


// ***************************************
// ** 					**
// ** MAIN - main function		**
// ** 					**
// ***************************************


int cdecl main(int argc,char *argv[])
{
	unsigned char drive = 0;
	char 		*argVal	= NULL;
	long 		sectors = -99;
	long	 	first = -99;
	char 		cmd [20];
	char 		batch = 0;
	char 		key[8];
	byte 		type = 99;
	byte		protectionType = 0;


	memset(key,1, 8);
	memset(cmd, 0, 20);
	

// Print version
  Print_Ver();

// Check Arguments
  if( argc < 3 ) {
	printHelp();
    return(EXIT_FAILURE);

  }

// Parse command line
  argv++;
  while( --argc > 0 ) {
	if( (argVal = getParm(*argv,"/D:")) != NULL )
	  drive = getDrive(argVal);
	else if( (argVal = getParm(*argv,"/C:")) != NULL )
	  strcpy(cmd, getParm(*argv,"/C:")) ;
	else if( (argVal = getParm(*argv,"/S:")) != NULL )
		sectors = getNumber(argVal);
	else if( (argVal = getParm(*argv,"/F:")) != NULL )
	  first = getNumber(argVal);
	else if( (argVal = getParm(*argv,"/P:")) != NULL )
	  protectionType = getNumber(argVal);
	else if( (argVal = getParm(*argv,"/T:")) != NULL )
		type = getNumber(argVal);
	else if( (argVal = getParm(*argv,"/K:")) != NULL )
		strcpy(key, getParm(*argv,"/K:")) ;
	else if( (argVal = getParm(*argv,"/B")) != NULL )
		batch = 1 ;


	else {
			printHelp();
			return(EXIT_FAILURE);
		}
		argv++;
	}



	if (drive < 0x80)
	{
	 PRINTF ("Drive Letter must be specified: C, D, E, etc...\r\n");
	 printHelp();
	}

	if ( batch )
		batchTest(drive, key);
	else if ( strcmp ( cmd, "GETINFO")==0)
	{
   getInfo(drive);
  }
  else if ( strcmp ( cmd, "DELSECT")==0)
  {
   if ((sectors <= 0))
   {
    PRINTF("sector number must be above 0\n");
    return(EXIT_FAILURE);
   }
   if ((first <= 0))
   {
    PRINTF("first parameter must be above 0\n");
    return(EXIT_FAILURE);
   }
   deleteSectors(drive, first, sectors);
  }
  else if ( strcmp ( cmd, "DEFRAG")==0)
  {
   if ((sectors <= 0) && (sectors != -1))
   {
    PRINTF("sector number must be above 0 or -1\n");
    return(EXIT_FAILURE);
   }
   defragVolume(drive, sectors);
  }
  else if ( strcmp ( cmd, "BDTLHW")==0)
  {
   if (type>6)
   {
    PRINTF("Available protection types are 1 to 6\n");
    return(EXIT_FAILURE);
   }
   protectHWBDTL (drive, protectionType, key, &type);
	}
  else if ( strcmp ( cmd, "BINHW")==0)
  {
   if (type>6)
   {
    PRINTF("Available protection types are 1 to 6\n");
    return(EXIT_FAILURE);
   }
   protectHWBIN (drive, protectionType, key, &type);
  }
  else if ( strcmp ( cmd, "HWOTP")==0)
  {
    hwOTP(drive);
  }
  else if ( strcmp ( cmd, "CUSTOMER")==0)
  {
   getCustomerID(drive);
  }
  else if ( strcmp ( cmd, "UNIQUE")==0)
  {
   getUniqueID(drive);
  }
  else if ( strcmp ( cmd, "DEEPOWER")==0)
  {
   deepPowerMode(drive);
  }
  else
  {
	  PRINTF ("Unknown command, Use known /C:[command].\n");
	  printHelp();
  }


 return (EXIT_SUCCESS);
}


// ***************************************
// ** 					**
// ** EXECUTECOMMAND - execute ioctl by	**
// ** 		       by int 13	**
// ** 					**
// ** INPUT - ioctl command	        **
// **       - driver volume		**
// ** 	    - input/output record	**
// ** 					**
// ** OUTPUT - none			**
// ** 					**
// ***************************************

void executeCommand(unsigned char drive,IOCTLRequestPacket *command,struct REGPACK *sreg)
{
// Send special command to INT 13, function: IOCTL_WRITE.
  sreg->r_ax = 0x1F00;       // IOCTL_WRITE
  sreg->r_dx = drive ;       // Drive: 0x80 - C, 0x81 - D, etc
  sreg->r_bx = FP_OFF(command);
  sreg->r_es = FP_SEG(command);
  intr(DISK, sreg);
}


// ***************************************
// ** 					**
// ** DEFRAGEVOLUME - defragment volume	**
// ** 		      ioctl operation	**
// ** 					**
// ** INPUT - number of sectors         **
// **       - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************

FLStatus defragVolume (unsigned char drive, dword sectors)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;

  strcpy(request.id,DEFRAG_IOCTL);
  request.DiskInput  = (flDefragInput far*)malloc(sizeof(flDefragInput));
  request.DiskOutput = (flDefragOutput far*)malloc(sizeof(flDefragOutput));

  ((flDefragInput far*)request.DiskInput)->requiredNoOfSectors = sectors;
  executeCommand(drive,&request,&reg);
  status = ((flDefragOutput far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  sectors =((flDefragOutput far*)(request.DiskOutput))->actualNoOfSectors;
  PRINTF ("Defrag finished, actual sector free is: %ld\n",sectors);
  PrintFLStatus(status);
  free (request.DiskInput);
  free (request.DiskOutput);
  return(status);
}

// ***************************************
// ** 					**
// ** GETINFO - Get volume information	**
// ** 		      ioctl operation	**
// ** 					**
// ** INPUT - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************

FLStatus getInfo(unsigned char drive)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  flDiskInfoOutput far* outRec;
  struct REGPACK reg;

  strcpy(request.id,GET_INFO_IOCTL);
  request.DiskInput  = NULL;
  request.DiskOutput = (flDiskInfoOutput far*)malloc(sizeof(flDiskInfoOutput));
  memset (request.DiskOutput, 0,sizeof(flDiskInfoOutput));
  outRec =(flDiskInfoOutput far*) request.DiskOutput;
  executeCommand(drive,&request,&reg);
  status = outRec->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  PRINTF("GetInfo IOCTL retrieved the following data:\n");
	PRINTF("\tNumber of logical sectors      - 0x%lx\n",outRec->info.logicalSectors);
  PRINTF("\tBoot area size                 - 0x%lx\n",outRec->info.bootAreaSize);
  PRINTF("\tPhysical base address (hex)    - 0x%lx\n",outRec->info.baseAddress);
  PRINTF("\tFlash type                     - 0x%x\n",outRec->info.flashType);
  PRINTF("\tPhysical size of media         - 0x%lx\n",outRec->info.physicalSize);
  PRINTF("\tPhysical erasable unit size    - 0x%x\n",outRec->info.physicalUnitSize);
  PRINTF("\tDOC Type code                  - 0x%x\n",outRec->info.DOCType);
  PRINTF("\tDOC lifetime data (1-10)       - %d\n",outRec->info.lifeTime);
  PRINTF("\tDriver version                 - %s\n",outRec->info.driverVer);
  PRINTF("\tOSAK version                   - %s\n",outRec->info.OSAKVer);
  PRINTF("\tMedia geometry: (size = cylinders * heads * sectors * 512):\n");
  PRINTF("\tcylinders                      - %ld\n",outRec->info.cylinders);
  PRINTF("\theads                          - %ld\n",outRec->info.heads);
  PRINTF("\tsectors                        - %ld\n\n",outRec->info.sectors);
  PrintFLStatus(status);
  free (request.DiskOutput);
  return(status);
}




// ***************************************
// ** 					**
// ** DELETESECTORS - delete sectors	**
// ** 		      ioctl operation	**
// ** 					**
// ** INPUT - first sector to erase     **
// ** 	    - number of sectors	to erase**
// **       - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus deleteSectors(unsigned char drive, long firstSector, long numberOfSectors)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;

  /* Delete Sectors Input/Output structure */
  strcpy(request.id,DELETE_SECTORS_IOCTL);
  request.DiskInput  = (DeleteSectorsInput far*)malloc(sizeof(DeleteSectorsInput));
  request.DiskOutput = (OutputStatusRecord far*)malloc(sizeof(OutputStatusRecord));
  ((DeleteSectorsInput far*)request.DiskInput)->firstSector = firstSector;
  ((DeleteSectorsInput far*)request.DiskInput)->numberOfSectors = numberOfSectors;
  executeCommand(drive,&request,&reg);
  status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  PRINTF("Sector %ld till %ld were deleted.\n",firstSector, numberOfSectors+firstSector );
  PrintFLStatus(status);
  free (request.DiskInput);
  free (request.DiskOutput);
  return(status);
}




// ***************************************
// ** 					**
// ** HWOTP - hardware otp ioctl        **
// **	      operation			**
// ** 					**
// ** INPUT - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus hwOTP(char drive)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;
  byte buf[10];

  memcpy( buf, "ZTAK REMO", 9 );

  strcpy(request.id,HW_OTP_IOCTL);
  request.DiskInput  = (flOtpInput far*)malloc(sizeof(flOtpInput));;
	((flOtpInput far*)(request.DiskInput))->type = 1;
  ((flOtpInput far*)(request.DiskInput))->length = 100;
  ((flOtpInput far*)(request.DiskInput))->usedSize = 0;
  ((flOtpInput far*)(request.DiskInput))->buffer = buf;
  request.DiskOutput = (OutputStatusRecord far*)malloc(sizeof(OutputStatusRecord));
  executeCommand(drive,&request,&reg);
  status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
	if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }

  PRINTF("OTP area information:\n");
  PRINTF("\tOTP size: %ld\n",((flOtpInput far*)(request.DiskInput))->length );
  PRINTF("\tOTP used: %ld\n",((flOtpInput far*)(request.DiskInput))->usedSize );
  if( ((flOtpInput far*)(request.DiskInput))->lockedFlag == 1 )
	PRINTF("\tOTP locked\n");
  else
	PRINTF("\tOTP unlocked\n");

  PrintFLStatus(status);
  free (request.DiskOutput);
  return(status);
}



// ***************************************
// ** 					**
// ** GETCUSTOMERID -  get customer ID  **
// **	      	       ioctl operation	**
// ** 					**
// ** INPUT - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus getCustomerID(char drive)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;

  /* Delete Sectors Input/Output structure */
  strcpy(request.id,CUSTOMER_ID_IOCTL);
  request.DiskInput  = NULL;
  request.DiskOutput = (flCustomerIdOutput far*)malloc(sizeof(flCustomerIdOutput));
  executeCommand(drive,&request,&reg);
  status = ((flCustomerIdOutput far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
	{
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  PRINTF("The customer ID of the chip is - %x\n",((flCustomerIdOutput far*)(request.DiskOutput))->id);
  PrintFLStatus(status);
  free (request.DiskOutput);
  return(status);
}



// ***************************************
// ** 					**
// ** GETUNIQUEID -  get unique ID  	**
// **	      	     ioctl operation	**
// ** 					**
// ** INPUT - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus getUniqueID (char drive)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;

  /* Delete Sectors Input/Output structure */
  strcpy(request.id,UNIQUE_ID_IOCTL);
  request.DiskInput  = NULL;
	request.DiskOutput = (flUniqueIdOutput far*)malloc(sizeof(flUniqueIdOutput));
  executeCommand(drive,&request,&reg);
  status = ((flUniqueIdOutput far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  PRINTF("The unique ID of the chip is - ");
  for( int i=0;i<16;i++)
	PRINTF("%x ",((flUniqueIdOutput far*)(request.DiskOutput))->id[i]);
  PRINTF("\n");
  PrintFLStatus(status);
  free (request.DiskOutput);
  return(status);
}



// ***************************************
// ** 					**
// ** DEEPPOWERMODE - deep power down  	**
// **	      	  mode ioctl operation	**
// ** 					**
// ** INPUT - driver volume		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus deepPowerMode(char drive)
{
	IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;

  /* DeepPoworDown Input/Output structure */
  strcpy(request.id,DEEPOWER_MODE_IOCTL);
  request.DiskInput  = (PowerDownInput far*)malloc(sizeof(PowerDownInput));
  request.DiskOutput = (OutputStatusRecord far*)malloc(sizeof(OutputStatusRecord));
  ((PowerDownInput far*)(request.DiskInput))->state = POWER_DOWN_ON;
  executeCommand(drive,&request,&reg);
  status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  PRINTF("POWER DOWN MODE - ON\n");
  PrintFLStatus(status);
  free (request.DiskOutput);
	return(status);
}


// ***************************************
// ** 					**
// ** PROTECTHWBDTL - hardware protection*
// **	      	      ioctl operation	**
// ** 					**
// ** INPUT - driver volume		**
// ** 	      protection type		**
// ** 	      operation type		**
// ** 	      key number		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus protectHWBDTL (char drive, byte protectType, unsigned char* key, byte *type)
{
  IOCTLRequestPacket request;
  FLStatus status = flOK;
  struct REGPACK reg;
  flProtectionInput far* in;
  OutputStatusRecord far* out;


  strcpy(request.id,BDTL_HW_PROTECTION_IOCTL);
  request.DiskInput  = (flProtectionInput far*)malloc(sizeof(flProtectionInput));
  request.DiskOutput = (OutputStatusRecord far*)malloc(sizeof(OutputStatusRecord));
  ((flProtectionInput far*)request.DiskInput)->protectionType = protectType;
  memcpy(((flProtectionInput far*)request.DiskInput)->key,key,8);
  ((flProtectionInput far*)request.DiskInput)->type =*type;
  executeCommand(drive,&request,&reg);
  status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  if(*type == 2)
	PRINTF ("Protection type = %d   \n",((flProtectionInput far*)request.DiskInput)->protectionType);
  if(*type == 0)
	PRINTF ("Insert Key succeeded   \n");
  if(*type == 1)
	PRINTF ("remove Key succeeded   \n");
  if(*type == 3)
	PRINTF ("Disable Lock succeeded   \n");
  if(*type == 4)
	PRINTF ("Enable Lock succeeded   \n");
  if(*type == 5)
	PRINTF ("Change Key succeeded   \n");
  if(*type == 6)
	PRINTF ("Set Protection succeeded   \n");
  PrintFLStatus(status);
  *type = ((flProtectionInput far*)request.DiskInput)->protectionType;
  free (request.DiskOutput);
  return(status);
}

// ***************************************
// ** 					**
// ** PROTECTHWBDK - hardware protection**
// **	      	      ioctl operation	**
// ** 					**
// ** INPUT - driver volume		**
// ** 	      protection type		**
// ** 	      operation type		**
// ** 	      key number		**
// ** 					**
// ** OUTPUT - FLstatus recieved from   **
// ** 	       the driver		**
// ** 					**
// ***************************************
FLStatus protectHWBIN (char drive, byte protectType, unsigned char* key, byte *type)
{
  IOCTLRequestPacket request;
	FLStatus status = flOK;
  struct REGPACK reg;
  flProtectionInput far* in;
  OutputStatusRecord far* out;


  strcpy(request.id,BIN_HW_PROTECTION_IOCTL);
  request.DiskInput  = (flProtectionInput far*)malloc(sizeof(flProtectionInput));
  request.DiskOutput = (OutputStatusRecord far*)malloc(sizeof(OutputStatusRecord));
  ((flProtectionInput far*)request.DiskInput)->protectionType = protectType;
  memcpy(((flProtectionInput far*)request.DiskInput)->key,key,8);
  ((flProtectionInput far*)request.DiskInput)->type =*type;
  executeCommand(drive,&request,&reg);
  status = ((OutputStatusRecord far*)(request.DiskOutput))->status;
  if( reg.r_flags & CF )
  {
	free (request.DiskInput);
	free (request.DiskOutput);
	PRINTF("Fail, DOS error: %x  \n",reg.r_ax);
	return(status);
  }
  if(*type == 2)
	PRINTF ("Protection type = %d   \n",((flProtectionInput far*)request.DiskInput)->protectionType);
  if(*type == 0)
	PRINTF ("Insert Key succeeded   \n");
  if(*type == 1)
	PRINTF ("remove Key succeeded   \n");
  if(*type == 3)
	PRINTF ("Disable Lock succeeded   \n");
  if(*type == 4)
	PRINTF ("Enable Lock succeeded   \n");
  if(*type == 5)
	PRINTF ("Change Key succeeded   \n");
  if(*type == 6)
	PRINTF ("Set Protection succeeded   \n");
  PrintFLStatus(status);
  *type = ((flProtectionInput far*)request.DiskInput)->protectionType;
  free (request.DiskOutput);
  return(status);
}



