#ifndef _NTIOCTL_H_
#define _NTIOCTL_H_

#define FL_IOCTL_START   0

#include "flioctl.h"

#define FILE_DEVICE_TFFS_IOCTL		0x8000
#define ACCESS_DEVICE_TFFS_IOCTL	0x800


#define IOCTL_TFFS_GET_INFO										\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_GET_INFO),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_DEFRAGMENT									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_DEFRAGMENT),		\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_WRITE_PROTECT								\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_WRITE_PROTECT),	\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_MOUNT_VOLUME									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_MOUNT_VOLUME),		\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_FORMAT_VOLUME								\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_FORMAT_VOLUME),	\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_BDK_OPERATION								\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_BDK_OPERATION),	\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_DELETE_SECTORS								\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_DELETE_SECTORS),	\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_READ_SECTORS									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_READ_SECTORS),		\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_WRITE_SECTORS								\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_WRITE_SECTORS),	\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_NUMBER_OF_PARTITIONS									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_NUMBER_OF_PARTITIONS),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_CUSTOMER_ID									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_CUSTOMER_ID),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_EXTENDED_WRITE_IPL									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_EXTENDED_WRITE_IPL),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFSFL_UNIQUE_ID									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_UNIQUE_ID),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFSFL_INQUIRE_CAPABILITIES									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_INQUIRE_CAPABILITIES),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_DEEP_POWER_DOWN_MODE									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_DEEP_POWER_DOWN_MODE),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_FORMAT_PHYSICAL_DRIVE									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,							\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_FORMAT_PHYSICAL_DRIVE),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_BDTL_HW_PROTECTION									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,												\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_BDTL_HW_PROTECTION),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_BINARY_HW_PROTECTION									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,												\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_BINARY_HW_PROTECTION),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_OTP									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,												\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_OTP),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_PLACE_EXB_BY_BUFFER									\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,												\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_PLACE_EXB_BY_BUFFER),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_EXTENDED_ENVIRONMENT_VARIABLES				\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,												\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_EXTENDED_ENVIRONMENT_VARIABLES),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TFFS_VERIFY_VOLUME				\
	CTL_CODE( FILE_DEVICE_TFFS_IOCTL,												\
		(ACCESS_DEVICE_TFFS_IOCTL + FL_IOCTL_VERIFY_VOLUME),			\
		METHOD_BUFFERED, FILE_ANY_ACCESS )

#ifdef IOCTL_INTERFACE


/* General output record that returns only status. */
/*typedef struct {
  FLStatus status;
} flOutputStatusRecord;
*/

#ifdef  WRITE_EXB_IMAGE
#define EXB_BUFFER_SIZE		0x200
#endif /*WRITE_EXB_IMAGE*/

#ifdef FORMAT_VOLUME
#ifdef FL_LOW_LEVEL
typedef struct {
/*****************************/
/* Device formatting section */
/*****************************/
byte      percentUse;
     	/* BDTL performance depends on how full the flash media is,
		   becoming slower as the media becomes closer to 100% full.
		   It is possible to avoid the worst-case performance
		   (at 100% full) by formatting the media to less than 100%
		   capacity, thus guaranteeing free space at all times. This
		   of course sacrifices some capacity. The standard value
		   used is 98 */
byte             noOfBDTLPartitions;
		/* Indicates the number of BDTL partitions (1 to 4). 0 will
           cause a single STD_BDTL_PARAMS BDTL partition */
byte            noOfBinaryPartitions;
       /* Indicates the number of binary partitions (up to 3). 0 will
	      cause formatting with no binary partition. This value is ignored
	  unless the TL_BINARY_FORMAT flag is set in the irFlags f the ioreq */
BDTLPartitionFormatParams   BDTLPartitionInfo[4];
       /* BDTL partition information array  */
BinaryPartitionFormatParams binaryPartitionInfo[3];
       /* Binary partition information array*/
/***********************************/
/* Special format features section */
/***********************************/
#ifdef WRITE_EXB_IMAGE
byte            exbBuffer[EXB_BUFFER_SIZE];
	/* A buffer containing the EXB file. Optionaly this file can
	   contain only the first 512 bytes of the file while the rest
	   will be sent using consequitive calls to flPlaceExbByBuffer */
dword           exbBufferLen;     /* Size of the given EXB buffer */
dword           exbLen; /* The specific size to leave for the EXB */
word            exbWindow; /* Set explicit DiskOnChip window base */
byte            exbFlags; /* For the flags list see doc2exb.h */
#endif /* WRITE_EXB_IMAGE */
byte            cascadedDeviceNo;
	/* Reserved for individual cascaded device formatting 0..n. For
	   this value to have any affect the TL_SINGLE_CHIP_FORMATTING flag
	   should be set in the flags field.*/
byte            noOfCascadedDevices;
	/* This field must be supplied in order to perform a format of
	   a single chip that will be eventualy assembeled as a cascaded
	   device. The field should specify the number of DiskOnChips
	   that will be eventualy cascaded on the targe plaform */
FLStatus (*progressCallback)(int totalUnitsToFormat,
			     int totalUnitsFormattedSoFar);
	/* Progress callback routine, will be called if not NULL.
	   The callback routine is called after erasing each unit,
	   and its parameters are the total number of erase units
	   to format and the number erased so far.
	   The callback routine returns a Status value. A value of
	   OK (0) allows formatting to continue. Any other value
	   will abort the formatting with the returned status code. */
/* Note the following section is not used by for DiskOnChips */
/*************************************************************/
dword        	vmAddressingLimit;
	    /* A part of the FTL Virtual Map always resides in RAM. The
	       RAM part is the one that is used to address the part of
	       the media below the VM addressing limit. Reading and
		   writing to this part is usually faster to some degree.
		   The downside is that the bigger the limit, the more RAM
		   size is required.
		   To get the extra RAM requirement in bytes, divide the
		   limit by 128 or by 256, depending on whether you
		   specified in #2.9 more than 32 or not, respectively.
		   The minimum VM limit is 0.
		   The standard value to use is 0x10000 (first 64 KBytes) */
word	    embeddedCISlength;
		/* Length in bytes of CIS to embed after the unit header */
byte embeddedCIS[0x100];
		/* The unit header is structured as a beginning of a PCMCIA
		   'tuple' chain (a CIS). The unit header contains a
		   data-organization tuple, which points past the end of the
		   unit header to a location which usually just contains
		   hex FF's which mark an 'end-of-tuple-chain'. Optionally,
		   it is possible to embed an entire CIS chain at this
		   location. If so, 'embeddedCISlength' marks the length in
		   bytes */
} UserFormatParams2;


typedef struct {
  byte formatType;   /* type of format as defined in blockdev.h */
  UserFormatParams2 fp;              /* Format parameters structure (defined in flformat.h) */
} flUserFormatPhysicalInput;
#endif /* FL_LOW_LEVEL */
#endif /* FORMAT_VOLUME */

#ifdef BDK_ACCESS
#define BDK_MAX_BUFFER									0x400
typedef struct {
byte oldSign[BDK_SIGNATURE_NAME];
byte newSign[BDK_SIGNATURE_NAME];
byte signOffset;
dword startingBlock;
dword length;
byte flags;
byte bdkBuffer[BDK_MAX_BUFFER];
} UserBDKStruct;

typedef struct {
  byte partitionNumber;
  byte type;  /* type of operation: BDK_INIT_READ\BDK_READ\BDK_INIT_WRITE\ */
                       /* BDK_WRITE\BDK_ERASE\BDK_CREATE\BDK_GET_INFO               */
  UserBDKStruct bdkStruct; /* parameters for BDK operations (defined in docbdk.h)       */
} flUserBDKOperationInput;

typedef struct {
  flOutputStatusRecord statusRec;					/* The status of the operation*/
  UserBDKStruct bdkStruct; /* parameters for BDK operations (defined in docbdk.h)       */
} flUserBDKOperationOutput;
#endif /* BDK_ACCESS  */

#ifdef HW_PROTECTION
typedef struct {
   byte partitionNumber;
   byte protectionType;    /* see flflash.h for the protection attributes */
   byte key[8];            /* The new key to the change Key call          */
   byte type;              /* Operation type see list bellow              */
} flBDKProtectionInput;
#endif /* HW_PROTECTION */

#ifdef HW_OTP
typedef struct {
unsigned long          length;                /* Length to read\write\size                                  */
unsigned long          usedSize;         /* The written size of the area \ Area offset */
byte lockedFlag;       /* The area condition LOCKED_OTP (flflash.h)  */
byte buffer[0x1800];                /* pointer to user buffer                                           */
word           type;                        /* defined bellow                             */
} UserOtpInput;

typedef struct {
long          length;                /* Length to read\write\size                                  */
long          usedSize;         /* The written size of the area \ Area offset */
byte					lockedFlag;       /* The area condition LOCKED_OTP (flflash.h)  */
byte					buffer[0x1800];                /* pointer to user buffer                                           */
flOutputStatusRecord      statusRec;                        /* defined bellow                             */
} UserOtpOutput;
#endif /* HW_OTP */

#ifdef FL_LOW_LEVEL
#ifdef WRITE_EXB_IMAGE
typedef struct {
  byte  buf[EXB_BUFFER_SIZE];  /* buffer of EXB file */
  dword bufLen;     /* buffer length      */
  byte exbFlags;   /* a combination of EXB flags see flPlaceExbByBuffer routine  */
                            /* The list of flags is defined in doc2exb.h                  */
  word exbWindow; /* explicitly set device window. 0 will automatcly set window */
} flUserPlaceExbInput;
#endif /* WRITE_EXB_IMAGE */
#define IPL_MAX_SIZE			0x1000L
typedef struct {
	byte	buf[IPL_MAX_SIZE];  /* IPL data buffer        */
	word  flags;							/* IPL flags (see flflash.h) */
	word	bufLen;							/* IPL data buffer length */
} flUserIplInput;
#endif /* FL_LOW_LEVEL */


#endif /* IOCTL_INTERFACE */


#endif /* _NTIOCTL_H_ */
