/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.JobQueue;
import auth.sdk.JobQueueEntry;
import auth.sdk.Log;
import auth.sdk.TaskListener;
import auth.utauthd.AuthRecord;
import auth.utauthd.CallBack;
import auth.utauthd.Configuration;
import auth.utauthd.DaemonManager;
import auth.utauthd.DeviceManager;
import auth.utauthd.SessionId;
import auth.utauthd.Terminal;
import auth.utauthd.utauthd;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SessionManager
extends DaemonManager
implements Runnable,
TaskListener {
    private Vector fifo = new Vector();
    private static int smcount = 0;
    private static Method m_terminate = null;
    private static JobQueue jobQueue = null;
    private static String devMgrId = DeviceManager.getDefaultId();
    private AuthRecord authRecord = null;
    private static Object monitor = new Object();
    static /* synthetic */ Class class$auth$utauthd$AuthRecord;

    static {
        Log.debug((String)"Initializing Terminator");
        try {
            jobQueue = new JobQueue("Terminator");
            m_terminate = (class$auth$utauthd$AuthRecord != null ? class$auth$utauthd$AuthRecord : (class$auth$utauthd$AuthRecord = SessionManager.class$("auth.utauthd.AuthRecord"))).getMethod("terminate", Integer.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.configError((String)("Cannot get AuthRecord.terminate method" + noSuchMethodException));
            System.exit(1);
        }
        Log.debug((String)"Terminator Initialized");
    }

    private SessionManager(String string) {
        super("SessionManager", string, Configuration.sessionHost, Configuration.sessionPort);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void cleanup() {
        this.min = null;
        this.mout = null;
        try {
            this.socket.close();
        }
        catch (Exception exception) {}
        this.socket = null;
    }

    private String confirmation(Hashtable hashtable) {
        Object object = hashtable;
        synchronized (object) {
            while (!((Boolean)hashtable.get("done")).booleanValue()) {
                try {
                    hashtable.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.unexpectedError((String)("SessionManager.confirmation: " + interruptedException));
                }
            }
        }
        object = (String)hashtable.get("result");
        Log.debug((String)("SessionManager.confirmation: \"" + (String)object + "\""));
        return object;
    }

    public boolean destroySession(SessionId sessionId) {
        Hashtable hashtable;
        Throwable throwable = new Throwable("SessionManager.destroySession: ");
        throwable.fillInStackTrace();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        Log.debug((String)byteArrayOutputStream.toString());
        String string = "destroy " + sessionId.getId();
        try {
            hashtable = this.request(sessionId, string);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("sm destroy error: " + exception));
            return false;
        }
        String string2 = this.confirmation(hashtable);
        if (string2.startsWith("OK/destroy")) {
            this.sendMsgToDeviceManager(sessionId, string, false);
            return true;
        }
        return false;
    }

    private void empty(String string, boolean bl) {
        SessionId sessionId;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = "0";
        }
        int n = Integer.parseInt(string2);
        if (string3 != null) {
            try {
                sessionId = new SessionId(string3);
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("SessionManager " + (bl ? "terminate" : "empty") + "(\"" + string + "\"): invalid SessionId"));
                return;
            }
        } else {
            Log.unexpectedError((String)("SessionManager.empty: bad argument: \"" + string + "\""));
            return;
        }
        AuthRecord authRecord = AuthRecord.getBySid(sessionId);
        if (authRecord == null) {
            Log.notice((String)(String.valueOf(bl ? "TERMINATE" : "EMPTY") + ": inactive session"));
        } else {
            Log.notice((String)(String.valueOf(bl ? "TERMINATE" : "EMPTY") + ": ACTIVE session"));
            if (Configuration.terminateEnable) {
                SessionManager.terminate(authRecord, n, bl);
            } else {
                Log.notice((String)(String.valueOf(bl ? "TERMINATE" : "EMPTY") + ": empty session cleanup is disabled"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SessionManager getSessionManager(String string) {
        Log.debug((String)"Getting session manager ..");
        SessionManager sessionManager = (SessionManager)DaemonManager.getManager(string);
        if (sessionManager == null) {
            try {
                sessionManager = new SessionManager(string);
            }
            catch (Exception exception) {
                return null;
            }
            Object object = monitor;
            synchronized (object) {
                if (utauthd.attachInProgress) {
                    return null;
                }
                utauthd.attachInProgress = true;
            }
            object = sessionManager;
            synchronized (object) {
                Log.notice((String)("SessionManager.getSessionManager: Initiate callback to utsessiond at " + string));
                CallBack.setupCallBack(sessionManager);
                if (!sessionManager.initiateCallback()) {
                    Log.debug((String)"SessionManager: Session Mgr connection failed");
                    return null;
                }
                while (!sessionManager.isConnected()) {
                    try {
                        Log.debug((String)"SessionManager.getSessionManager: wait 5 mins");
                        sessionManager.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.unexpectedError((String)("SessionManager.getSessionManager: " + interruptedException));
                    }
                    if (sessionManager.isConnected()) {
                        Log.debug((String)("SessionManager.getSessionManager: socket connected : " + sessionManager.socket));
                        DaemonManager.addManager(string, sessionManager);
                        utauthd.attachInProgress = false;
                        break;
                    }
                    Log.notice((String)"SessionManager connection Not established yet..Continuing to wait for this connection");
                }
            }
        }
        if (sessionManager.isConnected()) return sessionManager;
        return null;
    }

    public static void init(String string) {
        utauthd.attachInProgress = false;
        SessionManager sessionManager = SessionManager.getSessionManager(string);
        if (sessionManager == null) {
            return;
        }
        Enumeration enumeration = DeviceManager.sidTbl.keys();
        while (enumeration.hasMoreElements()) {
            Terminal terminal;
            SessionId sessionId = (SessionId)enumeration.nextElement();
            AuthRecord authRecord = AuthRecord.getBySid(sessionId);
            if (authRecord == null || (terminal = authRecord.getTerminal()) == null) continue;
            terminal.lock();
            try {
                authRecord.disconnect("Force disconnect", true);
            }
            finally {
                Object var7_6 = null;
                terminal.unlock();
            }
        }
        DeviceManager.sidTbl.clear();
    }

    public boolean permit(SessionId sessionId, String string, String string2, String string3) {
        Hashtable hashtable;
        String string4 = "permit " + sessionId.getId() + " " + string + " " + string2;
        Log.debug((String)("SessionManager.permit: request \"" + string4 + "\""));
        String string5 = String.valueOf(string4) + string3;
        Log.debug((String)("SessionManager.permit: request \"" + string5 + "\""));
        try {
            hashtable = this.request(sessionId, string5);
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("SessionManager.permit: " + iOException));
            return false;
        }
        String string6 = this.confirmation(hashtable);
        if (string6.startsWith("OK/permit")) {
            this.sendMsgToDeviceManager(sessionId, string4, true);
            return true;
        }
        Log.unexpectedError((String)("SessionManager.permit: line=\"" + string6 + "\""));
        return false;
    }

    public static SessionId readActiveSessionId(String string) {
        SessionId sessionId;
        block5: {
            BufferedReader bufferedReader = null;
            sessionId = null;
            try {
                File file = new File(String.valueOf(Configuration.tokenDir) + File.separator + string.replace('.', File.separatorChar));
                if (file.exists()) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "8859_1"));
                    sessionId = new SessionId(bufferedReader.readLine());
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (Exception exception) {
                if (bufferedReader == null) break block5;
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (Exception exception2) {}
            }
        }
        Log.debug((String)("readActiveSessionId " + string + " " + sessionId));
        return sessionId;
    }

    private Hashtable request(SessionId sessionId, String string) throws IOException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(2);
        if (this.mout == null) {
            throw new IOException("Session Manager connection not available..");
        }
        if (sessionId != null) {
            hashtable.put("sid", sessionId);
        }
        hashtable.put("message", string);
        hashtable.put("thread", Thread.currentThread());
        hashtable.put("done", new Boolean(false));
        BufferedWriter bufferedWriter = this.mout;
        synchronized (bufferedWriter) {
            this.fifo.addElement(hashtable);
            Log.debug((String)("SessionManager.request: \"" + string + "\""));
            this.mout.write(string);
            this.mout.newLine();
            this.mout.flush();
        }
        return hashtable;
    }

    public boolean revoke(SessionId sessionId, String string) {
        Hashtable hashtable;
        String string2 = "revoke " + sessionId.getId() + " " + string;
        Log.debug((String)("revoke request: " + string2));
        try {
            hashtable = this.request(sessionId, string2);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("revoke error: " + exception));
            return false;
        }
        String string3 = this.confirmation(hashtable);
        if (string3.startsWith("OK/revoke")) {
            this.sendMsgToDeviceManager(sessionId, string2, false);
            return true;
        }
        return false;
    }

    public void run() {
        while (true) {
            Hashtable hashtable;
            Object object;
            String string;
            try {
                string = this.min.readLine();
                Log.debug((String)("SessionManager.run(): readLine() = " + string));
            }
            catch (SocketException socketException) {
                Log.unexpectedError((String)("SessionManager.run: " + socketException));
                this.cleanup();
                object = String.valueOf(Configuration.sessionHost) + ":" + Configuration.sessionPort;
                DaemonManager.wakeup((String)object, DaemonManager.SESSION_MANAGER);
                return;
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("SessionManager.run: " + exception));
                this.cleanup();
                return;
            }
            if (string == null) {
                Log.unexpectedError((String)"SessionManager.run: readLine returns null");
                this.cleanup();
                this.sendRevokeAllToDevMgr();
                return;
            }
            Log.debug((String)("SessionManager.run: <" + string + ">"));
            if (string.startsWith("terminated")) {
                this.empty(string, true);
                continue;
            }
            if (string.startsWith("empty")) {
                this.empty(string, false);
                continue;
            }
            try {
                hashtable = (Hashtable)this.fifo.elementAt(0);
                this.fifo.removeElementAt(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.unexpectedError((String)("SessionManager.run: No job to match with \"" + string + "\" " + arrayIndexOutOfBoundsException));
                System.exit(1);
                continue;
            }
            object = hashtable;
            synchronized (object) {
                hashtable.put("result", string);
                hashtable.put("done", new Boolean(true));
                hashtable.notifyAll();
            }
        }
    }

    private void sendMsgToDeviceManager(SessionId sessionId, String string, boolean bl) {
        block5: {
            DeviceManager deviceManager = (DeviceManager)DaemonManager.getManager(devMgrId);
            if (bl) {
                if (DeviceManager.existsSid(sessionId)) {
                    return;
                }
                DeviceManager.addSidToTbl(sessionId, string);
            } else {
                DeviceManager.rmSidFromTbl(sessionId);
            }
            if (deviceManager == null) break block5;
            try {
                deviceManager.sendMsg(string);
            }
            catch (Exception exception) {
                Log.debug((String)("SM.sendMsgToDeviceManager(): devMgr request failed: e = " + exception));
            }
        }
    }

    private void sendRevokeAllToDevMgr() {
        DeviceManager deviceManager = (DeviceManager)DaemonManager.getManager(devMgrId);
        if (deviceManager == null) {
            return;
        }
        Enumeration enumeration = DeviceManager.sidTbl.keys();
        while (enumeration.hasMoreElements()) {
            SessionId sessionId;
            try {
                sessionId = (SessionId)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            String string = (String)DeviceManager.sidTbl.get(sessionId);
            if (string == null) continue;
            String string2 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
            }
            String string4 = "revoke " + string2 + string3;
            try {
                deviceManager.sendMsg(string4);
                Log.debug((String)("SM.sendMsgToDeviceManager(): " + string4));
            }
            catch (Exception exception) {
                Log.debug((String)("SM.sendMsgToDeviceManager(): devMgr request failed: e = " + enumeration));
            }
        }
    }

    public SessionId sessionFactory(String string) {
        String string2;
        SessionId sessionId = null;
        sessionId = SessionManager.readActiveSessionId(string);
        if (sessionId != null) {
            return sessionId;
        }
        String string3 = "create " + string;
        Log.debug((String)("SessionManager.sessionFactory: sending: \"" + string3 + "\""));
        try {
            Hashtable hashtable = this.request(null, string3);
            string2 = this.confirmation(hashtable);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("SessionManager.sessionFactory: Cannot send create: " + exception));
            return null;
        }
        if (!string2.startsWith("OK/create")) {
            Log.unexpectedError((String)("SessionManager.sessionFactory: unable to create new session: \"" + string2 + "\""));
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        try {
            sessionId = new SessionId(string4);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("SessionManager.sessionFactory:invalid SID from utsessiond: " + exception));
            return null;
        }
        Log.debug((String)("SessionManager.sessionFactory: CORONA_SESSION=" + sessionId));
        return sessionId;
    }

    public synchronized void setSocket(Socket socket) {
        this.socket = socket;
        try {
            this.socket.setSoTimeout(Configuration.smtimeout);
        }
        catch (SocketException socketException) {
            Log.unexpectedError((String)("Cannot set socket timeout: " + socketException));
        }
        try {
            this.min = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "8859_1"));
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("Cannot derive BufferedReader: " + iOException));
            this.min = null;
            try {
                this.socket.close();
            }
            catch (IOException iOException2) {}
            this.socket = null;
        }
        try {
            if (this.socket != null) {
                this.mout = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "8859_1"));
            }
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("Cannot derive BufferedOutputStream: " + iOException));
            this.min = null;
            try {
                this.socket.close();
            }
            catch (IOException iOException3) {}
        }
        new Thread((Runnable)this, "SessionManager" + smcount++).start();
        Log.debug((String)("SessionManager.setSocket ready: " + socket));
        this.notifyAll();
    }

    public void taskEvent(Object object) {
        JobQueueEntry jobQueueEntry = (JobQueueEntry)object;
        Log.debug((String)"SessionManger.taskEvent:: locking terminal");
        AuthRecord authRecord = (AuthRecord)jobQueueEntry.param;
        Terminal terminal = authRecord.getTerminal();
        if (terminal == null) {
            return;
        }
        terminal.lock();
        JobQueueEntry jobQueueEntry2 = jobQueueEntry;
        synchronized (jobQueueEntry2) {
            try {
                block11: {
                    try {
                        jobQueueEntry.result = jobQueueEntry.method.invoke(jobQueueEntry.param, jobQueueEntry.args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Log.unexpectedError((String)("Sessionmanager:taskEvent " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + illegalAccessException));
                        System.exit(1);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Log.unexpectedError((String)("Sessionmanager:taskEvent: " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + invocationTargetException));
                        System.exit(1);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        Log.unexpectedError((String)("Sessionmanager:taskEvent: " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + noClassDefFoundError));
                        System.exit(1);
                    }
                    catch (Exception exception) {
                        jobQueueEntry.exception = exception;
                        if (jobQueueEntry.sync) break block11;
                        Log.unexpectedError((String)("Sessionmanager:taskEvent: " + exception));
                    }
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                Log.debug((String)"SessionManger.taskEvent:: releasing terminal");
                terminal.unlock();
                throw throwable;
            }
            Log.debug((String)"SessionManger.taskEvent:: releasing terminal");
            terminal.unlock();
            jobQueueEntry.done = true;
        }
    }

    private static void terminate(AuthRecord authRecord, int n, boolean bl) {
        try {
            jobQueue.submit((TaskListener)new SessionManager(null), (Object)authRecord, m_terminate, new Object[]{new Integer(n), new Boolean(bl)}, false);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("SessionManager.terminate: " + exception));
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " { fifo=" + this.fifo + "}";
    }
}

