/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.protocol.AuthWriter;
import auth.protocol.Protocol;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.Task;
import auth.sdk.TaskListener;
import auth.utauthd.Alarm;
import auth.utauthd.AuthModule;
import auth.utauthd.AuthRecord;
import auth.utauthd.Configuration;
import auth.utauthd.Crypto;
import auth.utauthd.DeadlockException;
import auth.utauthd.Mutex;
import auth.utauthd.SmartCardID;
import auth.utauthd.SmartCardIDException;
import auth.utauthd.WatchIO;
import auth.utauthd.WatchIOListener;
import auth.utauthd.WatchIORequest;
import auth.utauthd.Worker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Terminal
implements WatchIOListener,
TaskListener {
    private boolean valid = false;
    private int tagCtr = 0;
    private String msgTag;
    private boolean protocolErrorPending = false;
    private AuthRecord ar = null;
    private SmartCardID scId = null;
    private boolean scDone = false;
    private AuthWriter out = null;
    private BufferedInputStream in;
    private InputStreamReader reader;
    private Socket s;
    private String address;
    private InetAddress ipAddress;
    private int ipPort;
    private String lastInsertToken = null;
    private String buffer = null;
    private WatchIORequest wior = null;
    private int tokenSeq = 0;
    private int savedTokenSeq = 0;
    private int mtu = 0;
    private static final String NAMESPACE = "IEEE802";
    private String model = null;
    private String sn = null;
    private String namespace = null;
    private long pktCount = 0L;
    private long lossCount = 0L;
    private float connTime = 0.0f;
    private float idleTime = 0.0f;
    private long byteCount = 0L;
    private long latency = 0L;
    private String startRes = null;
    private String initState = null;
    private String barrierLevel = null;
    private Hashtable storedParams = new Hashtable();
    private boolean actionPending = false;
    private static File networksFile = null;
    private static File netmasksFile = null;
    private static long networksModTime = 0L;
    private static long netmasksModTime = 0L;
    private static Hashtable legalNetworks = null;
    private static long lastReadTime = 0L;
    private static Object connectionCounterLock = new Object();
    private static int connectionCounter = 0;
    private String debugName = null;
    private int keepAliveState = 0;
    private static final int KEEPALIVE_OK = 0;
    private static final int KEEPALIVE_PENDING = 1;
    private static final int KEEPALIVE_ERROR = 2;
    int errorCount = 0;
    static final int MAXERRORS = 1000;
    private Mutex mutex = new Mutex();
    private Crypto crypto = new Crypto();
    private String clientRand = null;
    private StringBuffer tokenSet = null;
    private final String CORONA_NAME = "corona";
    private final String SUNRAY_NAME = "SunRay";
    private String firstServer = null;

    public Terminal(Socket socket, String string) throws Exception {
        if (socket == null) {
            throw new Exception("Terminal instantiated with null");
        }
        this.msgTag = string;
        this.s = socket;
        this.ipAddress = socket.getInetAddress();
        this.ipPort = socket.getPort();
        this.address = this.ipAddress.getHostAddress();
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.reader = new InputStreamReader((InputStream)this.in, "8859_1");
        this.out = new AuthWriter(this.s.getOutputStream());
        Log.debug((String)"Terminal:: creating terminal object .. getting lock");
        this.lock();
        try {
            try {
                socket.setTcpNoDelay(true);
                this.s.setSoTimeout(Configuration.timeout);
                if (!Terminal.isNetworkAllowed(this.ipAddress)) {
                    Log.unexpectedError((String)("Connection from " + this.address + " is not allowed"));
                    this.protocolError("networkNotAllowed");
                } else {
                    this.valid = true;
                    this.debugName = "Terminal" + ++connectionCounter;
                    this.wior = new WatchIORequest(this.s, 1, this, true, this.debugName);
                    this.wior.setTimeout(Configuration.timeout);
                    WatchIO.add(this.wior);
                }
            }
            catch (SocketException socketException) {
                Log.unexpectedError((String)(String.valueOf(String.valueOf(this.s)) + " Cannot set socket timeout: " + socketException));
                this.close();
                Object var4_4 = null;
                Log.debug((String)"Terminal:: releasing lock after create terminal");
                this.unlock();
                return;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Log.debug((String)"Terminal:: releasing lock after create terminal");
            this.unlock();
            throw throwable;
        }
        Log.debug((String)"Terminal:: releasing lock after create terminal");
        this.unlock();
    }

    public void addToTokenSet(String string) {
        if (this.tokenSet == null || this.tokenSet.length() == 0) {
            this.tokenSet = new StringBuffer(string);
        } else if (this.tokenSet.toString().indexOf(string) == -1) {
            this.tokenSet.append("," + string);
        }
    }

    private static Long addrToLong(String string) {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreElements()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            l = l << 8 | (long)n;
        }
        return new Long(l & 0xFFFFFFFFFFFFFFFFL);
    }

    private boolean alreadyHasAR(String string, Hashtable hashtable) {
        Log.debug((String)"In already hasAR");
        if (this.ar.isTerminated()) {
            if (this.ar != null) {
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("cause", "terminated");
                if (!this.ar.message("discReq", hashtable)) {
                    this.ar = null;
                }
            }
            return false;
        }
        if (string.equals("controlRsp")) {
            this.ar.controlRsp(hashtable);
        } else {
            if (string.equals("connRsp")) {
                int n;
                String string2 = (String)hashtable.get("tokenSeq");
                if (string2 != null && (n = Integer.parseInt(string2)) != this.savedTokenSeq) {
                    return true;
                }
                String string3 = (String)hashtable.get("pn");
                this.crypto.processConnRsp(hashtable);
                return this.ar.connRsp(string3);
            }
            if (!string.equals("discRsp")) {
                if (string.equals("infoReq") || string.equals("infoRsp")) {
                    if (!this.ar.message(string, hashtable)) {
                        this.ar = null;
                    }
                } else {
                    if (string.equals("discReq")) {
                        String string4;
                        if (!this.ar.message(string, hashtable)) {
                            this.ar = null;
                        }
                        return (string4 = (String)hashtable.get("cause")) == null || !string4.equals("redirect");
                    }
                    this.protocolError("invalid message: " + string);
                    return false;
                }
            }
        }
        return true;
    }

    public InetAddress authIpa() {
        return this.ipAddress;
    }

    public int authPort() {
        return this.ipPort;
    }

    private boolean checkSmartCardMsg(String string, Hashtable hashtable) {
        try {
            if (string.equals("infoReq")) {
                String string2 = (String)hashtable.get("event");
                if (string2.equals("insert")) {
                    if (this.scId == null) {
                        try {
                            this.createSmartCardID(this, Configuration.scConfigData, Configuration.terminalTokens);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    this.scDone = this.processSmartCardMessage(string, hashtable);
                }
                if (string2.equals("remove")) {
                    boolean bl = true;
                    if (this.scId != null) {
                        bl = this.processSmartCardMessage(string, hashtable);
                    }
                    this.scDone = bl;
                }
            }
            if (string.equals("infoSmartCard")) {
                if (this.scId == null) {
                    Log.unexpectedError((String)"Terminal.checkSmartCardMsg:(1): SmartCardID is null");
                    this.scDone = false;
                    return false;
                }
                this.scDone = this.processSmartCardMessage(string, hashtable);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean cleanup(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("event");
        if (!string.equals("infoReq") || string2 == null || !string2.equals("insert")) {
            this.ar.destroy();
            this.ar = null;
            return true;
        }
        String string3 = "unclaimed token from: " + this.address + " sent: " + hashtable;
        this.protocolError(string3);
        return false;
    }

    public void clearTokenSet() {
        this.tokenSet = new StringBuffer("");
    }

    public void close() {
        Log.debug((String)"Terminal.close: BEGIN");
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"close:: Does not have required locks!");
            System.exit(1);
        }
        if (this.ar != null) {
            this.ar.destroy();
            this.ar = null;
        }
        this.valid = false;
        if (this.s != null) {
            this.disable();
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                Log.unexpectedError((String)("Terminal.close: " + iOException));
                System.exit(1);
            }
            this.s = null;
        }
        this.in = null;
        this.out = null;
        this.address = null;
        this.wior = null;
    }

    private boolean continueProcess(String string, Hashtable hashtable) {
        boolean bl = true;
        if (this.ar != null && this.ar.isTerminated()) {
            this.ar = null;
        }
        if (this.ar == null) {
            bl = this.requireNewAR(string, hashtable);
            return bl;
        }
        bl = this.alreadyHasAR(string, hashtable);
        return bl;
    }

    private void createSmartCardID(Terminal terminal, Vector vector, Vector vector2) throws Exception {
        try {
            this.scId = new SmartCardID(terminal, vector, vector2, this.getUniqueTag());
            Log.debug((String)("Terminal.createSmartCardID(): SmartCard object created: " + this.scId));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("Terminal.createSmartCardID(): new SmartCardId() failed " + exception));
            throw exception;
        }
    }

    public void disable() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"disable:: Does not have required locks!");
            System.exit(1);
        }
        WatchIO.remove(this.wior);
    }

    public void enable() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"enable:: Does not have required locks!");
            System.exit(1);
        }
        WatchIO.add(this.wior);
    }

    public String getAuthIPAandPortString() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"getAuthIPAandPortString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return String.valueOf(this.address) + "/" + this.ipPort;
        }
        return null;
    }

    public String getAuthPortString() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"getAuthPortString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return Integer.toString(this.ipPort);
        }
        return null;
    }

    public String getClientRandom() {
        return this.clientRand;
    }

    public String getFirstServer() {
        return this.firstServer;
    }

    public String getIPAddressString() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"getIPAddressString:: Does not have required locks!");
            return null;
        }
        if (this.valid) {
            return this.address;
        }
        return null;
    }

    public String getInitialState() {
        return this.initState;
    }

    public int getMTU() {
        return this.mtu;
    }

    public String getModel() {
        return this.model;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getResolution() {
        return this.startRes;
    }

    public String getSerialNumber() {
        return this.sn;
    }

    public Hashtable getStoredParams() {
        return this.storedParams;
    }

    public String getTerminalStats() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"getTerminalStats:: Does not have required locks!");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("terminalPackets=" + this.pktCount);
        stringBuffer.append("\nterminalLostPackets=" + this.lossCount);
        stringBuffer.append("\nterminalConnectTime=" + this.connTime);
        stringBuffer.append("\nterminalIdleTime=" + this.idleTime);
        stringBuffer.append("\nterminalBytes=" + this.byteCount);
        stringBuffer.append("\nterminalLatency=" + this.latency);
        stringBuffer.append("\nterminalBarrierLevel=" + this.barrierLevel);
        return stringBuffer.toString();
    }

    public String getTokenSet() {
        return this.tokenSet.toString();
    }

    public synchronized String getUniqueTag() {
        return String.valueOf(this.msgTag) + ":" + Integer.toHexString(this.tagCtr++);
    }

    public static void init() {
        networksFile = new File("/etc/inet/networks");
        netmasksFile = new File("/etc/inet/netmasks");
        networksModTime = networksFile.lastModified();
        netmasksModTime = netmasksFile.lastModified();
        legalNetworks = Terminal.readLegalNets();
    }

    private void insertRemove(Hashtable hashtable) {
        String string;
        String string2;
        String string3;
        String string4 = (String)hashtable.get("event");
        if (string4 == null) {
            return;
        }
        String string5 = (String)hashtable.get("rawType");
        if (string5 == null) {
            string5 = "unknown";
        }
        if ((string3 = (String)hashtable.get("rawId")) == null) {
            string3 = "unknown";
        }
        this.lastInsertToken = string2 = String.valueOf(string5) + "." + string3;
        Admin admin = Admin.getAdmin();
        if (admin == null) {
            return;
        }
        String string6 = (String)hashtable.get("hw");
        if (string6 == null) {
            string6 = "unknown";
        }
        if ((string = (String)hashtable.get("sn")) == null) {
            string = "unknown";
        }
        String string7 = String.valueOf(string6) + "." + string;
        if (string4.equals("insert")) {
            admin.userEvent(string2, string7, "n/a", -1, "insert", System.currentTimeMillis());
        } else if (string4.equals("remove")) {
            if (string2.equals("card.0") && this.lastInsertToken != null) {
                string2 = this.lastInsertToken;
            }
            this.lastInsertToken = null;
            admin.userEvent(string2, string7, "n/a", -1, "remove", System.currentTimeMillis());
        } else {
            admin.userEvent(string2, string7, "n/a", -1, "unknown", System.currentTimeMillis());
        }
    }

    public boolean isActionPending() {
        return this.actionPending;
    }

    private static boolean isNetworkAllowed(InetAddress inetAddress) {
        boolean bl = false;
        if (Configuration.allowLANConnections) {
            return true;
        }
        if (!Terminal.updateLegalNets()) {
            Log.configError((String)"Unable to update legal networks list");
            System.exit(1);
        }
        if (legalNetworks == null) {
            Log.configError((String)"Missing legal networks list");
            System.exit(1);
        }
        Long l = Terminal.addrToLong(inetAddress.getHostAddress());
        Enumeration enumeration = legalNetworks.keys();
        while (enumeration.hasMoreElements()) {
            Long l2 = (Long)enumeration.nextElement();
            Long l3 = (Long)legalNetworks.get(l2);
            if ((l & l3) != l2) continue;
            return true;
        }
        return false;
    }

    public void lock() {
        try {
            this.mutex.lock();
        }
        catch (DeadlockException deadlockException) {
            Log.unexpectedError((String)deadlockException.getMessage());
            deadlockException.printStackTrace();
            Log.notice((String)"System error !!! Server exiting.");
            System.exit(1);
        }
    }

    private String moreSmartCardProcessing(String string, Hashtable hashtable) {
        String string2;
        if (string.equals("infoSmartCard")) {
            Log.debug((String)("Terminal.moreSmartCardProcessing: change to infoReq from " + string));
            string = "infoReq";
        }
        if (string.equals("infoReq") && (string2 = (String)hashtable.get("event")).equals("remove")) {
            this.scId = null;
        }
        return string;
    }

    private boolean process(String string, Hashtable hashtable) {
        Log.debug((String)("PROCESS: " + string + hashtable));
        if (string.equals("keepAliveReq")) {
            this.startSmartCardIDTimer();
            if (!this.write("keepAliveCnf", null)) {
                Log.unexpectedError((String)"cannot send keepAliveCnf");
                return false;
            }
            if (hashtable.get("pktCount") != null) {
                this.pktCount = Long.parseLong((String)hashtable.get("pktCount"));
            }
            if (hashtable.get("lossCount") != null) {
                this.lossCount = Long.parseLong((String)hashtable.get("lossCount"));
            }
            if (hashtable.get("byteCount") != null) {
                this.byteCount = Long.parseLong((String)hashtable.get("byteCount"));
            }
            if (hashtable.get("idleTime") != null) {
                this.idleTime = Float.parseFloat((String)hashtable.get("idleTime"));
            }
            if (hashtable.get("connTime") != null) {
                this.connTime = Float.parseFloat((String)hashtable.get("connTime"));
            }
            if (hashtable.get("latency") != null) {
                this.latency = Long.parseLong((String)hashtable.get("latency"));
            }
            return true;
        }
        if (string.equals("keepAliveRsp")) {
            return true;
        }
        String string2 = (String)hashtable.get("terminalIPA");
        if (string2 == null) {
            hashtable.put("terminalIPA", this.address);
        }
        String string3 = (String)hashtable.get("event");
        String string4 = (String)hashtable.get("cause");
        if (string.equals("infoReq") && string3.equals("insert")) {
            String string5 = (String)hashtable.get("tokenSeq");
            if (string5 != null) {
                this.tokenSeq = Integer.parseInt((String)hashtable.get("tokenSeq"));
            }
            this.startRes = (String)hashtable.get("startRes");
            this.initState = (String)hashtable.get("initState");
            this.barrierLevel = (String)hashtable.get("barrierLevel");
            if (this.barrierLevel == null) {
                this.barrierLevel = "0";
            }
            this.mtu = (string5 = (String)hashtable.get("MTU")) != null ? Integer.parseInt(string5) : 1500;
            hashtable.put("rawType", hashtable.get("type"));
            hashtable.put("rawId", hashtable.get("id"));
            this.clientRand = (String)hashtable.get("clientRand");
        }
        if (!this.checkSmartCardMsg(string, hashtable)) {
            return false;
        }
        if ((string.equals("infoReq") || string.equals("infoSmartCard")) && this.scId != null) {
            if (this.scDone) {
                string = this.moreSmartCardProcessing(string, hashtable);
                hashtable.put("rawType", hashtable.get("type"));
                hashtable.put("rawId", hashtable.get("id"));
                Log.debug((String)"Terminal.process: Done processing smartcard");
            } else {
                Log.debug((String)"Terminal.process: Still processing smartcard");
                return true;
            }
        }
        string3 = (String)hashtable.get("event");
        string4 = (String)hashtable.get("cause");
        if (string.equals("infoReq")) {
            this.insertRemove(hashtable);
            this.setStoredParams(hashtable);
            this.clearTokenSet();
        }
        return this.continueProcess(string, hashtable);
    }

    private boolean processSmartCardMessage(String string, Hashtable hashtable) throws SmartCardIDException {
        Log.debug((String)"Terminal.processSmartCardMessage(): process smartcard");
        try {
            this.scDone = this.scId.process(string, hashtable);
            Log.debug((String)("Terminal.processSmartCardMessage: SmartCard.process() returns : " + this.scDone));
        }
        catch (SmartCardIDException smartCardIDException) {
            Log.unexpectedError((String)("Cannot obtain SmartCard ID: " + smartCardIDException.getMessage()));
            this.scId = null;
            this.scDone = false;
            throw smartCardIDException;
        }
        return this.scDone;
    }

    public void protocolError(String string) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"protocolError:: Does not have required locks!");
            return;
        }
        Log.unexpectedError((String)(String.valueOf(this.address) + " protocolError: " + string));
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("state", "disconnected");
            hashtable.put("error", string);
            this.write("protocolErrorInf", hashtable);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(String.valueOf(this.address) + " Error while processing protocolError: " + exception));
            Thread.currentThread();
            Thread.dumpStack();
        }
        this.close();
    }

    private void queueProtocolError(long l, String string) {
        long l2 = System.currentTimeMillis() + l;
        if (!this.protocolErrorPending) {
            this.protocolErrorPending = true;
            Vector<String> vector = new Vector<String>(2);
            vector.addElement("protocolError");
            vector.addElement(string);
            Alarm.queue(this, l2, vector, (byte)0);
        }
    }

    private static Hashtable readLegalNets() {
        Hashtable<Long, Long> hashtable = new Hashtable<Long, Long>();
        try {
            Object object;
            Object object2;
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(networksFile));
            while ((string = bufferedReader.readLine()) != null) {
                string.trim();
                if (string.length() == 0 || string.startsWith("#") || string.indexOf("# SUNRAY ADD") == -1 || !((StringTokenizer)(object2 = new StringTokenizer(string))).hasMoreTokens()) continue;
                ((StringTokenizer)object2).nextToken();
                object = ((StringTokenizer)object2).nextToken();
                hashtable.put(Terminal.addrToLong((String)object), new Long(0L));
            }
            bufferedReader.close();
            object2 = new BufferedReader(new FileReader(netmasksFile));
            while ((string = ((BufferedReader)object2).readLine()) != null) {
                string.trim();
                if (string.length() == 0 || string.startsWith("#")) continue;
                object = new StringTokenizer(string);
                Long l = Terminal.addrToLong(((StringTokenizer)object).nextToken());
                Long l2 = Terminal.addrToLong(((StringTokenizer)object).nextToken());
                if (!hashtable.containsKey(l)) continue;
                hashtable.put(l, l2);
            }
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("readLegalNets:" + exception));
            return null;
        }
        return hashtable;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readMessages() {
        var3_1 = true;
        block12: while (this.valid) {
            block25: {
                try {
                    var1_2 = this.in.available();
                }
                catch (Exception var4_4) {
                    Log.unexpectedError((String)("Terminal.readMesages: " + var4_4));
                    return false;
                }
                if (var3_1 && var1_2 < 1) {
                    ++this.errorCount;
                    if (this.errorCount > 1000) {
                        Log.notice((String)"readMessage::socket looping limit exceeded.Close it.");
                        return false;
                    }
                } else {
                    this.errorCount = 0;
                }
                if (var1_2 <= 0) {
                    if (!Configuration.nonBlockRead || !var3_1) break;
                    try {
                        var4_5 = this.s.getSoTimeout();
                        this.s.setSoTimeout(1);
                        var2_20 = this.in.read();
                        if (var2_20 == -1) {
                            Log.debug((String)"end of file. Close socket.");
                            return false;
                        }
                        Log.notice((String)("Read a byte after av was <=0 : " + (char)var2_20));
                        this.buffer = String.valueOf(this.buffer) + (char)var2_20;
                        this.s.setSoTimeout(var4_5);
                        break;
                    }
                    catch (InterruptedIOException v0) {
                        break;
                    }
                    catch (Exception var4_6) {
                        Log.unexpectedError((String)("Terminal.readMessages: " + var4_6));
                        return false;
                    }
                }
                var4_3 = new byte[var1_2];
                var5_7 = 0;
                try {
                    var5_7 = this.in.read(var4_3, 0, var1_2);
                    var3_1 = false;
                }
                catch (IOException var6_9) {
                    Log.unexpectedError((String)("Terminal.readMessages: in.read: " + var6_9));
                    return false;
                }
                catch (Exception var6_10) {
                    Log.unexpectedError((String)("Terminal.readMessages: catchall-2" + var6_10));
                    return false;
                }
                if (var5_7 != var1_2) {
                    Log.unexpectedError((String)("Terminal.readMessages: expected " + var1_2 + " bytes, got " + var5_7));
                }
                if (var5_7 <= 0) break block25;
                var6_11 = "";
                try {
                    var6_11 = new String(var4_3, "8859_1");
                }
                catch (UnsupportedEncodingException v1) {
                    Log.configError((String)"Terminal.readMessages: impossible");
                    System.exit(1);
                }
                this.buffer = this.buffer != null ? String.valueOf(this.buffer) + var6_11 : var6_11;
                ** GOTO lbl112
            }
            if (var5_7 > 0) ** GOTO lbl112
            Log.unexpectedError((String)"Terminal.readMessages: end of stream; socket closed.");
            return false;
lbl-1000:
            // 1 sources

            {
                var7_12 = this.buffer.substring(0, var6_8);
                Log.debug((String)("Terminal.processCompleteCommands: msg=\"" + var7_12 + "\""));
                this.buffer = this.buffer.substring(var6_8 + 1);
                var8_13 = Protocol.parse((String)var7_12);
                if (var8_13 == null) {
                    this.protocolError("does_not_parse");
                    if (this.buffer != null && this.buffer.length() > 0) {
                        Log.debug((String)("Terminal.readMessages: discard_a " + this.buffer.length() + "<" + this.buffer + ">"));
                    }
                    this.buffer = null;
                    continue block12;
                }
                var9_14 = (String)var8_13.get("_command");
                if (var9_14 == null) {
                    this.protocolError("missing command");
                    Log.debug((String)("Terminal.readMessages: discard_b " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    continue block12;
                }
                var8_13.remove("_command");
                var10_15 = (String)var8_13.get("hw");
                var11_16 = var10_15.toLowerCase().indexOf("corona");
                if (var11_16 != -1) {
                    var12_18 = new StringBuffer("");
                    var12_18.append(var10_15.substring(0, var11_16));
                    var12_18.append("SunRay");
                    var12_18.append(var10_15.substring(var11_16 + "corona".length(), var10_15.length()));
                    var8_13.put("hw", var12_18.toString());
                }
                var12_17 = false;
                try {
                    var12_17 = this.process(var9_14, var8_13);
                }
                catch (Exception var13_19) {
                    Log.unexpectedError((String)("Terminal.readMessages: process() failed with exception " + var13_19));
                    var13_19.printStackTrace();
                    System.out.println("Worker thread recovered from error. Continuing..");
                    Log.notice((String)"Worker thread recovered from error. Continuing..");
                    var12_17 = false;
                }
                if (!var12_17) {
                    Log.debug((String)("Terminal.readMessages: discard_c " + this.buffer.length() + "<" + this.buffer + ">"));
                    this.buffer = null;
                    this.close();
                    if (this.ar == null) continue block12;
                    this.ar.destroy();
                    this.ar = null;
                    continue block12;
                }
                if (this.buffer.length() <= 0) continue;
                Log.debug((String)("Terminal.readMessages: iOfNL=" + this.buffer.indexOf(10) + ", remainder=\"" + this.buffer + "\""));
lbl112:
                // 4 sources

                ** while ((var6_8 = this.buffer.indexOf((int)10)) != -1)
            }
lbl113:
            // 1 sources

        }
        return true;
    }

    private void recordTokenState(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("event");
        if (string.equals("infoReq")) {
            if (string2.equals("insert")) {
                this.ar.setTokenState(true);
            } else {
                this.ar.setTokenState(false);
            }
        }
    }

    public InetAddress renderIpa() {
        return this.ipAddress;
    }

    public int renderPort() {
        return this.ipPort;
    }

    private boolean requireNewAR(String string, Hashtable hashtable) {
        Log.debug((String)"In require newAR");
        if (string.equals("discRsp")) {
            if (this.actionPending) {
                return true;
            }
            return this.scDone ^ true;
        }
        if (string.equals("discReq")) {
            return false;
        }
        if (string.equals("controlRsp") || string.equals("protocolErrorReq")) {
            return true;
        }
        if (string.equals("connRsp")) {
            return false;
        }
        if (!string.equals("infoReq")) {
            this.protocolError("incorrect state");
            return false;
        }
        if (!this.setupAR(hashtable)) {
            return false;
        }
        this.addToTokenSet(String.valueOf(String.valueOf(hashtable.get("type"))) + "." + hashtable.get("id"));
        if (this.actionPending) {
            this.actionPending = false;
        }
        AuthenticationClient authenticationClient = AuthModule.select(hashtable, this.ar);
        Log.debug((String)("Client = " + authenticationClient));
        if (authenticationClient == null) {
            return this.cleanup(string, hashtable);
        }
        this.ar.setClient(authenticationClient);
        if (authenticationClient.getModuleName().startsWith("TerminalId")) {
            this.ar.insertToken = authenticationClient.getLocalName();
            this.clearTokenSet();
            this.addToTokenSet(this.ar.insertToken);
            this.addToTokenSet(authenticationClient.getGlobalName());
        } else {
            this.ar.insertToken = this.lastInsertToken;
            this.addToTokenSet(String.valueOf(String.valueOf(hashtable.get("type"))) + "." + hashtable.get("id"));
        }
        this.recordTokenState(string, hashtable);
        if (hashtable.get("savedType") != null) {
            this.storedParams.put("savedType", hashtable.get("savedType"));
        }
        Log.debug((String)"Terminal.requireNewAR(): calling ar.connReq");
        if (!this.ar.connReq(hashtable)) {
            this.protocolError("connReq failed: " + this.address);
            return false;
        }
        return true;
    }

    public void setActionPending(boolean bl) {
        this.actionPending = bl;
    }

    public void setRedirectedTokenSet(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("rawType");
        String string3 = (String)hashtable.get("rawId");
        this.tokenSet = new StringBuffer(String.valueOf(string2) + "." + string3);
        int n = string.indexOf(44);
        if (n != -1) {
            this.tokenSet.append(string.substring(n));
        }
    }

    public void setStoredParams(Hashtable hashtable) {
        this.storedParams = hashtable;
    }

    private boolean setupAR(Hashtable hashtable) {
        Log.debug((String)"In setupAR");
        this.model = (String)hashtable.get("hw");
        this.sn = (String)hashtable.get("sn");
        this.namespace = (String)hashtable.get("namespace");
        this.firstServer = (String)hashtable.get("firstServer");
        String string = (String)hashtable.get("fw");
        String string2 = (String)hashtable.get("pn");
        if (this.sn != null) {
            if (this.namespace == null) {
                this.namespace = NAMESPACE;
            }
        } else {
            this.protocolError("terminal must supply unique hw.sn params");
            return false;
        }
        String string3 = String.valueOf(this.namespace) + "." + this.sn;
        try {
            this.ar = new AuthRecord(this, string3, string, string2, this.address, this.mutex, this.crypto);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)(String.valueOf(this.address) + "Handleclient, AuthRecord: " + exception));
            exception.printStackTrace();
            this.close();
            return false;
        }
        return true;
    }

    private void startSmartCardIDTimer() {
        if (this.scId != null) {
            this.scId.tick();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void taskEvent(Object object) {
        block29: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            this.lock();
                            try {
                                boolean bl = true;
                                Task task = (Task)object;
                                short s = (Short)task.param;
                                if ((s & 1) != 0) {
                                    s = (short)(s & 0xFFFFFFFE);
                                    if (!this.readMessages()) {
                                        this.close();
                                    } else {
                                        this.keepAliveState = 0;
                                    }
                                }
                                if ((s & 8) != 0) {
                                    s = (short)(s & 0xFFFFFFF7);
                                    Log.unexpectedError((String)"Terminal.taskEvent: POLLERR");
                                    Object var3_5 = null;
                                    this.unlock();
                                    return;
                                }
                                if ((s & 0x10) != 0) {
                                    s = (short)(s & 0xFFFFFFEF);
                                    Log.unexpectedError((String)"Terminal.taskEvent: POLLHUP");
                                    break block25;
                                }
                                if ((s & 4) != 0) {
                                    s = (short)(s & 0xFFFFFFFB);
                                    Log.unexpectedError((String)"Terminal.taskEvent: POLLPRI");
                                    break block26;
                                }
                                if ((s & 0x20) != 0) {
                                    s = (short)(s & 0xFFFFFFDF);
                                    Log.unexpectedError((String)"Terminal.taskEvent: POLLNVAL");
                                    this.close();
                                    break block27;
                                }
                                if ((s & 0x1000) != 0) {
                                    s = (short)(s & 0xFFFFEFFF);
                                    switch (this.keepAliveState) {
                                        case 0: {
                                            try {
                                                if (this.write("keepAliveInf", null)) {
                                                    this.keepAliveState = 1;
                                                    break;
                                                }
                                                this.keepAliveState = 2;
                                            }
                                            catch (Exception exception) {
                                                Log.unexpectedError((String)"cannot send keepAliveInf");
                                                this.keepAliveState = 2;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            this.keepAliveState = 2;
                                            break;
                                        }
                                        case 2: {
                                            this.keepAliveState = 2;
                                            break;
                                        }
                                    }
                                    if (this.keepAliveState == 2) {
                                        this.close();
                                    }
                                }
                                if (s != 0) {
                                    Log.unexpectedError((String)("Terminal.taskEvent: ignored events: " + s));
                                    s = 0;
                                    break block28;
                                }
                                if (!this.actionPending) break block29;
                                if (this.storedParams.get("savedType") != null) {
                                    this.storedParams.put("type", this.storedParams.get("savedType"));
                                }
                                try {
                                    bl = this.continueProcess("infoReq", this.storedParams);
                                    this.actionPending = false;
                                }
                                catch (Exception exception) {
                                    Log.unexpectedError((String)("Failed in process: " + exception));
                                    exception.printStackTrace();
                                    bl = false;
                                }
                                if (bl) break block29;
                                this.close();
                                if (this.ar != null) {
                                    this.ar.destroy();
                                    this.ar = null;
                                }
                                break block29;
                            }
                            catch (Throwable throwable) {
                                Object var3_11 = null;
                                this.unlock();
                                throw throwable;
                            }
                        }
                        Object var3_6 = null;
                        this.unlock();
                        return;
                    }
                    Object var3_7 = null;
                    this.unlock();
                    return;
                }
                Object var3_8 = null;
                this.unlock();
                return;
            }
            Object var3_9 = null;
            this.unlock();
            return;
        }
        Object var3_10 = null;
        this.unlock();
        if (this.valid) {
            WatchIO.add(this.wior);
        }
    }

    public void taskEvent(Object[] objectArray) {
        block5: {
            String string = (String)objectArray[0];
            this.lock();
            try {
                if (string.equals("protocolError")) {
                    if (!this.protocolErrorPending) {
                        Object var4_3 = null;
                        this.unlock();
                        return;
                    }
                    String string2 = null;
                    if (objectArray.length > 1) {
                        string2 = (String)objectArray[1];
                    }
                    break block5;
                }
                Log.unexpectedError((String)("Terminal.alarmEvent: " + string));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        Object var4_4 = null;
        this.unlock();
    }

    public String toString() {
        String string;
        if (this.ar != null) {
            string = this.ar.toString();
            if (string.length() > 40) {
                string = String.valueOf(string.substring(0, 40)) + "...";
            }
        } else {
            string = "null";
        }
        return String.valueOf(this.debugName) + "(valid:" + this.valid + ", s:" + this.address + ", ar:" + string + ")";
    }

    public void unlock() {
        this.mutex.unlock();
    }

    private static synchronized boolean updateLegalNets() {
        if (!networksFile.exists()) {
            Log.configError((String)("updateLegalNets: file non-existent: " + networksFile));
            return false;
        }
        if (!netmasksFile.exists()) {
            Log.configError((String)("updateLegalNets: file non-existent: " + netmasksFile));
            return false;
        }
        networksModTime = networksFile.lastModified();
        netmasksModTime = netmasksFile.lastModified();
        if (networksModTime <= lastReadTime && netmasksModTime <= lastReadTime) {
            return true;
        }
        lastReadTime = System.currentTimeMillis();
        legalNetworks = Terminal.readLegalNets();
        return true;
    }

    public boolean watchIOEvent(short s, Object object) {
        Worker.begin(new Task((TaskListener)this, (Object)new Short(s), true));
        return false;
    }

    public boolean write(String string, Hashtable hashtable) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"write:: Does not have required locks!");
            System.exit(1);
        }
        if (this.valid) {
            if (string.equals("connInf") || string.equals("redirectInf")) {
                hashtable.put("tokenSeq", String.valueOf(this.tokenSeq));
                if (string.equals("connInf")) {
                    this.savedTokenSeq = this.tokenSeq;
                }
            }
            return this.out.write(string, hashtable);
        }
        return false;
    }
}

