/*
 * Decompiled with CFR 0.152.
 */
package auth.module.StartSession;

import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import java.util.Hashtable;

public class StartSessionClient
implements AuthenticationClient {
    protected AccessControl access;
    protected String myTokenType;
    protected String myTokenId;
    protected String localName;
    protected String globalName;
    protected Authentication module;
    protected String sessionType;
    protected String sessionOptions;

    public StartSessionClient() {
    }

    protected StartSessionClient(AccessControl access, Authentication module, String rawname, String logicalname, String sessionType, String sessionOptions) {
        this.myTokenType = null;
        this.myTokenId = null;
        this.access = access;
        this.module = module;
        this.sessionType = sessionType;
        this.sessionOptions = sessionOptions;
        if (this.sessionOptions != null) {
            this.sessionOptions.trim();
            if (this.sessionOptions.length() == 0) {
                this.sessionOptions = null;
            }
        }
        this.localName = rawname;
        this.globalName = logicalname;
    }

    public void close() {
    }

    public boolean connReq(Hashtable param) {
        this.myTokenType = (String)param.get("type");
        this.myTokenId = (String)param.get("id");
        if (this.myTokenType == null) {
            Hashtable<String, String> arg = new Hashtable<String, String>(3);
            arg.put("access", "denied");
            arg.put("cause", "invalid token type");
            this.access.send("discInf", arg);
            return false;
        }
        return this.access.connect("all connections allowed");
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getModuleName() {
        return this.module.getName();
    }

    public String getServiceInitCommand() {
        String command = this.sessionType != null ? this.access.getServiceStartCommand(this.sessionType) : this.access.getServiceStartCommand("default");
        if (this.sessionOptions != null) {
            command = String.valueOf(command) + " -- " + this.sessionOptions;
        }
        return command;
    }

    public String getSessionManagerId() {
        return String.valueOf(this.access.getDefaultSessionHost()) + ":" + this.access.getDefaultSessionPort();
    }

    public boolean message(String command, Hashtable param) {
        if (command.equals("infoReq")) {
            String event = (String)param.get("event");
            String type = (String)param.get("type");
            if (event != null && event.equals("remove") && type != null && (type.equals(this.myTokenType) || !this.myTokenType.equals("pseudo") && type.equals("card"))) {
                this.access.disconnect("token removed: " + this.myTokenType + "." + this.myTokenId);
                return false;
            }
            if (event != null && event.equals("insert")) {
                this.access.disconnect("token removed: " + this.myTokenType);
                return false;
            }
            return true;
        }
        if (command.equals("discReq")) {
            this.access.disconnect("discReq-or-terminated");
            return false;
        }
        return true;
    }
}

