/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.sdk.ParseOptions;
import auth.sdk.Syslog;
import auth.sdk.Utils;
import auth.utauthd.AuthRecord;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Configuration {
    static String configDir = String.valueOf(File.separator) + "etc" + File.separator + "opt" + File.separator + "SUNWut";
    static String tokenDir = String.valueOf(File.separator) + "var" + File.separator + "opt" + File.separator + "SUNWut" + File.separator + "tokens";
    static Hashtable terminals = new Hashtable(32);
    static Vector scConfigData = new Vector();
    protected static Properties props = new Properties();
    static File root;
    static int timeout;
    static int workers;
    static int maxStarting;
    static int controllers;
    static String namesFileName;
    static String policyFileName;
    static int port;
    static int cbport;
    static int gmport;
    static String deviceManagerHost;
    static int deviceManagerPort;
    static int gmKeepAliveInterval;
    static boolean enableMulticast;
    static String multicastAddress;
    static int multicastTTL;
    static String gmSignatureFile;
    static int cbtimeout;
    static int smtimeout;
    static boolean allowFWLoad;
    static boolean waitFlag;
    static boolean allowLANConnections;
    static boolean terminateEnable;
    static boolean allowAnnotations;
    static boolean termAddrIsSecret;
    static boolean reportAllDesktopEvents;
    static boolean forceSessionLocation;
    static boolean enableGroupManager;
    static boolean enableLoadBalancing;
    static int gmDebug;
    static String smartcardConfigSource;
    static String terminalTokensProp;
    static Vector terminalTokens;
    public static final String msgTagKey = "tag";
    static String configFile;
    static String sessionHost;
    static int sessionPort;
    static String sessionTypesFileName;
    static Vector modules;
    static boolean nonBlockRead;
    static int logFacility;
    static boolean logAddTimeStamp;
    static int logPriClientError;
    static int logPriDebug;
    static int logPriNotice;
    static int logPriWarning;
    static int logPriConfigError;
    static int logPriUnexpectedError;

    static {
        timeout = 60;
        workers = 5;
        maxStarting = 3;
        controllers = 2;
        namesFileName = null;
        policyFileName = null;
        port = 7009;
        cbport = 7010;
        gmport = 7009;
        deviceManagerHost = "localhost";
        deviceManagerPort = 7011;
        gmKeepAliveInterval = 20;
        enableMulticast = true;
        multicastAddress = null;
        multicastTTL = 1;
        gmSignatureFile = null;
        cbtimeout = 45;
        smtimeout = 0;
        allowFWLoad = true;
        waitFlag = false;
        allowLANConnections = false;
        terminateEnable = false;
        allowAnnotations = false;
        termAddrIsSecret = true;
        reportAllDesktopEvents = false;
        forceSessionLocation = true;
        enableGroupManager = true;
        enableLoadBalancing = false;
        gmDebug = 0;
        smartcardConfigSource = null;
        terminalTokensProp = null;
        terminalTokens = new Vector();
        configFile = String.valueOf(configDir) + File.separator + "auth.props";
        sessionHost = "localhost";
        sessionPort = 7007;
        sessionTypesFileName = null;
        modules = new Vector();
        nonBlockRead = false;
        logFacility = 24;
        logAddTimeStamp = false;
        logPriClientError = 4;
        logPriDebug = -1;
        logPriNotice = 5;
        logPriWarning = 4;
        logPriConfigError = 0;
        logPriUnexpectedError = 3;
    }

    private static void loadPolicy(String string) {
        BufferedReader bufferedReader = null;
        File file = new File(string);
        if (!file.exists()) {
            Log.configError((String)("Policy file does not exist: " + string));
            System.exit(1);
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            Log.configError((String)(String.valueOf(String.valueOf(exception)) + ": " + string));
            System.exit(1);
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0 || string2.startsWith("#")) continue;
                String string3 = null;
                int n = string2.indexOf(32);
                if (n != -1) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n).trim();
                } else {
                    n = string2.indexOf(9);
                    if (n != -1) {
                        string3 = string2.substring(0, n);
                        string2 = string2.substring(n).trim();
                    } else {
                        string3 = string2;
                        string2 = "";
                    }
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
                hashtable.put("name", string3);
                hashtable.put("param", string2);
                modules.addElement(hashtable);
            }
        }
        catch (Exception exception) {
            Log.configError((String)("Error while reading policy file " + string + ": " + exception));
            System.exit(1);
        }
    }

    static void loadProps(String string) throws IOException {
        Object object;
        String string2;
        File file;
        if (string == null) {
            string = configFile;
        }
        if (!(file = new File(string)).exists()) {
            throw new IOException(string);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        String string3 = file.getAbsolutePath();
        int n = string3.lastIndexOf(File.separatorChar);
        if (n != -1) {
            configDir = string3.substring(0, n);
        }
        props.load(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        logAddTimeStamp = Boolean.valueOf(props.getProperty("logAddTimeStamp", new Boolean(logAddTimeStamp).toString()));
        try {
            string2 = props.getProperty("logFacility", "daemon");
            logFacility = Syslog.mapFacility((String)string2);
            string2 = props.getProperty("logPriClientError", "warning");
            logPriClientError = Syslog.mapPriority((String)string2);
            string2 = props.getProperty("logPriDebug", "OFF");
            logPriDebug = Syslog.mapPriority((String)string2);
            string2 = props.getProperty("logPriNotice", "notice");
            logPriNotice = Syslog.mapPriority((String)string2);
            string2 = props.getProperty("logPriConfigError", "emerg");
            logPriConfigError = Syslog.mapPriority((String)string2);
            string2 = props.getProperty("logPriUnexpectedError", "err");
            logPriUnexpectedError = Syslog.mapPriority((String)string2);
        }
        catch (Exception exception) {
            System.err.println("Cannot parse syslog configuration: " + exception);
            System.exit(1);
        }
        try {
            Log.init((String)"utauthd", (int)logFacility, (boolean)logAddTimeStamp, (int)logPriDebug, (int)logPriClientError, (int)logPriUnexpectedError, (int)logPriNotice, (int)logPriWarning, (int)logPriConfigError);
        }
        catch (Exception exception) {
            System.err.println("Cannot initialize logging: " + exception);
            System.exit(1);
        }
        string2 = props.getProperty("moduleDir", System.getProperty("user.dir"));
        if (string2 != null && !(root = new File(string2)).exists()) {
            throw new Error(String.valueOf(String.valueOf(root)) + " doesn't exist as server root");
        }
        timeout = Integer.parseInt(props.getProperty("timeout", new Integer(timeout).toString()));
        timeout *= 1000;
        workers = Integer.parseInt(props.getProperty("workers", new Integer(workers).toString()));
        maxStarting = Integer.parseInt(props.getProperty("maxStarting", new Integer(maxStarting).toString()));
        AuthRecord.initTickets(maxStarting);
        controllers = Integer.parseInt(props.getProperty("controllers", new Integer(controllers).toString()));
        sessionHost = props.getProperty("sessionHost", sessionHost);
        sessionPort = Integer.parseInt(props.getProperty("sessionPort", new Integer(sessionPort).toString()));
        deviceManagerHost = props.getProperty("deviceManagerHost", deviceManagerHost);
        int n2 = Utils.getPortForService((String)"utdevmgrd", (String)"tcp");
        if (n2 > 0) {
            deviceManagerPort = n2;
        }
        Log.debug((String)("devMgrPort = " + deviceManagerPort + " port = " + n2));
        sessionTypesFileName = props.getProperty("sessionTypesFile", null);
        if (sessionTypesFileName == null) {
            Log.configError((String)"sessionTypesFile not specified");
            System.exit(1);
        }
        sessionTypesFileName = String.valueOf(configDir) + File.separator + sessionTypesFileName;
        tokenDir = props.getProperty("tokenDir", tokenDir);
        namesFileName = props.getProperty("token.equiv");
        if (namesFileName != null) {
            namesFileName = String.valueOf(configDir) + File.separator + namesFileName;
        }
        if ((policyFileName = props.getProperty("policy")) == null) {
            object = "No policy specified";
            System.err.print(String.valueOf(object) + "\n");
            Log.configError((String)object);
            System.exit(1);
        }
        policyFileName = String.valueOf(configDir) + File.separator + "policy" + File.separator + policyFileName;
        n2 = Integer.parseInt(props.getProperty("port", new Integer(n2).toString()));
        cbport = Integer.parseInt(props.getProperty("cbport", new Integer(cbport).toString()));
        gmport = Integer.parseInt(props.getProperty("gmport", new Integer(gmport).toString()));
        gmKeepAliveInterval = Integer.parseInt(props.getProperty("gmKeepAliveInterval", new Integer(gmKeepAliveInterval).toString()));
        enableMulticast = Boolean.valueOf(props.getProperty("enableMulticast", new Boolean(enableMulticast).toString()));
        multicastTTL = Integer.parseInt(props.getProperty("multicastTTL", new Integer(multicastTTL).toString()));
        multicastAddress = props.getProperty("multicastAddress", "");
        gmSignatureFile = props.getProperty("gmSignatureFile", "");
        cbtimeout = Integer.parseInt(props.getProperty("cbtimeout", new Integer(cbtimeout).toString()));
        cbtimeout *= 1000;
        smtimeout = Integer.parseInt(props.getProperty("smtimeout", new Integer(smtimeout).toString()));
        smtimeout *= 1000;
        allowAnnotations = Boolean.valueOf(props.getProperty("allowAnnotations", new Boolean(allowAnnotations).toString()));
        allowFWLoad = Boolean.valueOf(props.getProperty("allowFWLoad", new Boolean(allowFWLoad).toString()));
        allowLANConnections = Boolean.valueOf(props.getProperty("allowLANConnections", new Boolean(allowLANConnections).toString()));
        terminateEnable = Boolean.valueOf(props.getProperty("terminateEnable", new Boolean(terminateEnable).toString()));
        termAddrIsSecret = Boolean.valueOf(props.getProperty("termAddrIsSecret", new Boolean(termAddrIsSecret).toString()));
        reportAllDesktopEvents = Boolean.valueOf(props.getProperty("reportAllDesktopEvents", new Boolean(reportAllDesktopEvents).toString()));
        forceSessionLocation = Boolean.valueOf(props.getProperty("forceSessionLocation", new Boolean(forceSessionLocation).toString()));
        enableGroupManager = Boolean.valueOf(props.getProperty("enableGroupManager", new Boolean(enableGroupManager).toString()));
        enableLoadBalancing = Boolean.valueOf(props.getProperty("enableLoadBalancing", new Boolean(enableLoadBalancing).toString()));
        gmDebug = Integer.parseInt(props.getProperty("gmDebug", new Integer(gmDebug).toString()));
        smartcardConfigSource = props.getProperty("smartcardConfigSource");
        if (smartcardConfigSource != null && smartcardConfigSource.length() == 0) {
            smartcardConfigSource = null;
        }
        if ((terminalTokensProp = props.getProperty("terminalTokens")) != null) {
            object = new StringTokenizer(terminalTokensProp);
            while (((StringTokenizer)object).hasMoreElements()) {
                terminalTokens.add(((StringTokenizer)object).nextToken().toLowerCase());
            }
        }
        terminalTokens.add("pseudo");
        nonBlockRead = Boolean.valueOf(props.getProperty("nonBlockRead", new Boolean(nonBlockRead).toString()));
        Configuration.loadPolicy(policyFileName);
    }

    public static void options(String[] stringArray) {
        Object object;
        Object var1_1 = null;
        String string = null;
        ParseOptions parseOptions = new ParseOptions(stringArray, "c:p:w");
        Enumeration enumeration = parseOptions.keys();
        while (enumeration.hasMoreElements()) {
            Character c = (Character)enumeration.nextElement();
            object = parseOptions.getValue(c);
            switch (c.charValue()) {
                case 'c': {
                    configFile = (String)object;
                    break;
                }
                case 'p': {
                    string = (String)object;
                    break;
                }
                case 'w': {
                    waitFlag = true;
                    break;
                }
                default: {
                    System.err.print("Invalid option '" + c + "'\n");
                }
                case '?': {
                    String string2 = "Invalid option: \"" + parseOptions.errorOpt + "\"\n" + "Valid options are:\n" + "\t-c propertiesFileName\n" + "\t-p port" + "\t-w # wait for debugger attach";
                    System.err.print(String.valueOf(string2) + "\n");
                    System.exit(1);
                }
            }
        }
        try {
            Configuration.loadProps(configFile);
        }
        catch (IOException iOException) {
            object = "Cannot read properties file: " + iOException;
            System.err.println((String)object);
            System.exit(1);
        }
        Configuration.printProps();
        if (string != null) {
            port = Integer.parseInt(string);
        }
    }

    static void printProps() {
        Log.debug((String)"PROPERTIES:");
        Log.debug((String)("\tmoduleDir=" + root));
        Log.debug((String)("\tport=" + port));
        Log.debug((String)("\ttimeout=" + timeout / 1000));
        Log.debug((String)("\tsmtimeout=" + smtimeout / 1000));
        Log.debug((String)("\tcbtimeout=" + cbtimeout / 1000));
        Log.debug((String)("\tworkers=" + workers));
        Log.debug((String)("\ttoken.equiv=" + namesFileName));
        Log.debug((String)("\tsessionHost=" + sessionHost));
        Log.debug((String)("\tsessionPort=" + sessionPort));
        Log.debug((String)("\tdeviceManagerHost=" + deviceManagerHost));
        Log.debug((String)("\tdeviceManagerPort=" + deviceManagerPort));
        Log.debug((String)("\tsessionTypesFileName=" + sessionTypesFileName));
        Log.debug((String)"\tModules configured =");
        Log.debug((String)("\tgmSignatureFile=" + gmSignatureFile));
        int n = 0;
        Enumeration enumeration = modules.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            String string = (String)hashtable.get("name");
            String string2 = (String)hashtable.get("param");
            Log.debug((String)("\t" + n + ": " + string + " " + string2));
            ++n;
        }
    }
}

