/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.util.StringTokenizer;

public class CMultiLineLabel
extends Panel {
    private CLabel[] label;
    private int line_padding = -1;

    public CMultiLineLabel(String string, int n, int n2) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.label = new CLabel[n2];
        for (int i = 0; i < n2; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.weightx = 1.0;
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.label[i] = new CLabel(string2, n);
                this.label[i].setVisible(true);
            } else {
                this.label[i] = new CLabel("", n);
                this.label[i].setVisible(false);
            }
            this.add((Component)this.label[i], gridBagConstraints);
        }
    }

    public void set_line_padding(int n) {
        this.line_padding = n;
    }

    public void set_text(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        for (n = 0; n < this.label.length; ++n) {
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.label[n].setText(string2);
                this.label[n].setVisible(true);
                continue;
            }
            this.label[n].setVisible(false);
            this.label[n].setText("");
        }
        int n2 = this.getMaxPixelWidth();
        if (n2 > 0) {
            for (n = 0; n < this.label.length; ++n) {
                Dimension dimension = this.label[n].getSize();
                dimension.width = n2;
                this.label[n].setSize(dimension);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.line_padding != -1) {
            Font font = this.label[0].getFont();
            if (font == null) {
                Debug.printme("font is null");
                return;
            }
            FontMetrics fontMetrics = this.label[0].getFontMetrics(font);
            if (fontMetrics == null) {
                Debug.printme("fm is null");
                return;
            }
            for (int i = 0; i < this.label.length; ++i) {
                this.label[i].set_preferred_size_overrides(-1, fontMetrics.getHeight() + this.line_padding);
            }
        }
    }

    public int getMaxPixelWidth() {
        Font font = this.label[0].getFont();
        if (font == null) {
            return -1;
        }
        FontMetrics fontMetrics = this.label[0].getFontMetrics(font);
        if (fontMetrics == null) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < this.label.length; ++i) {
            String string;
            int n2;
            if (!this.label[i].isVisible() || (n2 = fontMetrics.stringWidth(string = this.label[i].getText())) <= n) continue;
            n = n2;
        }
        return n;
    }
}

