/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.terminal.sunray;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.terminal.sunray.CardNotPresentException;
import com.sun.opencard.terminal.sunray.SRCOMeventListener;
import com.sun.opencard.terminal.sunray.SRCOMreaderHandle;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.TerminalInitException;
import opencard.core.util.HexString;

public class SRCOM {
    private static final String SCCS_ID = "@(#)SRCOM.java\t1.11 02/12/03 SMI";
    public static final int EVENT_UNKNOWN = 0;
    public static final int EVENT_NEW_READER = 1;
    public static final int EVENT_READER_GONE = 2;
    public static final int EVENT_CARD_INSERTED = 3;
    public static final int EVENT_CARD_REMOVED = 4;
    public static final String[] SRCOMeventS = new String[]{"EVENT_UNKNOWN", "EVENT_NEW_READER", "EVENT_READER_GONE", "EVENT_CARD_INSERTED", "EVENT_CARD_REMOVED"};
    public static final int CARD_PRESENT = 1;
    public static final int RESET_CARD = 1;
    public static final int TIMEOUT_IMMEDIATE = -1;
    public static final int NO_TIMEOUT = 0;

    private SRCOM() {
    }

    public static void init(SRCOMeventListener sRCOMeventListener, String string, String string2) throws TerminalInitException {
        try {
            System.load(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new TerminalInitException(unsatisfiedLinkError.getMessage());
        }
        SRCOM.debug("init", "loaded library: [" + string + "]");
        try {
            SRCOM.initN(sRCOMeventListener, string2);
        }
        catch (TerminalInitException terminalInitException) {
            throw new TerminalInitException(terminalInitException.getMessage());
        }
        SRCOM.debug("init", "loaded library: [" + string2 + "]");
    }

    public static SRCOMreaderHandle allocate(String string) throws TerminalInitException, CardNotPresentException {
        return new SRCOMreaderHandle(SRCOM.allocateN(string));
    }

    public static void deallocate(SRCOMreaderHandle sRCOMreaderHandle) throws CardTerminalException {
        SRCOM.deallocateN(sRCOMreaderHandle.getHandle());
    }

    public static byte[] getATR(SRCOMreaderHandle sRCOMreaderHandle, int n) throws CardTerminalException {
        byte[] byArray;
        String string = SRCOM.getATRN(sRCOMreaderHandle.getHandle(), n);
        if (string == null) {
            String string2 = "no ATR available";
            SRCOM.debug("getATR", string2);
            throw new CardTerminalException(string2);
        }
        try {
            byArray = HexString.parseHexString((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = "invalid ATR format: [" + string + "]";
            SRCOM.debug("getATR", string3);
            throw new CardTerminalException(string3);
        }
        return byArray;
    }

    public static byte[] exchange_APDU(SRCOMreaderHandle sRCOMreaderHandle, byte[] byArray, int n) throws CardTerminalException {
        String string = SRCOM.exchangeAPDUN(sRCOMreaderHandle.getHandle(), SRCOM.byteToHexASCII(byArray), n);
        if (string == null) {
            throw new CardTerminalException("no response APDU available");
        }
        SRCOM.debug("exchange_APDU", "sendAPDU: [" + SRCOM.byteToHexASCII(byArray) + "] " + "recvAPDU: [" + string + "]");
        return HexString.parseHexString((String)string);
    }

    public static int getCardState(SRCOMreaderHandle sRCOMreaderHandle, int n) throws CardTerminalException {
        return SRCOM.getCardStateN(sRCOMreaderHandle.getHandle(), n);
    }

    public static void cardControl(SRCOMreaderHandle sRCOMreaderHandle, int n, int n2) throws CardTerminalException {
        SRCOM.cardControlN(sRCOMreaderHandle.getHandle(), n, n2);
    }

    private static String byteToHexASCII(byte[] byArray) throws CardTerminalException {
        if (byArray == null) {
            throw new CardTerminalException("input byte array is null");
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(SRCOM.toHexChar(byArray[i] >> 4 & 0xF));
            stringBuffer.append(SRCOM.toHexChar(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    private static char toHexChar(int n) {
        char c = '?';
        if (n < 10) {
            c = (char)(n + 48);
        } else if (n < 16) {
            c = (char)(n - 10 + 97);
        }
        return c;
    }

    private static void debug(String string, String string2) {
        try {
            OCFDebug.debugln((String)("SRCOM: <" + string + "> " + string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static native void initN(SRCOMeventListener var0, String var1) throws TerminalInitException;

    public static native long allocateN(String var0) throws TerminalInitException, CardNotPresentException;

    public static native void deallocateN(long var0) throws CardTerminalException;

    public static native String getATRN(long var0, int var2) throws CardTerminalException;

    public static native String exchangeAPDUN(long var0, String var2, int var3) throws CardTerminalException;

    public static native int getCardStateN(long var0, int var2) throws CardTerminalException;

    public static native void cardControlN(long var0, int var2, int var3) throws CardTerminalException;
}

