/*
 * Decompiled with CFR 0.152.
 */
package auth.sdk;

import auth.sdk.AuthCallback;
import auth.sdk.DTUInfo;
import auth.sdk.InvalidSessionException;
import auth.sdk.Log;
import java.io.IOException;
import java.net.UnknownHostException;

public class Token {
    private static final String SCCS_ID = "@(#)Token.java\t1.3 02/10/13 SMI";
    private String tokenName = null;
    private String lcTokenName = null;

    public Token(String string) throws InvalidSessionException {
        if (string == null) {
            try {
                string = System.getProperty("SUN_SUNRAY_TOKEN");
            }
            catch (SecurityException securityException) {
                System.err.println(securityException.getMessage());
                Log.unexpectedError("Token(), " + securityException.getMessage());
            }
        }
        if (string == null) {
            throw new InvalidSessionException("Token is not defined");
        }
        this.tokenName = string;
        this.lcTokenName = this.tokenName.toLowerCase();
    }

    public Token() throws InvalidSessionException {
        this(null);
    }

    public String getName() {
        return this.tokenName;
    }

    public boolean isPersonal() {
        boolean bl = true;
        if (this.lcTokenName == null) {
            bl = false;
        } else if (this.lcTokenName.startsWith("pseudo.")) {
            bl = false;
        } else if (this.lcTokenName.startsWith("escape.")) {
            bl = false;
        } else if (this.lcTokenName.startsWith("terminalid.")) {
            bl = false;
        }
        return bl;
    }

    public DTUInfo[] getDTU() {
        DTUInfo[] dTUInfoArray = new DTUInfo[]{};
        try {
            AuthCallback authCallback = new AuthCallback();
            dTUInfoArray = authCallback.status(this);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            Log.unexpectedError("Token.getDTU(), " + unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Log.unexpectedError("Token.getDTU(), " + iOException.getMessage());
        }
        return dTUInfoArray;
    }

    public String getCID() {
        String string = null;
        DTUInfo[] dTUInfoArray = this.getDTU();
        for (int i = 0; i < dTUInfoArray.length; ++i) {
            DTUInfo dTUInfo = dTUInfoArray[i];
            String string2 = dTUInfo.getMHPrimary();
            if (string2 == null) {
                string = dTUInfo.getTermCID();
                break;
            }
            if (!string2.equalsIgnoreCase("true")) continue;
            string = dTUInfo.getTermCID();
            break;
        }
        return string;
    }
}

