/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * utio module Public Interface
 */

#ifndef UTIO_H_
#define	UTIO_H__

#pragma ident	"@(#)utio.h	1.2 04/09/03 SMI"

#ifdef _SCCSID
static char *_SCCSid_UTIO_H = "@(#)utio.h	1.2 04/09/03 SMI";
#endif	/* defined _SCCSID */

#ifdef __cplusplus
extern "C" {
#endif	/* defined __cplusplus */


#define	UTIO_MAGIC		0x5554494F	/* UTIO */
#define	UTIO_VERSION		0x10		/* v1.0 */

/* version interpretation */
#define	UTIO_VER_MAJOR(x)	(((x) & 0xf0) >> 4)
#define	UTIO_VER_MINOR(x)	(((x) & 0x0f))

/* fixed minor numbers */
#define	UTSERIALD_MINOR		1
#define	UTPARALLELD_MINOR	2

/*
 * protocol message format - sent to/from kernel & daemon
 */

typedef union {
	struct termio tio;
	struct termios tios;
	struct winsize twsz;
	struct timeval tval;
	int intval;
	unsigned char charval;
} utio_args;

typedef struct {
	uint32_t magic;		/* UTIO magic number */
	uint32_t version;	/* UTIO_VERSION of the module */
	uint32_t msgtype;	/* UTIO_MSG_{OPEN,CLOSE,IOCTL,READ,WRITE} */
	uint32_t cmd;		/* This will contain device specific ioctls */
	utio_args args;		/* args for device specific ioctls */
	uid_t uid;		/* effective uid. only valid on open */
	uint32_t datasize;	/* No. of bytes available to read/write */
	uint32_t response;	/* Response(ACK/NACK) from the deamon for the */
				/* pending open/close/ioctl */
} utio_pmsg_t;


/*
 * values for msgtype
 */
#define	UTIO_MSG_OPEN		0x0001 /* user opened session; arg = sessid */
#define	UTIO_MSG_CLOSE		0x0002 /* close message */
#define	UTIO_MSG_IOCTL		0x0004 /* IOCTL message */
#define	UTIO_MSG_READ		0x0008 /* Data available to read */
#define	UTIO_MSG_WRITE		0x0010 /* Buffer space available to write */
#define	UTIO_MSG_ACK		0x0020 /* for the pending open/close/ioctl */
#define	UTIO_MSG_NACK		0x0040 /* for the pending open/close/ioctl */

/*
 * master-side ioctls
 */
#define	UTA_IOC_BASE		'U'
#define	UTIO_GETVERSION		_IOR(UTA_IOC_BASE, 0, unsigned long)
#define	UTIO_GETMAJOR		_IO(UTA_IOC_BASE, 1)
#define	UTIO_GETDEVID		_IO(UTA_IOC_BASE, 2)
#define	UTIO_GETMSG		_IOR(UTA_IOC_BASE, 3, utio_pmsg_t)
#define	UTIO_PUTMSG		_IOW(UTA_IOC_BASE, 4, utio_pmsg_t)


#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif /* UTIO_H__ */
