/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef UTADEM_H__
#define	UTADEM_H__

#pragma ident	"@(#)utadem.h	1.7 05/02/04 SMI"

#ifdef _SCCSID
static char *_SCCSid_UTADEM_H = "@(#)utadem.h	1.7 05/02/04 SMI";
#endif	/* defined _SCCSID */

#ifdef __cplusplus
extern "C" {
#endif	/* defined __cplusplus */

#define	UTADEM_VERSION		0x000c

/* version interpretation */
#define	UTADEM_VER_MAJOR(x)	(((x) & 0xff00) >> 8)
#define	UTADEM_VER_MINOR(x)	(((x) & 0x00ff))

/*
 * protocol message format - sent from kernel to daemon
 */
struct utadem_msg {
	uint32_t version;	/* UTADEM_VERSION of the driver */
	uint32_t msgtype;	/* UTADEM_MSG_* */
	uint32_t arg;
};

/*
 * values for msgtype
 */
#define	UTADEM_MSG_JOINED	1 /* user opened session; arg = sessid */
#define	UTADEM_MSG_LEFT		2 /* user closed session; arg = sessid */
#define	UTADEM_MSG_PLAY		3 /* start playback; arg ignored */
#define	UTADEM_MSG_RECORD	4 /* start recording; arg ignored */
#define	UTADEM_MSG_SETFORMAT	5 /* set format; arg = negotiated format */
#define	UTADEM_MSG_SETRATE	6 /* set sampling rate; arg = Hz */
#define	UTADEM_MSG_SETCHANNELS	7 /* set number of channels; arg = nchannels */
#define	UTADEM_MSG_RESET	8 /* stop processing; arg = ACK required? */
#define	UTADEM_MSG_SYNC		9 /* drain buffers and RESET; arg ignored */
#define	UTADEM_MSG_MIXER	10 /* mixer; arg: 16MSB=value, 16LSB=channel */
#define	UTADEM_MSG_SETINSRC	11 /* set input source; arg = mask of devs */
#define	UTADEM_MSG_SETOUTSRC	12 /* set output source; arg = mask of devs */
#define	UTADEM_MSG_SETFRAGSIZE  13 /* set fragment size ; arg = # of bytes */

/*
 * daemon capabilities - sent from daemon to kernel
 */
struct utadem_dcaps {
	uint32_t version;	/* UTADEM_VERSION of the daemon */
	uint32_t formats;	/* bitmask of OSS formats supported */
	uint32_t channels;	/* bitmask of channel counts (max 32) */
	uint32_t rate_min;	/* range of sample rates */
	uint32_t rate_max;
	uint32_t def_format;	/* default format */
	uint32_t def_channels;	/* default channel count */
	uint32_t def_rate;	/* default sample rate */
};

/*
 * mixer state - sent from daemon to kernel
 */
struct utadem_mixdev {
	uint16_t channels;	/* number of channels - 0 == off */
	uint16_t level;		/* current value = 0-100 */
	uint8_t insrc;		/* is the device a recording source? */
	uint8_t outsrc;		/* is the device a playback source? */
};
#define	UTADEM_MIXER_NDEVS	32

/* ioctls */
#define	UTA_IOC_BASE		'U'
#define	UTAIO_GETVERSION	_IOR(UTA_IOC_BASE, 0, unsigned long)
#define	UTAIO_NEWSESSION	_IO(UTA_IOC_BASE, 1)
#define	UTAIO_GETMSG		_IOR(UTA_IOC_BASE, 2, struct utadem_msg)
#define	UTAIO_SETDCAPS		_IOW(UTA_IOC_BASE, 3, struct utadem_dcaps)
#define	UTAIO_ACKRESET		_IO(UTA_IOC_BASE, 4)
#define	UTAIO_ACKSYNC		_IO(UTA_IOC_BASE, 5)
#define	UTAIO_SETMIXER		_IOW(UTA_IOC_BASE, 6, struct utadem_mixdev *)
#define	UTAIO_UNDERRUN		_IO(UTA_IOC_BASE, 7)
#define	UTAIO_OVERRUN		_IO(UTA_IOC_BASE, 8)

#ifdef __cplusplus
}
#endif	/* defined __cplusplus */

#endif /* UTADEM_H__ */
