/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.cli;

import com.sun.apoc.cli.util.CLIException;
import com.sun.apoc.cli.util.CmdLineArguments;
import com.sun.apoc.cli.util.FileCredentials;
import com.sun.apoc.cli.util.MaskedInput;
import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.PolicyMgrFactory;
import com.sun.apoc.spi.PolicyMgrFactoryImpl;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.environment.EnvironmentMgr;
import com.sun.apoc.spi.environment.RemoteEnvironmentException;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class PolicyGroupTool {
    private PolicyMgr mPolicyMgr = null;
    private CmdLineArguments mCmdLineArgs;
    private Hashtable mEnvironment;
    private static final String USERNAME_PROMPT = "Enter a user name";
    private static final String USER_PASSWORD_PROMPT = "Enter a user password";
    private static final String AUTHORIZED_USER_PROMPT = "Enter the full name of a user with sufficient access rights to search the datastore";
    private static final String AUTHORIZED_PASSWORD_PROMPT = "Enter a password for this user";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String DEFAULT_PROFILE_NAME = "NewProfile";
    private static final String USAGE_STATEMENT = "Usage: pgtool [-?V] \n       pgtool command [args...]";

    public void processArguments(String[] stringArray) throws CLIException {
        this.mCmdLineArgs = new CmdLineArguments();
        this.mCmdLineArgs.processArguments(stringArray);
        this.setEnvironmentTable();
        if (this.mCmdLineArgs.getUserName() != null) {
            this.mEnvironment.put("SECURITY_PRINCIPAL", this.mCmdLineArgs.getUserName());
        }
    }

    public static void printUsage() {
        System.err.println(USAGE_STATEMENT);
        PolicyGroupTool.printCommandsUsage();
        PolicyGroupTool.printOptionsUsage();
    }

    public static void printVersion() {
        System.out.println("version 2.0");
        System.exit(0);
    }

    public static void printHelp() {
        System.out.println(USAGE_STATEMENT);
        System.out.println("Maintains profiles, i.e. groups of configuration policies.");
        System.out.println("The name and password of a user with administrator access rights");
        System.out.println("must be made available.");
        System.out.println();
        PolicyGroupTool.printCommandsHelp();
        System.out.println();
        PolicyGroupTool.printOptionsHelp();
        System.exit(0);
    }

    public static void printCommandsHelp() {
        System.out.println("Commands:");
        System.out.println("add   \tAssigns a profile from the profile repository to an element.");
        System.out.println("create\tCreates a new, empty profile.");
        System.out.println("delete\tDeletes a profile.");
        System.out.println("export\tExports a profile in zip file format to the specified target.");
        System.out.println("import\tImports a profile stored in zip file format from the");
        System.out.println("      \tspecified source.");
        System.out.println("list  \tLists all the profiles or the profiles assigned to an element");
        System.out.println("      \tor the elements a profile has been assigned to.");
        System.out.println("login \tStores the username and password for this storage backend in a file");
        System.out.println("      \tnamed .apocpass in the user's home directory. This username and password");
        System.out.println("      \tcan then be used in future invocations of pgtool.");
        System.out.println("modify\tChanges the priority of a profile in the profile repository.");
        System.out.println("remove\tUnassigns a profile from an element.");
        System.out.println("rename\tRenames a profile in the profile repository.");
    }

    private static void printOptionsHelp() {
        System.out.println("Options and option arguments:");
        System.out.println("-a <authentication type>, --authentication=<authentication type>");
        System.out.println("\tSpecifies the type of authentication to be used in connecting to");
        System.out.println("\tthe storage backend. This may be anonymous or GSSAPI, the default");
        System.out.println("\tis anonymous. This option may not be used with the -f option.");
        System.out.println("\tExample: -a GSSAPI");
        System.out.println("-b <base entry>, --base=<base entry>");
        System.out.println("\tSpecifies the root entry of the storage backend. The format for this");
        System.out.println("\tbase entry is determined by the storage backend used. This option");
        System.out.println("\tmay not be used with the -f option. For example, an LDAP storage");
        System.out.println("\tbackend with a root entry o=apoc:");
        System.out.println("\t-b o=apoc");
        System.out.println("   DEPRECATED: use --url=<url> option instead");
        System.out.println("-e <element>, --entity=<element>");
        System.out.println("\tSpecifies the element representing a user, role, organization, host");
        System.out.println("\tor domain. The entry format for the element is determined by the");
        System.out.println("\tstorage backend used. For example, an LDAP storage backend with");
        System.out.println("\tuser jbloggs:");
        System.out.println("\t-e uid=jbloggs,ou=People,o=Staff,o=apoc");
        System.out.println("-f <file>, --file=<file>");
        System.out.println("\tSpecifies a fully qualified file name for a file detailing the");
        System.out.println("\tbootstrapping settings to be used in the execution of this command.");
        System.out.println("\tThis option may not be used with the -a, -b, -h, -l, -p or -t options.");
        System.out.println("\tExample: -f /tmp/policymgr.cfg");
        System.out.println("-h <hostname>, --hostname=<hostname>");
        System.out.println("\tSpecifies the name of the host for the storage backend. The default");
        System.out.println("\tis localhost. This option may not be used with the -f option.");
        System.out.println("\tExample: --hostname=server1.sun.com");
        System.out.println("   DEPRECATED: use --url=<url> option instead");
        System.out.println("-i <priority>, --priority=<priority>");
        System.out.println("\tSpecifies a positive integer denoting the priority of a profile.");
        System.out.println("\tExample: -i 12");
        System.out.println("-l <url>, --url=<url>");
        System.out.println("\tSpecifies the URL for the storage backend.");
        System.out.println("\tThe format for the LDAP URL is ldap://<hostname>:<port>/<base entry>.");
        System.out.println("\tThis option may not be used with the -f option.");
        System.out.println("\tExample: --url=ldap://server1.sun.com:399/o=apoc");
        System.out.println("-m <name>, --name=<profile name>");
        System.out.println("\tSpecifies the name of a profile.");
        System.out.println("\tExample: --name=\"New Staff\"");
        System.out.println("-p <port>, --port=<port>");
        System.out.println("\tSpecifies the port number for the storage backend. The default is 389.");
        System.out.println("\tThis option may not be used with the -f option.");
        System.out.println("\tExample: --port=399");
        System.out.println("   DEPRECATED: use --url=<url> option instead");
        System.out.println("-s <scope>, --scope=<scope>");
        System.out.println("\tSpecifies the scope of the profile. This can be either user or host.");
        System.out.println("\tThe default is user.");
        System.out.println("\tExample: --scope=host");
        System.out.println("-t <type>, --type=<type>");
        System.out.println("\tSpecifies the type of backend storage. The default is LDAP.");
        System.out.println("\tThis option may not be used with the -f option.");
        System.out.println("\tExample: -t LDAP");
        System.out.println("   DEPRECATED: use --url=<url> option instead");
        System.out.println("-u <username>, --username=<username>");
        System.out.println("\tSpecifies the username for an administrator of the storage backend.");
        System.out.println("\tIf there is not an appropriate entry for this user in the user's");
        System.out.println("\tcredentials file then the user will be prompted to enter a password.");
        System.out.println("\tIf this option is not used, and the user has not already used the");
        System.out.println("\tpgtool login command, then the user will be prompted to enter a");
        System.out.println("\tusername and password.");
        System.out.println("\tExample: --username=jbloggs");
        System.out.println("-?, --help");
        System.out.println("\tDisplays this help and exits");
        System.out.println("-V, --version");
        System.out.println("\tDisplays the version and exits");
    }

    public static void printCommandsUsage() {
        System.err.println("Commands:");
        System.err.println("add; create; delete; export; import; list; login; modify; remove; rename ");
    }

    private static void printOptionsUsage() {
        System.err.println("Options and option arguments:");
        System.err.println("-b <base entry>, --base=<base entry>, DEPRECATED");
        System.err.println("-e <element>, --entity=<element>");
        System.err.println("-f <file>, --file=<file>");
        System.err.println("-h <hostname>, --hostname=<hostname>, DEPRECATED");
        System.err.println("-i <priority>, --priority=<priority>");
        System.out.println("-l <url>, --url=<url>");
        System.err.println("-m <name>, --name=<profile name>");
        System.err.println("-p <port>, --port <port>, DEPRECATED");
        System.err.println("-s <scope>, --scope=<scope>");
        System.err.println("-t <type>, --type=<type>, DEPRECATED");
        System.err.println("-u <username>, --username <username>");
        System.err.println("-?, --help");
        System.err.println("-V, --version");
    }

    private Profile findProfile(ProfileRepository profileRepository, String string, Applicability applicability) throws SPIException {
        Profile profile = null;
        Iterator iterator = profileRepository.getProfiles(applicability);
        while (iterator.hasNext()) {
            Profile profile2 = (Profile)iterator.next();
            if (!profile2.getDisplayName().equals(string)) continue;
            if (profile == null) {
                profile = profile2;
                continue;
            }
            profile = null;
            break;
        }
        return profile;
    }

    private String findNewProfileName(ProfileRepository profileRepository) throws SPIException {
        String string = DEFAULT_PROFILE_NAME;
        Profile profile = null;
        int n = 1;
        while ((profile = profileRepository.findProfile(string)) != null) {
            string = DEFAULT_PROFILE_NAME + ++n;
            if (profile != null) continue;
        }
        return string;
    }

    private Entity getEntity(String string, Applicability applicability) throws SPIException {
        Organization organization = null;
        if (string == null) {
            if (applicability.equals((Object)Applicability.USER)) {
                organization = this.mPolicyMgr.getRootOrganization();
            } else if (applicability.equals((Object)Applicability.HOST)) {
                organization = this.mPolicyMgr.getRootDomain();
            }
        } else {
            Domain domain = this.mPolicyMgr.getRootDomain();
            if (applicability.equals((Object)Applicability.HOST) && string.equals(domain.getId())) {
                organization = domain;
            }
            organization = this.mPolicyMgr.getEntity(string);
        }
        return organization;
    }

    void exportProfile() throws CLIException {
        String string = (String)this.mCmdLineArgs.getOperands().get(0);
        if (string == null) {
            throw new CLIException("pgtool: invalid operand: a valid target must be specified for the export command", CLIException.INVALID_ARGS);
        }
        if (string.indexOf(File.separator) == -1) {
            throw new CLIException("pgtool: invalid operand: a valid target must be specified for the export command: " + string, CLIException.INVALID_ARGS);
        }
        this.setCredentialsForCommand();
        try {
            this.createPolicyMgr();
            String string2 = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            Entity entity = this.getEntity(string2, applicability);
            if (entity == null) {
                throw new CLIException("pgtool: the export command failed: the element does not exist", CLIException.COMMAND_FAILURE);
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the export command failed", CLIException.COMMAND_FAILURE);
            }
            String string3 = this.mCmdLineArgs.getProfileName();
            Profile profile = this.findProfile(profileRepository, string3, applicability);
            if (profile == null) {
                throw new CLIException("pgtool: the export command failed: a unique profile " + string3 + " cannot be found", CLIException.COMMAND_FAILURE);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            profileRepository.exportProfile(profile, (OutputStream)byteArrayOutputStream);
            try {
                this.writeProfileStreamToFile(byteArrayOutputStream, string3, string);
            }
            catch (CLIException cLIException) {
                throw new CLIException("pgtool: the export command failed: " + cLIException.getMessage(), cLIException.getErrorCode());
            }
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the export command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void importProfile() throws CLIException {
        String string = (String)this.mCmdLineArgs.getOperands().get(0);
        if (string == null) {
            throw new CLIException("pgtool: invalid operand: a valid source must be specified for the import command", CLIException.INVALID_ARGS);
        }
        if (string.indexOf(File.separator) == -1) {
            throw new CLIException("pgtool: invalid operand: a valid source must be specified for the import command: " + string, CLIException.INVALID_ARGS);
        }
        this.setCredentialsForCommand();
        try {
            Profile profile;
            this.createPolicyMgr();
            String string2 = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            Entity entity = this.getEntity(string2, applicability);
            if (entity == null) {
                throw new CLIException("pgtool: the import command failed: the element does not exist", CLIException.COMMAND_FAILURE);
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the import command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the import command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            String string3 = this.mCmdLineArgs.getProfileName();
            if (string3 == null) {
                int n = string.lastIndexOf(File.separator);
                int n2 = string.indexOf(ZIP_EXTENSION);
                if (n != -1 && n2 != -1) {
                    string3 = string.substring(n + 1, n2);
                }
                if (string3 == null) {
                    throw new CLIException("pgtool: the import command failed: profile name cannot be deducted from source name", CLIException.COMMAND_FAILURE);
                }
            }
            Iterator iterator = profileRepository.getProfiles(applicability);
            while (iterator.hasNext()) {
                Profile profile2 = (Profile)iterator.next();
                if (!profile2.getDisplayName().equals(string3)) continue;
                profileRepository.destroyProfile(profile2);
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = this.getBufferedInputStream(string);
            }
            catch (CLIException cLIException) {
                throw new CLIException("pgtool: the import command failed: " + cLIException.getMessage(), cLIException.getErrorCode());
            }
            profileRepository.importProfile(string3, applicability, (InputStream)bufferedInputStream);
            int n = this.mCmdLineArgs.getPriority();
            if (n > 0 && (profile = profileRepository.findProfile(string3)) != null) {
                profile.setPriority(n);
            }
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the import command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void list() throws CLIException {
        this.setCredentialsForCommand();
        try {
            this.createPolicyMgr();
            String string = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            String string2 = this.mCmdLineArgs.getProfileName();
            if (string2 == null) {
                if (string == null) {
                    ProfileProvider profileProvider = this.mPolicyMgr.getProfileProvider();
                    Iterator iterator = profileProvider.getAllProfiles();
                    Vector<Profile> vector = new Vector<Profile>();
                    while (iterator.hasNext()) {
                        Profile profile = (Profile)iterator.next();
                        if (!profile.getApplicability().equals((Object)applicability)) continue;
                        vector.add(profile);
                    }
                    this.printProfiles(vector.iterator());
                } else {
                    Entity entity = this.getEntity(string, applicability);
                    if (entity == null) {
                        throw new CLIException("pgtool: the list command failed: the element does not exist", CLIException.COMMAND_FAILURE);
                    }
                    Iterator iterator = entity.getAssignedProfiles();
                    this.printProfiles(iterator);
                }
            } else {
                Entity entity = this.getEntity(string, applicability);
                if (entity == null) {
                    throw new CLIException("pgtool: the list command failed: the element does not exist", CLIException.COMMAND_FAILURE);
                }
                ProfileRepository profileRepository = entity.getProfileRepository();
                if (profileRepository == null) {
                    throw new CLIException("pgtool: the list command failed", CLIException.COMMAND_FAILURE);
                }
                Profile profile = this.findProfile(profileRepository, string2, applicability);
                if (profile == null) {
                    throw new CLIException("pgtool: the list command failed: a unique profile " + string2 + " cannot be found", CLIException.COMMAND_FAILURE);
                }
                Iterator iterator = profile.getAssignedEntities();
                this.printEntities(iterator);
            }
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the list command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void login() throws CLIException {
        Object object;
        File file = FileCredentials.getExistingCredentialsFile();
        String string = null;
        try {
            this.createPolicyMgrFactory();
        }
        catch (RemoteEnvironmentException remoteEnvironmentException) {
            if (this.mEnvironment.get("AuthDn") == null) {
                string = this.getInput(AUTHORIZED_USER_PROMPT);
                this.mEnvironment.put("AuthDn", string);
                object = this.getMaskedPasswordInput(AUTHORIZED_PASSWORD_PROMPT);
                this.mEnvironment.put("Password", object);
                try {
                    this.createPolicyMgrFactory();
                }
                catch (SPIException sPIException) {
                    throw new CLIException("pgtool: the login command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
                }
            }
            throw new CLIException("pgtool: the login command failed: " + remoteEnvironmentException.getMessage(), CLIException.COMMAND_FAILURE);
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the login command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
        string = (String)this.mEnvironment.get("SECURITY_PRINCIPAL");
        if (string == null) {
            string = this.getInput(USERNAME_PROMPT);
            this.mEnvironment.put("SECURITY_PRINCIPAL", string);
        }
        this.mEnvironment.put("SECURITY_CREDENTIALS", this.getMaskedPasswordInput(USER_PASSWORD_PROMPT));
        this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "none");
        Entity entity = null;
        try {
            this.createPolicyMgr();
            object = this.mPolicyMgr.getRootOrganization();
            Iterator iterator = object.findUsers(string, true);
            entity = (Entity)iterator.next();
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the login command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
        FileCredentials.storeUserCredentials(file, this.mEnvironment, entity);
    }

    void createProfile() throws CLIException {
        this.setCredentialsForCommand();
        try {
            this.createPolicyMgr();
            String string = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            Entity entity = this.getEntity(string, applicability);
            if (entity == null) {
                throw new CLIException("pgtool: the create command failed: the element does not exist", CLIException.COMMAND_FAILURE);
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the create command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the create command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            String string2 = this.mCmdLineArgs.getProfileName();
            if (string2 == null) {
                string2 = this.findNewProfileName(profileRepository);
            }
            Profile profile = profileRepository.createProfile(string2, applicability);
            int n = this.mCmdLineArgs.getPriority();
            if (n > 0 && profile != null) {
                profile.setPriority(n);
            }
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the create command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void renameProfile() throws CLIException {
        this.setCredentialsForCommand();
        String string = (String)this.mCmdLineArgs.getOperands().get(0);
        String string2 = (String)this.mCmdLineArgs.getOperands().get(1);
        try {
            Profile profile;
            this.createPolicyMgr();
            String string3 = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            Entity entity = this.getEntity(string3, applicability);
            if (entity == null) {
                throw new CLIException("pgtool: the rename command failed: the element does not exist", CLIException.COMMAND_FAILURE);
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the rename command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the rename command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            Iterator iterator = profileRepository.getProfiles(applicability);
            while (iterator.hasNext()) {
                profile = (Profile)iterator.next();
                if (!profile.getDisplayName().equals(string2)) continue;
                throw new CLIException("pgtool: the rename command failed: a profile with the new name " + string2 + " already exists ", CLIException.COMMAND_FAILURE);
            }
            profile = this.findProfile(profileRepository, string, applicability);
            if (profile == null) {
                throw new CLIException("pgtool: the rename command failed: a unique profile " + string + " cannot be found", CLIException.COMMAND_FAILURE);
            }
            profile.setDisplayName(string2);
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the rename command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void deleteProfile() throws CLIException {
        this.setCredentialsForCommand();
        try {
            this.createPolicyMgr();
            String string = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            Entity entity = this.getEntity(string, applicability);
            if (entity == null) {
                throw new CLIException("pgtool: the delete command failed: the element does not exist", CLIException.COMMAND_FAILURE);
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the delete command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the delete command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            String string2 = this.mCmdLineArgs.getProfileName();
            Profile profile = this.findProfile(profileRepository, string2, applicability);
            if (profile == null) {
                throw new CLIException("pgtool: the delete command failed: a unique profile " + string2 + " cannot be found", CLIException.COMMAND_FAILURE);
            }
            AssignmentProvider assignmentProvider = this.mPolicyMgr.getAssignmentProvider();
            Iterator iterator = profile.getAssignedEntities();
            while (iterator.hasNext()) {
                Entity entity2 = (Entity)iterator.next();
                assignmentProvider.unassignProfile(entity2, profile);
            }
            profileRepository.destroyProfile(profile);
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the delete command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void modifyProfilePriority() throws CLIException {
        this.setCredentialsForCommand();
        String string = (String)this.mCmdLineArgs.getOperands().get(0);
        String string2 = (String)this.mCmdLineArgs.getOperands().get(1);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CLIException("pgtool: invalid priority: " + string2, CLIException.INVALID_ARGS);
        }
        if (n <= 0) {
            throw new CLIException("pgtool: invalid priority: " + string2, CLIException.INVALID_ARGS);
        }
        try {
            this.createPolicyMgr();
            String string3 = this.mCmdLineArgs.getEntity();
            Applicability applicability = this.mCmdLineArgs.getApplicability();
            Entity entity = this.getEntity(string3, applicability);
            if (entity == null) {
                throw new CLIException("pgtool: the modify command failed: the element does not exist", CLIException.COMMAND_FAILURE);
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the modify command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the modify command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            Profile profile = this.findProfile(profileRepository, string, applicability);
            if (profile == null) {
                throw new CLIException("pgtool: the modify command failed: a unique profile " + string + " cannot be found", CLIException.COMMAND_FAILURE);
            }
            profile.setPriority(n);
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the modify command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void assignProfileToEntity() throws CLIException {
        this.setCredentialsForCommand();
        try {
            Applicability applicability;
            this.createPolicyMgr();
            String string = (String)this.mCmdLineArgs.getOperands().get(0);
            String string2 = (String)this.mCmdLineArgs.getOperands().get(1);
            Entity entity = this.mPolicyMgr.getEntity(string2);
            if (entity == null) {
                throw new CLIException("pgtool: the add command failed: the target element " + string2 + " does not exist", CLIException.INVALID_ARGS);
            }
            String string3 = this.mCmdLineArgs.getEntity();
            Entity entity2 = this.getEntity(string3, applicability = this.mCmdLineArgs.getApplicability());
            if (entity2 == null) {
                throw new CLIException("pgtool: the add command failed: the element does not exist", CLIException.INVALID_ARGS);
            }
            ProfileRepository profileRepository = entity2.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the add command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the add command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            Profile profile = this.findProfile(profileRepository, string, applicability);
            if (profile == null) {
                throw new CLIException("pgtool: the add command failed: a unique profile " + string + " cannot be found", CLIException.COMMAND_FAILURE);
            }
            entity.assignProfile(profile);
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the add command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    void unassignProfileFromEntity() throws CLIException {
        this.setCredentialsForCommand();
        try {
            Applicability applicability;
            this.createPolicyMgr();
            String string = (String)this.mCmdLineArgs.getOperands().get(0);
            String string2 = (String)this.mCmdLineArgs.getOperands().get(1);
            Entity entity = this.mPolicyMgr.getEntity(string2);
            if (entity == null) {
                throw new CLIException("pgtool: the remove command failed: the target element " + string2 + " does not exist", CLIException.INVALID_ARGS);
            }
            String string3 = this.mCmdLineArgs.getEntity();
            Entity entity2 = this.getEntity(string3, applicability = this.mCmdLineArgs.getApplicability());
            if (entity2 == null) {
                throw new CLIException("pgtool: the remove command failed: the element does not exist", CLIException.INVALID_ARGS);
            }
            ProfileRepository profileRepository = entity2.getProfileRepository();
            if (profileRepository == null) {
                throw new CLIException("pgtool: the remove command failed", CLIException.COMMAND_FAILURE);
            }
            if (profileRepository.isReadOnly()) {
                throw new CLIException("pgtool: the remove command failed: user has insufficient access rights", CLIException.COMMAND_FAILURE);
            }
            Profile profile = this.findProfile(profileRepository, string, applicability);
            if (profile == null) {
                throw new CLIException("pgtool: the remove command failed: a unique profile " + string + " cannot be found", CLIException.COMMAND_FAILURE);
            }
            entity.unassignProfile(profile);
        }
        catch (SPIException sPIException) {
            throw new CLIException("pgtool: the remove command failed: " + sPIException.getMessage(), CLIException.COMMAND_FAILURE);
        }
    }

    private PolicyMgrFactory createPolicyMgrFactory() throws SPIException {
        PolicyMgrFactoryImpl policyMgrFactoryImpl = new PolicyMgrFactoryImpl();
        return policyMgrFactoryImpl;
    }

    private void createPolicyMgr(PolicyMgrFactory policyMgrFactory) throws SPIException {
        this.mPolicyMgr = policyMgrFactory.createPolicyMgr(this.mEnvironment);
    }

    private void createPolicyMgr() throws SPIException {
        PolicyMgrFactory policyMgrFactory = this.createPolicyMgrFactory();
        this.createPolicyMgr(policyMgrFactory);
    }

    private void writeProfileStreamToFile(ByteArrayOutputStream byteArrayOutputStream, String string, String string2) throws CLIException {
        String string3 = null;
        String string4 = null;
        int n = string2.lastIndexOf(File.separator);
        string3 = string2.substring(0, n);
        string4 = this.extractFileName(string2, n, ZIP_EXTENSION);
        if (string4 == null) {
            string3 = string2 + File.separator;
            string4 = string + ZIP_EXTENSION;
        } else if (!string4.endsWith(ZIP_EXTENSION)) {
            throw new CLIException("pgtool: invalid file name: " + string4, CLIException.INVALID_ARGS);
        }
        File file = new File(string3);
        if (!(file.isDirectory() || file.mkdir() && file.canWrite())) {
            throw new CLIException("pgtool: cannot access directory: " + string3, CLIException.INVALID_ARGS);
        }
        File file2 = new File(file, string4);
        try {
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byteArrayOutputStream.writeTo(fileOutputStream);
        }
        catch (Exception exception) {
            throw new CLIException("pgtool: cannot create file: " + string4, CLIException.COMMAND_FAILURE);
        }
    }

    private String extractFileName(String string, int n, String string2) {
        String string3 = null;
        if (string.length() > ++n && (string3 = string.substring(n)) != null) {
            int n2 = string3.lastIndexOf(".");
            if (n2 != -1 && string3.length() > n2) {
                String string4 = string3.substring(n2, string3.length());
                if (!string4.equalsIgnoreCase(string2)) {
                    string3 = null;
                }
            } else {
                string3 = null;
            }
        }
        return string3;
    }

    private BufferedInputStream getBufferedInputStream(String string) throws CLIException {
        String string2 = null;
        String string3 = null;
        int n = string.lastIndexOf(File.separator);
        string2 = string.substring(0, n);
        File file = new File(string2);
        if (file.isDirectory()) {
            string3 = this.extractFileName(string, n, ZIP_EXTENSION);
        }
        if (!file.isDirectory() || string3 == null) {
            throw new CLIException("the file does not exist", 1);
        }
        File file2 = new File(file, string3);
        if (!file2.canRead()) {
            throw new CLIException("the file cannot be accessed: " + string3, 1);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
        }
        catch (Exception exception) {
            throw new CLIException("the file cannot be accessed: " + string3, 1);
        }
        return new BufferedInputStream(fileInputStream);
    }

    void printProfiles(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer(50);
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            stringBuffer.delete(0, stringBuffer.length());
            String string = profile.getDisplayName();
            if (string.length() > 30) {
                stringBuffer.append(string.substring(0, 30));
            } else {
                stringBuffer.append(string);
                for (int i = stringBuffer.length(); i < 30; ++i) {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append("\t");
            stringBuffer.append(profile.getApplicability().getStringValue());
            stringBuffer.append("\t");
            String string2 = Integer.toString(profile.getPriority());
            if (string2.length() > 50 - stringBuffer.length()) {
                stringBuffer.append(string2.substring(0, 50 - stringBuffer.length()));
            } else {
                stringBuffer.append(string2);
            }
            System.out.println(stringBuffer.toString());
        }
    }

    void printEntities(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer(90);
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            stringBuffer.delete(0, stringBuffer.length());
            try {
                String string = entity.getId();
                if (string.length() > 60) {
                    stringBuffer.append(string.substring(0, 60));
                } else {
                    stringBuffer.append(string);
                    for (int i = stringBuffer.length(); i < 60; ++i) {
                        stringBuffer.append(" ");
                    }
                }
                stringBuffer.append("\t");
                String string2 = entity.getDisplayName();
                if (string2.length() > 90 - stringBuffer.length()) {
                    stringBuffer.append(string2.substring(0, 90 - stringBuffer.length()));
                } else {
                    stringBuffer.append(string2);
                }
                System.out.println(stringBuffer.toString());
            }
            catch (SPIException sPIException) {}
        }
    }

    private String getInput(String string) throws CLIException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        System.out.println(string);
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new CLIException("pgtool: error reading user input.", CLIException.COMMAND_FAILURE);
        }
        return string2;
    }

    private void setEnvironmentTable() throws CLIException {
        this.mEnvironment = new Hashtable();
        String string = this.mCmdLineArgs.getUserName();
        if (string != null) {
            this.mEnvironment.put("SECURITY_PRINCIPAL", string);
        }
        if (this.mCmdLineArgs.getAuthType() != null) {
            this.mEnvironment.put("AuthType", this.mCmdLineArgs.getAuthType());
        }
        if (this.mCmdLineArgs.getUrl() != null) {
            this.mEnvironment.put("PROVIDER_URL", this.mCmdLineArgs.getUrl());
        } else {
            if (this.mCmdLineArgs.getBaseEntry() != null) {
                String string2 = "ldap";
                String string3 = "localhost";
                int n = 389;
                String string4 = this.mCmdLineArgs.getBaseEntry();
                if (!string4.startsWith("/")) {
                    string4 = "/" + string4;
                }
                if (this.mCmdLineArgs.getType() != null) {
                    string2 = this.mCmdLineArgs.getType();
                    string2 = string2.toLowerCase();
                }
                if (this.mCmdLineArgs.getHostName() != null) {
                    string3 = this.mCmdLineArgs.getHostName();
                }
                if (this.mCmdLineArgs.getPort() != null) {
                    try {
                        n = Integer.parseInt(this.mCmdLineArgs.getPort());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                try {
                    URI uRI = new URI(string2, string, string3, n, string4, null, null);
                    this.mEnvironment.put("PROVIDER_URL", uRI.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new CLIException("pgtool: error in constructing url from parameters " + uRISyntaxException.toString(), CLIException.COMMAND_FAILURE);
                }
            }
            try {
                String string5 = this.mCmdLineArgs.getBootstrapFile();
                FileInputStream fileInputStream = new FileInputStream(string5);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                EnvironmentMgr environmentMgr = new EnvironmentMgr((Hashtable)properties);
                environmentMgr.translateOldParameters();
                this.mEnvironment = environmentMgr.getEnvironment();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CLIException("pgtool: bootstrapping file " + this.mCmdLineArgs.getBootstrapFile() + " does not exist.", CLIException.COMMAND_FAILURE);
            }
            catch (SecurityException securityException) {
                throw new CLIException("pgtool: read access denied to bootstrapping file " + this.mCmdLineArgs.getBootstrapFile() + ".", CLIException.COMMAND_FAILURE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CLIException("pgtool: Cannot read bootstrapping data from file " + this.mCmdLineArgs.getBootstrapFile() + ".", CLIException.COMMAND_FAILURE);
            }
            catch (IOException iOException) {
                throw new CLIException("pgtool: Cannot read bootstrapping data from file " + this.mCmdLineArgs.getBootstrapFile() + ".", CLIException.COMMAND_FAILURE);
            }
        }
    }

    public void setCredentialsForCommand() throws CLIException {
        File file = FileCredentials.getExistingCredentialsFile();
        Properties properties = FileCredentials.getCredentialsFileProperties(file);
        String string = (String)this.mEnvironment.get("SECURITY_PRINCIPAL");
        if (properties == null) {
            if (string == null) {
                this.mEnvironment.put("SECURITY_PRINCIPAL", this.getInput(USERNAME_PROMPT));
            }
            this.mEnvironment.put("SECURITY_CREDENTIALS", this.getMaskedPasswordInput(USER_PASSWORD_PROMPT));
            this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "none");
        } else {
            String string2 = null;
            char[] cArray = null;
            ArrayList arrayList = null;
            if (string != null) {
                string2 = FileCredentials.getStoredUserEntry(properties, this.mEnvironment);
                if (string2 != null) {
                    cArray = FileCredentials.getStoredUserPassword(properties, this.mEnvironment);
                    if (cArray == null) {
                        throw new CLIException("pgtool: incomplete data in user's .apocpass.", CLIException.COMMAND_FAILURE);
                    }
                    this.mEnvironment.put("SECURITY_PRINCIPAL", string);
                    this.mEnvironment.put("SECURITY_CREDENTIALS", cArray);
                    this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "scramble");
                    this.mEnvironment.put("AuthDn", string2);
                    this.mEnvironment.put("Password", cArray);
                    this.mEnvironment.put("Password_ENCODING", "scramble");
                } else {
                    this.mEnvironment.put("SECURITY_CREDENTIALS", this.getMaskedPasswordInput(USER_PASSWORD_PROMPT));
                    this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "none");
                    arrayList = FileCredentials.getStoredUserEntryKeys(properties, this.mEnvironment);
                    if (!arrayList.isEmpty()) {
                        String string3 = (String)arrayList.get(0);
                        string2 = FileCredentials.getStoredUserEntry(properties, string3);
                        cArray = FileCredentials.getStoredUserPassword(properties, string3);
                        if (cArray == null) {
                            throw new CLIException("pgtool: incomplete data in user's .apocpass.", CLIException.COMMAND_FAILURE);
                        }
                        this.mEnvironment.put("AuthDn", string2);
                        this.mEnvironment.put("Password", cArray);
                        this.mEnvironment.put("Password_ENCODING", "scramble");
                    }
                }
            } else {
                arrayList = FileCredentials.getStoredUserEntryKeys(properties, this.mEnvironment);
                if (arrayList.isEmpty()) {
                    this.mEnvironment.put("SECURITY_PRINCIPAL", this.getInput(USERNAME_PROMPT));
                    this.mEnvironment.put("SECURITY_CREDENTIALS", this.getMaskedPasswordInput(USER_PASSWORD_PROMPT));
                    this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "none");
                } else if (arrayList.size() == 1) {
                    String string4 = (String)arrayList.get(0);
                    string2 = FileCredentials.getStoredUserEntry(properties, string4);
                    string = FileCredentials.getUserNameFromKey(string4);
                    cArray = FileCredentials.getStoredUserPassword(properties, string4);
                    if (cArray == null) {
                        throw new CLIException("pgtool: incomplete data in user's .apocpass.", CLIException.COMMAND_FAILURE);
                    }
                    this.mEnvironment.put("SECURITY_PRINCIPAL", string);
                    this.mEnvironment.put("SECURITY_CREDENTIALS", cArray);
                    this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "scramble");
                    this.mEnvironment.put("AuthDn", string2);
                    this.mEnvironment.put("Password", cArray);
                    this.mEnvironment.put("Password_ENCODING", "scramble");
                } else {
                    this.mEnvironment.put("SECURITY_PRINCIPAL", this.getInput(USERNAME_PROMPT));
                    string2 = FileCredentials.getStoredUserEntry(properties, this.mEnvironment);
                    if (string2 != null) {
                        cArray = FileCredentials.getStoredUserPassword(properties, this.mEnvironment);
                        if (cArray == null) {
                            throw new CLIException("pgtool: incomplete data in user's .apocpass.", CLIException.COMMAND_FAILURE);
                        }
                        this.mEnvironment.put("SECURITY_CREDENTIALS", cArray);
                        this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "scramble");
                        this.mEnvironment.put("AuthDn", string2);
                        this.mEnvironment.put("Password", cArray);
                        this.mEnvironment.put("Password_ENCODING", "scramble");
                    } else {
                        this.mEnvironment.put("SECURITY_CREDENTIALS", this.getMaskedPasswordInput(USER_PASSWORD_PROMPT));
                        this.mEnvironment.put("SECURITY_CREDENTIALS_ENCODING", "none");
                        String string5 = (String)arrayList.get(0);
                        string2 = FileCredentials.getStoredUserEntry(properties, string5);
                        cArray = FileCredentials.getStoredUserPassword(properties, string5);
                        if (cArray == null) {
                            throw new CLIException("pgtool: incomplete data in user's .apocpass.", CLIException.COMMAND_FAILURE);
                        }
                        this.mEnvironment.put("AuthDn", string2);
                        this.mEnvironment.put("Password", cArray);
                        this.mEnvironment.put("Password_ENCODING", "scramble");
                    }
                }
            }
        }
    }

    private char[] getMaskedPasswordInput(String string) throws CLIException {
        char[] cArray = MaskedInput.getPassword(System.in, USER_PASSWORD_PROMPT);
        if (cArray == null) {
            throw new CLIException("pgtool: password was not entered.", CLIException.INVALID_ARGS);
        }
        return cArray;
    }

    public static void main(String[] stringArray) {
        block13: {
            try {
                PolicyGroupTool policyGroupTool = new PolicyGroupTool();
                policyGroupTool.processArguments(stringArray);
                String string = policyGroupTool.mCmdLineArgs.getSubcommand();
                if (string.equals("login")) {
                    policyGroupTool.login();
                    break block13;
                }
                if (string.equals("add")) {
                    policyGroupTool.assignProfileToEntity();
                    break block13;
                }
                if (string.equals("create")) {
                    policyGroupTool.createProfile();
                    break block13;
                }
                if (string.equals("delete")) {
                    policyGroupTool.deleteProfile();
                    break block13;
                }
                if (string.equals("export")) {
                    policyGroupTool.exportProfile();
                    break block13;
                }
                if (string.equals("import")) {
                    policyGroupTool.importProfile();
                    break block13;
                }
                if (string.equals("list")) {
                    policyGroupTool.list();
                    break block13;
                }
                if (string.equals("modify")) {
                    policyGroupTool.modifyProfilePriority();
                    break block13;
                }
                if (string.equals("remove")) {
                    policyGroupTool.unassignProfileFromEntity();
                    break block13;
                }
                if (string.equals("rename")) {
                    policyGroupTool.renameProfile();
                    break block13;
                }
                throw new CLIException("pgtool: a valid command was not specified", CLIException.INVALID_ARGS);
            }
            catch (CLIException cLIException) {
                System.err.println(cLIException.getMessage());
                if (cLIException.getErrorCode() == CLIException.INVALID_ARGS) {
                    PolicyGroupTool.printUsage();
                }
                System.exit(cLIException.getErrorCode());
            }
        }
    }
}

