/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi;

import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.Provider;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.DomainTreeProvider;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.OrganizationTreeProvider;
import com.sun.apoc.spi.environment.EnvironmentMgr;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class PolicyMgrImpl
implements PolicyMgr {
    private EnvironmentMgr mEnvironmentMgr;
    private Hashtable mConnections = new Hashtable();
    private Set mFailedURLs = new HashSet();
    private OrganizationTreeProvider mOrgTreeProvider;
    private DomainTreeProvider mDomTreeProvider;
    private ProfileProvider mProfileProvider;
    private AssignmentProvider mAssignmentProvider;

    public PolicyMgrImpl(Hashtable hashtable) throws SPIException {
        this.mEnvironmentMgr = new EnvironmentMgr(hashtable);
        this.mEnvironmentMgr.checkEnvironment();
    }

    public void setOrganizationTreeProvider(OrganizationTreeProvider organizationTreeProvider) {
        this.mOrgTreeProvider = organizationTreeProvider;
    }

    public void setDomainTreeProvider(DomainTreeProvider domainTreeProvider) {
        this.mDomTreeProvider = domainTreeProvider;
    }

    public void setProfileProvider(ProfileProvider profileProvider) {
        this.mProfileProvider = profileProvider;
    }

    public void setAssignmentProvider(AssignmentProvider assignmentProvider) {
        this.mAssignmentProvider = assignmentProvider;
    }

    public Hashtable getEnvironment() {
        return this.mEnvironmentMgr.getEnvironment();
    }

    public Organization getRootOrganization() throws SPIException {
        Organization organization = null;
        if (this.mOrgTreeProvider != null) {
            organization = this.mOrgTreeProvider.getRootOrganization();
        }
        return organization;
    }

    public Domain getRootDomain() throws SPIException {
        Domain domain = null;
        if (this.mDomTreeProvider != null) {
            domain = this.mDomTreeProvider.getRootDomain();
        }
        return domain;
    }

    public void close() throws SPIException {
        HashSet<Provider> hashSet = new HashSet<Provider>();
        if (this.mOrgTreeProvider != null) {
            hashSet.add(this.mOrgTreeProvider);
        }
        if (this.mDomTreeProvider != null) {
            hashSet.add(this.mDomTreeProvider);
        }
        if (this.mProfileProvider != null) {
            hashSet.add(this.mProfileProvider);
        }
        if (this.mAssignmentProvider != null) {
            hashSet.add(this.mAssignmentProvider);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((Provider)iterator.next()).close();
        }
    }

    public Entity getEntity(String string) throws SPIException {
        Entity entity = null;
        Organization organization = this.getRootOrganization();
        Domain domain = this.getRootDomain();
        if (organization != null && string.equals(organization.getId())) {
            entity = organization;
        }
        if (entity == null && domain != null && string.equals(domain.getId())) {
            entity = domain;
        }
        if (entity == null && organization != null) {
            entity = organization.getEntity(string);
        }
        if (entity == null && domain != null) {
            entity = domain.getEntity(string);
        }
        return entity;
    }

    public Profile getProfile(String string) throws SPIException {
        Profile profile = null;
        if (this.mProfileProvider != null) {
            profile = this.mProfileProvider.getProfile(string);
        }
        return profile;
    }

    public ProfileRepository getDefaultProfileRepository() throws SPIException {
        ProfileRepository profileRepository = null;
        if (this.mProfileProvider != null) {
            profileRepository = this.mProfileProvider.getDefaultProfileRepository();
        }
        return profileRepository;
    }

    public ProfileRepository getProfileRepository(String string) throws SPIException {
        ProfileRepository profileRepository = null;
        if (this.mProfileProvider != null) {
            profileRepository = this.mProfileProvider.getProfileRepository(string);
        }
        return profileRepository;
    }

    public OrganizationTreeProvider getOrganizationTreeProvider() {
        return this.mOrgTreeProvider;
    }

    public DomainTreeProvider getDomainTreeProvider() {
        return this.mDomTreeProvider;
    }

    public ProfileProvider getProfileProvider() {
        return this.mProfileProvider;
    }

    public AssignmentProvider getAssignmentProvider() {
        return this.mAssignmentProvider;
    }

    public synchronized Object getConnectionHandler(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.mConnections.get(string);
        }
        return var2_2;
    }

    public synchronized void setConnectionHandler(String string, Object object) {
        if (string != null) {
            if (object == null) {
                this.mConnections.remove(string);
            } else {
                this.mConnections.put(string, object);
            }
        }
    }

    public synchronized boolean isFailedURL(String string) {
        return this.mFailedURLs.contains(string);
    }

    public synchronized void addFailedURL(String string) {
        if (!this.isFailedURL(string)) {
            this.mFailedURLs.add(string);
        }
    }
}

