/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.environment;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.environment.MissingParameterException;
import com.sun.apoc.spi.environment.PasswordCodec;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class EnvironmentMgr {
    private static final String SERVER_KEY = "Server";
    private static final String PORT_KEY = "Port";
    private static final String BASE_DN_KEY = "BaseDn";
    private static final String TYPE_KEY = "DataStoreType";
    private static final String LDAP_TYPE = "LDAP";
    protected Hashtable mEnvironment;
    protected HashSet mLdapProtocols;
    protected HashSet mFileProtocols;

    public EnvironmentMgr(Hashtable hashtable) {
        this.mEnvironment = hashtable;
        this.mLdapProtocols = new HashSet();
        this.mLdapProtocols.add("ldap");
        this.mLdapProtocols.add("ldaps");
        this.mFileProtocols = new HashSet();
        this.mFileProtocols.add("file");
        this.mFileProtocols.add("http");
        this.mFileProtocols.add("https");
    }

    public void translateOldParameters() {
        if (this.getOrganizationURLs().length == 0 && this.getDomainURLs().length == 0 && this.getProfileURLs().length == 0 && this.getAssignmentURLs().length == 0) {
            String string = (String)this.mEnvironment.get(TYPE_KEY);
            if (string == null || string.length() == 0) {
                string = LDAP_TYPE;
            }
            if (string.equals(LDAP_TYPE)) {
                boolean bl;
                String string2 = (String)this.mEnvironment.get(SERVER_KEY);
                boolean bl2 = string2 == null || string2.length() == 0;
                String string3 = (String)this.mEnvironment.get(BASE_DN_KEY);
                boolean bl3 = bl = string3 == null || string3.length() == 0;
                if (!bl2 && !bl) {
                    boolean bl4;
                    StringBuffer stringBuffer = new StringBuffer("ldap");
                    stringBuffer.append("://").append(string2);
                    String string4 = (String)this.mEnvironment.get(PORT_KEY);
                    boolean bl5 = bl4 = string4 == null || string4.length() == 0;
                    if (!bl4) {
                        stringBuffer.append(":").append(string4);
                    }
                    stringBuffer.append("/").append(string3);
                    this.mEnvironment.put("PROVIDER_URL", stringBuffer.toString());
                }
            }
        }
    }

    public void checkEnvironment() throws SPIException {
        if (this.getOrganizationURLs().length == 0) {
            throw new MissingParameterException("organization PROVIDER_URL");
        }
        if (this.getDomainURLs().length == 0) {
            throw new MissingParameterException("domain PROVIDER_URL");
        }
        if (this.getProfileURLs().length == 0) {
            throw new MissingParameterException("profile PROVIDER_URL");
        }
        if (this.getAssignmentURLs().length == 0) {
            throw new MissingParameterException("assignment PROVIDER_URL");
        }
    }

    public Hashtable getEnvironment() {
        return this.mEnvironment;
    }

    protected String getStringParam(String string) {
        return (String)this.mEnvironment.get(string);
    }

    protected String getParam(String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = this.getStringParam(string + string2);
        }
        if (string3 == null) {
            string3 = this.getStringParam(string2);
        }
        return string3;
    }

    protected String[] getURLList(String string) {
        String[] stringArray = new String[]{};
        if (string != null) {
            stringArray = string.split("\\s");
        }
        return stringArray;
    }

    protected int getIntParamFromString(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    protected char[] getPasswordParam(String string, String string2) {
        String string3;
        Object var3_3 = null;
        char[] cArray = null;
        var3_3 = this.mEnvironment.get(string + string2);
        if (var3_3 == null) {
            var3_3 = this.mEnvironment.get(string2);
        }
        if (var3_3 != null) {
            if (var3_3 instanceof String) {
                cArray = ((String)var3_3).toCharArray();
            } else {
                try {
                    cArray = var3_3;
                }
                catch (ClassCastException classCastException) {
                    cArray = null;
                }
            }
        }
        if ((string3 = this.getStringParam(string + string2 + "_ENCODING")) == null) {
            string3 = this.getStringParam(string2 + "_ENCODING");
        }
        if (string3 != null && string3.equals("scramble")) {
            cArray = PasswordCodec.decode(cArray);
        }
        return cArray;
    }

    public static String getUserFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getUserInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getProtocolFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getScheme();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getHostFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static int getPortFromURL(String string) {
        int n = -1;
        try {
            URI uRI = new URI(string);
            n = uRI.getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static String getPathFromURL(String string) {
        String string2 = null;
        try {
            string2 = new URI(string).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public String[] getOrganizationURLs() {
        String string = this.getParam("ORGANIZATION_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getDomainURLs() {
        String string = this.getParam("DOMAIN_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getProfileURLs() {
        String string = this.getParam("PROFILE_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public String[] getAssignmentURLs() {
        String string = this.getParam("ASSIGNMENT_", "PROVIDER_URL");
        return this.getURLList(string);
    }

    public char[] getOrganizationCredentials() {
        return this.getPasswordParam("ORGANIZATION_", "SECURITY_CREDENTIALS");
    }

    public char[] getDomainCredentials() {
        return this.getPasswordParam("DOMAIN_", "SECURITY_CREDENTIALS");
    }

    public char[] getProfileCredentials() {
        return this.getPasswordParam("PROFILE_", "SECURITY_CREDENTIALS");
    }

    public char[] getAssignmentCredentials() {
        return this.getPasswordParam("ASSIGNMENT_", "SECURITY_CREDENTIALS");
    }

    public String getOrganizationClass() {
        return this.getParam("ORGANIZATION_", "PROVIDER_CLASS");
    }

    public String getDomainClass() {
        return this.getParam("DOMAIN_", "PROVIDER_CLASS");
    }

    public String getProfileClass() {
        return this.getParam("PROFILE_", "PROVIDER_CLASS");
    }

    public String getAssignmentClass() {
        return this.getParam("ASSIGNMENT_", "PROVIDER_CLASS");
    }

    public String getOrganizationUser(String string) {
        String string2 = null;
        string2 = EnvironmentMgr.getUserFromURL(string);
        if (string2 == null) {
            string2 = this.getParam("ORGANIZATION_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public String getDomainUser(String string) {
        String string2 = null;
        if (string != null) {
            string2 = EnvironmentMgr.getUserFromURL(string);
        }
        if (string2 == null) {
            string2 = this.getParam("DOMAIN_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public String getProfileUser(String string) {
        String string2 = null;
        if (string != null) {
            string2 = EnvironmentMgr.getUserFromURL(string);
        }
        if (string2 == null) {
            string2 = this.getParam("PROFILE_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public String getAssignmentUser(String string) {
        String string2 = null;
        if (string != null) {
            string2 = EnvironmentMgr.getUserFromURL(string);
        }
        if (string2 == null) {
            string2 = this.getParam("ASSIGNMENT_", "SECURITY_PRINCIPAL");
        }
        return string2;
    }

    public boolean isLdapProtocol(String string) {
        return this.mLdapProtocols.contains(string);
    }

    public boolean isFileProtocol(String string) {
        return this.mFileProtocols.contains(string);
    }

    public String getSupportedProtocolsString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Iterator iterator = this.mLdapProtocols.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next()).append(",");
        }
        Iterator iterator2 = this.mFileProtocols.iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append((String)iterator2.next()).append(",");
        }
        if (stringBuffer.lastIndexOf(",") == stringBuffer.length() - 1) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

