/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.OrganizationTreeProvider;
import com.sun.apoc.spi.file.entities.FileEntityProvider;
import com.sun.apoc.spi.file.entities.FileNode;
import com.sun.apoc.spi.file.entities.FileOrganization;
import com.sun.apoc.spi.file.entities.FileUser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;

public class FileOrganizationProvider
extends FileEntityProvider
implements OrganizationTreeProvider {
    private static final String DEFAULT_ORG_CONTAINER = "entities.txt";

    public FileOrganizationProvider(PolicyMgr policyMgr, String string) throws SPIException {
        super(policyMgr, string, DEFAULT_ORG_CONTAINER);
    }

    public Organization getRootOrganization() throws SPIException {
        if (!this.mDataIsLoaded) {
            this.loadData();
        }
        return (Organization)this.mRootNode;
    }

    protected void loadData() throws SPIException {
        if (this.mRootNode != null) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mLocation.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("u:") && !string.endsWith("/")) {
                    this.createEntities(true, string);
                    continue;
                }
                if (!string.startsWith("o:")) continue;
                this.createEntities(false, string);
            }
            bufferedReader.close();
            if (this.mRootNode == null) {
                this.mRootNode = new FileOrganization("", "fakeOrgRoot", null, this.mPolicyMgr);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", iOException);
        }
        this.mDataIsLoaded = true;
    }

    private void createEntities(boolean bl, String string) throws SPIException {
        if (string.indexOf(47) != -1) {
            String[] stringArray = string.split("/");
            StringBuffer stringBuffer = new StringBuffer(stringArray[1]).append("Org");
            if (this.mRootNode == null) {
                this.mRootNode = new FileOrganization(stringArray[1], stringBuffer.toString(), null, this.mPolicyMgr);
            } else if (!this.mRootNode.getId().contentEquals(stringBuffer)) {
                return;
            }
            if (stringArray.length > 2) {
                FileOrganization fileOrganization;
                int n;
                FileNode fileNode = (FileNode)this.mRootNode;
                for (n = 2; n < stringArray.length - 1; ++n) {
                    Iterator iterator = fileNode.getChildren();
                    stringBuffer.append("_");
                    stringBuffer.append(stringArray[n]);
                    if (!this.contains(iterator, stringBuffer.toString())) {
                        fileOrganization = new FileOrganization(stringArray[n], stringBuffer.toString(), fileNode, this.mPolicyMgr);
                        fileNode.addChildNode(fileOrganization);
                        fileNode = fileOrganization;
                        continue;
                    }
                    fileNode = (FileNode)this.internalGetEntity(stringBuffer.toString());
                }
                stringBuffer.append("_");
                stringBuffer.append(stringArray[n]);
                if (bl) {
                    FileUser fileUser = new FileUser(stringArray[n], stringBuffer.toString(), fileNode, this.mPolicyMgr);
                    fileNode.addChildLeaf(fileUser);
                } else {
                    fileOrganization = new FileOrganization(stringArray[n], stringBuffer.toString(), fileNode, this.mPolicyMgr);
                    fileNode.addChildNode(fileOrganization);
                }
            }
        }
    }

    private boolean contains(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!entity.getId().equals(string)) continue;
            return true;
        }
        return false;
    }
}

