/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.file.profiles;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.IllegalWriteException;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.file.profiles.FileProfileRepository;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.policies.PolicyInfo;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.InvalidPriorityException;
import com.sun.apoc.spi.profiles.InvalidProfileException;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import com.sun.apoc.spi.profiles.ProfileStreamException;
import com.sun.apoc.spi.profiles.ProfileZipException;
import com.sun.apoc.spi.profiles.ZipProfileReadWrite;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileProfile
implements Profile {
    private ProfileRepository mRepository;
    private Applicability mApplicability;
    private final int BUFSIZE = 2028;
    private PolicyMgr mPolicyMgr;
    private String mDisplayName;
    private Map mPolicyCache;
    private URL mProfileURL;
    private String mComment;
    private String mAuthor;
    private int mPriority;
    private String mId;
    private long mLastModified;

    public static Profile loadProfile(String string, ProfileRepository profileRepository, PolicyMgr policyMgr) throws SPIException {
        Applicability applicability = null;
        String string2 = null;
        String string3 = "";
        String string4 = "";
        int n = 0;
        FileProfile fileProfile = null;
        URL uRL = null;
        uRL = FileProfile.getProfileURL(string, profileRepository);
        fileProfile = new FileProfile(string, profileRepository, string2, string4, applicability, n, uRL, policyMgr, string3, true);
        return fileProfile;
    }

    public static Profile createNewProfile(ProfileRepository profileRepository, String string, Applicability applicability, int n, PolicyMgr policyMgr) throws SPIException {
        FileProfile fileProfile = null;
        if (profileRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer(profileRepository.getId()).append("-");
        stringBuffer.append(Integer.toString(Math.abs(random.nextInt())));
        URL uRL = FileProfile.getProfileURL(stringBuffer.toString(), profileRepository);
        String string2 = "";
        if (policyMgr.getEnvironment().containsKey("SECURITY_PRINCIPAL")) {
            string2 = (String)policyMgr.getEnvironment().get("SECURITY_PRINCIPAL");
        }
        fileProfile = new FileProfile(stringBuffer.toString(), profileRepository, string, "", applicability, n, uRL, policyMgr, string2, false);
        fileProfile.writeProfile();
        return fileProfile;
    }

    public void setPriority(int n) throws SPIException {
        if (((FileProfileRepository)this.mRepository).priorityExists(n)) {
            throw new InvalidPriorityException("error.spi.profile.priority.used", n);
        }
        this.mPriority = n;
        this.writeProfile();
    }

    public void setDisplayName(String string) throws SPIException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.mRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        this.mDisplayName = string;
        this.writeProfile();
    }

    public void storePolicy(Policy policy) throws SPIException {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        if (this.mRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        String string = policy.getId();
        if (this.mPolicyCache.containsKey(string)) {
            this.mPolicyCache.remove(string);
        }
        if (policy.getData() != null) {
            Policy policy2 = policy;
            if (policy.getProfileId() == null) {
                policy2 = new Policy(policy.getId(), this.getId(), policy.getData(), policy.getLastModified());
            }
            this.mPolicyCache.put(string, policy2);
        }
        this.writeProfile();
    }

    public void destroyPolicy(Policy policy) throws SPIException {
        if (this.mRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        String string = policy.getId();
        if (this.mPolicyCache.containsKey(string)) {
            this.mPolicyCache.remove(string);
        }
        this.writeProfile();
    }

    public boolean hasPolicies() throws SPIException {
        return this.mPolicyCache.size() != 0;
    }

    public Iterator getPolicies() throws SPIException {
        return this.mPolicyCache.values().iterator();
    }

    public Iterator getPolicies(ArrayList arrayList) throws SPIException {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.mPolicyCache.containsKey(string)) continue;
            linkedList.add(this.mPolicyCache.get(string));
        }
        return linkedList.iterator();
    }

    public Policy getPolicy(String string) throws SPIException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Policy policy = null;
        if (this.mPolicyCache.containsKey(string)) {
            policy = (Policy)this.mPolicyCache.get(string);
        }
        return policy;
    }

    public boolean hasAssignedEntities() throws SPIException {
        return this.mPolicyMgr.getAssignmentProvider().getAssignedEntities(this).hasNext();
    }

    public Iterator getAssignedEntities() throws SPIException {
        return this.mPolicyMgr.getAssignmentProvider().getAssignedEntities(this);
    }

    public void setApplicability(Applicability applicability) throws SPIException {
        if (applicability == null) {
            throw new IllegalArgumentException();
        }
        if (this.mRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        this.mApplicability = applicability;
        this.writeProfile();
    }

    public void setComment(String string) throws SPIException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.mRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        this.mComment = string;
        this.writeProfile();
    }

    public String getAuthor() throws SPIException {
        if (this.mAuthor == null) {
            return new String("");
        }
        return this.mAuthor;
    }

    public boolean equals(Object object) {
        Profile profile = (Profile)object;
        return this.mId.equals(profile.getId());
    }

    private FileProfile(String string, ProfileRepository profileRepository, String string2, String string3, Applicability applicability, int n, URL uRL, PolicyMgr policyMgr, String string4, boolean bl) throws SPIException {
        this.mApplicability = applicability;
        this.mDisplayName = string2;
        this.mRepository = profileRepository;
        this.mProfileURL = uRL;
        this.mPolicyMgr = policyMgr;
        this.mPriority = n;
        this.mComment = string3;
        this.mAuthor = string4;
        this.mId = string;
        this.mPolicyCache = Collections.synchronizedMap(new HashMap());
        if (bl) {
            this.readPolicy();
        } else {
            this.mLastModified = System.currentTimeMillis();
        }
    }

    private void readPolicy() throws SPIException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(this.mProfileURL.openStream());
            Properties properties = ZipProfileReadWrite.readMetaData(zipInputStream);
            Iterator iterator = null;
            if (properties != null) {
                iterator = ZipProfileReadWrite.readPolicies(zipInputStream);
            } else {
                iterator = ZipProfileReadWrite.readOldPoliciesFormat(zipInputStream);
                if (!iterator.hasNext()) {
                    zipInputStream.close();
                    throw new ProfileStreamException("error.spi.profile.stream.empty");
                }
            }
            zipInputStream.close();
            this.mLastModified = 0L;
            while (iterator.hasNext()) {
                Policy policy = (Policy)iterator.next();
                this.mPolicyCache.put(policy.getId(), new Policy(policy.getId(), this.mId, policy.getData(), policy.getLastModified()));
                if (this.mLastModified >= policy.getLastModified()) continue;
                this.mLastModified = policy.getLastModified();
            }
            this.setMetaData(properties);
        }
        catch (ZipException zipException) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileZipException(zipException);
        }
        catch (IOException iOException) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileStreamException("error.spi.profile.stream.error", iOException);
        }
    }

    private void writeProfile() throws SPIException {
        FileOutputStream fileOutputStream = null;
        if (this.mRepository.isReadOnly()) {
            throw new IllegalWriteException();
        }
        try {
            ((FileProfileRepository)this.mRepository).createStorage();
            fileOutputStream = new FileOutputStream(this.mProfileURL.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalWriteException("error.spi.access.illegal.write.file", fileNotFoundException);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        try {
            this.mLastModified = System.currentTimeMillis();
            ZipProfileReadWrite.writeMetaData(this, zipOutputStream);
            ZipProfileReadWrite.writePolicies(this, zipOutputStream);
            zipOutputStream.close();
            fileOutputStream.close();
        }
        catch (ZipException zipException) {
            try {
                zipOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileZipException(zipException);
        }
        catch (IOException iOException) {
            try {
                zipOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProfileStreamException("error.spi.profile.stream.error", iOException);
        }
    }

    private void setMetaData(Properties properties) {
        if (properties != null) {
            String string;
            if (properties.containsKey("DisplayName")) {
                this.mDisplayName = (String)properties.get("DisplayName");
            }
            if (properties.containsKey("Comment")) {
                this.mComment = (String)properties.get("Comment");
            }
            if (properties.containsKey("Applicability")) {
                string = (String)properties.get("Applicability");
                this.mApplicability = Applicability.getApplicability(string);
            }
            if (properties.containsKey("Priority")) {
                string = (String)properties.get("Priority");
                this.mPriority = new Integer(string);
            }
            if (properties.containsKey("Author")) {
                this.mAuthor = (String)properties.get("Author");
            }
            if (properties.containsKey("LastModified")) {
                this.mLastModified = Long.parseLong((String)properties.get("LastModified"));
            }
        }
    }

    protected static URL getProfileURL(String string, ProfileRepository profileRepository) throws SPIException {
        if (string.indexOf(45) == -1) {
            throw new InvalidProfileException("error.spi.profile.invalid.id", string);
        }
        StringBuffer stringBuffer = new StringBuffer(((FileProfileRepository)profileRepository).getLocation());
        String string2 = profileRepository.getId();
        String[] stringArray = string.split("\\Q" + string2 + "-\\E");
        stringBuffer.append(stringArray[1]);
        stringBuffer.append(".zip");
        URL uRL = null;
        try {
            uRL = new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalReadException("error.spi.access.illegal.read.file", malformedURLException);
        }
        return uRL;
    }

    public String getId() {
        return this.mId;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null) {
            return new String("");
        }
        return this.mDisplayName;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public long getLastModified() throws SPIException {
        return this.mLastModified;
    }

    public Applicability getApplicability() {
        return this.mApplicability;
    }

    public String getComment() throws SPIException {
        if (this.mComment == null) {
            return new String("");
        }
        return this.mComment;
    }

    public ProfileRepository getProfileRepository() {
        return this.mRepository;
    }

    protected static String createId(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("-");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public Iterator getPolicies(Iterator iterator) throws SPIException {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.mPolicyCache.containsKey(string)) continue;
            linkedList.add(this.mPolicyCache.get(string));
        }
        return linkedList.iterator();
    }

    public Iterator getPolicyInfos(Iterator iterator) throws SPIException {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<PolicyInfo> linkedList = new LinkedList<PolicyInfo>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.mPolicyCache.containsKey(string)) continue;
            Policy policy = (Policy)this.mPolicyCache.get(string);
            PolicyInfo policyInfo = new PolicyInfo(string, this.mId, policy.getLastModified());
            linkedList.add(policyInfo);
        }
        return linkedList.iterator();
    }
}

