/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.PolicyMgrImpl;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.AbstractEntity;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.DomainTreeProvider;
import com.sun.apoc.spi.ldap.LdapConnectionHandler;
import com.sun.apoc.spi.ldap.entities.LdapEntityProvider;

public class LdapDomainProvider
extends LdapEntityProvider
implements DomainTreeProvider {
    public LdapDomainProvider(PolicyMgr policyMgr, String string) throws SPIException {
        super(policyMgr, string);
    }

    public void open() throws SPIException {
        if (this.mConnection == null && this.mEnvironmentMgr != null) {
            this.mConnection = new LdapConnectionHandler();
            this.mConnection.connect(this.mURL, this.mEnvironmentMgr.getDomainTimeout(), this.mEnvironmentMgr.getDomainAuthUser(), this.mEnvironmentMgr.getDomainAuthPassword(), this.mEnvironmentMgr);
            if (this.isGSSAPIAuthentication()) {
                Object object = this.mEnvironmentMgr.getDomainCallbackHandler();
                this.mConnection.authenticate(object);
            } else {
                this.mConnection.authenticate(this.mEnvironmentMgr.getDomainUser(this.mURL), this.mEnvironmentMgr.getDomainCredentials());
            }
            this.mConnection.closeAuthorizedContext();
            ((PolicyMgrImpl)this.mPolicyMgr).setConnectionHandler(this.mURL, this.mConnection);
        }
        this.mDataStore = this.mConnection.getDataStore();
        this.mRootNode = this.mDataStore.getRootDomain();
        ((AbstractEntity)((Object)this.mRootNode)).setPolicyMgr(this.mPolicyMgr);
    }

    protected boolean isGSSAPIAuthentication() {
        return this.mEnvironmentMgr.getDomainAuthType().equals("GSSAPI");
    }

    public Domain getRootDomain() throws SPIException {
        return (Domain)super.getRootEntity();
    }
}

