/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.profiles;

import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.PolicyMgrImpl;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.ldap.LdapConnectionHandler;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import com.sun.apoc.spi.ldap.profiles.LdapProfileComparator;
import com.sun.apoc.spi.ldap.profiles.LdapProfileRepository;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileComparatorProvider;
import com.sun.apoc.spi.profiles.ProfileProvider;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.Comparator;
import java.util.Iterator;

public class LdapProfileProvider
implements ProfileProvider,
ProfileComparatorProvider {
    protected PolicyMgr mPolicyMgr;
    protected LdapConnectionHandler mConnection;
    protected LdapDataStore mDataStore;
    protected LdapEnvironmentMgr mEnvironmentMgr;
    protected String mURL;

    public LdapProfileProvider(PolicyMgr policyMgr, String string) throws SPIException {
        this.mPolicyMgr = policyMgr;
        this.mEnvironmentMgr = new LdapEnvironmentMgr(this.mPolicyMgr.getEnvironment());
        String string2 = string;
        this.mConnection = (LdapConnectionHandler)((PolicyMgrImpl)this.mPolicyMgr).getConnectionHandler(string2);
        if (this.mConnection == null) {
            this.mEnvironmentMgr.checkEnvironment();
        }
    }

    public Comparator getProfileComparator() {
        return new LdapProfileComparator();
    }

    public void open() throws SPIException {
        if (this.mConnection == null && this.mEnvironmentMgr != null) {
            this.mConnection = new LdapConnectionHandler();
            this.mConnection.connect(this.mURL, this.mEnvironmentMgr.getProfileTimeout(), this.mEnvironmentMgr.getProfileAuthUser(), this.mEnvironmentMgr.getProfileAuthPassword(), this.mEnvironmentMgr);
            if (this.isGSSAPIAuthentication()) {
                Object object = this.mEnvironmentMgr.getProfileCallbackHandler();
                this.mConnection.authenticate(object);
            } else {
                this.mConnection.authenticate(this.mEnvironmentMgr.getProfileUser(this.mURL), this.mEnvironmentMgr.getProfileCredentials());
            }
            this.mConnection.closeAuthorizedContext();
            ((PolicyMgrImpl)this.mPolicyMgr).setConnectionHandler(this.mURL, this.mConnection);
        }
        this.mDataStore = this.mConnection.getDataStore();
    }

    public void close() throws SPIException {
        if (((PolicyMgrImpl)this.mPolicyMgr).getConnectionHandler(this.mURL) != null) {
            ((PolicyMgrImpl)this.mPolicyMgr).setConnectionHandler(this.mURL, null);
        }
        this.mConnection.disconnect();
    }

    protected boolean isGSSAPIAuthentication() {
        return this.mEnvironmentMgr.getProfileAuthType().equals("GSSAPI");
    }

    public ProfileRepository getDefaultProfileRepository() throws SPIException {
        Node node = this.mPolicyMgr.getRootOrganization();
        if (node == null) {
            node = this.mPolicyMgr.getRootDomain();
        }
        if (node != null) {
            return this.getProfileRepository(node.getId());
        }
        return null;
    }

    public ProfileRepository getProfileRepository(String string) throws SPIException {
        return new LdapProfileRepository(string, this.mPolicyMgr);
    }

    public Profile getProfile(String string) throws SPIException {
        return this.mDataStore.getProfile(string);
    }

    public Iterator getAllProfiles() throws SPIException {
        return this.mDataStore.getAllProfiles(this.mPolicyMgr, (LdapEntity)((Object)this.mPolicyMgr.getRootOrganization()), Applicability.ALL);
    }

    public Iterator getAllProfiles(Entity entity) throws SPIException {
        Applicability applicability = entity instanceof Organization ? Applicability.USER : (entity instanceof Domain ? Applicability.HOST : Applicability.ALL);
        return this.mDataStore.getAllProfiles(this.mPolicyMgr, (LdapEntity)entity, applicability);
    }

    public LdapDataStore getDataStore() {
        return this.mDataStore;
    }
}

