/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.cfgtree;

import com.sun.apoc.policy.cfgtree.NodeValue;
import com.sun.apoc.policy.cfgtree.PropertyNodeImpl;
import com.sun.apoc.policy.cfgtree.ValueType;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;

public class NodeValueImpl
implements NodeValue {
    private StringBuffer mValueBuf;
    protected String[] mValueArray;
    private String mSeparator;
    private ValueType mValueType = ValueType.UNKNOWN;
    private String mLocaleName;
    private PolicyGroupIdImpl mOriginLayer;
    private boolean mNilAttribute = false;
    private boolean mIsContentsSet = false;
    private boolean mIsModifiedAtTopLayer = false;
    private PropertyNodeImpl mPropertyNodeImpl;
    private static final String MODULE = "NodeValueImpl";

    public String getContents() {
        if (!this.mIsContentsSet) {
            if (this.mValueBuf != null) {
                this.setOriginalContents(this.mValueBuf.toString());
            }
            this.mIsContentsSet = true;
        }
        if (this.mValueArray == null) {
            return null;
        }
        String string = this.mValueArray[0];
        if (this.mSeparator == null) {
            return string;
        }
        for (int i = 1; i < this.mValueArray.length; ++i) {
            string = string + this.mSeparator + this.mValueArray[i];
        }
        return string;
    }

    public void setNewContents(String string) throws RegistryException {
        this.mPropertyNodeImpl.checkIsReadOnly();
        String string2 = this.getContents();
        String[] stringArray = null;
        if (string2 != null && !string2.equals(string) && this.mValueArray != null) {
            stringArray = new String[this.mValueArray.length];
            for (int i = 0; i < this.mValueArray.length; ++i) {
                stringArray[i] = new String(this.mValueArray[i]);
            }
        }
        this.setOriginalContents(string);
        try {
            this.checkContentsAgainstValueType(this.mValueType);
        }
        catch (RegistryException registryException) {
            this.mValueArray = stringArray;
            throw registryException;
        }
        this.mNilAttribute = false;
        this.mIsModifiedAtTopLayer = true;
        if (this.mPropertyNodeImpl.getConfigDataManager().mMergedCache != null) {
            this.mOriginLayer = this.mPropertyNodeImpl.getConfigDataManager().mMergedCache.getPolicyGroupId();
        }
        this.mPropertyNodeImpl.setValue(this, this.mPropertyNodeImpl.getRequiredLocale());
        if (!this.mPropertyNodeImpl.isAddedAtTopLayer()) {
            this.mPropertyNodeImpl.setOperationType(0);
        }
    }

    public void setValueToNil() throws RegistryException {
        this.mPropertyNodeImpl.checkIsReadOnly();
        if (!this.mPropertyNodeImpl.isNillable()) {
            throw new RegistryException("The item is not nillable:  " + this.mPropertyNodeImpl.getName() + ".", "error.nillable.item", MODULE, 0);
        }
        if (!this.mIsContentsSet) {
            this.getContents();
        }
        this.mValueArray = null;
        this.mNilAttribute = true;
        this.mIsModifiedAtTopLayer = true;
        if (this.mPropertyNodeImpl.getConfigDataManager().mMergedCache != null) {
            this.mOriginLayer = this.mPropertyNodeImpl.getConfigDataManager().mMergedCache.getPolicyGroupId();
        }
        this.mPropertyNodeImpl.setValue(this, this.mPropertyNodeImpl.getRequiredLocale());
        if (!this.mPropertyNodeImpl.isAddedAtTopLayer()) {
            this.mPropertyNodeImpl.setOperationType(0);
        }
    }

    public PolicySetId getOrigin() {
        return this.mOriginLayer;
    }

    public boolean hasNilAttribute() {
        return this.mNilAttribute;
    }

    public ValueType getValueType() {
        return this.mValueType;
    }

    public void printToStream(String string, PrintStream printStream) {
        printStream.print(string + "<" + "value");
        if (this.mLocaleName != null) {
            printStream.print(" xml:lang=\"");
            printStream.print(this.mLocaleName + "\"");
        }
        if (this.mSeparator != null && !this.mSeparator.equals(" ")) {
            printStream.print(" oor:separator=\"");
            printStream.print(this.mSeparator + "\"");
        }
        this.printXMLValues(printStream);
    }

    private void printXMLString(PrintStream printStream, String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printStream.print(string);
            return;
        }
        block7: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 38: {
                    printStream.print("&amp;");
                    continue block7;
                }
                case 60: {
                    printStream.print("&lt;");
                    continue block7;
                }
                case 62: {
                    printStream.print("&gt;");
                    continue block7;
                }
                default: {
                    printStream.write(by);
                }
            }
        }
    }

    private void printXMLValues(PrintStream printStream) {
        if (!this.mIsContentsSet) {
            if (this.mValueBuf != null) {
                this.setOriginalContents(this.mValueBuf.toString());
            } else {
                this.mIsContentsSet = true;
            }
        }
        if (this.mValueArray != null) {
            printStream.print(">");
            int n = this.mValueArray.length;
            this.printXMLString(printStream, this.mValueArray[0]);
            if (this.mSeparator != null && n > 1) {
                for (int i = 1; i < this.mValueArray.length; ++i) {
                    this.printXMLString(printStream, this.mSeparator);
                    this.printXMLString(printStream, this.mValueArray[i]);
                }
            }
            printStream.print("</value>\n");
        } else if (this.mNilAttribute) {
            printStream.print(" xsi:nil=\"true\"/>\n");
        } else {
            printStream.print("/>\n");
        }
    }

    protected NodeValueImpl copyNodeValueImpl() {
        NodeValueImpl nodeValueImpl = new NodeValueImpl();
        if (!this.mIsContentsSet) {
            this.getContents();
        }
        nodeValueImpl.mIsContentsSet = true;
        if (this.mValueArray != null) {
            String[] stringArray = new String[this.mValueArray.length];
            for (int i = 0; i < this.mValueArray.length; ++i) {
                stringArray[i] = new String(this.mValueArray[i]);
            }
            nodeValueImpl.mValueArray = stringArray;
        }
        if (this.mSeparator != null) {
            nodeValueImpl.mSeparator = this.mSeparator;
        }
        nodeValueImpl.mValueType = this.mValueType;
        nodeValueImpl.mLocaleName = this.mLocaleName;
        nodeValueImpl.mNilAttribute = this.mNilAttribute;
        nodeValueImpl.mPropertyNodeImpl = this.mPropertyNodeImpl;
        nodeValueImpl.mOriginLayer = this.mOriginLayer;
        nodeValueImpl.mIsModifiedAtTopLayer = this.mIsModifiedAtTopLayer;
        return nodeValueImpl;
    }

    protected void checkContentsAgainstValueType(ValueType valueType) throws RegistryException {
        block22: {
            int n;
            block23: {
                block21: {
                    if (this.mValueArray == null || this.mValueArray.length < 1) {
                        return;
                    }
                    n = valueType.getIntValue();
                    if (n == -1) {
                        return;
                    }
                    if (n != 2 && n != 3 && n != 4) break block21;
                    long l = 0L;
                    switch (n) {
                        case 2: {
                            for (int i = 0; i < this.mValueArray.length; ++i) {
                                try {
                                    l = Short.parseShort(this.mValueArray[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.handleIncorrectValueType();
                                }
                            }
                            break;
                        }
                        case 3: {
                            for (int i = 0; i < this.mValueArray.length; ++i) {
                                try {
                                    l = Integer.parseInt(this.mValueArray[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.handleIncorrectValueType();
                                }
                            }
                            break;
                        }
                        case 4: {
                            for (int i = 0; i < this.mValueArray.length; ++i) {
                                try {
                                    l = Long.parseLong(this.mValueArray[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.handleIncorrectValueType();
                                }
                            }
                            break;
                        }
                    }
                    break block22;
                }
                if (n != 5) break block23;
                for (int i = 0; i < this.mValueArray.length; ++i) {
                    try {
                        double d = Double.parseDouble(this.mValueArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.handleIncorrectValueType();
                    }
                }
                break block22;
            }
            if (n != 1) break block22;
            for (int i = 0; i < this.mValueArray.length; ++i) {
                if (this.mValueArray[i].length() == 1) {
                    if (this.mValueArray[i].equals("1") || this.mValueArray[i].equals("0")) continue;
                    this.handleIncorrectValueType();
                    continue;
                }
                String string = this.mValueArray[i].toLowerCase();
                if (string.equals("true") || string.equals("false")) continue;
                this.handleIncorrectValueType();
            }
        }
    }

    private void handleIncorrectValueType() throws RegistryException {
        throw new RegistryException("Value does not comply with property value type for node: " + this.mPropertyNodeImpl.getName(), "error.comply.constraints", MODULE, 0);
    }

    protected void setNilAttribute(boolean bl) {
        this.mNilAttribute = bl;
    }

    protected void setPropertyNodeImpl(PropertyNodeImpl propertyNodeImpl) {
        this.mPropertyNodeImpl = propertyNodeImpl;
    }

    protected void setModifiedAtTopLayer() {
        this.mIsModifiedAtTopLayer = true;
    }

    protected boolean isModifiedAtTopLayer() {
        return this.mIsModifiedAtTopLayer;
    }

    protected void setValueType(ValueType valueType) {
        this.mValueType = valueType;
    }

    protected void setLocaleName(String string) {
        this.mLocaleName = string;
    }

    protected String getLocaleName() {
        return this.mLocaleName;
    }

    protected void setSeparator(String string) {
        this.mSeparator = string;
    }

    protected String getSeparator() {
        return this.mSeparator;
    }

    protected void setOriginalContents(String string) {
        String string2 = string;
        if (this.mSeparator == null) {
            this.mValueArray = new String[1];
            this.mValueArray[0] = string2;
        } else if (this.mSeparator == " ") {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, this.mSeparator);
            int n = 0;
            this.mValueArray = new String[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                this.mValueArray[n++] = stringTokenizer.nextToken();
            }
        } else {
            int n = 0;
            int n2 = 0;
            Vector<String> vector = new Vector<String>();
            while (n <= string2.length()) {
                n2 = string2.indexOf(this.mSeparator);
                if (n2 < 0) {
                    vector.add(string2);
                    break;
                }
                String string3 = string2.substring(n, n2);
                string3.trim();
                vector.add(string3);
                string2 = string2.substring(n2 + 1, string2.length());
            }
            if (vector != null && !vector.isEmpty()) {
                int n3 = vector.size();
                this.mValueArray = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    this.mValueArray[i] = new String((String)vector.get(i));
                }
            }
        }
        this.mIsContentsSet = true;
        this.mNilAttribute = false;
    }

    protected void appendContents(String string) {
        if (this.mValueBuf == null) {
            this.mValueBuf = new StringBuffer(200);
        }
        this.mValueBuf.append(string);
    }

    protected void setOrigin(PolicyGroupIdImpl policyGroupIdImpl) {
        this.mOriginLayer = policyGroupIdImpl;
    }
}

