/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.policy.organization;

import com.sun.apoc.policy.common.EntityId;
import com.sun.apoc.policy.common.EntityType;
import com.sun.apoc.policy.common.PolicyGroupIdImpl;
import com.sun.apoc.policy.common.PolicyGroupUse;
import com.sun.apoc.policy.common.PolicyId;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.policy.datastore.DataStore;
import com.sun.apoc.policy.datastore.ldap.LdapDataStore;
import com.sun.apoc.policy.organization.Organization;
import com.sun.apoc.policy.pmgr.ClientContext;
import com.sun.apoc.policy.util.MetaConfiguration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;

public class LdapOrganization
extends Organization {
    private static final boolean DNS_REQUIRED = true;
    private static final String MODULE = "LdapOrganization";
    private static final String OBJCLASS = "ObjectClass";
    private static final String NAMING_ATTR = "NamingAttribute";
    private static final String CONTAINER = "Container";
    private static final String UNIQUE_ATTR = "UniqueIdAttribute";
    private static final String MEMBER_ATTR = "MemberAttribute";
    private static final String LISTING_ATTR = "VirtualMemberAttribute";
    private static final String DISPLAY = "DisplayNameFormat";
    private static final String DEFAULT_DISPLAY = "sn, givenname";
    public LdapDataStore mDataStore = null;
    public EntityId mRootOrgEntityId = null;
    public EntityId mRootDomainEntityId = null;
    private ContainerMapping mOrgMapping = null;
    private ContainerMapping mDomainMapping = null;
    private ListMapping mRoleMapping = null;
    private UserMapping mUserMapping = null;
    private ItemMapping mHostMapping = null;
    private static final String DEFAULT_DISPLAY_FORMAT = "sn, givenname";
    private static final String SKIPPABLES = "()|&! \t";

    public LdapOrganization(DataStore dataStore) throws RegistryException {
        this.mDataStore = (LdapDataStore)dataStore;
        MetaConfiguration metaConfiguration = this.mDataStore.getDataStoreMetaConfiguration();
        this.mOrgMapping = new ContainerMapping("Organization/", metaConfiguration, "error.org.settings");
        this.mDomainMapping = new ContainerMapping("Domain/", metaConfiguration, "error.domain.settings");
        this.mRoleMapping = new ListMapping("Role/", metaConfiguration, "error.role.settings");
        this.mUserMapping = new UserMapping("User/", metaConfiguration, "error.user.settings");
        this.mHostMapping = new ItemMapping("Host/", metaConfiguration, "error.host.settings");
    }

    private ContainerMapping getContainerMapping(int n) {
        switch (n) {
            case 3: {
                return this.mOrgMapping;
            }
            case 4: {
                return this.mDomainMapping;
            }
            case 5: {
                return this.mRoleMapping;
            }
        }
        return null;
    }

    private ItemMapping getItemMapping(int n) {
        switch (n) {
            case 6: {
                return this.mUserMapping;
            }
            case 7: {
                return this.mHostMapping;
            }
        }
        return null;
    }

    public EntityId getRootEntityId(EntityType entityType, ClientContext clientContext) throws RegistryException {
        EntityId entityId = null;
        switch (entityType.getIntValue()) {
            case 3: {
                if (this.mRootOrgEntityId == null) {
                    String string = this.mDataStore.readEntryDN(this.mDataStore.getBaseDN(), clientContext);
                    this.mRootOrgEntityId = new EntityId(EntityType.ORG, string, false, -1);
                }
                entityId = this.mRootOrgEntityId;
                break;
            }
            case 4: {
                if (this.mRootDomainEntityId == null) {
                    String string = this.mDataStore.readEntryDN(this.mDataStore.getBaseDN(), clientContext);
                    this.mRootDomainEntityId = new EntityId(EntityType.DOMAIN, string, false, -1);
                }
                entityId = this.mRootDomainEntityId;
            }
        }
        if (entityId == null) {
            throw new RegistryException("Cannot create root EntityId.", "error.occurred", MODULE, 0);
        }
        return entityId;
    }

    public EntityId getEntityParent(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        if (entityId == null || entityType == null) {
            return null;
        }
        EntityId entityId2 = null;
        int n = entityId.getEntityType().getIntValue();
        switch (entityType.getIntValue()) {
            case 3: {
                switch (n) {
                    case 3: 
                    case 5: 
                    case 6: {
                        entityId2 = this.getParentOrgOrDomain(entityId, entityType, clientContext);
                    }
                }
                break;
            }
            case 4: {
                switch (n) {
                    case 4: 
                    case 5: 
                    case 7: {
                        entityId2 = this.getParentOrgOrDomain(entityId, entityType, clientContext);
                    }
                }
                break;
            }
            case 5: {
                if (n != 5) break;
                entityId2 = entityId.getParentBeforeContainer();
            }
        }
        return entityId2;
    }

    private EntityId[] getAllParents(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        EntityId[] entityIdArray;
        Vector<Object> vector = new Vector<Object>();
        switch (entityType.getIntValue()) {
            case 3: 
            case 4: {
                EntityId entityId2 = this.getParentOrgOrDomain(entityId, entityType, clientContext);
                while (entityId2 != null) {
                    vector.add(entityId2);
                    entityId2 = this.getParentOrgOrDomain(entityId2, entityType, clientContext);
                }
                break;
            }
            case 5: {
                if (entityId.getEntityType() != EntityType.ROLE) break;
                for (entityIdArray = entityId.getParentBeforeContainer(); entityIdArray != null; entityIdArray = entityIdArray.getParentBeforeContainer()) {
                    vector.add(entityIdArray);
                }
                break;
            }
            default: {
                return new EntityId[0];
            }
        }
        int n = vector.size();
        entityIdArray = new EntityId[n];
        for (int i = 0; i < n; ++i) {
            entityIdArray[i] = (EntityId)vector.get(n - 1 - i);
        }
        return entityIdArray;
    }

    public EntityId[] getAllParentsInPath(EntityId entityId, ClientContext clientContext) throws RegistryException {
        int n;
        if (entityId == null) {
            return new EntityId[0];
        }
        int n2 = entityId.getEntityType().getIntValue();
        int n3 = 0;
        EntityId[] entityIdArray = null;
        if (n2 == 5) {
            entityIdArray = this.getAllParents(entityId, EntityType.ROLE, clientContext);
            n3 += entityIdArray.length;
        }
        EntityType entityType = EntityType.UNKNOWN;
        switch (n2) {
            case 4: 
            case 7: {
                entityType = EntityType.DOMAIN;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                entityType = EntityType.ORG;
            }
        }
        EntityId[] entityIdArray2 = this.getAllParents(entityId, entityType, clientContext);
        EntityId[] entityIdArray3 = new EntityId[n3 += entityIdArray2.length];
        int n4 = 0;
        if (entityIdArray != null) {
            for (n = 0; n < entityIdArray.length; ++n) {
                entityIdArray3[n4++] = entityIdArray[n];
            }
        }
        for (n = 0; n < entityIdArray2.length; ++n) {
            entityIdArray3[n4++] = entityIdArray2[n];
        }
        return entityIdArray3;
    }

    private EntityId getParentOrgOrDomain(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        EntityId entityId2 = this.getRootEntityId(entityType, clientContext);
        if (entityId.equals(entityId2)) {
            return null;
        }
        return entityId.getParentEntity(entityType);
    }

    public EntityId[] getRolesEntityIsAMemberOf(EntityId entityId, ClientContext clientContext) throws RegistryException {
        if (entityId == null) {
            return new EntityId[0];
        }
        EntityId[] entityIdArray = null;
        switch (entityId.getEntityType().getIntValue()) {
            case 6: 
            case 7: {
                entityIdArray = this.getRolesForMemberEntity(entityId, clientContext);
            }
        }
        return entityIdArray == null ? new EntityId[]{} : entityIdArray;
    }

    private EntityId[] getRolesForMemberEntity(EntityId entityId, ClientContext clientContext) throws RegistryException {
        int n;
        Vector vector = this.mDataStore.getListedRolesForEntity(entityId, this.mRoleMapping.mListingAttribute, clientContext);
        EntityId[] entityIdArray = null;
        int n2 = 0;
        if (!vector.isEmpty()) {
            n = vector.size();
            EntityId entityId2 = null;
            for (int i = 0; i < n; ++i) {
                try {
                    String string = this.mDataStore.readEntryDN((String)vector.get(i), clientContext);
                    entityId2 = this.convertDnToEntityId((String)vector.get(i), EntityType.ROLE, false, null, clientContext);
                    vector.set(n2++, entityId2);
                    continue;
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
            }
        }
        entityIdArray = new EntityId[n2];
        for (n = 0; n < n2; ++n) {
            entityIdArray[n] = (EntityId)vector.get(n);
        }
        return entityIdArray;
    }

    public EntityId[] getEntityChildren(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        if (entityId == null || entityType == null) {
            return new EntityId[0];
        }
        Organization.BooleanReturnObject booleanReturnObject = new Organization.BooleanReturnObject(false);
        return this.getEntityChildren(entityId, entityType, false, clientContext, booleanReturnObject);
    }

    public EntityId[] getRoleMembers(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        Organization.BooleanReturnObject booleanReturnObject = new Organization.BooleanReturnObject(false);
        return this.getRoleMembers(entityId, entityType, false, clientContext, booleanReturnObject);
    }

    private EntityId[] getRoleMembers(EntityId entityId, EntityType entityType, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        Vector vector = null;
        EntityId[] entityIdArray = null;
        if (entityId.getEntityType() == EntityType.ROLE) {
            switch (entityType.getIntValue()) {
                case 6: {
                    vector = this.searchForMembers(entityId, 6, bl, clientContext, booleanReturnObject);
                    break;
                }
                case 7: {
                    vector = this.searchForMembers(entityId, 7, bl, clientContext, booleanReturnObject);
                    break;
                }
                case 2: {
                    vector = new Vector();
                    Vector vector2 = this.searchForMembers(entityId, 6, bl, clientContext, booleanReturnObject);
                    if (booleanReturnObject.getReturnValue()) break;
                    if (vector2.size() > 0) {
                        vector.addAll(vector2);
                    }
                    if ((vector2 = this.searchForMembers(entityId, 7, bl, clientContext, booleanReturnObject)).size() <= 0) break;
                    vector.addAll(vector2);
                }
            }
        }
        if (!bl && vector != null) {
            int n = vector.size();
            entityIdArray = new EntityId[n];
            for (int i = 0; i < n; ++i) {
                entityIdArray[i] = (EntityId)vector.get(i);
            }
        }
        return entityIdArray == null ? new EntityId[]{} : entityIdArray;
    }

    private Vector searchForMembers(EntityId entityId, int n, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        EntityId entityId2 = null;
        ItemMapping itemMapping = this.getItemMapping(n);
        entityId2 = n == 6 ? this.getParentOrgOrDomain(entityId, EntityType.ORG, clientContext) : this.getParentOrgOrDomain(entityId, EntityType.DOMAIN, clientContext);
        Vector vector = null;
        try {
            vector = this.mDataStore.getRoleMembers(entityId, itemMapping.mObjectClass, this.mRoleMapping.mMemberAttribute, itemMapping.getSearchAttributes(), entityId2, bl, clientContext, booleanReturnObject);
            if (bl) {
                return vector;
            }
        }
        catch (RegistryException registryException) {
            LdapDataStore.checkIfSizeLimitExceeded(registryException);
        }
        int n2 = 0;
        if (vector != null && !vector.isEmpty()) {
            int n3 = vector.size();
            Object var11_12 = null;
            EntityId entityId3 = null;
            for (int i = 0; i < n3; ++i) {
                Hashtable hashtable = (Hashtable)vector.get(i);
                try {
                    Vector vector2 = (Vector)hashtable.get("DN");
                    String string = (String)vector2.get(0);
                    entityId3 = n == 6 ? this.convertDnToEntityId(string, EntityType.USERID, false, hashtable, clientContext) : this.convertDnToEntityId(string, EntityType.HOST, false, hashtable, clientContext);
                    vector.set(n2++, entityId3);
                    entityId3 = null;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector;
    }

    private EntityId[] getEntityChildren(EntityId entityId, EntityType entityType, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        EntityId[] entityIdArray = null;
        int n = entityType.getIntValue();
        switch (entityId.getEntityType().getIntValue()) {
            case 3: {
                switch (n) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        entityIdArray = this.searchForChildren(entityId, entityType, bl, clientContext, booleanReturnObject);
                    }
                }
            }
            case 4: {
                switch (n) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 7: {
                        entityIdArray = this.searchForChildren(entityId, entityType, bl, clientContext, booleanReturnObject);
                    }
                }
                break;
            }
            case 5: {
                switch (n) {
                    case 2: 
                    case 5: {
                        entityIdArray = this.searchForChildren(entityId, entityType, bl, clientContext, booleanReturnObject);
                    }
                }
            }
        }
        return entityIdArray == null ? new EntityId[]{} : entityIdArray;
    }

    public boolean hasEntityChildren(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        if (entityId == null || entityType == null) {
            return false;
        }
        Organization.BooleanReturnObject booleanReturnObject = new Organization.BooleanReturnObject(false);
        this.getEntityChildren(entityId, entityType, true, clientContext, booleanReturnObject);
        return booleanReturnObject.getReturnValue();
    }

    public boolean hasMembers(EntityId entityId, EntityType entityType, ClientContext clientContext) throws RegistryException {
        if (entityId == null || entityType == null) {
            return false;
        }
        Organization.BooleanReturnObject booleanReturnObject = new Organization.BooleanReturnObject(false);
        this.getRoleMembers(entityId, entityType, true, clientContext, booleanReturnObject);
        return booleanReturnObject.getReturnValue();
    }

    private EntityId[] searchForChildren(EntityId entityId, EntityType entityType, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        Object object;
        EntityId[] entityIdArray = null;
        Vector vector = null;
        int n = entityType.getIntValue();
        int n2 = entityId.getEntityType().getIntValue();
        if (n != 2) {
            vector = this.getListOfChildren(entityId, entityType, this.buildClassFilter(entityType, false), bl, clientContext, booleanReturnObject);
        } else if (bl) {
            switch (n2) {
                case 3: {
                    vector = this.getListOfChildren(entityId, EntityType.ORG, this.buildClassFilter(EntityType.ORG, false), bl, clientContext, booleanReturnObject);
                    if (booleanReturnObject.getReturnValue()) break;
                    vector = this.getListOfChildren(entityId, EntityType.ROLE, this.buildClassFilter(EntityType.ROLE, false), bl, clientContext, booleanReturnObject);
                    if (booleanReturnObject.getReturnValue()) break;
                    vector = this.getListOfChildren(entityId, EntityType.USERID, this.buildClassFilter(EntityType.USERID, false), bl, clientContext, booleanReturnObject);
                    break;
                }
                case 4: {
                    vector = this.getListOfChildren(entityId, EntityType.DOMAIN, this.buildClassFilter(EntityType.DOMAIN, false), bl, clientContext, booleanReturnObject);
                    if (booleanReturnObject.getReturnValue()) break;
                    vector = this.getListOfChildren(entityId, EntityType.ROLE, this.buildClassFilter(EntityType.ROLE, false), bl, clientContext, booleanReturnObject);
                    if (booleanReturnObject.getReturnValue()) break;
                    vector = this.getListOfChildren(entityId, EntityType.HOST, this.buildClassFilter(EntityType.HOST, false), bl, clientContext, booleanReturnObject);
                    break;
                }
                case 5: {
                    vector = this.getListOfChildren(entityId, EntityType.ROLE, this.buildClassFilter(EntityType.ROLE, false), bl, clientContext, booleanReturnObject);
                }
            }
        } else {
            int n3;
            EntityId[] entityIdArray2 = null;
            EntityId[] entityIdArray3 = null;
            object = null;
            EntityId[] entityIdArray4 = null;
            int n4 = 0;
            switch (n2) {
                case 3: {
                    entityIdArray2 = this.searchForChildren(entityId, EntityType.ORG, bl, clientContext, booleanReturnObject);
                    entityIdArray3 = this.searchForChildren(entityId, EntityType.ROLE, bl, clientContext, booleanReturnObject);
                    object = this.searchForChildren(entityId, EntityType.USERID, bl, clientContext, booleanReturnObject);
                    n4 = entityIdArray2.length + entityIdArray3.length + ((EntityId[])object).length;
                    break;
                }
                case 4: {
                    entityIdArray2 = this.searchForChildren(entityId, EntityType.DOMAIN, bl, clientContext, booleanReturnObject);
                    entityIdArray3 = this.searchForChildren(entityId, EntityType.ROLE, bl, clientContext, booleanReturnObject);
                    entityIdArray4 = this.searchForChildren(entityId, EntityType.HOST, bl, clientContext, booleanReturnObject);
                    n4 = entityIdArray2.length + entityIdArray3.length + entityIdArray4.length;
                    break;
                }
                case 5: {
                    entityIdArray3 = this.searchForChildren(entityId, EntityType.ROLE, bl, clientContext, booleanReturnObject);
                    n4 = entityIdArray3.length;
                }
            }
            entityIdArray = new EntityId[n4];
            int n5 = 0;
            if (entityIdArray2 != null) {
                for (n3 = 0; n3 < entityIdArray2.length; ++n3) {
                    entityIdArray[n5++] = entityIdArray2[n3];
                }
            }
            if (entityIdArray3 != null) {
                for (n3 = 0; n3 < entityIdArray3.length; ++n3) {
                    entityIdArray[n5++] = entityIdArray3[n3];
                }
            }
            if (object != null) {
                for (n3 = 0; n3 < (object).length; ++n3) {
                    entityIdArray[n5++] = object[n3];
                }
            }
            if (entityIdArray4 != null) {
                for (n3 = 0; n3 < entityIdArray4.length; ++n3) {
                    entityIdArray[n5++] = entityIdArray4[n3];
                }
            }
        }
        if (bl || n == 2) {
            return entityIdArray;
        }
        int n6 = 0;
        if (vector != null && !vector.isEmpty()) {
            int n7 = vector.size();
            object = null;
            for (int i = 0; i < n7; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector2 = (Vector)hashtable.get("DN");
                    if (vector2 == null || vector2.isEmpty()) continue;
                    String string = (String)vector2.get(0);
                    object = this.convertDnToEntityId(string, entityType, false, hashtable, clientContext);
                    vector.set(n6++, object);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        entityIdArray = new EntityId[n6];
        for (int i = 0; i < n6; ++i) {
            entityIdArray[i] = (EntityId)vector.get(i);
        }
        return entityIdArray;
    }

    private Vector getListOfChildren(EntityId entityId, EntityType entityType, String string, boolean bl, ClientContext clientContext, Organization.BooleanReturnObject booleanReturnObject) throws RegistryException {
        Vector vector = null;
        String string2 = null;
        String[] stringArray = null;
        int n = entityType.getIntValue();
        switch (n) {
            case 5: {
                string2 = this.mRoleMapping.mContainerEntry;
                break;
            }
            case 6: 
            case 7: {
                ItemMapping itemMapping = this.getItemMapping(n);
                stringArray = itemMapping.getSearchAttributes();
                string2 = itemMapping.mContainerEntry;
            }
        }
        try {
            vector = this.mDataStore.getListOfChildren(entityId, string2, string, false, stringArray, bl, clientContext, booleanReturnObject);
        }
        catch (RegistryException registryException) {
            LdapDataStore.checkIfSizeLimitExceeded(registryException);
        }
        return vector;
    }

    private String buildUnionFilter(String[] stringArray, String[] stringArray2) {
        int n;
        boolean bl;
        if (stringArray == null) {
            if (stringArray2 == null) {
                return null;
            }
            stringArray = stringArray2;
            stringArray2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = stringArray.length > 1 || stringArray2 != null;
        if (bl) {
            stringBuffer.append("(|");
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append("(").append("objectclass").append("=");
            stringBuffer.append(stringArray[n]).append(")");
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                stringBuffer.append("(").append("objectclass");
                stringBuffer.append("=").append(stringArray2[n]).append(")");
            }
        }
        if (bl) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public EntityId[] getLayerPath(EntityId entityId, ClientContext clientContext) throws RegistryException {
        int n;
        if (entityId == null) {
            return new EntityId[0];
        }
        EntityId[] entityIdArray = null;
        int n2 = entityId.getEntityType().getIntValue();
        switch (n2) {
            case 3: 
            case 5: 
            case 6: {
                entityIdArray = this.getAllParents(entityId, EntityType.ORG, clientContext);
                break;
            }
            case 4: 
            case 7: {
                entityIdArray = this.getAllParents(entityId, EntityType.DOMAIN, clientContext);
            }
        }
        int n3 = entityIdArray.length;
        EntityId[] entityIdArray2 = null;
        if (n2 == 5) {
            entityIdArray2 = this.getAllParents(entityId, EntityType.ROLE, clientContext);
            n3 += entityIdArray2.length;
        } else if (n2 == 6 || n2 == 7) {
            entityIdArray2 = this.getRolesEntityIsAMemberOf(entityId, clientContext);
            n3 += entityIdArray2.length;
        }
        EntityId[] entityIdArray3 = new EntityId[n3];
        int n4 = 0;
        for (n = 0; n < entityIdArray.length; ++n) {
            entityIdArray3[n4++] = entityIdArray[n];
        }
        if (entityIdArray2 != null) {
            for (n = 0; n < entityIdArray2.length; ++n) {
                entityIdArray3[n4++] = entityIdArray2[n];
            }
        }
        return entityIdArray3;
    }

    public PolicySetId[] getLayeredPolicySetIds(EntityId entityId, ClientContext clientContext) throws RegistryException {
        int n;
        if (entityId == null) {
            return new PolicySetId[0];
        }
        int n2 = entityId.getEntityType().getIntValue();
        PolicyGroupUse policyGroupUse = PolicyGroupUse.UNKNOWN;
        EntityType entityType = EntityType.UNKNOWN;
        switch (n2) {
            case 3: 
            case 5: 
            case 6: {
                policyGroupUse = PolicyGroupUse.USER;
                entityType = EntityType.ORG;
                break;
            }
            case 4: 
            case 7: {
                policyGroupUse = PolicyGroupUse.HOST;
                entityType = EntityType.DOMAIN;
                break;
            }
            default: {
                return new PolicySetId[0];
            }
        }
        int n3 = 0;
        EntityId[] entityIdArray = this.getAllParents(entityId, entityType, clientContext);
        Vector<PolicySetId> vector = new Vector<PolicySetId>();
        PolicySetId[] policySetIdArray = null;
        for (int i = 0; i < entityIdArray.length; ++i) {
            policySetIdArray = this.mDataStore.getAllPolicyGroupsForEntity(entityIdArray[i], policyGroupUse, clientContext);
            for (int j = 0; j < policySetIdArray.length; ++j) {
                vector.add(policySetIdArray[j]);
                ++n3;
            }
        }
        entityIdArray = null;
        TreeSet treeSet = null;
        if (n2 == 5) {
            entityIdArray = this.getAllParents(entityId, EntityType.ROLE, clientContext);
        } else if (n2 == 6 || n2 == 7) {
            entityIdArray = this.getRolesEntityIsAMemberOf(entityId, clientContext);
        }
        if (entityIdArray != null && entityIdArray.length > 0) {
            treeSet = this.mDataStore.getAssignedPolicyGroupTreeForEntities(entityIdArray, PolicyGroupUse.ALL, clientContext);
            n3 += treeSet.size();
        }
        policySetIdArray = this.mDataStore.getAllPolicyGroupsForEntity(entityId, policyGroupUse, clientContext);
        PolicySetId[] policySetIdArray2 = new PolicySetId[n3 + policySetIdArray.length];
        int n4 = 0;
        int n5 = vector.size();
        for (n = 0; n < n5; ++n) {
            policySetIdArray2[n4++] = (PolicySetId)vector.get(n);
        }
        if (treeSet != null) {
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                policySetIdArray2[n4++] = (PolicySetId)iterator.next();
            }
        }
        for (n = 0; n < policySetIdArray.length; ++n) {
            policySetIdArray2[n4++] = policySetIdArray[n];
        }
        return policySetIdArray2;
    }

    public PolicyId[][] getLayeredPolicies(EntityId entityId, String[] stringArray, boolean bl, ClientContext clientContext) throws RegistryException {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] != null) continue;
            throw new RegistryException("The policy name is null.", "error.policy.invalid", MODULE, 0);
        }
        PolicySetId[] policySetIdArray = this.getLayeredPolicySetIds(entityId, clientContext);
        Vector<PolicyId[]> vector = new Vector<PolicyId[]>();
        PolicyId[] policyIdArray = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            policyIdArray = this.getPolicies(stringArray[i], policySetIdArray, bl, clientContext);
            if (policyIdArray == null) continue;
            vector.add(policyIdArray);
            ++n2;
        }
        PolicyId[][] policyIdArray2 = new PolicyId[n2][];
        for (int i = 0; i < n2; ++i) {
            policyIdArray2[i] = (PolicyId[])vector.get(i);
        }
        return policyIdArray2;
    }

    public PolicyId[] getLayeredPolicies(EntityId entityId, String string, ClientContext clientContext) throws RegistryException {
        if (string == null) {
            throw new RegistryException("The policy name is null.", "error.policy.invalid", MODULE, 0);
        }
        PolicySetId[] policySetIdArray = this.getLayeredPolicySetIds(entityId, clientContext);
        return this.getPolicies(string, policySetIdArray, false, clientContext);
    }

    public PolicyId[] getPolicies(String string, PolicySetId[] policySetIdArray, boolean bl, ClientContext clientContext) throws RegistryException {
        int n = 0;
        Vector<PolicyId> vector = new Vector<PolicyId>();
        PolicyId policyId = null;
        for (int i = 0; i < policySetIdArray.length; ++i) {
            policyId = this.getPolicyId(string, (PolicyGroupIdImpl)policySetIdArray[i], bl, clientContext);
            if (policyId == null) continue;
            vector.add(policyId);
            ++n;
        }
        PolicyId[] policyIdArray = new PolicyId[n];
        for (int i = 0; i < n; ++i) {
            policyIdArray[i] = (PolicyId)vector.get(i);
        }
        return policyIdArray;
    }

    public PolicyId getPolicyId(String string, PolicyGroupIdImpl policyGroupIdImpl, boolean bl, ClientContext clientContext) throws RegistryException {
        PolicyId policyId = new PolicyId(string, policyGroupIdImpl);
        this.mDataStore.readPolicy(policyId, bl, clientContext);
        if (!bl) {
            return policyId.getData() == null || policyId.getTimeStamp() == null ? null : policyId;
        }
        return policyId.getTimeStamp() == null ? null : policyId;
    }

    public EntityId[] getEntitiesForPolicyGroup(PolicyGroupIdImpl policyGroupIdImpl, ClientContext clientContext) throws RegistryException {
        int n;
        if (policyGroupIdImpl == null) {
            throw new RegistryException("Invalid policy group parameter for method that finds entities for a policy group.", "error.policygroup.not.exists", MODULE, 0);
        }
        int n2 = 0;
        EntityId[] entityIdArray = null;
        Vector vector = this.mDataStore.getListOfEntitiesForPolicyGroup(policyGroupIdImpl, clientContext);
        if (!vector.isEmpty()) {
            n = vector.size();
            EntityId entityId = null;
            for (int i = 0; i < n; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector2 = (Vector)hashtable.get("DN");
                    if (vector2 == null || vector2.isEmpty()) continue;
                    String string = (String)vector2.get(0);
                    entityId = this.convertDnToEntityId(string, EntityType.UNKNOWN, true, null, clientContext);
                    vector.set(n2++, entityId);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        entityIdArray = new EntityId[n2];
        for (n = 0; n < n2; ++n) {
            entityIdArray[n] = (EntityId)vector.get(n);
        }
        return entityIdArray;
    }

    private EntityType detectEntityType(String string, Hashtable hashtable) {
        EntityType entityType = EntityType.UNKNOWN;
        Vector vector = (Vector)hashtable.get("objectclass");
        if (vector == null || vector.isEmpty()) {
            return entityType;
        }
        Enumeration enumeration = vector.elements();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        int n = arrayList.size();
        block1: for (int i = 0; i < n && entityType == EntityType.UNKNOWN; ++i) {
            int n2;
            String string2 = (String)arrayList.get(i);
            if (string2.equalsIgnoreCase(this.mUserMapping.mObjectClass)) {
                entityType = EntityType.USERID;
                break;
            }
            if (string2.equalsIgnoreCase(this.mHostMapping.mObjectClass)) {
                entityType = EntityType.HOST;
                break;
            }
            for (n2 = 0; n2 < this.mOrgMapping.mObjectClasses.length; ++n2) {
                if (!string2.equalsIgnoreCase(this.mOrgMapping.mObjectClasses[n2])) continue;
                entityType = EntityType.ORG;
                break;
            }
            if (entityType == EntityType.UNKNOWN) {
                for (n2 = 0; n2 < this.mDomainMapping.mObjectClasses.length; ++n2) {
                    if (!string2.equalsIgnoreCase(this.mDomainMapping.mObjectClasses[n2])) continue;
                    entityType = EntityType.DOMAIN;
                    break;
                }
            }
            if (entityType != EntityType.UNKNOWN) continue;
            for (n2 = 0; n2 < this.mRoleMapping.mObjectClasses.length; ++n2) {
                if (!string2.equalsIgnoreCase(this.mRoleMapping.mObjectClasses[n2])) continue;
                entityType = EntityType.ROLE;
                continue block1;
            }
        }
        if (entityType == EntityType.USERID) {
            for (int i = 0; i < n; ++i) {
                String string3 = (String)arrayList.get(i);
                if (!string3.equalsIgnoreCase(this.mHostMapping.mObjectClass)) continue;
                entityType = EntityType.HOST;
                break;
            }
        }
        return entityType;
    }

    private static int findContainer(String[] stringArray, int n, String string) {
        String string2 = stringArray[n].substring(0, stringArray[n].indexOf("="));
        for (int i = n + 1; i < stringArray.length; ++i) {
            if (string != null) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return i;
            }
            if (stringArray[i].startsWith(string2)) continue;
            return i - 1;
        }
        return -1;
    }

    private EntityId getEntityIdFromDn(String string, EntityType entityType, boolean bl, Hashtable hashtable, ClientContext clientContext) {
        String string2;
        Vector vector;
        int n;
        Object object;
        if (string == null) {
            return null;
        }
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        if (stringArray == null) {
            return null;
        }
        int n2 = 0;
        if (bl) {
            n2 = 6;
        }
        if (n2 >= stringArray.length) {
            return null;
        }
        String string3 = string;
        if (bl) {
            object = new StringBuffer(stringArray[n2]);
            for (n = n2 + 1; n < stringArray.length; ++n) {
                ((StringBuffer)object).append(",").append(stringArray[n]);
            }
            string3 = ((StringBuffer)object).toString();
        }
        if (hashtable == null) {
            object = new String[3 + this.mUserMapping.mDisplayAttributes.length];
            object[0] = "objectclass";
            object[1] = this.mUserMapping.mUniqueAttribute;
            object[2] = this.mHostMapping.mUniqueAttribute;
            n = 3;
            for (int i = 0; i < this.mUserMapping.mDisplayAttributes.length; ++i) {
                object[n++] = this.mUserMapping.mDisplayAttributes[i];
            }
            try {
                hashtable = this.mDataStore.getAttributeValueTable(string3, true, (String[])object, clientContext);
            }
            catch (LDAPException lDAPException) {
                return null;
            }
            if (hashtable == null) {
                return null;
            }
            Vector vector2 = (Vector)hashtable.get("DN");
            if (vector2 == null || vector2.isEmpty()) {
                return null;
            }
            string3 = (String)vector2.get(0);
        }
        if (entityType == EntityType.UNKNOWN && (entityType = this.detectEntityType(stringArray[n2], hashtable)) == EntityType.UNKNOWN) {
            return null;
        }
        object = null;
        n = 1;
        int n3 = entityType.getIntValue();
        switch (n3) {
            case 6: {
                object = this.mUserMapping.mContainerEntry;
                break;
            }
            case 7: {
                object = this.mHostMapping.mContainerEntry;
                break;
            }
            case 5: {
                object = this.mRoleMapping.mContainerEntry;
                n = -1;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (object != null && ((String)object).length() == 0) {
            object = null;
        }
        if (n == -1) {
            n = LdapOrganization.findContainer(stringArray, n2, (String)object);
            if (n == -1) {
                return null;
            }
            n -= n2;
        }
        EntityId entityId = new EntityId(entityType, string3, object != null, n + 1);
        String string4 = null;
        switch (n3) {
            case 6: {
                entityId.setDisplayName(hashtable, this.mUserMapping.mDisplayAttributes, this.mUserMapping.mDisplayFormat);
                string4 = this.mUserMapping.mUniqueAttribute;
                break;
            }
            case 7: {
                string4 = this.mHostMapping.mUniqueAttribute;
            }
        }
        if (string4 != null && (vector = (Vector)hashtable.get(string4)) != null && !vector.isEmpty() && (string2 = (String)vector.get(0)) != null) {
            entityId.setUniqueId(string2);
        }
        return entityId;
    }

    public EntityId getEntityIdFromLocation(String string, ClientContext clientContext) throws RegistryException {
        return this.convertDnToEntityId(string, EntityType.UNKNOWN, false, null, clientContext);
    }

    public EntityId convertDnToEntityId(String string, EntityType entityType, boolean bl, Hashtable hashtable, ClientContext clientContext) throws RegistryException {
        EntityId entityId = this.getEntityIdFromDn(string, entityType, bl, hashtable, clientContext);
        if (entityId == null) {
            throw new RegistryException("Cannot convert LDAP DN to EntityId.", "error.occurred", MODULE, 0);
        }
        return entityId;
    }

    public EntityId findUserEntityId(String string, ClientContext clientContext) throws RegistryException {
        EntityId[] entityIdArray = null;
        if (string == null || string.indexOf("*") != -1) {
            throw new RegistryException("The username is invalid.", "error.user.invalid", MODULE, 0);
        }
        entityIdArray = this.findEntitiesByName(this.mRootOrgEntityId, EntityType.USERID, string, true, clientContext);
        if (entityIdArray.length != 1) {
            throw new RegistryException("The username is invalid.", "error.user.invalid", MODULE, 0);
        }
        return entityIdArray[0];
    }

    public EntityId findHostEntityId(String string, ClientContext clientContext) throws RegistryException {
        EntityId[] entityIdArray = null;
        if (string == null || string.indexOf("*") != -1) {
            throw new RegistryException("The host name is invalid.", "error.host.invalid", MODULE, 0);
        }
        entityIdArray = this.findEntitiesByName(this.mRootDomainEntityId, EntityType.HOST, string, true, clientContext);
        if (entityIdArray.length != 1) {
            throw new RegistryException("The host name is invalid.", "error.host.invalid", MODULE, 0);
        }
        return entityIdArray[0];
    }

    public EntityId[] findEntitiesByName(EntityId entityId, EntityType entityType, String string, boolean bl, ClientContext clientContext) throws RegistryException {
        int n;
        if (entityType == null) {
            return new EntityId[0];
        }
        if (entityType != EntityType.ALL) {
            return this.searchForEntities(entityId, entityType, this.buildNameFilter(entityType, "=", string, bl), bl, clientContext);
        }
        EntityId[] entityIdArray = null;
        EntityId[] entityIdArray2 = null;
        EntityId[] entityIdArray3 = null;
        EntityId[] entityIdArray4 = null;
        int n2 = 0;
        switch (entityId.getEntityType().getIntValue()) {
            case 3: {
                entityIdArray = this.searchForEntities(entityId, EntityType.ORG, this.buildNameFilter(EntityType.ORG, "=", string, bl), bl, clientContext);
                entityIdArray2 = this.searchForEntities(entityId, EntityType.ROLE, this.buildNameFilter(EntityType.ROLE, "=", string, bl), bl, clientContext);
                entityIdArray3 = this.searchForEntities(entityId, EntityType.USERID, this.buildNameFilter(EntityType.USERID, "=", string, bl), bl, clientContext);
                n2 = entityIdArray.length + entityIdArray2.length + entityIdArray3.length;
                break;
            }
            case 4: {
                entityIdArray = this.searchForEntities(entityId, EntityType.DOMAIN, this.buildNameFilter(EntityType.DOMAIN, "=", string, bl), bl, clientContext);
                entityIdArray2 = this.searchForEntities(entityId, EntityType.ROLE, this.buildNameFilter(EntityType.ROLE, "=", string, bl), bl, clientContext);
                entityIdArray4 = this.searchForEntities(entityId, EntityType.HOST, this.buildNameFilter(EntityType.HOST, "=", string, bl), bl, clientContext);
                n2 = entityIdArray.length + entityIdArray2.length + entityIdArray4.length;
                break;
            }
            case 5: {
                entityIdArray3 = this.searchForEntities(entityId, EntityType.USERID, this.buildNameFilter(EntityType.USERID, "=", string, bl), bl, clientContext);
                entityIdArray4 = this.searchForEntities(entityId, EntityType.HOST, this.buildNameFilter(EntityType.HOST, "=", string, bl), bl, clientContext);
                n2 = entityIdArray3.length + entityIdArray4.length;
            }
        }
        EntityId[] entityIdArray5 = new EntityId[n2];
        int n3 = 0;
        if (entityIdArray != null) {
            for (n = 0; n < entityIdArray.length; ++n) {
                entityIdArray5[n3++] = entityIdArray[n];
            }
        }
        if (entityIdArray2 != null) {
            for (n = 0; n < entityIdArray2.length; ++n) {
                entityIdArray5[n3++] = entityIdArray2[n];
            }
        }
        if (entityIdArray3 != null) {
            for (n = 0; n < entityIdArray3.length; ++n) {
                entityIdArray5[n3++] = entityIdArray3[n];
            }
        }
        if (entityIdArray4 != null) {
            for (n = 0; n < entityIdArray4.length; ++n) {
                entityIdArray5[n3++] = entityIdArray4[n];
            }
        }
        return entityIdArray5;
    }

    private void addNameFilter(String string, String string2, String string3, String string4, Vector vector) {
        vector.add("(&(objectclass=" + string + ")(" + string2 + string3 + (string4 == null ? "*" : string4) + "))");
    }

    private void addNameFilters(ContainerMapping containerMapping, String string, String string2, Vector vector) {
        for (int i = 0; i < containerMapping.mObjectClasses.length; ++i) {
            this.addNameFilter(containerMapping.mObjectClasses[i], containerMapping.mNamingAttributes[i], string, string2, vector);
        }
    }

    private String buildNameFilter(EntityType entityType, String string, String string2, boolean bl) throws RegistryException {
        Object object;
        if (entityType == null) {
            throw new RegistryException("An entity type was not provided for the search.", "error.FILTER", MODULE, 0);
        }
        if (string2 == null) {
            throw new RegistryException("The filter is badly formatted.", "error.FILTER", MODULE, 0);
        }
        Vector vector = new Vector();
        int n = entityType.getIntValue();
        ContainerMapping containerMapping = this.getContainerMapping(n);
        if (containerMapping == null) {
            object = this.getItemMapping(n);
            if (object == null) {
                throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
            }
            this.addNameFilter(((ItemMapping)object).mObjectClass, ((ItemMapping)object).mUniqueAttribute, string, string2, vector);
        } else {
            this.addNameFilters(containerMapping, string, string2, vector);
        }
        object = new StringBuffer();
        if (n == 5) {
            this.createRoleFilter(vector, (StringBuffer)object);
        } else if (vector.size() > 1) {
            ((StringBuffer)object).append("(|");
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((StringBuffer)object).append(vector.get(i));
            }
            ((StringBuffer)object).append(")");
        } else {
            ((StringBuffer)object).append(vector.get(0));
        }
        if (n == 6) {
            ((StringBuffer)object).insert(0, "(&(!(objectclass=" + this.mHostMapping.mObjectClass + "))");
            ((StringBuffer)object).append(")");
        }
        this.excludeServiceEntriesFromSearchFilter(bl, (StringBuffer)object);
        return ((StringBuffer)object).toString();
    }

    private void excludeServiceEntriesFromSearchFilter(boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("(&(!(");
        stringBuffer2.append("ou=services");
        stringBuffer2.append("))");
        if (bl) {
            stringBuffer2.append("(!(");
            stringBuffer2.append("ou=OrganizationConfig");
            stringBuffer2.append("))");
        }
        stringBuffer.insert(0, stringBuffer2.toString());
        stringBuffer.append(")");
    }

    private String buildClassFilter(EntityType entityType, boolean bl) throws RegistryException {
        if (entityType == null) {
            throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = entityType.getIntValue();
        ContainerMapping containerMapping = this.getContainerMapping(n);
        if (containerMapping == null) {
            ItemMapping itemMapping = this.getItemMapping(n);
            if (itemMapping == null) {
                throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
            }
            vector.add("(objectclass=" + itemMapping.mObjectClass + ")");
        } else {
            for (int i = 0; i < containerMapping.mObjectClasses.length; ++i) {
                vector.add("(objectclass=" + containerMapping.mObjectClasses[i] + ")");
            }
        }
        if (n == 5) {
            this.createRoleFilter(vector, stringBuffer);
        } else if (vector.size() > 1) {
            stringBuffer.append("(|");
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(vector.get(i));
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(vector.get(0));
        }
        if (n == 6) {
            stringBuffer.insert(0, "(&(!(objectclass=" + this.mHostMapping.mObjectClass + "))");
            stringBuffer.append(")");
        }
        this.excludeServiceEntriesFromSearchFilter(bl, stringBuffer);
        return stringBuffer.toString();
    }

    private void createRoleFilter(Vector vector, StringBuffer stringBuffer) {
        if (vector.size() > 1) {
            stringBuffer.append("(|");
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.get(i));
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(vector.get(0));
        }
        String string = stringBuffer.toString();
        stringBuffer.insert(0, "(|");
        stringBuffer.append("(&(");
        stringBuffer.append("objectclass");
        stringBuffer.append("=ldapsubentry)");
        stringBuffer.append(string);
        stringBuffer.append("))");
    }

    private int parseNextAttribute(String string, int n, int n2, ParsedAttribute parsedAttribute) throws RegistryException {
        int n3;
        parsedAttribute.mAttribute = null;
        int n4 = string.length();
        for (n3 = n; n3 < n4 && SKIPPABLES.indexOf(string.charAt(n3)) != -1; ++n3) {
        }
        if (n3 >= n4) {
            return -1;
        }
        int n5 = string.indexOf(")", n3);
        int n6 = string.indexOf(61, n3);
        if (n6 != -1 && (n5 == -1 || n6 < n5)) {
            char c = string.charAt(n6 - 1);
            if (c == '<' || c == '>' || c == '~') {
                parsedAttribute.mAttribute = string.substring(n3, n6 - 1);
                parsedAttribute.mOperator = string.substring(n6 - 1, n6 + 1);
            } else {
                if (n3 < n6) {
                    parsedAttribute.mAttribute = string.substring(n3, n6);
                }
                parsedAttribute.mOperator = "=";
            }
            parsedAttribute.mLastChar = n6 + 1;
        } else {
            parsedAttribute.mLastChar = n3;
        }
        while (parsedAttribute.mLastChar < n4 && (string.charAt(parsedAttribute.mLastChar) != ')' || string.charAt(parsedAttribute.mLastChar - 1) == '\\')) {
            ++parsedAttribute.mLastChar;
        }
        parsedAttribute.mValue = n6 != -1 && (n5 == -1 || n6 < n5) ? string.substring(n6 + 1, parsedAttribute.mLastChar) : string.substring(n3, parsedAttribute.mLastChar);
        if (parsedAttribute.mAttribute != null) {
            parsedAttribute.mAttribute.trim().toLowerCase();
        }
        parsedAttribute.mValue = parsedAttribute.mValue.trim();
        return n3;
    }

    private String buildMappedFilter(String string, EntityType entityType) throws RegistryException {
        int n;
        Object object;
        if (entityType == null) {
            throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
        }
        int n2 = entityType.getIntValue();
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(0) == '(') {
            n3 = 1;
            bl = true;
        }
        ParsedAttribute parsedAttribute = new ParsedAttribute();
        int n4 = this.parseNextAttribute(string, n3, n2, parsedAttribute);
        StringBuffer stringBuffer = new StringBuffer(200);
        Vector<String> vector = new Vector<String>();
        while (n4 != -1) {
            stringBuffer.delete(0, stringBuffer.length());
            object = this.getContainerMapping(n2);
            if (object != null) {
                for (n = 0; n < ((ContainerMapping)object).mNamingAttributes.length; ++n) {
                    stringBuffer.append("(");
                    stringBuffer.append(((ContainerMapping)object).mNamingAttributes[n]);
                    stringBuffer.append(parsedAttribute.mOperator).append(parsedAttribute.mValue);
                    stringBuffer.append(")");
                }
                vector.add(stringBuffer.toString());
            } else {
                ItemMapping itemMapping = this.getItemMapping(n2);
                if (itemMapping == null) {
                    throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
                }
                if (parsedAttribute.mAttribute == null || parsedAttribute.mAttribute.length() == 0) {
                    parsedAttribute.mAttribute = itemMapping.mUniqueAttribute;
                } else {
                    if (n2 != 6 || !parsedAttribute.mAttribute.equals("sn") && !parsedAttribute.mAttribute.equals("givenname")) {
                        throw new RegistryException("The filter is badly formatted.", "error.FILTER", MODULE, 0);
                    }
                    parsedAttribute.mAttribute = this.mDataStore.getUserProfLdapAttribute(parsedAttribute.mAttribute);
                }
                stringBuffer.append("(").append(parsedAttribute.mAttribute).append(parsedAttribute.mOperator).append(parsedAttribute.mValue).append(")");
                vector.add(stringBuffer.toString());
            }
            n3 = parsedAttribute.mLastChar;
            n4 = this.parseNextAttribute(string, n3, n2, parsedAttribute);
        }
        object = new StringBuffer(200);
        if (vector.size() > 1) {
            ((StringBuffer)object).append("(&");
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StringBuffer)object).append(vector.get(i));
            }
            ((StringBuffer)object).append(")");
        } else {
            ((StringBuffer)object).append(vector.get(0));
        }
        return ((StringBuffer)object).toString();
    }

    public String mapFilter(String string, EntityType entityType, boolean bl) throws RegistryException {
        String string2 = this.buildClassFilter(entityType, bl);
        if (string == null || string.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(string2);
        stringBuffer.append(this.buildMappedFilter(string, entityType)).append(")");
        return stringBuffer.toString();
    }

    public EntityId[] findEntitiesByFilter(EntityId entityId, EntityType entityType, String string, boolean bl, ClientContext clientContext) throws RegistryException {
        int n;
        if (entityType == null) {
            return new EntityId[0];
        }
        if (entityType != EntityType.ALL) {
            return this.searchForEntities(entityId, entityType, this.mapFilter(string, entityType, bl), bl, clientContext);
        }
        EntityId[] entityIdArray = null;
        EntityId[] entityIdArray2 = null;
        EntityId[] entityIdArray3 = null;
        EntityId[] entityIdArray4 = null;
        int n2 = 0;
        switch (entityId.getEntityType().getIntValue()) {
            case 3: {
                entityIdArray = this.searchForEntities(entityId, EntityType.ORG, this.mapFilter(string, EntityType.ORG, bl), bl, clientContext);
                entityIdArray2 = this.searchForEntities(entityId, EntityType.ROLE, this.mapFilter(string, EntityType.ROLE, bl), bl, clientContext);
                entityIdArray3 = this.searchForEntities(entityId, EntityType.USERID, this.mapFilter(string, EntityType.USERID, bl), bl, clientContext);
                n2 = entityIdArray.length + entityIdArray2.length + entityIdArray3.length;
                break;
            }
            case 4: {
                entityIdArray = this.searchForEntities(entityId, EntityType.DOMAIN, this.mapFilter(string, EntityType.DOMAIN, bl), bl, clientContext);
                entityIdArray2 = this.searchForEntities(entityId, EntityType.ROLE, this.mapFilter(string, EntityType.ROLE, bl), bl, clientContext);
                entityIdArray4 = this.searchForEntities(entityId, EntityType.HOST, this.mapFilter(string, EntityType.HOST, bl), bl, clientContext);
                n2 = entityIdArray.length + entityIdArray2.length + entityIdArray4.length;
                break;
            }
            case 5: {
                entityIdArray3 = this.searchForEntities(entityId, EntityType.USERID, this.mapFilter(string, EntityType.USERID, bl), bl, clientContext);
                entityIdArray4 = this.searchForEntities(entityId, EntityType.HOST, this.mapFilter(string, EntityType.HOST, bl), bl, clientContext);
                n2 = entityIdArray3.length + entityIdArray4.length;
            }
        }
        EntityId[] entityIdArray5 = new EntityId[n2];
        int n3 = 0;
        if (entityIdArray != null) {
            for (n = 0; n < entityIdArray.length; ++n) {
                entityIdArray5[n3++] = entityIdArray[n];
            }
        }
        if (entityIdArray2 != null) {
            for (n = 0; n < entityIdArray2.length; ++n) {
                entityIdArray5[n3++] = entityIdArray2[n];
            }
        }
        if (entityIdArray3 != null) {
            for (n = 0; n < entityIdArray3.length; ++n) {
                entityIdArray5[n3++] = entityIdArray3[n];
            }
        }
        if (entityIdArray4 != null) {
            for (n = 0; n < entityIdArray4.length; ++n) {
                entityIdArray5[n3++] = entityIdArray4[n];
            }
        }
        return entityIdArray5;
    }

    private EntityId[] searchForEntities(EntityId entityId, EntityType entityType, String string, boolean bl, ClientContext clientContext) throws RegistryException {
        int n;
        Vector vector;
        int n2;
        if (entityType == null) {
            throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
        }
        int n3 = entityType.getIntValue();
        if (n3 == 0 || n3 == 1) {
            throw new RegistryException("The type provided for the search is invalid.", "error.FILTER", MODULE, 0);
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        String[] stringArray = null;
        String string2 = null;
        switch (n3) {
            case 6: 
            case 7: {
                ItemMapping itemMapping = this.getItemMapping(n3);
                string2 = itemMapping.mUniqueAttribute;
                stringArray = itemMapping.getSearchAttributes();
                if (bl || itemMapping.mContainerEntry == null || itemMapping.mContainerEntry.equals("")) break;
                stringBuffer.append(itemMapping.mContainerEntry).append(",");
                break;
            }
            case 5: {
                if (bl || this.mRoleMapping.mContainerEntry == null || this.mRoleMapping.mContainerEntry.equals("")) break;
                stringBuffer.append(this.mRoleMapping.mContainerEntry).append(",");
            }
        }
        if (entityId != null) {
            stringBuffer.append(entityId.getLocation());
            n2 = entityId.getEntityType().getIntValue();
        } else {
            switch (n3) {
                case 4: 
                case 7: {
                    n2 = 4;
                    entityId = this.mRootDomainEntityId;
                    break;
                }
                default: {
                    n2 = 3;
                    entityId = this.mRootOrgEntityId;
                }
            }
            stringBuffer.append(this.mDataStore.getBaseDN());
        }
        try {
            vector = this.mDataStore.performSearch(stringBuffer.toString(), bl, string, stringArray, true, false, new Organization.BooleanReturnObject(false), false, clientContext);
        }
        catch (RegistryException registryException) {
            if (registryException.getErrorCode() == 32) {
                return new EntityId[0];
            }
            LdapDataStore.checkIfSizeLimitExceeded(registryException);
            throw registryException;
        }
        int n4 = 0;
        if (!vector.isEmpty()) {
            int n5 = vector.size();
            n = 0;
            if (bl && n3 == n2) {
                n = 1;
            }
            EntityId entityId2 = null;
            for (int i = 0; i < n5; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector2 = (Vector)hashtable.get("DN");
                    if (vector2 != null && !vector2.isEmpty()) {
                        entityId2 = this.convertDnToEntityId((String)vector2.get(0), entityType, false, hashtable, clientContext);
                    }
                    if (n != 0) {
                        if (!entityId.equals(entityId2)) {
                            vector.set(n4++, entityId2);
                            continue;
                        }
                        n = 0;
                        continue;
                    }
                    vector.set(n4++, entityId2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        EntityId[] entityIdArray = new EntityId[n4];
        for (n = 0; n < n4; ++n) {
            entityIdArray[n] = (EntityId)vector.get(n);
        }
        return entityIdArray;
    }

    private void getSubEntities(String string, String string2, String[] stringArray, Vector vector, ClientContext clientContext) throws RegistryException {
        int n;
        Vector vector2 = null;
        vector2 = this.mDataStore.getEntriesAttributes(string, false, string2, stringArray, true, clientContext);
        if (vector2 == null || vector2.size() == 0) {
            return;
        }
        vector.addAll(vector2);
        int n2 = n = vector2.size();
        for (int i = 0; i < n; ++i) {
            this.getSubEntities(((String[])vector2.get(i))[n2], string2, stringArray, vector, clientContext);
        }
    }

    private static class ParsedAttribute {
        public String mAttribute;
        public String mOperator = "=";
        public String mValue;
        public int mLastChar;

        private ParsedAttribute() {
        }
    }

    static class UserMapping
    extends ItemMapping {
        String mDisplayFormat = null;
        String[] mDisplayAttributes = null;

        UserMapping(String string, MetaConfiguration metaConfiguration, String string2) throws RegistryException {
            super(string, metaConfiguration, string2);
            this.mDisplayFormat = metaConfiguration.getString(string + LdapOrganization.DISPLAY);
            if (this.mDisplayFormat == null || this.mDisplayFormat.length() == 0) {
                this.mDisplayFormat = "sn, givenname";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.mDisplayFormat, ",");
            int n = 0;
            this.mDisplayAttributes = new String[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreTokens()) {
                this.mDisplayAttributes[n++] = stringTokenizer.nextToken().trim();
            }
        }

        String[] getSearchAttributes() {
            if (this.mSearchAttributes == null) {
                this.mSearchAttributes = new String[1 + this.mDisplayAttributes.length];
                int n = 0;
                this.mSearchAttributes[n] = this.mUniqueAttribute;
                for (int i = 0; i < this.mDisplayAttributes.length; ++i) {
                    this.mSearchAttributes[++n] = this.mDisplayAttributes[i];
                }
            }
            return this.mSearchAttributes;
        }
    }

    static class ItemMapping {
        String mObjectClass = null;
        String mUniqueAttribute = null;
        String mContainerEntry = null;
        String[] mSearchAttributes = null;

        ItemMapping(String string, MetaConfiguration metaConfiguration, String string2) throws RegistryException {
            this.mObjectClass = metaConfiguration.getString(string + LdapOrganization.OBJCLASS);
            this.mUniqueAttribute = metaConfiguration.getString(string + LdapOrganization.UNIQUE_ATTR);
            if (this.mObjectClass == null || this.mUniqueAttribute == null) {
                throw new RegistryException("Error in settings prefixed: " + string, string2, LdapOrganization.MODULE, 0);
            }
            this.mContainerEntry = metaConfiguration.getString(string + LdapOrganization.CONTAINER);
            if (this.mContainerEntry != null && this.mContainerEntry.length() == 0) {
                this.mContainerEntry = null;
            }
        }

        String[] getSearchAttributes() {
            if (this.mSearchAttributes == null) {
                this.mSearchAttributes = new String[1];
                this.mSearchAttributes[0] = this.mUniqueAttribute;
            }
            return this.mSearchAttributes;
        }
    }

    static class ListMapping
    extends ContainerMapping {
        String mContainerEntry = null;
        String mMemberAttribute = null;
        String mListingAttribute = null;

        ListMapping(String string, MetaConfiguration metaConfiguration, String string2) throws RegistryException {
            super(string, metaConfiguration, string2);
            this.mMemberAttribute = metaConfiguration.getString(string + LdapOrganization.MEMBER_ATTR);
            this.mListingAttribute = metaConfiguration.getString(string + LdapOrganization.LISTING_ATTR);
            if (this.mMemberAttribute == null || this.mListingAttribute == null) {
                throw new RegistryException("Error in settings prefixed: " + string, string2, LdapOrganization.MODULE, 0);
            }
            this.mContainerEntry = metaConfiguration.getString(string + LdapOrganization.CONTAINER);
            if (this.mContainerEntry != null && this.mContainerEntry.length() == 0) {
                this.mContainerEntry = null;
            }
        }
    }

    static class ContainerMapping {
        String[] mObjectClasses;
        String[] mNamingAttributes;

        ContainerMapping(String string, MetaConfiguration metaConfiguration, String string2) throws RegistryException {
            this.mObjectClasses = metaConfiguration.getStrings(string + LdapOrganization.OBJCLASS);
            this.mNamingAttributes = metaConfiguration.getStrings(string + LdapOrganization.NAMING_ATTR);
            if (this.mObjectClasses == null || this.mNamingAttributes == null || this.mObjectClasses.length != this.mNamingAttributes.length) {
                throw new RegistryException("Error in settings prefixed " + string, string2, LdapOrganization.MODULE, 0);
            }
        }
    }
}

