/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.model.policytemplate;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.ChooserModel;
import com.sun.apoc.manager.Toolbox;
import com.sun.apoc.manager.model.policytemplate.PolicyNavigationModel;
import com.sun.apoc.manager.model.policytemplate.PolicyTemplateModel;
import com.sun.apoc.manager.model.policytemplate.PropertyStatusModel;
import com.sun.apoc.manager.resource.ResourceRepository;
import com.sun.apoc.policy.cfgtree.ConfigNode;
import com.sun.apoc.policy.cfgtree.NodeType;
import com.sun.apoc.policy.cfgtree.PropertyNode;
import com.sun.apoc.policy.cfgtree.ValueType;
import com.sun.apoc.policy.common.PolicySetId;
import com.sun.apoc.policy.common.RegistryException;
import com.sun.apoc.templates.parsing.TemplateProperty;
import com.sun.apoc.templates.parsing.TemplatePropertyConstraint;
import com.sun.apoc.templates.parsing.TemplateSection;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class PolicySectionModel
extends CCActionTableModel
implements PropertyStatusModel {
    public static final String PROPERTY = "Property";
    public static final String PROPERTY_NAME = "PropertyName";
    public static final String PROPERTY_STATUS = "PropertyStatusValue";
    public static final String PROPERTY_VALUE = "PropertyValue";
    public static final String PROPERTY_VALUE_TMP = "PropertyValueTmp";
    public static final String PREVIOUS_VALUE = "PreviousValue";
    public static final String DEFAULT_VALUE = "DefaultValue";
    public static final String PREVIOUS_STATUS = "PreviousStatus";
    public static final String VALUE_ABOVE = "ValueAbove";
    public static final String DISABLED_FIELDS_VALUES = "DisabledFieldsValues";
    public static final byte UNPROTECTED = 1;
    public static final byte PROTECTED = 2;
    public static final byte CLEARED = 4;
    public static final byte DEFAULT = 8;
    public static final String UNDEFINED = "_UNDEFINED_";
    public static final String NIL = "_NIL_";
    public static final String RELATIVE_PATH = "./";
    public static final String QUERIED_ID = "$queriedId";
    private TemplateSection m_templateSection = null;
    private PolicyTemplateModel m_templateModel = null;
    private Vector choosers = new Vector(0);
    private Vector handlers = new Vector(0);

    public PolicySectionModel(TemplateSection templateSection, PolicyTemplateModel policyTemplateModel) {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/ContentAreaPoliciesSection.xml");
        this.m_templateSection = templateSection;
        this.m_templateModel = policyTemplateModel;
        this.setActionValue("NameColumn", "APOC.policies.nameCol");
        this.setActionValue("ValueColumn", "APOC.policies.value");
        this.setActionValue("StateColumn", "APOC.policies.status");
        this.setSelectionType("multiple");
        this.update();
    }

    public void update() {
        ResourceRepository resourceRepository = ResourceRepository.getDefaultRepository();
        String string = resourceRepository.getMessage(this.m_templateSection.getResourceId(), this.m_templateSection.getResourceBundle(), RequestManager.getRequest());
        this.setTitle(string);
        try {
            this.getRowList().clear();
            for (int i = 0; i < this.m_templateSection.getProperties().size(); ++i) {
                int n;
                Object object;
                Object object2;
                TemplateProperty templateProperty = this.m_templateSection.getProperty(i);
                if (!templateProperty.isInScope(PolicyNavigationModel.getScope())) continue;
                this.appendRow();
                String string2 = resourceRepository.getMessage(templateProperty.getResourceId(), templateProperty.getResourceBundle(), RequestManager.getRequest());
                String string3 = this.getAbsolutePath(templateProperty.getDataPath());
                PropertyNode propertyNode = PolicySectionModel.getConfigNode(string3);
                this.setConfigNode((ConfigNode)propertyNode);
                String string4 = null;
                if (propertyNode != null && propertyNode.getValue() != null && propertyNode.getValue().getContents() != null) {
                    string4 = propertyNode.getValue().getContents();
                    if (templateProperty.getVisualType().equals("colorSelector") && templateProperty.getDataPath().startsWith("org.openoffice.Office")) {
                        object2 = new StringBuffer();
                        try {
                            object = Integer.toHexString(new Integer(string4));
                            ((StringBuffer)object2).append("#");
                            if (((String)object).length() < 6) {
                                for (n = 0; n < 6 - ((String)object).length(); ++n) {
                                    ((StringBuffer)object2).append("0");
                                }
                            }
                            ((StringBuffer)object2).append((String)object);
                            string4 = ((StringBuffer)object2).toString();
                        }
                        catch (NumberFormatException numberFormatException) {
                            CCDebug.trace1((String)("Error decoding value" + string4), (Throwable)numberFormatException);
                        }
                    }
                    if (templateProperty.getVisualType().equals("chooser")) {
                        object2 = new ChooserModel();
                        if (templateProperty.getExtendsChooser() == null) {
                            this.choosers.add(((ChooserModel)((Object)object2)).getPropertyPath(templateProperty, RequestManager.getRequestContext()));
                            this.choosers.add(string4);
                            if (templateProperty.getDefaultValue() != null) {
                                this.choosers.add(((ChooserModel)((Object)object2)).getPropertyPath(templateProperty, RequestManager.getRequestContext()));
                                this.choosers.add(templateProperty.getDefaultValue());
                            }
                        } else {
                            object = ((ChooserModel)((Object)object2)).getLinkedChooserProperty(templateProperty.getExtendsChooser());
                            this.choosers.add(templateProperty.getExtendsChooser());
                            this.choosers.add(string4);
                            if (object.getDefaultValue() != null) {
                                this.choosers.add(templateProperty.getExtendsChooser());
                                this.choosers.add(object.getDefaultValue());
                            }
                        }
                    }
                } else if (templateProperty.getDefaultValue() != null) {
                    string4 = templateProperty.getDefaultValue();
                    if (templateProperty.getVisualType().equals("chooser")) {
                        object2 = new ChooserModel();
                        if (templateProperty.getExtendsChooser() == null) {
                            this.choosers.add(((ChooserModel)((Object)object2)).getPropertyPath(templateProperty, RequestManager.getRequestContext()));
                            this.choosers.add(string4);
                        } else {
                            object = ((ChooserModel)((Object)object2)).getLinkedChooserProperty(templateProperty.getExtendsChooser());
                            this.choosers.add(templateProperty.getExtendsChooser());
                            this.choosers.add(string4);
                        }
                    }
                } else {
                    string4 = templateProperty.getVisualType().equals("checkBox") ? "false" : "";
                }
                if (propertyNode != null && propertyNode.isReadOnly() || PolicyNavigationModel.isReadOnlyPage()) {
                    this.setSelectionVisible(false);
                    object2 = new CCI18N(RequestManager.getRequestContext(), "com.sun.apoc.manager.resource.apoc_manager");
                    if (templateProperty.getVisualType().equals("checkBox")) {
                        if (string4.equals("true")) {
                            string4 = resourceRepository.getValidMessage(templateProperty.getResourceId() + ".checked", templateProperty.getResourceBundle(), RequestManager.getRequest());
                            if (string4 == null) {
                                string4 = object2.getMessage("APOC.policies.enabled");
                            }
                        } else {
                            string4 = resourceRepository.getValidMessage(templateProperty.getResourceId() + ".unchecked", templateProperty.getResourceBundle(), RequestManager.getRequest());
                            if (string4 == null) {
                                string4 = object2.getMessage("APOC.policies.disabled");
                            }
                        }
                    } else if (templateProperty.getVisualType().equals("radioButtons") || templateProperty.getVisualType().equals("comboBox")) {
                        object = new StringBuffer();
                        ((StringBuffer)object).append(templateProperty.getResourceId());
                        ((StringBuffer)object).append(".");
                        ((StringBuffer)object).append(string4);
                        String string5 = resourceRepository.getValidMessage(((StringBuffer)object).toString(), templateProperty.getResourceBundle(), RequestManager.getRequest());
                        if (string5 == null) {
                            for (int j = 0; j < templateProperty.getConstraints().size(); ++j) {
                                TemplatePropertyConstraint templatePropertyConstraint = (TemplatePropertyConstraint)templateProperty.getConstraints().elementAt(j);
                                if (!templatePropertyConstraint.getValue().equals(string4) || templatePropertyConstraint.getResourceId() == null) continue;
                                string5 = resourceRepository.getMessage(templatePropertyConstraint.getResourceId(), templateProperty.getResourceBundle(), RequestManager.getRequest());
                                break;
                            }
                        }
                        string4 = string5 != null ? string5 : ((StringBuffer)object).toString();
                    } else if (templateProperty.getVisualType().equals("password")) {
                        object = new StringBuffer();
                        for (n = 0; n < string4.length(); ++n) {
                            ((StringBuffer)object).append("*");
                        }
                        string4 = ((StringBuffer)object).toString();
                    }
                }
                super.setValue(PROPERTY_NAME, (Object)string2);
                super.setValue(PROPERTY, (Object)templateProperty);
                super.setValue(PROPERTY_VALUE_TMP, null);
                super.setValue(PROPERTY_VALUE, (Object)string4);
                super.setValue(PREVIOUS_VALUE, (Object)string4);
                super.setValue(PREVIOUS_STATUS, (Object)"");
                super.setValue(VALUE_ABOVE, (Object)"");
                super.setValue(PROPERTY_STATUS, (Object)"");
                if (templateProperty.getDefaultValue() != null) {
                    super.setValue(DEFAULT_VALUE, (Object)templateProperty.getDefaultValue());
                    continue;
                }
                if (templateProperty.hasDefaultNilValue()) {
                    super.setValue(DEFAULT_VALUE, (Object)NIL);
                    continue;
                }
                super.setValue(DEFAULT_VALUE, (Object)UNDEFINED);
            }
            this.beforeFirst();
        }
        catch (RegistryException registryException) {
            CCDebug.trace1((String)"Error using policy manager!", (Throwable)registryException);
        }
        catch (ModelControlException modelControlException) {
            CCDebug.trace1((String)"Error initializing the model!", (Throwable)modelControlException);
        }
    }

    public ConfigNode getConfigNode() {
        return (ConfigNode)this.getValue("CONFIG_NODE");
    }

    public void setConfigNode(ConfigNode configNode) {
        this.setValue("CONFIG_NODE", configNode);
    }

    public TemplateSection getTemplateSection() {
        return this.m_templateSection;
    }

    public void setValue(String string, Object object) {
        if (string.equals(PROPERTY_VALUE)) {
            super.setValue(PROPERTY_VALUE_TMP, object);
        } else {
            super.setValue(string, object);
        }
    }

    public List getPropertiesChanges() throws RegistryException {
        LinkedList<PropertyNode> linkedList = new LinkedList<PropertyNode>();
        for (int i = 0; i < this.getNumRows(); ++i) {
            this.setRowIndex(i);
            TemplateProperty templateProperty = (TemplateProperty)this.getValue(PROPERTY);
            String string = (String)this.getValue(PROPERTY_VALUE_TMP);
            String string2 = (String)this.getValue(PROPERTY_VALUE);
            String string3 = (String)this.getValue(PROPERTY_STATUS);
            PropertyNode propertyNode = (PropertyNode)this.getConfigNode();
            if (propertyNode != null && (propertyNode == null || propertyNode.isReadOnly())) continue;
            if (string == null) {
                string = "false";
            }
            if (string.equals(string2) && string3.equals("")) continue;
            CCDebug.trace3((String)("Change detected in " + templateProperty.getDefaultName()));
            if (propertyNode == null) {
                String string4 = this.getAbsolutePath(templateProperty.getDataPath());
                propertyNode = PolicySectionModel.createConfigNode(string4);
                propertyNode.setValueType(PolicySectionModel.getDataType(templateProperty));
            }
            int n = 0;
            if (!string3.equals("")) {
                n = Integer.decode(string3);
            }
            if (!string.equals(string2) && (n & 4) == 0) {
                CCDebug.trace3((String)("Value changed: " + templateProperty.getDefaultName()));
                CCDebug.trace3((String)("New Value: " + string));
                CCDebug.trace3((String)("Old Value: " + string2));
                if (this.isValidValue(propertyNode.getValueType(), string)) {
                    if (templateProperty.getVisualType().equals("colorSelector") && templateProperty.getDataPath().startsWith("org.openoffice.Office")) {
                        try {
                            string = string.substring(1);
                            int n2 = Integer.parseInt(string, 16);
                            long l = Long.parseLong(string, 16);
                            string = Integer.toString(n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            CCDebug.trace1((String)("Error wrong value format" + string), (Throwable)numberFormatException);
                            string = "";
                        }
                    }
                    propertyNode.getValue().setNewContents(string);
                    if (templateProperty.getVisualType().equals("stringList")) {
                        propertyNode.setSeparator(templateProperty.getSeparator());
                    }
                } else {
                    propertyNode.clear();
                }
            }
            if (n != 0) {
                CCDebug.trace3((String)("Status changed: " + templateProperty.getDefaultName()));
                if ((n & 4) != 0) {
                    CCDebug.trace3((String)"Cleared");
                    propertyNode.clear();
                }
                if ((n & 2) != 0) {
                    propertyNode.protect(true);
                    CCDebug.trace3((String)"Protected");
                } else if ((n & 1) != 0) {
                    CCDebug.trace3((String)"Unprotected");
                    propertyNode.protect(false);
                }
                if ((n & 8) != 0) {
                    CCDebug.trace3((String)"Set to default value");
                    if (templateProperty.hasDefaultNilValue()) {
                        propertyNode.getValue().setValueToNil();
                    } else {
                        propertyNode.getValue().setNewContents(string);
                        if (templateProperty.getVisualType().equals("stringList")) {
                            propertyNode.setSeparator(templateProperty.getSeparator());
                        }
                    }
                }
                this.setValue(PROPERTY_STATUS, "");
            }
            linkedList.add(propertyNode);
        }
        return linkedList;
    }

    protected boolean isValidValue(ValueType valueType, String string) {
        if (string.trim().length() == 0) {
            if (valueType == ValueType.SHORT) {
                return false;
            }
            if (valueType == ValueType.INTEGER) {
                return false;
            }
            if (valueType == ValueType.LONG) {
                return false;
            }
            if (valueType == ValueType.HEXBIN) {
                return false;
            }
            return valueType != ValueType.DOUBLE;
        }
        return true;
    }

    public static ValueType getDataType(TemplateProperty templateProperty) {
        if (templateProperty.getDataType() == null) {
            if (templateProperty.getVisualType().equals("checkBox")) {
                return ValueType.BOOLEAN;
            }
            if (templateProperty.getVisualType().equals("comboBox")) {
                return ValueType.INTEGER;
            }
            if (templateProperty.getVisualType().equals("textField")) {
                return ValueType.STRING;
            }
            if (templateProperty.getVisualType().equals("textArea")) {
                return ValueType.STRING;
            }
            if (templateProperty.getVisualType().equals("radioButtons")) {
                return ValueType.INTEGER;
            }
            return ValueType.STRING;
        }
        if (templateProperty.getDataType().equals("xs:boolean")) {
            return ValueType.BOOLEAN;
        }
        if (templateProperty.getDataType().equals("xs:short")) {
            return ValueType.SHORT;
        }
        if (templateProperty.getDataType().equals("xs:int")) {
            return ValueType.INTEGER;
        }
        if (templateProperty.getDataType().equals("xs:long")) {
            return ValueType.LONG;
        }
        if (templateProperty.getDataType().equals("xs:double")) {
            return ValueType.DOUBLE;
        }
        if (templateProperty.getDataType().equals("xs:string")) {
            return ValueType.STRING;
        }
        if (templateProperty.getDataType().equals("xs:hexBinary")) {
            return ValueType.HEXBIN;
        }
        if (templateProperty.getDataType().equals("oor:any")) {
            return ValueType.ANY;
        }
        if (templateProperty.getDataType().equals("oor:boolean-list")) {
            return ValueType.BOOLEAN_LIST;
        }
        if (templateProperty.getDataType().equals("oor:short-list")) {
            return ValueType.SHORT_LIST;
        }
        if (templateProperty.getDataType().equals("oor:int-list")) {
            return ValueType.INTEGER_LIST;
        }
        if (templateProperty.getDataType().equals("oor:long-list")) {
            return ValueType.LONG_LIST;
        }
        if (templateProperty.getDataType().equals("oor:double-list")) {
            return ValueType.DOUBLE_LIST;
        }
        if (templateProperty.getDataType().equals("oor:string-list")) {
            return ValueType.STRING_LIST;
        }
        if (templateProperty.getDataType().equals("oor:hexBinary-list")) {
            return ValueType.HEXBIN_LIST;
        }
        return ValueType.STRING;
    }

    public static void setDataType(TemplateProperty templateProperty, PropertyNode propertyNode) {
        propertyNode.setValueType(PolicySectionModel.getDataType(templateProperty));
    }

    public static PropertyNode createConfigNode(String string) throws RegistryException {
        PolicySetId policySetId = Toolbox.getPolicyGroupId();
        return (PropertyNode)Toolbox.getPolicyManager().createNode(string, NodeType.PROPERTY, policySetId, false);
    }

    public static PropertyNode getConfigNode(String string) throws RegistryException {
        PolicySetId policySetId = Toolbox.getPolicyGroupId();
        return (PropertyNode)Toolbox.getPolicyManager().getNode(string, policySetId);
    }

    protected String getAbsolutePath(String string) {
        String string2 = string;
        if (string.startsWith(RELATIVE_PATH)) {
            string2 = this.m_templateModel.getPage().getDataPath() + string.substring(1);
            int n = string2.indexOf(QUERIED_ID);
            string2 = string2.substring(0, n) + this.m_templateModel.getSetIndex() + string2.substring(n + QUERIED_ID.length());
        }
        return string2;
    }

    public Vector getChoosers() {
        return this.choosers;
    }

    public Vector getHandlers() {
        return this.handlers;
    }

    public void resetChoosers() {
        this.choosers.clear();
    }

    public void resetHandlers() {
        this.handlers.clear();
    }
}

