/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.profiles;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.manager.entities.NavigationModel;
import com.sun.apoc.manager.profiles.ProfileModel;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class AvailableTableModel
extends ProfileModel {
    public static final String CHILD_ACCESS_HIDDEN = "AccessHidden";
    private static LinkedList m_allProfiles;
    private static HashMap m_accessCache;
    private static Boolean m_organizationRootReadOnly;
    private static Boolean m_domainRootReadOnly;
    static /* synthetic */ Class class$com$sun$apoc$manager$entities$NavigationModel;

    public void setRequestContext(RequestContext requestContext) {
        super.setRequestContext(requestContext);
        this.setActionValue("NameColumn", "APOC.navigation.name");
        this.setActionValue("AuthorColumn", "APOC.profilemgr.author");
        this.setActionValue("LastModifiedColumn", "APOC.profilemgr.lastMod");
    }

    public void rename(String string, String string2) throws ModelControlException {
        try {
            Profile profile = Toolbox2.getPolicyManager().getProfile(string);
            profile.setDisplayName(string2);
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }

    public void destroy(LinkedList linkedList) throws ModelControlException {
        try {
            NavigationModel navigationModel = (NavigationModel)this.m_requestContext.getModelManager().getModel(class$com$sun$apoc$manager$entities$NavigationModel == null ? (class$com$sun$apoc$manager$entities$NavigationModel = AvailableTableModel.class$("com.sun.apoc.manager.entities.NavigationModel")) : class$com$sun$apoc$manager$entities$NavigationModel, "NavTree", true, true);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Profile profile = Toolbox2.getPolicyManager().getProfile(string);
                ProfileRepository profileRepository = profile.getProfileRepository();
                Iterator iterator2 = profile.getAssignedEntities();
                while (iterator2.hasNext()) {
                    Entity entity = (Entity)iterator2.next();
                    Iterator iterator3 = entity.getAssignedProfiles();
                    iterator3.next();
                    navigationModel.setAssignedState(entity, iterator3.hasNext());
                    entity.unassignProfile(profile);
                }
                profileRepository.destroyProfile(profile);
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }

    public void retrieve(Entity entity) throws ModelControlException {
        try {
            m_allProfiles = new LinkedList();
            m_accessCache = new HashMap();
            m_organizationRootReadOnly = null;
            m_domainRootReadOnly = null;
            Iterator iterator = Toolbox2.getPolicyManager().getProfileProvider().getAllProfiles();
            while (iterator.hasNext()) {
                Profile profile = (Profile)iterator.next();
                m_allProfiles.add(profile);
                if (m_accessCache.containsKey(profile)) continue;
                m_accessCache.put(profile, new Boolean(profile.getProfileRepository().isReadOnly()));
                if (m_organizationRootReadOnly == null && profile.getProfileRepository().getEntity().equals(Toolbox2.getPolicyManager().getRootOrganization())) {
                    m_organizationRootReadOnly = (Boolean)m_accessCache.get(profile);
                    continue;
                }
                if (m_domainRootReadOnly != null || !profile.getProfileRepository().getEntity().equals(Toolbox2.getPolicyManager().getRootDomain())) continue;
                m_domainRootReadOnly = (Boolean)m_accessCache.get(profile);
            }
            if (m_organizationRootReadOnly == null) {
                m_organizationRootReadOnly = new Boolean(Toolbox2.getPolicyManager().getRootOrganization().getProfileRepository().isReadOnly());
            }
            if (m_domainRootReadOnly == null) {
                m_domainRootReadOnly = new Boolean(Toolbox2.getPolicyManager().getRootDomain().getProfileRepository().isReadOnly());
            }
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
    }

    public void fillModel(Applicability applicability) throws ModelControlException {
        this.clear();
        try {
            ListIterator listIterator = m_allProfiles.listIterator();
            while (listIterator.hasNext()) {
                Profile profile = (Profile)listIterator.next();
                if (!profile.getApplicability().equals((Object)applicability)) continue;
                this.appendRow();
                Date date = new Date(profile.getLastModified());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z");
                String string = simpleDateFormat.format(date);
                this.setValue("NameText", profile.getDisplayName());
                this.setValue("NameHref", profile.getId());
                this.setValue("LastModifiedText", string);
                this.setValue(CHILD_ACCESS_HIDDEN, ((Boolean)m_accessCache.get(profile)).toString());
                if (profile.getAuthor() == null) continue;
                this.setValue("AuthorText", profile.getAuthor());
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }

    public boolean hasReadOnlyProfile() {
        Iterator iterator = m_accessCache.values().iterator();
        while (iterator.hasNext()) {
            if (!((Boolean)iterator.next()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isOrganizationRootReadOnly() {
        return m_organizationRootReadOnly;
    }

    public boolean isDomainRootReadOnly() {
        return m_domainRootReadOnly;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

