/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.profiles;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.sun.apoc.manager.profiles.ProfileModel;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Host;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class PrioritizationTableModel
extends ProfileModel {
    public void setRequestContext(RequestContext requestContext) {
        super.setRequestContext(requestContext);
        this.setActionValue("NameColumn", "APOC.navigation.name");
        this.setActionValue("AuthorColumn", "APOC.profilemgr.author");
        this.setActionValue("LastModifiedColumn", "APOC.profilemgr.lastMod");
        this.setPrimarySortName("PrioText");
    }

    public void retrieve(Profile profile) throws ModelControlException {
        try {
            if (profile != null) {
                this.retrieve(profile.getProfileRepository().getEntity());
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }

    public void retrieve(Entity entity) throws ModelControlException {
        this.clear();
        try {
            Applicability applicability = Applicability.USER;
            if (entity instanceof Domain || entity instanceof Host) {
                applicability = Applicability.HOST;
            }
            ProfileRepository profileRepository = entity.getProfileRepository();
            Iterator iterator = profileRepository.getProfiles(applicability);
            while (iterator.hasNext()) {
                this.appendRow();
                Profile profile = (Profile)iterator.next();
                Date date = new Date(profile.getLastModified());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z");
                String string = simpleDateFormat.format(date);
                this.setValue("NameText", profile.getDisplayName());
                this.setValue("NameHref", profile.getId());
                this.setValue("LastModifiedText", string);
                this.setValue("PrioText", new Integer(profile.getPriority()));
                if (profile.getAuthor() == null) continue;
                this.setValue("AuthorText", profile.getAuthor());
            }
        }
        catch (SPIException sPIException) {
            throw new ModelControlException((Throwable)sPIException);
        }
    }
}

