/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.profiles;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.sun.apoc.manager.ProfileWindowSettingsTreeViewBean;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.manager.entities.NavigationModel;
import com.sun.apoc.manager.settings.PolicyMgrHelper;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Host;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import com.sun.web.ui.common.CCI18N;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ProfileWindowModel
extends DefaultModel
implements RequestParticipant {
    public static final String SETTINGS_TAB = "1";
    public static final String ASSIGNEES_TAB = "2";
    public static final String GENERAL_TAB = "3";
    public static final String SUMMARY_TAB = "4";
    public static final String ADVANCED_TAB = "5";
    public static final String SELECTED_TAB = "SelectedEditorTab";
    public static final String SELECTED_PROFILE = "ProfileWindowFrameset.SelectedProfile";
    public static final String CATEGORY_HREF_SELECTION = "PolicySettingsContent.CategoryHref";
    public static final String PROFILE_HELPER = "ProfileHelper";
    public static final String NEW_ASSIGNED_PROFILE = "NewAssignedProfile";
    public static final String NEW_PROFILE = "NewProfile";
    public static final String NEW_PROFILE_ORG = "NewProfileOrg";
    public static final String NEW_PROFILE_DOMAIN = "NewProfileDomain";
    public static final String ALERT_TXT = "AlertText";
    public static final String ALERT_DETAILS = "AlertDetails";
    public static final String ALERT_TYPE = "AlertType";
    private String mSelectedTab = null;
    private Profile mProfile = null;
    private String mSelectedCategory = null;
    private HttpServletRequest mRequest = null;
    private HttpSession mSession = null;
    private String mAnchor = "";
    static /* synthetic */ Class class$com$sun$apoc$manager$entities$NavigationModel;

    public void setSelectedTab(String string) {
        this.mSession.setAttribute(SELECTED_TAB, (Object)string);
        this.mSelectedTab = string;
    }

    public String getSelectedTab() {
        return this.mSelectedTab;
    }

    protected String determineSelectedTab() {
        String string = this.mRequest.getParameter(SELECTED_TAB);
        if (string == null) {
            string = (String)this.mSession.getAttribute(SELECTED_TAB);
        }
        if (string == null) {
            string = GENERAL_TAB;
        }
        return string;
    }

    public void setSelectedCategory(String string) {
        this.mSession.setAttribute("ContentArea.PolicyTemplateSelection", (Object)string);
        this.mSelectedCategory = string;
    }

    public String getSelectedCategory() {
        return this.mSelectedCategory;
    }

    public String determineSelectedCategory() {
        String string = this.mRequest.getParameter(CATEGORY_HREF_SELECTION);
        if (string == null) {
            string = (String)this.mSession.getAttribute("ContentArea.PolicyTemplateSelection");
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setProfile(Profile profile) {
        Profile profile2 = (Profile)this.mSession.getAttribute(SELECTED_PROFILE);
        if (profile2 == null) {
            this.resetNavigationState();
        } else if (profile == null) {
            this.resetNavigationState();
        } else if (!profile.getId().equals(profile2.getId())) {
            this.resetNavigationState();
        }
        this.mSession.setAttribute(PROFILE_HELPER, (Object)new PolicyMgrHelper(Toolbox2.getPolicyManager(), profile));
        this.mSession.setAttribute(SELECTED_PROFILE, (Object)profile);
        this.mProfile = profile;
    }

    protected void resetNavigationState() {
        ProfileWindowSettingsTreeViewBean.resetTreeModel();
        String string = this.determineSelectedCategory();
        if (string != null && string.indexOf("SET_") != -1) {
            string = string.substring(0, string.indexOf("SET_") - 1);
            this.setSelectedCategory(string);
        }
    }

    public Profile getProfile() {
        return this.mProfile;
    }

    protected Profile determineProfile() {
        Profile profile = null;
        try {
            String string = this.mRequest.getParameter(SELECTED_PROFILE);
            if (string == null) {
                profile = (Profile)this.mSession.getAttribute(SELECTED_PROFILE);
            } else {
                PolicyMgr policyMgr = Toolbox2.getPolicyManager();
                if (string.equals(NEW_ASSIGNED_PROFILE) || string.startsWith(NEW_PROFILE)) {
                    this.setSelectedTab(GENERAL_TAB);
                    if (string.equals(NEW_PROFILE_ORG)) {
                        string = this.createNewProfile((Entity)policyMgr.getRootOrganization(), false);
                    } else if (string.equals(NEW_PROFILE_DOMAIN)) {
                        string = this.createNewProfile((Entity)policyMgr.getRootDomain(), false);
                    } else {
                        Entity entity = Toolbox2.getSelectedEntity();
                        boolean bl = string.equals(NEW_ASSIGNED_PROFILE);
                        string = this.createNewProfile(entity, bl);
                    }
                }
                profile = policyMgr.getProfile(string);
            }
        }
        catch (SPIException sPIException) {
            this.setErrorMessage("Could not create new profile.", sPIException);
        }
        return profile;
    }

    public String createNewProfile(Entity entity, boolean bl) throws SPIException {
        Object object;
        Object object2;
        Object[] objectArray;
        Profile profile = null;
        CCI18N cCI18N = new CCI18N(RequestManager.getRequestContext(), "com.sun.apoc.manager.resource.apoc_manager");
        String string = cCI18N.getMessage("APOC.profilewnd.lc_domains");
        String string2 = cCI18N.getMessage("APOC.profilewnd.lc_hosts");
        String string3 = cCI18N.getMessage("APOC.profilewnd.lc_orgs");
        String string4 = cCI18N.getMessage("APOC.profilewnd.lc_users");
        Applicability applicability = Applicability.USER;
        if (entity instanceof Domain || entity instanceof Host) {
            applicability = Applicability.HOST;
            objectArray = new Object[]{string, string2};
            this.setInfoMessage(cCI18N.getMessage("APOC.profilewnd.creating_new"), cCI18N.getMessage("APOC.profilewnd.general.new_profile_instructions", objectArray));
        } else {
            objectArray = new Object[]{string3, string4};
            this.setInfoMessage(cCI18N.getMessage("APOC.profilewnd.creating_new"), cCI18N.getMessage("APOC.profilewnd.general.new_profile_instructions", objectArray));
        }
        objectArray = null;
        for (object2 = entity; object2 != null; object2 = object2.getParent()) {
            object = object2.getProfileRepository();
            if (object.isReadOnly()) continue;
            objectArray = object;
        }
        object2 = this.generateDefaultProfileName((ProfileRepository)objectArray, applicability);
        profile = objectArray.createProfile((String)object2, applicability);
        if (bl) {
            entity.assignProfile(profile);
        }
        object = (NavigationModel)RequestManager.getRequestContext().getModelManager().getModel(class$com$sun$apoc$manager$entities$NavigationModel == null ? (class$com$sun$apoc$manager$entities$NavigationModel = ProfileWindowModel.class$("com.sun.apoc.manager.entities.NavigationModel")) : class$com$sun$apoc$manager$entities$NavigationModel, "NavTree", true, true);
        ((NavigationModel)((Object)object)).setAssignedState(entity, true);
        return profile.getId();
    }

    protected String generateDefaultProfileName(ProfileRepository profileRepository, Applicability applicability) throws SPIException {
        String string;
        String string2 = NEW_PROFILE;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = profileRepository.getProfiles(applicability);
        while (iterator.hasNext()) {
            string = (Profile)iterator.next();
            hashSet.add(string.getDisplayName());
        }
        string = string2;
        int n = 1;
        while (hashSet.contains(string)) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(n);
            string = stringBuffer.toString();
            ++n;
        }
        return string;
    }

    public boolean isHostProfileSelected() {
        if (this.getProfile() != null) {
            return Applicability.HOST.equals((Object)this.getProfile().getApplicability());
        }
        return true;
    }

    public byte getSettingsScope() {
        if (this.isHostProfileSelected()) {
            return 2;
        }
        return 1;
    }

    public boolean isReadOnlyProfile() {
        boolean bl = true;
        try {
            bl = this.getProfile().getProfileRepository().isReadOnly();
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        return bl;
    }

    public void setInfoMessage(String string, String string2) {
        this.mSession.setAttribute(ALERT_TXT, (Object)string);
        this.mSession.setAttribute(ALERT_DETAILS, (Object)string2);
        this.mSession.setAttribute(ALERT_TYPE, (Object)"info");
    }

    public void setErrorMessage(String string, String string2) {
        this.mSession.setAttribute(ALERT_TXT, (Object)string);
        this.mSession.setAttribute(ALERT_DETAILS, (Object)string2);
        this.mSession.setAttribute(ALERT_TYPE, (Object)"error");
    }

    public void setErrorMessage(String string, SPIException sPIException) {
        this.setErrorMessage(string, sPIException.getLocalizedMessage(this.mRequest.getLocale()));
    }

    public void setAnchor(String string) {
        this.mSession.setAttribute("ANCHOR", (Object)string);
    }

    public boolean hasAlert() {
        return this.getAlertMessage() != null;
    }

    public String getAlertMessage() {
        return (String)this.mSession.getAttribute(ALERT_TXT);
    }

    public String getAlertType() {
        return (String)this.mSession.getAttribute(ALERT_TYPE);
    }

    public String getAlertDetails() {
        return (String)this.mSession.getAttribute(ALERT_DETAILS);
    }

    public PolicyMgrHelper getProfileHelper() {
        return (PolicyMgrHelper)this.mSession.getAttribute(PROFILE_HELPER);
    }

    public String getAnchor() {
        return (String)this.mSession.getAttribute("ANCHOR");
    }

    public void setRequestContext(RequestContext requestContext) {
        this.mRequest = requestContext.getRequest();
        this.mSession = this.mRequest.getSession();
        this.setProfile(this.determineProfile());
        this.setSelectedTab(this.determineSelectedTab());
        this.setSelectedCategory(this.determineSelectedCategory());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

