/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager.settings;

import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.PolicyTree;
import com.sun.apoc.spi.cfgtree.policynode.PolicyNode;
import com.sun.apoc.spi.cfgtree.property.Property;
import com.sun.apoc.spi.cfgtree.readwrite.ReadWritePolicyTreeConverterImpl;
import com.sun.apoc.spi.cfgtree.readwrite.ReadWritePolicyTreeFactoryImpl;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Profile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PolicyMgrHelper {
    public static final String SEPARATOR = "/";
    private PolicyMgr m_mgr = null;
    private Profile m_pg = null;
    private HashMap m_treeCache = new HashMap();

    public PolicyMgrHelper() {
    }

    public PolicyMgrHelper(PolicyMgr policyMgr, Profile profile) {
        this.initialize(policyMgr, profile);
    }

    public PolicyMgr getManager() {
        return this.m_mgr;
    }

    public Profile getPolicyGroup() {
        return this.m_pg;
    }

    public void initialize(PolicyMgr policyMgr, Profile profile) {
        this.m_mgr = policyMgr;
        this.m_pg = profile;
        this.m_treeCache.clear();
    }

    public Property getProperty(String string) throws SPIException {
        String string2 = PolicyMgrHelper.decodePath(string.substring(string.lastIndexOf(SEPARATOR) + 1, string.length()));
        String string3 = string.substring(0, string.lastIndexOf(SEPARATOR));
        PolicyNode policyNode = this.getNode(string3);
        if (policyNode != null) {
            return policyNode.getProperty(string2);
        }
        return null;
    }

    public boolean equalProperties(Property property, Property property2) throws SPIException {
        if (property == null || property2 == null) {
            return false;
        }
        if (property.isProtected() != property2.isProtected()) {
            return false;
        }
        return !(property.getValue() == null ? property2.getValue() != null : !property.getValue().equals(property2.getValue()));
    }

    public Property createProperty(String string) throws SPIException {
        String string2 = PolicyMgrHelper.decodePath(string.substring(string.lastIndexOf(SEPARATOR) + 1, string.length()));
        String string3 = string.substring(0, string.lastIndexOf(SEPARATOR));
        PolicyNode policyNode = this.createNode(string3);
        if (policyNode != null) {
            return policyNode.addProperty(string2);
        }
        return null;
    }

    public void removeProperty(String string) throws SPIException {
        String string2 = PolicyMgrHelper.decodePath(string.substring(string.lastIndexOf(SEPARATOR) + 1, string.length()));
        String string3 = string.substring(0, string.lastIndexOf(SEPARATOR));
        PolicyNode policyNode = this.getNode(string3);
        if (policyNode != null) {
            policyNode.removeProperty(string2);
        }
    }

    public boolean nodeExists(String string) throws SPIException {
        String string2 = string.substring(0, string.indexOf(SEPARATOR));
        PolicyTree policyTree = this.getTree(string2);
        if (policyTree != null) {
            return policyTree.nodeExists(string);
        }
        return false;
    }

    public PolicyNode getNode(String string) throws SPIException {
        PolicyTree policyTree;
        int n = string.indexOf(SEPARATOR);
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(0, string.indexOf(SEPARATOR));
        }
        if ((policyTree = this.getTree(string2)) != null) {
            return policyTree.getNode(string);
        }
        return null;
    }

    public PolicyNode createNode(String string) throws SPIException {
        return this.createNode(string, false);
    }

    public PolicyNode createReplaceNode(String string) throws SPIException {
        return this.createNode(string, true);
    }

    public PolicyNode createNode(String string, boolean bl) throws SPIException {
        PolicyTree policyTree;
        int n = string.indexOf(SEPARATOR);
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(0, string.indexOf(SEPARATOR));
        }
        if ((policyTree = this.getTree(string2)) != null) {
            if (bl) {
                return policyTree.createReplaceNode(string);
            }
            return policyTree.createNode(string);
        }
        return null;
    }

    public void flushAllChanges() throws SPIException {
        Iterator iterator = this.m_treeCache.keySet().iterator();
        while (iterator.hasNext()) {
            PolicyTree policyTree = this.getTree((String)iterator.next());
            if (!policyTree.hasBeenModified()) continue;
            ReadWritePolicyTreeConverterImpl readWritePolicyTreeConverterImpl = new ReadWritePolicyTreeConverterImpl();
            Policy policy = readWritePolicyTreeConverterImpl.getPolicy(policyTree);
            this.getPolicyGroup().storePolicy(policy);
        }
    }

    public void resetAllChanges() {
        this.m_treeCache.clear();
    }

    public PolicyTree getTree(String string) throws SPIException {
        PolicyTree policyTree = null;
        if (this.m_treeCache.containsKey(string)) {
            policyTree = (PolicyTree)this.m_treeCache.get(string);
        } else {
            ReadWritePolicyTreeFactoryImpl readWritePolicyTreeFactoryImpl = new ReadWritePolicyTreeFactoryImpl();
            Policy policy = null;
            if (this.getPolicyGroup() != null) {
                policy = this.getPolicyGroup().getPolicy(string);
            }
            if (policy == null) {
                policy = new Policy(string, this.m_pg.getId(), null);
            }
            Vector<Policy> vector = new Vector<Policy>();
            vector.add(policy);
            policyTree = readWritePolicyTreeFactoryImpl.getPolicyTree(vector.iterator());
            this.m_treeCache.put(string, policyTree);
        }
        return policyTree;
    }

    public static String decodePath(String string) throws SPIException {
        try {
            if (string.indexOf(37) == -1) {
                return string;
            }
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SPIException((Throwable)unsupportedEncodingException);
        }
    }

    public static String encodePath(String string) throws SPIException {
        try {
            if (string.indexOf(47) != -1) {
                return URLEncoder.encode(string, "UTF-8");
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SPIException((Throwable)unsupportedEncodingException);
        }
    }
}

