/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi;

import com.sun.apoc.spi.AssignmentProvider;
import com.sun.apoc.spi.IllegalAssignmentException;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Host;
import com.sun.apoc.spi.entities.Organization;
import com.sun.apoc.spi.entities.Role;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.NullProfileException;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileComparatorProvider;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class AbstractAssignmentProvider
implements AssignmentProvider {
    protected PolicyMgr mPolicyMgr;

    public void assignProfile(Entity entity, Profile profile) throws SPIException {
        Iterator iterator = this.getAssignedProfiles(entity);
        while (iterator.hasNext()) {
            Profile profile2 = (Profile)iterator.next();
            if (!profile.equals(profile2)) continue;
            return;
        }
        if (!this.isCompatible(entity, profile)) {
            throw new IllegalAssignmentException(profile.getApplicability().getStringValue(), entity.getDisplayName());
        }
        this.assignProfileToEntity(entity, profile);
    }

    protected abstract void assignProfileToEntity(Entity var1, Profile var2) throws SPIException;

    public abstract void unassignProfile(Entity var1, Profile var2) throws SPIException;

    public Iterator getAssignedProfiles(Entity entity) throws SPIException {
        Comparator comparator = ((ProfileComparatorProvider)((Object)this.mPolicyMgr.getProfileProvider())).getProfileComparator();
        TreeSet<Profile> treeSet = new TreeSet<Profile>(comparator);
        Iterator iterator = this.getProfilesAssignedToEntity(entity);
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!this.isCompatible(entity, profile)) continue;
            treeSet.add(profile);
        }
        return treeSet.iterator();
    }

    protected abstract Iterator getProfilesAssignedToEntity(Entity var1) throws SPIException;

    public Iterator getAssignedEntities(Profile profile) throws SPIException {
        if (profile == null) {
            throw new NullProfileException();
        }
        HashSet<Entity> hashSet = new HashSet<Entity>();
        Iterator iterator = this.getEntitiesAssignedToProfile(profile);
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!this.isCompatible(entity, profile)) continue;
            hashSet.add(entity);
        }
        return hashSet.iterator();
    }

    protected abstract Iterator getEntitiesAssignedToProfile(Profile var1) throws SPIException;

    public abstract void open() throws SPIException;

    public abstract void close() throws SPIException;

    private boolean isCompatible(Entity entity, Profile profile) {
        boolean bl = false;
        if (profile != null && entity != null) {
            Applicability applicability = profile.getApplicability();
            if (applicability.equals(Applicability.ALL)) {
                bl = true;
            } else if (applicability.equals(Applicability.HOST)) {
                bl = entity instanceof Domain || entity instanceof Host;
            } else if (applicability.equals(Applicability.USER)) {
                bl = entity instanceof Organization || entity instanceof User || entity instanceof Role;
            }
        }
        return bl;
    }
}

