/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap;

import com.sun.apoc.spi.AbstractAssignmentProvider;
import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.PolicyMgrImpl;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.ldap.LdapConnectionHandler;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.environment.LdapEnvironmentMgr;
import com.sun.apoc.spi.ldap.profiles.LdapProfile;
import com.sun.apoc.spi.ldap.profiles.LdapProfileRepository;
import com.sun.apoc.spi.profiles.InvalidProfileException;
import com.sun.apoc.spi.profiles.Profile;
import java.util.Iterator;

public class LdapAssignmentProvider
extends AbstractAssignmentProvider {
    protected LdapConnectionHandler mConnection;
    protected LdapDataStore mDataStore;
    protected LdapEnvironmentMgr mEnvironmentMgr;
    protected String mURL;

    public LdapAssignmentProvider(PolicyMgr policyMgr, String string) throws SPIException {
        this.mPolicyMgr = policyMgr;
        this.mEnvironmentMgr = new LdapEnvironmentMgr(this.mPolicyMgr.getEnvironment());
        String string2 = string;
        this.mConnection = (LdapConnectionHandler)((PolicyMgrImpl)this.mPolicyMgr).getConnectionHandler(string2);
        if (this.mConnection == null) {
            this.mEnvironmentMgr.checkEnvironment();
        }
    }

    public void open() throws SPIException {
        if (this.mConnection == null && this.mEnvironmentMgr != null) {
            this.mConnection = new LdapConnectionHandler();
            this.mConnection.connect(this.mURL, this.mEnvironmentMgr.getAssignmentTimeout(), this.mEnvironmentMgr.getAssignmentAuthUser(), this.mEnvironmentMgr.getAssignmentAuthPassword(), this.mEnvironmentMgr);
            if (this.isGSSAPIAuthentication()) {
                Object object = this.mEnvironmentMgr.getAssignmentCallbackHandler();
                this.mConnection.authenticate(object);
            } else {
                this.mConnection.authenticate(this.mEnvironmentMgr.getAssignmentUser(this.mURL), this.mEnvironmentMgr.getAssignmentCredentials());
            }
            this.mConnection.closeAuthorizedContext();
            ((PolicyMgrImpl)this.mPolicyMgr).setConnectionHandler(this.mURL, this.mConnection);
        }
        this.mDataStore = this.mConnection.getDataStore();
    }

    public void close() throws SPIException {
        if (((PolicyMgrImpl)this.mPolicyMgr).getConnectionHandler(this.mURL) != null) {
            ((PolicyMgrImpl)this.mPolicyMgr).setConnectionHandler(this.mURL, null);
        }
        this.mConnection.disconnect();
    }

    protected boolean isGSSAPIAuthentication() {
        return this.mEnvironmentMgr.getAssignmentAuthType().equals("GSSAPI");
    }

    protected void assignProfileToEntity(Entity entity, Profile profile) throws SPIException {
        if (!(profile instanceof LdapProfile)) {
            throw new InvalidProfileException();
        }
        LdapProfile ldapProfile = (LdapProfile)profile;
        if (ldapProfile.isLocal()) {
            LdapProfileRepository ldapProfileRepository = (LdapProfileRepository)ldapProfile.getProfileRepository();
            ldapProfileRepository.migrateProfile(ldapProfile);
        }
        this.mDataStore.assignProfile(profile, entity);
    }

    public void unassignProfile(Entity entity, Profile profile) throws SPIException {
        if (!(profile instanceof LdapProfile)) {
            throw new InvalidProfileException();
        }
        LdapProfile ldapProfile = (LdapProfile)profile;
        if (ldapProfile.isLocal()) {
            LdapProfileRepository ldapProfileRepository = (LdapProfileRepository)ldapProfile.getProfileRepository();
            ldapProfileRepository.migrateProfile(ldapProfile);
        }
        this.mDataStore.unassignProfile(profile, entity);
    }

    protected Iterator getProfilesAssignedToEntity(Entity entity) throws SPIException {
        return this.mDataStore.getAssignedProfiles(entity);
    }

    public Iterator getEntitiesAssignedToProfile(Profile profile) throws SPIException {
        return this.mDataStore.getAssignedEntities(profile);
    }
}

