/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.AbstractEntity;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapDomain;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapHost;
import com.sun.apoc.spi.ldap.entities.LdapOrganization;
import com.sun.apoc.spi.ldap.entities.LdapRole;
import com.sun.apoc.spi.ldap.entities.LdapUser;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;

public abstract class LdapEntity
extends AbstractEntity {
    public static final String DOMAIN_TREE_INDICATOR = "1__";
    public static final boolean CHECK_ONLY = true;
    public static final boolean NOT_CHECK_ONLY = false;
    public static final boolean DN_REQUIRED = true;
    public static final boolean DN_NOT_REQUIRED = false;
    public static final String LDAP_SEPARATOR = ",";
    public static final char DN_SEPARATOR = '=';
    LdapDataStore mDataStore;
    LdapClientContext mContext;
    LdapEntityMapping mEntityMapping;
    String mLocation;
    int mParentIndex;
    boolean mIsDomainTree;

    protected LdapEntity(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        this.mId = string;
        this.mDataStore = ldapDataStore;
        this.mContext = ldapClientContext;
        this.mEntityMapping = ldapEntityMapping;
        this.mParentIndex = n;
        this.mLocation = string;
    }

    public LdapDataStore getDataStore() {
        return this.mDataStore;
    }

    public LdapClientContext getContext() {
        return this.mContext;
    }

    public void setContext(LdapClientContext ldapClientContext) {
        this.mContext = ldapClientContext;
    }

    public abstract boolean equals(Object var1);

    public String getLocation() {
        return this.mLocation;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null) {
            try {
                if (this.equals(this.mPolicyMgr.getRootOrganization()) || this.equals(this.mPolicyMgr.getRootDomain())) {
                    this.mDisplayName = this.mLocation;
                }
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
            if (this.mDisplayName == null) {
                this.mDisplayName = this.getDisplayNameFromLocation();
            }
        }
        return this.mDisplayName;
    }

    public Iterator getAncestorNames() {
        String string = this.mEntityMapping.mUserMapping.getContainerEntry();
        String string2 = this.mEntityMapping.mHostMapping.getContainerEntry();
        String[] stringArray = null;
        String string3 = null;
        try {
            string3 = this.mPolicyMgr.getRootOrganization().getId();
            stringArray = LDAPDN.explodeDN((String)string3, (boolean)false);
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        String[] stringArray2 = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (stringArray2 != null) {
            int n = stringArray2.length - 1;
            if (stringArray != null) {
                n = stringArray2.length - stringArray.length - 1;
                if (stringArray2.length > stringArray.length) {
                    linkedList.add(LDAPDN.unEscapeRDN((String)string3));
                }
            }
            for (int i = n; i > 0; --i) {
                int n2;
                String string4 = stringArray2[i];
                if (string4.equals(string) || string4.equals(string2) || (n2 = string4.indexOf(61)) < 0) continue;
                linkedList.add(LDAPDN.unEscapeRDN((String)string4.substring(n2 + 1)));
            }
        }
        return linkedList.iterator();
    }

    public abstract Entity getParent();

    private String getDisplayNameFromLocation() {
        String string = null;
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)true);
        if (stringArray != null && stringArray.length > 0) {
            string = LDAPDN.unEscapeRDN((String)stringArray[0]);
        }
        return string;
    }

    public boolean isDomainTree() {
        return this.mIsDomainTree;
    }

    protected void setIsDomainTree() {
        this.mIsDomainTree = true;
    }

    public Entity getEntityFromDN(String string, LdapEntityType ldapEntityType, boolean bl, Hashtable hashtable) {
        int n;
        Object object;
        if (string == null) {
            return null;
        }
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
        if (stringArray == null) {
            return null;
        }
        int n2 = 0;
        if (bl) {
            n2 = 6;
        }
        if (n2 >= stringArray.length) {
            return null;
        }
        String string2 = string;
        if (bl) {
            object = new StringBuffer(stringArray[n2]);
            for (n = n2 + 1; n < stringArray.length; ++n) {
                ((StringBuffer)object).append(LDAP_SEPARATOR).append(stringArray[n]);
            }
            string2 = ((StringBuffer)object).toString();
        }
        if (this.isDomainTree()) {
            if (((LdapEntity)((Object)this.getDataStore().getRootDomain())).getLocation().equalsIgnoreCase(string2)) {
                return this.getDataStore().getRootDomain();
            }
        } else if (((LdapEntity)((Object)this.getDataStore().getRootOrganization())).getLocation().equalsIgnoreCase(string2)) {
            return this.getDataStore().getRootOrganization();
        }
        if (hashtable == null) {
            object = new String[3 + this.mEntityMapping.mUserMapping.getDisplayAttributes().length];
            object[0] = "objectclass";
            object[1] = this.mEntityMapping.mUserMapping.getUniqueAttribute();
            object[2] = this.mEntityMapping.mHostMapping.getUniqueAttribute();
            n = 3;
            for (int i = 0; i < this.mEntityMapping.mUserMapping.getDisplayAttributes().length; ++i) {
                object[n++] = this.mEntityMapping.mUserMapping.getDisplayAttributes()[i];
            }
            try {
                hashtable = this.getDataStore().getAttributeValueTable(string2, true, (String[])object, this.getContext());
            }
            catch (LDAPException lDAPException) {
                return null;
            }
            if (hashtable == null) {
                return null;
            }
            Vector vector = (Vector)hashtable.get("DN");
            if (vector == null || vector.isEmpty()) {
                return null;
            }
            string2 = (String)vector.get(0);
        }
        if (ldapEntityType == LdapEntityType.UNKNOWN && (ldapEntityType = this.detectEntityType(stringArray[n2], hashtable)) == LdapEntityType.UNKNOWN) {
            return null;
        }
        object = null;
        n = 1;
        int n3 = ldapEntityType.getIntValue();
        switch (n3) {
            case 6: {
                object = this.mEntityMapping.mUserMapping.getContainerEntry();
                break;
            }
            case 7: {
                object = this.mEntityMapping.mHostMapping.getContainerEntry();
                break;
            }
            case 5: {
                object = this.mEntityMapping.mRoleMapping.getContainerEntry();
                n = -1;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (object != null && ((String)object).length() == 0) {
            object = null;
        }
        if (n == -1) {
            n = LdapEntity.findContainer(stringArray, n2, (String)object);
            if (n == -1) {
                return null;
            }
            n -= n2;
        }
        LdapEntity ldapEntity = null;
        Object var12_15 = null;
        switch (n3) {
            case 3: {
                ldapEntity = new LdapOrganization(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                break;
            }
            case 4: {
                ldapEntity = new LdapDomain(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                break;
            }
            case 5: {
                ldapEntity = new LdapRole(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                if (!this.isDomainTree()) break;
                ((LdapRole)ldapEntity).setIsDomainTree();
                break;
            }
            case 6: {
                ldapEntity = new LdapUser(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
                ((LdapUser)ldapEntity).setDisplayName(hashtable, this.mEntityMapping.mUserMapping.getDisplayAttributes(), this.mEntityMapping.mUserMapping.getDisplayFormat());
                break;
            }
            case 7: {
                ldapEntity = new LdapHost(string2, n + 1, this.getDataStore(), this.mEntityMapping, this.getContext());
            }
        }
        if (ldapEntity != null) {
            ((AbstractEntity)ldapEntity).setPolicyMgr(this.mPolicyMgr);
        }
        return ldapEntity;
    }

    public LdapEntityType detectEntityType(String string, Hashtable hashtable) {
        String[] stringArray;
        LdapEntityType ldapEntityType = LdapEntityType.UNKNOWN;
        Vector vector = (Vector)hashtable.get("objectclass");
        if (vector == null || vector.isEmpty()) {
            return ldapEntityType;
        }
        Enumeration enumeration = vector.elements();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        int n = arrayList.size();
        block1: for (int i = 0; i < n && ldapEntityType == LdapEntityType.UNKNOWN; ++i) {
            int n2;
            String string2 = (String)arrayList.get(i);
            if (string2.equalsIgnoreCase(this.mEntityMapping.mUserMapping.getObjectClass())) {
                ldapEntityType = LdapEntityType.USERID;
                break;
            }
            if (string2.equalsIgnoreCase(this.mEntityMapping.mHostMapping.getObjectClass())) {
                ldapEntityType = LdapEntityType.HOST;
                break;
            }
            stringArray = this.mEntityMapping.mOrganizationMapping.getObjectClasses();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string2.equalsIgnoreCase(stringArray[j])) continue;
                ldapEntityType = LdapEntityType.ORG;
                break;
            }
            if (ldapEntityType == LdapEntityType.UNKNOWN) {
                String[] stringArray2 = this.mEntityMapping.mRoleMapping.getObjectClasses();
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (!string2.equalsIgnoreCase(stringArray2[n2])) continue;
                    ldapEntityType = LdapEntityType.ROLE;
                    break;
                }
            }
            if (ldapEntityType != LdapEntityType.UNKNOWN) continue;
            String[] stringArray3 = this.mEntityMapping.mDomainMapping.getObjectClasses();
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                if (!string2.equalsIgnoreCase(stringArray3[n2])) continue;
                ldapEntityType = LdapEntityType.DOMAIN;
                continue block1;
            }
        }
        if (ldapEntityType == LdapEntityType.USERID) {
            for (int i = 0; i < n; ++i) {
                stringArray = (String[])arrayList.get(i);
                if (!stringArray.equalsIgnoreCase(this.mEntityMapping.mHostMapping.getObjectClass())) continue;
                ldapEntityType = LdapEntityType.HOST;
                break;
            }
        }
        return ldapEntityType;
    }

    private static int findContainer(String[] stringArray, int n, String string) {
        String string2 = stringArray[n].substring(0, stringArray[n].indexOf("="));
        for (int i = n + 1; i < stringArray.length; ++i) {
            if (string != null) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return i;
            }
            if (stringArray[i].startsWith(string2)) continue;
            return i - 1;
        }
        return -1;
    }

    public abstract Iterator getLayeredProfiles() throws SPIException;
}

