/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.InvalidFilterException;
import com.sun.apoc.spi.entities.Node;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.util.BooleanReturnValue;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class LdapNode
extends LdapEntity
implements Node {
    public static final String MODULE = "LdapNode";
    public static final String SEARCH_FILTER_DELIMITER = "(";
    private static final String SKIPPABLES = "()|&! \t";

    public LdapNode(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        super(string, n, ldapDataStore, ldapEntityMapping, ldapClientContext);
    }

    public Vector getChildrenList(String string, LdapEntityType ldapEntityType, String string2, boolean bl, BooleanReturnValue booleanReturnValue) throws SPIException {
        int n;
        Vector vector;
        block12: {
            vector = null;
            String[] stringArray = null;
            switch (ldapEntityType.getIntValue()) {
                case 6: {
                    stringArray = new String[2 + this.mEntityMapping.mUserMapping.getDisplayAttributes().length];
                    stringArray[0] = "objectclass";
                    stringArray[1] = this.mEntityMapping.mUserMapping.getUniqueAttribute();
                    int n2 = 2;
                    for (n = 0; n < this.mEntityMapping.mUserMapping.getDisplayAttributes().length; ++n) {
                        stringArray[n2++] = this.mEntityMapping.mUserMapping.getDisplayAttributes()[n];
                    }
                    break;
                }
                case 7: {
                    stringArray = new String[]{"ObjectClass", this.mEntityMapping.mHostMapping.getUniqueAttribute()};
                    break;
                }
                default: {
                    stringArray = new String[]{"ObjectClass"};
                }
            }
            try {
                vector = this.getDataStore().getListOfChildren(this, string2, string, false, stringArray, bl, this.getContext(), booleanReturnValue);
            }
            catch (SPIException sPIException) {
                n = LdapDataStore.getLdapErrorCode(sPIException);
                if (n == 94 || n == 16 || n == 32) break block12;
                throw sPIException;
            }
        }
        if (bl) {
            return vector;
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        if (vector != null && !vector.isEmpty()) {
            n = vector.size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    String string3;
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector3 = (Vector)hashtable.get("DN");
                    if (vector3 == null || vector3.isEmpty() || (entity = this.getEntityFromDN(string3 = (String)vector3.get(0), ldapEntityType, false, hashtable)) == null) continue;
                    vector2.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector2 == null ? new Vector<Entity>() : vector2;
    }

    public Iterator findEntities(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith(SEARCH_FILTER_DELIMITER)) {
            return this.findEntitiesByFilter(string, bl);
        }
        return this.findEntitiesByName(string, bl);
    }

    public Entity[] findEntitiesArray(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith(SEARCH_FILTER_DELIMITER)) {
            return this.findEntitiesByFilterArray(string, bl);
        }
        return this.findEntitiesByNameArray(string, bl);
    }

    public Iterator findEntitiesByName(String string, boolean bl) throws SPIException {
        Vector vector = this.findEntitiesByNameList(string, bl);
        return vector.iterator();
    }

    public Entity[] findEntitiesByNameArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findEntitiesByNameList(string, bl);
        int n = vector.size();
        Entity[] entityArray = new Entity[n];
        for (int i = 0; i < n; ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Vector findRolesByNameList(String string, boolean bl) throws SPIException {
        Vector vector = this.searchForRoles(this.buildNameFilter(string, "=", this.mEntityMapping.mRoleMapping, bl), bl);
        return vector;
    }

    public Vector findRolesByFilterList(String string, boolean bl) throws SPIException {
        Vector vector = this.searchForRoles(this.mapFilter(string, this.mEntityMapping.mRoleMapping, bl), bl);
        return vector;
    }

    public Iterator findEntitiesByFilter(String string, boolean bl) throws SPIException {
        Vector vector = this.findEntitiesByFilterList(string, bl);
        return vector.iterator();
    }

    public Entity[] findEntitiesByFilterArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findEntitiesByFilterList(string, bl);
        int n = vector.size();
        Entity[] entityArray = new Entity[n];
        for (int i = 0; i < n; ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public abstract Vector findEntitiesByNameList(String var1, boolean var2) throws SPIException;

    public abstract Vector findEntitiesByFilterList(String var1, boolean var2) throws SPIException;

    public Iterator findRoles(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith(SEARCH_FILTER_DELIMITER)) {
            return this.findRolesByFilter(string, bl);
        }
        return this.findRolesByName(string, bl);
    }

    public Entity[] findRolesArray(String string, boolean bl) throws SPIException {
        if (string == null) {
            throw new InvalidFilterException();
        }
        if (string.startsWith(SEARCH_FILTER_DELIMITER)) {
            return this.findRolesByFilterArray(string, bl);
        }
        return this.findRolesByNameArray(string, bl);
    }

    public Iterator findRolesByFilter(String string, boolean bl) throws SPIException {
        Vector vector = this.findRolesByFilterList(string, bl);
        return vector.iterator();
    }

    public Entity[] findRolesByFilterArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findRolesByFilterList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Iterator findRolesByName(String string, boolean bl) throws SPIException {
        Vector vector = this.findRolesByNameList(string, bl);
        return vector.iterator();
    }

    public Entity[] findRolesByNameArray(String string, boolean bl) throws SPIException {
        Vector vector = this.findRolesByNameList(string, bl);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Entity getEntity(String string) throws SPIException {
        return this.getEntityFromDN(string, LdapEntityType.UNKNOWN, false, null);
    }

    public abstract Iterator getChildren() throws SPIException;

    public abstract Entity[] getChildrenArray() throws SPIException;

    public Iterator getLeaves() throws SPIException {
        return null;
    }

    public boolean hasLeaves() throws SPIException {
        return false;
    }

    public Iterator getNodes() throws SPIException {
        return null;
    }

    public boolean hasNodes() throws SPIException {
        return false;
    }

    public String buildClassFilter(LdapEntityMapping.ContainerMapping containerMapping, boolean bl) throws SPIException {
        StringBuffer stringBuffer = this.buildClassFilterString(containerMapping.getObjectClasses(), bl);
        if (containerMapping instanceof LdapEntityMapping.ListMapping) {
            this.addRoleFilterPlus(bl, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String buildClassFilter(LdapEntityMapping.UserMapping userMapping, boolean bl) throws SPIException {
        String[] stringArray = new String[]{userMapping.getObjectClass()};
        StringBuffer stringBuffer = this.buildClassFilterString(stringArray, bl);
        stringBuffer.insert(0, "(&(!(objectclass=" + this.mEntityMapping.mHostMapping.getObjectClass() + "))");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String buildClassFilter(LdapEntityMapping.ItemMapping itemMapping, boolean bl) throws SPIException {
        String[] stringArray = new String[]{itemMapping.getObjectClass()};
        StringBuffer stringBuffer = this.buildClassFilterString(stringArray, bl);
        return stringBuffer.toString();
    }

    private StringBuffer buildClassFilterString(String[] stringArray, boolean bl) throws SPIException {
        int n;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            vector.add("(objectclass=" + stringArray[n] + ")");
            if (!stringArray[n].equalsIgnoreCase("organizationalunit")) continue;
            bl2 = true;
        }
        if (vector.size() > 1) {
            stringBuffer.append("(|");
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.get(i));
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(vector.get(0));
        }
        if (bl2) {
            this.excludeServiceEntriesFromSearchFilter(bl, stringBuffer);
        }
        return stringBuffer;
    }

    public String mapFilter(String string, LdapEntityMapping.ContainerMapping containerMapping, boolean bl) throws SPIException {
        String string2 = this.buildClassFilter(containerMapping, bl);
        if (string == null || string.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(string2);
        stringBuffer.append(this.buildMappedFilter(string, containerMapping));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String buildMappedFilter(String string, LdapEntityMapping.ContainerMapping containerMapping) throws SPIException {
        int n;
        String[] stringArray;
        int n2 = 0;
        boolean bl = false;
        if (string.charAt(0) == '(') {
            n2 = 1;
            bl = true;
        }
        ParsedAttribute parsedAttribute = new ParsedAttribute();
        int n3 = this.parseNextAttribute(string, n2, parsedAttribute);
        StringBuffer stringBuffer = new StringBuffer(200);
        Vector<String> vector = new Vector<String>();
        while (n3 != -1) {
            stringBuffer.delete(0, stringBuffer.length());
            stringArray = containerMapping.getNamingAttributes();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(SEARCH_FILTER_DELIMITER);
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(parsedAttribute.mOperator).append(parsedAttribute.mValue);
                stringBuffer.append(")");
            }
            vector.add(stringBuffer.toString());
            n2 = parsedAttribute.mLastChar;
            n3 = this.parseNextAttribute(string, n2, parsedAttribute);
        }
        stringArray = new StringBuffer(200);
        if (vector.size() > 1) {
            stringArray.append("(&");
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                stringArray.append(vector.get(i));
            }
            stringArray.append(")");
        } else {
            stringArray.append(vector.get(0));
        }
        return stringArray.toString();
    }

    public String buildNameFilter(String string, String string2, LdapEntityMapping.ContainerMapping containerMapping, boolean bl) throws SPIException {
        StringBuffer stringBuffer = this.buildNameFilterString(string, string2, containerMapping.getObjectClasses(), containerMapping.getNamingAttributes(), bl);
        return stringBuffer.toString();
    }

    public String buildNameFilter(String string, String string2, LdapEntityMapping.ListMapping listMapping, boolean bl) throws SPIException {
        StringBuffer stringBuffer = this.buildNameFilterString(string, string2, listMapping.getObjectClasses(), listMapping.getNamingAttributes(), bl);
        this.addRoleFilterPlus(bl, stringBuffer);
        return stringBuffer.toString();
    }

    private StringBuffer buildNameFilterString(String string, String string2, String[] stringArray, String[] stringArray2, boolean bl) throws SPIException {
        Vector vector = new Vector();
        boolean bl2 = this.addNameFilters(stringArray, stringArray2, string2, string, vector);
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.size() > 1) {
            stringBuffer.append("(|");
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.get(i));
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(vector.get(0));
        }
        if (bl2) {
            this.excludeServiceEntriesFromSearchFilter(bl, stringBuffer);
        }
        return stringBuffer;
    }

    public String buildNameFilter(String string, String string2, LdapEntityMapping.ItemMapping itemMapping, boolean bl) throws SPIException {
        Vector vector = new Vector();
        this.addNameFilter(itemMapping.getObjectClass(), itemMapping.getUniqueAttribute(), string2, string, vector);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(vector.get(0));
        if (itemMapping instanceof LdapEntityMapping.UserMapping) {
            stringBuffer.insert(0, "(&(!(objectclass=" + this.mEntityMapping.mHostMapping.getObjectClass() + "))");
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean addNameFilters(String[] stringArray, String[] stringArray2, String string, String string2, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNameFilter(stringArray[i], stringArray2[i], string, string2, vector);
            if (!stringArray[i].equalsIgnoreCase("organizationalunit")) continue;
            bl = true;
        }
        return bl;
    }

    public void addNameFilter(String string, String string2, String string3, String string4, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("(&(");
        stringBuffer.append("objectclass").append("=");
        stringBuffer.append(string).append(")(");
        stringBuffer.append(string2).append(string3);
        if (string4 == null) {
            stringBuffer.append("*");
        } else {
            stringBuffer.append(string4);
        }
        stringBuffer.append("))");
        vector.add(stringBuffer.toString());
    }

    public String buildMappedFilter(String string, LdapEntityMapping.UserMapping userMapping) throws SPIException {
        int n = 0;
        boolean bl = false;
        if (string.charAt(0) == '(') {
            n = 1;
            bl = true;
        }
        ParsedAttribute parsedAttribute = new ParsedAttribute();
        int n2 = this.parseNextAttribute(string, n, parsedAttribute);
        StringBuffer stringBuffer = new StringBuffer(200);
        Vector<String> vector = new Vector<String>();
        while (n2 != -1) {
            stringBuffer.delete(0, stringBuffer.length());
            if (parsedAttribute.mAttribute == null || parsedAttribute.mAttribute.length() == 0) {
                parsedAttribute.mAttribute = userMapping.getUniqueAttribute();
            } else {
                if (!parsedAttribute.mAttribute.equalsIgnoreCase("cn")) {
                    parsedAttribute.mAttribute = userMapping.getUserProfileAttribute(parsedAttribute.mAttribute);
                }
                if (parsedAttribute.mAttribute == null) {
                    throw new InvalidFilterException(string);
                }
            }
            stringBuffer.append(SEARCH_FILTER_DELIMITER).append(parsedAttribute.mAttribute).append(parsedAttribute.mOperator).append(parsedAttribute.mValue).append(")");
            vector.add(stringBuffer.toString());
            n = parsedAttribute.mLastChar;
            n2 = this.parseNextAttribute(string, n, parsedAttribute);
        }
        StringBuffer stringBuffer2 = new StringBuffer(200);
        if (vector.size() > 1) {
            stringBuffer2.append("(&");
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                stringBuffer2.append(vector.get(i));
            }
            stringBuffer2.append(")");
        } else {
            stringBuffer2.append(vector.get(0));
        }
        return stringBuffer2.toString();
    }

    public String buildMappedFilter(String string, LdapEntityMapping.ItemMapping itemMapping) throws SPIException {
        int n = 0;
        boolean bl = false;
        if (string.charAt(0) == '(') {
            n = 1;
            bl = true;
        }
        ParsedAttribute parsedAttribute = new ParsedAttribute();
        int n2 = this.parseNextAttribute(string, n, parsedAttribute);
        StringBuffer stringBuffer = new StringBuffer(200);
        Vector<String> vector = new Vector<String>();
        while (n2 != -1) {
            stringBuffer.delete(0, stringBuffer.length());
            if (parsedAttribute.mAttribute == null || parsedAttribute.mAttribute.length() == 0) {
                parsedAttribute.mAttribute = itemMapping.getUniqueAttribute();
            }
            stringBuffer.append(SEARCH_FILTER_DELIMITER).append(parsedAttribute.mAttribute).append(parsedAttribute.mOperator).append(parsedAttribute.mValue).append(")");
            vector.add(stringBuffer.toString());
            n = parsedAttribute.mLastChar;
            n2 = this.parseNextAttribute(string, n, parsedAttribute);
        }
        StringBuffer stringBuffer2 = new StringBuffer(200);
        if (vector.size() > 1) {
            stringBuffer2.append("(&");
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                stringBuffer2.append(vector.get(i));
            }
            stringBuffer2.append(")");
        } else {
            stringBuffer2.append(vector.get(0));
        }
        return stringBuffer2.toString();
    }

    public String mapFilter(String string, LdapEntityMapping.UserMapping userMapping, boolean bl) throws SPIException {
        String string2 = this.buildClassFilter(userMapping, bl);
        if (string == null || string.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(string2);
        stringBuffer.append(this.buildMappedFilter(string, userMapping));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String mapFilter(String string, LdapEntityMapping.ItemMapping itemMapping, boolean bl) throws SPIException {
        String string2 = this.buildClassFilter(itemMapping, bl);
        if (string == null || string.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&").append(string2);
        stringBuffer.append(this.buildMappedFilter(string, itemMapping));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void addRoleFilterPlus(boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return;
        }
        stringBuffer.insert(0, "(&");
        stringBuffer.insert(2, "(objectclass=ldapsubentry)");
        stringBuffer.append(")");
    }

    public void excludeServiceEntriesFromSearchFilter(boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("(&");
        stringBuffer2.append("(&(!(");
        stringBuffer2.append("ou=services");
        stringBuffer2.append("))");
        if (bl) {
            stringBuffer2.append("(!(");
            stringBuffer2.append("ou=OrganizationConfig");
            stringBuffer2.append("))");
            stringBuffer2.append("(!(");
            stringBuffer2.append("objectclass=sunservicecomponent");
            stringBuffer2.append("))");
        }
        stringBuffer2.append(")");
        stringBuffer.insert(0, stringBuffer2.toString());
        stringBuffer.append(")");
    }

    public int parseNextAttribute(String string, int n, ParsedAttribute parsedAttribute) throws SPIException {
        int n2;
        parsedAttribute.mAttribute = null;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && SKIPPABLES.indexOf(string.charAt(n2)) != -1; ++n2) {
        }
        if (n2 >= n3) {
            return -1;
        }
        int n4 = string.indexOf(")", n2);
        int n5 = string.indexOf(61, n2);
        if (n5 != -1 && (n4 == -1 || n5 < n4)) {
            char c = string.charAt(n5 - 1);
            if (c == '<' || c == '>' || c == '~') {
                parsedAttribute.mAttribute = string.substring(n2, n5 - 1);
                parsedAttribute.mOperator = string.substring(n5 - 1, n5 + 1);
            } else {
                if (n2 < n5) {
                    parsedAttribute.mAttribute = string.substring(n2, n5);
                }
                parsedAttribute.mOperator = "=";
            }
            parsedAttribute.mLastChar = n5 + 1;
        } else {
            parsedAttribute.mLastChar = n2;
        }
        while (parsedAttribute.mLastChar < n3 && (string.charAt(parsedAttribute.mLastChar) != ')' || string.charAt(parsedAttribute.mLastChar - 1) == '\\')) {
            ++parsedAttribute.mLastChar;
        }
        parsedAttribute.mValue = n5 != -1 && (n4 == -1 || n5 < n4) ? string.substring(n5 + 1, parsedAttribute.mLastChar) : string.substring(n2, parsedAttribute.mLastChar);
        if (parsedAttribute.mAttribute != null) {
            parsedAttribute.mAttribute = parsedAttribute.mAttribute.trim().toLowerCase();
        }
        parsedAttribute.mValue = parsedAttribute.mValue.trim();
        return n2;
    }

    public boolean hasRoles() throws SPIException {
        return false;
    }

    public Iterator getRoles() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mRoleMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.ROLE, this.mEntityMapping.mRoleMapping.getContainerEntry(), false, booleanReturnValue);
        return vector.iterator();
    }

    public Entity[] getRolesArray() throws SPIException {
        BooleanReturnValue booleanReturnValue = new BooleanReturnValue(false);
        String string = this.buildClassFilter(this.mEntityMapping.mRoleMapping, false);
        Vector vector = this.getChildrenList(string, LdapEntityType.ROLE, this.mEntityMapping.mRoleMapping.getContainerEntry(), false, booleanReturnValue);
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    public Vector searchForRoles(String string, boolean bl) throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (this.mEntityMapping.mRoleMapping.getContainerEntry() != null) {
            stringBuffer.append(this.mEntityMapping.mRoleMapping.getContainerEntry());
            stringBuffer.append(",");
        }
        stringBuffer.append(this.mLocation);
        String[] stringArray = new String[]{"objectclass"};
        Vector vector = null;
        try {
            vector = this.getDataStore().performSearch(stringBuffer.toString(), bl, string, stringArray, true, false, null, false, this.getContext());
        }
        catch (IllegalReadException illegalReadException) {
            if (LdapDataStore.getLdapErrorCode(illegalReadException) == 32) {
                return new Vector();
            }
            throw illegalReadException;
        }
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n = vector.size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    Hashtable hashtable = (Hashtable)vector.get(i);
                    Vector vector3 = (Vector)hashtable.get("DN");
                    if (vector3 != null && !vector3.isEmpty()) {
                        entity = this.getEntityFromDN((String)vector3.get(0), LdapEntityType.ROLE, false, hashtable);
                    }
                    if (entity == null) continue;
                    vector2.add(entity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return vector2 == null ? new Vector<Entity>() : vector2;
    }

    public Iterator getLayeredProfiles() throws SPIException {
        Iterator iterator = this.getAllParents();
        return this.getLayeredProfiles(iterator, null);
    }

    public static class ParsedAttribute {
        public String mAttribute;
        public String mOperator = "=";
        public String mValue;
        public int mLastChar;
    }
}

