/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.entities;

import com.sun.apoc.spi.IllegalReadException;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.entities.LdapEntityType;
import com.sun.apoc.spi.ldap.entities.LdapOrganization;
import com.sun.apoc.spi.ldap.entities.mapping.LdapEntityMapping;
import com.sun.apoc.spi.ldap.profiles.LdapUserProfile;
import com.sun.apoc.spi.profiles.Profile;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPException;

public class LdapUser
extends LdapEntity
implements User {
    private static final String USER_ID_KEY = "uid";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private LdapOrganization mParent;

    public LdapUser(String string, int n, LdapDataStore ldapDataStore, LdapEntityMapping ldapEntityMapping, LdapClientContext ldapClientContext) {
        super(string, n, ldapDataStore, ldapEntityMapping, ldapClientContext);
    }

    public String getUserId() {
        String string = this.mEntityMapping.mUserMapping.getUniqueAttribute();
        if (string == null || string.equals("")) {
            string = USER_ID_KEY;
        }
        string = string + KEY_VALUE_SEPARATOR;
        String string2 = new String("");
        String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)true);
        if (stringArray != null && stringArray.length > 0) {
            string2 = LDAPDN.unEscapeRDN((String)stringArray[0]);
        }
        return string2;
    }

    public boolean equals(Object object) {
        if (object instanceof LdapUser) {
            return LDAPDN.equals((String)this.mLocation.toLowerCase(), (String)((LdapUser)object).mLocation.toLowerCase());
        }
        return false;
    }

    public void setDisplayName(Hashtable hashtable, String[] stringArray, String string) {
        if (hashtable == null || stringArray == null || string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Vector vector = (Vector)hashtable.get(stringArray[i]);
            String string2 = null;
            if (vector != null && !vector.isEmpty()) {
                string2 = (String)vector.get(0);
            }
            if (string2 == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
            bl = true;
        }
        if (stringBuffer.length() > 0) {
            this.mDisplayName = stringBuffer.toString();
        }
    }

    public Entity getParent() {
        if (this.mParent == null) {
            String[] stringArray = LDAPDN.explodeDN((String)this.mLocation, (boolean)false);
            if (stringArray == null || this.mParentIndex >= stringArray.length) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(stringArray[this.mParentIndex]);
            for (int i = this.mParentIndex + 1; i < stringArray.length; ++i) {
                stringBuffer.append(",").append(stringArray[i]);
            }
            this.mParent = new LdapOrganization(stringBuffer.toString(), 1, this.getDataStore(), this.mEntityMapping, this.getContext());
            this.mParent.setPolicyMgr(this.mPolicyMgr);
        }
        return this.mParent;
    }

    public Iterator getMemberships() throws SPIException {
        return this.getListOfRoles().iterator();
    }

    public Entity[] getMembershipsArray() throws SPIException {
        Vector vector = this.getListOfRoles();
        Entity[] entityArray = new Entity[vector.size()];
        for (int i = 0; i < entityArray.length; ++i) {
            entityArray[i] = (Entity)vector.get(i);
        }
        return entityArray;
    }

    private Vector getListOfRoles() throws SPIException {
        Vector vector = this.getDataStore().getListedRolesForEntity(this, this.mEntityMapping.mRoleMapping.getListingAttribute(), this.getContext());
        Vector<Entity> vector2 = new Vector<Entity>();
        if (!vector.isEmpty()) {
            int n = vector.size();
            Entity entity = null;
            for (int i = 0; i < n; ++i) {
                try {
                    String string = this.getDataStore().readEntryDN((String)vector.get(i), this.getContext());
                    entity = this.getEntityFromDN((String)vector.get(i), LdapEntityType.ROLE, false, null);
                    if (entity == null) continue;
                    vector2.add(entity);
                    continue;
                }
                catch (SPIException sPIException) {
                    // empty catch block
                }
            }
        }
        return vector2;
    }

    public Iterator getLayeredProfiles() throws SPIException {
        Iterator iterator = this.getAllParents();
        Iterator iterator2 = this.getMemberships();
        return this.getLayeredProfiles(iterator, iterator2);
    }

    public Profile getUserProfile() throws SPIException {
        int n;
        String[] stringArray;
        LdapUserProfile ldapUserProfile = null;
        Hashtable hashtable = this.mEntityMapping.mUserMapping.getUserProfileAttributes();
        Iterator iterator = hashtable.values().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
        }
        stringArray = new String[hashSet.size()];
        n = 0;
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            stringArray[n] = (String)iterator2.next();
            ++n;
        }
        Hashtable hashtable2 = null;
        try {
            hashtable2 = this.getDataStore().getAttributeValueTable(this.getId(), false, stringArray, this.getContext());
        }
        catch (LDAPException lDAPException) {
            throw new IllegalReadException("error.spi.access.illegal.read.ldap", lDAPException);
        }
        if (hashtable2 != null) {
            ldapUserProfile = new LdapUserProfile(this, hashtable, hashtable2);
        }
        return ldapUserProfile;
    }
}

