/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.environment;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.environment.ConfigurationProvider;
import com.sun.apoc.spi.environment.RemoteEnvironmentException;
import com.sun.apoc.spi.ldap.LdapClientContext;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import netscape.ldap.LDAPException;

public class LdapConfigurationProvider
implements ConfigurationProvider {
    private static Map mContentMap = null;
    private String mUrl = null;
    private LdapClientContext mContext = null;
    private LdapDataStore mDataStore = null;
    private String[] mAttributesToGet = null;

    public LdapConfigurationProvider(String string, LdapClientContext ldapClientContext, LdapDataStore ldapDataStore, String[] stringArray) {
        if (mContentMap == null) {
            mContentMap = new HashMap();
        }
        this.mUrl = string;
        this.mContext = ldapClientContext;
        this.mDataStore = ldapDataStore;
        this.mAttributesToGet = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable loadData() throws SPIException {
        Properties properties = null;
        Object object = mContentMap;
        synchronized (object) {
            properties = (Properties)mContentMap.get(this.mUrl);
        }
        if (properties == null) {
            object = null;
            String[] stringArray = new String[]{"sunkeyvalue"};
            try {
                object = this.mDataStore.getAttributeValueList(this.mDataStore.getRootServiceEntryDN(), stringArray, this.mContext);
            }
            catch (LDAPException lDAPException) {
                throw new RemoteEnvironmentException("error.spi.environment.remote.ldap", new String[]{this.mContext.getConnectionURL()}, lDAPException);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.mAttributesToGet.length; ++i) {
                stringBuffer.append(this.loadAttributeData(this.mAttributesToGet[i], (Vector)object));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            properties = new Properties();
            try {
                properties.load(byteArrayInputStream);
            }
            catch (IOException iOException) {
                throw new RemoteEnvironmentException("error.spi.environment.remote.ldap", new String[]{this.mContext.getConnectionURL()}, iOException);
            }
            Map map = mContentMap;
            synchronized (map) {
                mContentMap.put(this.mUrl, properties);
            }
        }
        return properties;
    }

    private StringBuffer loadAttributeData(String string, Vector vector) throws RemoteEnvironmentException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = LdapDataStore.getValuesForKey(vector, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (stringBuffer == null) {
                throw new RemoteEnvironmentException("error.spi.environment.remote.ldap.invalid", new String[]{this.mContext.getConnectionURL()});
            }
            stringBuffer.append(string2).append("\n");
        }
        return stringBuffer;
    }
}

