/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.profiles;

import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Domain;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.entities.Host;
import com.sun.apoc.spi.ldap.datastore.LdapDataStore;
import com.sun.apoc.spi.ldap.entities.LdapEntity;
import com.sun.apoc.spi.ldap.profiles.LdapProfile;
import com.sun.apoc.spi.ldap.profiles.LdapProfileProvider;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileImpl;
import com.sun.apoc.spi.profiles.ProfileRepositoryImpl;
import java.util.Iterator;
import java.util.TreeSet;

public class LdapProfileRepository
extends ProfileRepositoryImpl {
    public static final String GLOBAL_PROFILE_CONTAINER = "_GlobalPolicyGroups_";
    public static final String DEFAULT_USER_PROFILE_NAME = "_DefaultUserPolicyGroup_";
    public static final String DEFAULT_USER_PROFILE_DN = "_defaultuserpolicygroup_";
    public static final String DEFAULT_HOST_PROFILE_NAME = "_DefaultHostPolicyGroup_";
    public static final String DEFAULT_HOST_PROFILE_DN = "_defaulthostpolicygroup_";
    protected Entity mRepositoryEntity;
    private String mLocation;

    public LdapProfileRepository(String string, PolicyMgr policyMgr) throws SPIException {
        this.mPolicyMgr = policyMgr;
        this.mEntityId = string;
        this.setId();
        this.mLocation = this.mId;
    }

    public Profile findProfile(String string) throws SPIException {
        return this.getDataStore().findProfile(this, string);
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setId() throws SPIException {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("ou=");
        stringBuffer.append(GLOBAL_PROFILE_CONTAINER);
        stringBuffer.append(",");
        for (int i = 0; i < 6; ++i) {
            stringBuffer.append(LdapDataStore.SERVICE_MAPPING_ELEMENTS[i].getRDN());
            stringBuffer.append(",");
        }
        stringBuffer.append(((LdapEntity)this.getEntity()).getLocation());
        this.mId = stringBuffer.toString();
    }

    protected Profile createTheProfile(String string, Applicability applicability, int n) throws SPIException {
        return this.getDataStore().createProfile(this, string, applicability, n);
    }

    public void deleteProfile(Profile profile) throws SPIException {
        this.getDataStore().destroyProfile(this, (ProfileImpl)profile);
    }

    public Profile getProfile(String string) throws SPIException {
        return this.getDataStore().getProfile(this, string);
    }

    protected TreeSet getTheProfiles(Applicability applicability) throws SPIException {
        return this.getDataStore().getProfiles(this, applicability);
    }

    public boolean isReadOnly() throws SPIException {
        Entity entity = this.getEntity();
        return !this.getDataStore().hasWriteAccess(this, entity);
    }

    public Entity getEntity() throws SPIException {
        if (this.mRepositoryEntity == null) {
            try {
                this.mRepositoryEntity = this.mPolicyMgr.getEntity(this.mEntityId);
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        return this.mRepositoryEntity;
    }

    public LdapDataStore getDataStore() {
        return ((LdapProfileProvider)this.mPolicyMgr.getProfileProvider()).getDataStore();
    }

    public String getLocalProfileId() throws SPIException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("ou=");
        stringBuffer2.append(GLOBAL_PROFILE_CONTAINER);
        stringBuffer2.append(",");
        StringBuffer stringBuffer3 = new StringBuffer();
        Entity entity = this.getEntity();
        if (entity instanceof Domain || entity instanceof Host) {
            stringBuffer3.append("ou=");
            stringBuffer3.append(DEFAULT_HOST_PROFILE_DN);
            stringBuffer3.append(",");
        } else {
            stringBuffer3.append("ou=");
            stringBuffer3.append(DEFAULT_USER_PROFILE_DN);
            stringBuffer3.append(",");
        }
        String string = stringBuffer2.toString();
        if (this.mLocation.startsWith(string)) {
            stringBuffer.append(stringBuffer3.toString());
            stringBuffer.append(this.mLocation.substring(string.length()));
            return stringBuffer.toString();
        }
        return this.mLocation;
    }

    public void migrateProfile(LdapProfile ldapProfile) throws SPIException {
        Object object;
        LdapProfile ldapProfile2 = (LdapProfile)this.createProfile(ldapProfile.getDisplayName(), ldapProfile.getApplicability());
        Iterator iterator = ldapProfile.getPolicies();
        while (iterator.hasNext()) {
            object = (Policy)iterator.next();
            ldapProfile2.storePolicy((Policy)object);
        }
        object = this.mPolicyMgr.getAssignmentProvider();
        object.assignProfile(this.getEntity(), ldapProfile2);
        this.deleteProfile(ldapProfile);
        ldapProfile.copy(ldapProfile2);
    }
}

