/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.ldap.profiles;

import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.User;
import com.sun.apoc.spi.policies.Policy;
import com.sun.apoc.spi.profiles.Applicability;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class LdapUserProfile
implements Profile {
    private static final String TAB = "  ";
    private static final String NODE_TAB = "  ";
    private static final String PROP_TAB = "    ";
    private static final String VALUE_TAB = "      ";
    private static final String QUOTE = "\"";
    private static final String TAG_CLOSE = ">";
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    private static final String COMPONENT_OPEN_BEGIN = "<oor:component-data";
    private static final String COMPONENT_OPEN_END = ">";
    private static final String COMPONENT_CLOSE = "</oor:component-data>";
    private static final String NODE_OPEN_BEGIN = "  <node";
    private static final String NODE_OPEN_END = ">";
    private static final String NODE_CLOSE = "  </node>";
    private static final String PROP_OPEN_BEGIN = "    <prop";
    private static final String PROP_OPEN_END = ">";
    private static final String PROP_CLOSE = "    </prop>";
    private static final String VALUE_OPEN = "      <value>";
    private static final String VALUE_CLOSE = "</value>";
    private static final String NAME_ATTR = "oor:name=";
    private static final String PKG_ATTR = "oor:package=";
    private static final String TYPE_ATTR = "oor:type=\"xs:string\"";
    private static final String COMPONENT_ATTRS = "xmlns:oor=\"http://openoffice.org/2001/registry\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";
    private static final String COMPONENT_PKG = "com.sun.jds";
    private static final String COMPONENT_NAME = "UserProfile";
    private static final String NODE_NAME = "Data";
    private static final String ID = "ou=UserProfile,";
    private static final String DISPLAY_NAME = " User Profile";
    private static final String POLICY_ID = "com.sun.jds.UserProfile";
    private String mId;
    private String mDisplayName = "";
    private Policy mPolicy = null;

    public LdapUserProfile(User user, Hashtable hashtable, Hashtable hashtable2) {
        this.mId = ID + user.getId();
        String string = this.getPolicyData(hashtable, hashtable2);
        this.mPolicy = new Policy(POLICY_ID, this.mId, string);
        try {
            this.mDisplayName = user.getDisplayName() + DISPLAY_NAME;
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
    }

    public Policy getPolicy() throws SPIException {
        return this.mPolicy;
    }

    private String getPolicyData(Hashtable hashtable, Hashtable hashtable2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XML_VERSION).append("\n");
        stringBuffer.append(COMPONENT_OPEN_BEGIN).append(" ");
        stringBuffer.append(COMPONENT_ATTRS).append(" ");
        stringBuffer.append(PKG_ATTR).append(QUOTE).append(COMPONENT_PKG).append(QUOTE).append(" ");
        stringBuffer.append(NAME_ATTR).append(QUOTE).append(COMPONENT_NAME).append(QUOTE);
        stringBuffer.append(">").append("\n");
        stringBuffer.append(NODE_OPEN_BEGIN).append(" ");
        stringBuffer.append(NAME_ATTR).append(QUOTE).append(NODE_NAME).append(QUOTE);
        stringBuffer.append(">").append("\n");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getAttributeValue(string, hashtable, hashtable2);
            stringBuffer.append(this.getPropertyData(string, string2));
        }
        stringBuffer.append(NODE_CLOSE).append("\n");
        stringBuffer.append(COMPONENT_CLOSE);
        return stringBuffer.toString();
    }

    private String getAttributeValue(String string, Hashtable hashtable, Hashtable hashtable2) {
        String string2 = new String("");
        Object v = hashtable.get(string);
        String[] stringArray = (String[])hashtable.get(string);
        if (stringArray != null) {
            string2 = this.getLdapValue(stringArray, hashtable2);
        }
        return string2;
    }

    private String getLdapValue(String[] stringArray, Hashtable hashtable) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            String string = this.getLdapAttributeValue(stringArray[n], hashtable);
            stringBuffer.append(string).append(",");
        }
        n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.deleteCharAt(n - 1);
        }
        return stringBuffer.toString();
    }

    private String getLdapAttributeValue(String string, Hashtable hashtable) {
        String string2 = new String("");
        Vector vector = (Vector)hashtable.get(string);
        String string3 = vector.toString();
        int n = string3.length();
        if (n > 1) {
            string2 = string3.substring(1, n - 1);
        }
        return string2;
    }

    private StringBuffer getPropertyData(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            stringBuffer.append(PROP_OPEN_BEGIN).append(" ");
            stringBuffer.append(NAME_ATTR).append(QUOTE).append(string).append(QUOTE).append(" ");
            stringBuffer.append(TYPE_ATTR);
            stringBuffer.append(">").append("\n");
            stringBuffer.append(VALUE_OPEN).append(string2).append(VALUE_CLOSE).append("\n");
            stringBuffer.append(PROP_CLOSE).append("\n");
        }
        return stringBuffer;
    }

    public String getId() {
        return this.mId;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public int getPriority() {
        return 0;
    }

    public Applicability getApplicability() {
        return Applicability.USER;
    }

    public String getAuthor() throws SPIException {
        return new String("");
    }

    public String getComment() throws SPIException {
        return new String("");
    }

    public long getLastModified() throws SPIException {
        return this.mPolicy.getLastModified();
    }

    public boolean hasPolicies() throws SPIException {
        return this.mPolicy != null;
    }

    public Iterator getPolicies() throws SPIException {
        Vector<Policy> vector = new Vector<Policy>();
        vector.add(this.mPolicy);
        return vector.iterator();
    }

    public Iterator getPolicies(Iterator iterator) throws SPIException {
        Vector<Policy> vector = new Vector<Policy>();
        String string = this.mPolicy.getId();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string)) continue;
            vector.add(this.mPolicy);
            break;
        }
        return vector.iterator();
    }

    public Iterator getPolicyInfos(Iterator iterator) throws SPIException {
        return this.getPolicies(iterator);
    }

    public Policy getPolicy(String string) throws SPIException {
        if (string.equals(this.mPolicy.getId())) {
            return this.mPolicy;
        }
        return null;
    }

    public ProfileRepository getProfileRepository() {
        return null;
    }

    public void storePolicy(Policy policy) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void destroyPolicy(Policy policy) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public boolean hasAssignedEntities() throws SPIException {
        throw new UnsupportedOperationException();
    }

    public Iterator getAssignedEntities() throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setApplicability(Applicability applicability) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setComment(String string) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setPriority(int n) throws SPIException {
        throw new UnsupportedOperationException();
    }

    public void setDisplayName(String string) throws SPIException {
        throw new UnsupportedOperationException();
    }
}

