/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.spi.memory.entities;

import com.sun.apoc.spi.PolicyMgr;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.entities.Entity;
import com.sun.apoc.spi.profiles.Profile;
import com.sun.apoc.spi.profiles.ProfileRepository;
import java.util.Iterator;
import java.util.LinkedList;

public class EntityImpl
implements Entity {
    private String m_displayName = "";
    private String m_id = "";
    private Entity m_parent = null;
    private PolicyMgr m_mgr = null;

    public EntityImpl(PolicyMgr policyMgr, Entity entity, String string, String string2) {
        this.m_mgr = policyMgr;
        this.m_parent = entity;
        this.m_displayName = string2;
        this.m_id = string;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public Iterator getAncestorNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            for (Entity entity = this.getParent(); entity != null; entity = entity.getParent()) {
                linkedList.add(entity.getDisplayName());
            }
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        return linkedList.iterator();
    }

    public String getId() {
        return this.m_id;
    }

    public Entity getParent() {
        return this.m_parent;
    }

    public Iterator getAssignedProfiles() throws SPIException {
        return this.m_mgr.getAssignmentProvider().getAssignedProfiles(this);
    }

    public void assignProfile(Profile profile) throws SPIException {
        this.m_mgr.getAssignmentProvider().assignProfile(this, profile);
    }

    public void unassignProfile(Profile profile) throws SPIException {
        this.m_mgr.getAssignmentProvider().unassignProfile(this, profile);
    }

    public Iterator getLayeredProfiles() throws SPIException {
        return null;
    }

    public ProfileRepository getProfileRepository() throws SPIException {
        if (this.getParent() != null) {
            return this.m_mgr.getProfileProvider().getProfileRepository(this.getId());
        }
        return this.m_mgr.getProfileProvider().getDefaultProfileRepository();
    }
}

