/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Method;
import java.util.Hashtable;
import netscape.ldap.LDAPException;

class DynamicInvoker {
    private static Hashtable m_methodLookup = new Hashtable();

    DynamicInvoker() {
    }

    static Method getMethod(String packageName, String methodName, String[] args) throws LDAPException {
        try {
            String key;
            Method method = null;
            String suffix = "";
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    suffix = String.valueOf(suffix) + args[i].getClass().getName();
                    ++i;
                }
            }
            if ((method = (Method)m_methodLookup.get(key = String.valueOf(packageName) + "." + methodName + "." + suffix)) != null) {
                return method;
            }
            Class<?> c = Class.forName(packageName);
            Method[] m = c.getMethods();
            int i = 0;
            while (i < m.length) {
                Class[] params = m[i].getParameterTypes();
                if (m[i].getName().equals(methodName) && DynamicInvoker.signatureCorrect(params, args)) {
                    m_methodLookup.put(key, m[i]);
                    return m[i];
                }
                ++i;
            }
            throw new LDAPException("Method " + methodName + " not found in " + packageName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class " + packageName + " not found");
        }
    }

    static Object invokeMethod(Object obj, String packageName, String methodName, Object[] args, String[] argNames) throws LDAPException {
        try {
            Method m = DynamicInvoker.getMethod(packageName, methodName, argNames);
            if (m != null) {
                return m.invoke(obj, args);
            }
        }
        catch (Exception e) {
            throw new LDAPException("Invoking " + methodName + ": " + e.toString(), 89);
        }
        return null;
    }

    private static boolean signatureCorrect(Class[] params, String[] args) {
        if (args == null) {
            return true;
        }
        if (params.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < params.length) {
            if (!params[i].getName().equals(args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

