/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class LDAPAttribute
implements Serializable {
    static final long serialVersionUID = -4594745735452202600L;
    private String name = null;
    private byte[] nameBuf = null;
    private Object[] values = new Object[0];

    public LDAPAttribute(String attrName) {
        this.name = attrName;
    }

    public LDAPAttribute(String attrName, String attrValue) {
        this.name = attrName;
        this.addValue(attrValue);
    }

    public LDAPAttribute(String attrName, byte[] attrValue) {
        this.name = attrName;
        this.addValue(attrValue);
    }

    public LDAPAttribute(String attrName, String[] attrValues) {
        this.name = attrName;
        if (attrValues != null) {
            this.setValues(attrValues);
        }
    }

    public LDAPAttribute(LDAPAttribute attr) {
        this.name = attr.name;
        this.nameBuf = attr.nameBuf;
        this.values = new Object[attr.values.length];
        int i = 0;
        while (i < attr.values.length) {
            this.values[i] = new byte[((byte[])attr.values[i]).length];
            System.arraycopy((byte[])attr.values[i], 0, (byte[])this.values[i], 0, ((byte[])attr.values[i]).length);
            ++i;
        }
    }

    public LDAPAttribute(BERElement element) throws IOException {
        BERSequence seq = (BERSequence)element;
        BEROctetString type = (BEROctetString)seq.elementAt(0);
        this.nameBuf = type.getValue();
        BERSet set = (BERSet)seq.elementAt(1);
        if (set.size() > 0) {
            Object[] vals = new Object[set.size()];
            int i = 0;
            while (i < set.size()) {
                vals[i] = ((BEROctetString)set.elementAt(i)).getValue();
                if (vals[i] == null) {
                    vals[i] = new byte[0];
                }
                ++i;
            }
            this.setValues(vals);
        }
    }

    public synchronized void addValue(String attrValue) {
        block2: {
            if (attrValue == null) break block2;
            try {
                byte[] b = attrValue.getBytes("UTF8");
                this.addValue(b);
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void addValue(byte[] attrValue) {
        if (attrValue != null) {
            Object[] vals = new Object[this.values.length + 1];
            int i = 0;
            while (i < this.values.length) {
                vals[i] = this.values[i];
                ++i;
            }
            vals[this.values.length] = attrValue;
            this.values = vals;
        }
    }

    private static boolean equalValue(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BERElement getBERElement() {
        try {
            BERSequence seq = new BERSequence();
            seq.addElement(new BEROctetString(this.getName()));
            BERSet set = new BERSet();
            int i = 0;
            while (i < this.values.length) {
                set.addElement(new BEROctetString((byte[])this.values[i]));
                ++i;
            }
            seq.addElement(set);
            return seq;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.getName());
    }

    public static String getBaseName(String attrName) {
        String basename = attrName;
        StringTokenizer st = new StringTokenizer(attrName, ";");
        if (st.hasMoreElements()) {
            basename = (String)st.nextElement();
        }
        return basename;
    }

    public byte[][] getByteValueArray() {
        byte[][] b = new byte[this.values.length][];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                int i = 0;
                while (i < this.values.length) {
                    b[i] = new byte[((byte[])this.values[i]).length];
                    System.arraycopy((byte[])this.values[i], 0, b[i], 0, ((byte[])this.values[i]).length);
                    ++i;
                }
            }
            catch (Exception exception) {
                byte[][] byArray = null;
                Object var4_5 = null;
                return byArray;
            }
        }
        return b;
    }

    public Enumeration getByteValues() {
        Vector<Object> v = new Vector<Object>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] != null) {
                    v.addElement(this.values[i]);
                } else {
                    v.addElement(new byte[0]);
                }
                ++i;
            }
        }
        return v.elements();
    }

    public String getLangSubtype() {
        String[] subTypes = this.getSubtypes();
        if (subTypes != null) {
            int i = 0;
            while (i < subTypes.length) {
                if (subTypes[i].length() >= 5 && subTypes[i].substring(0, 5).equalsIgnoreCase("lang-")) {
                    return subTypes[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String getName() {
        block2: {
            if (this.name != null || this.nameBuf == null) break block2;
            try {
                this.name = new String(this.nameBuf, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        return this.name;
    }

    private String getParamString() {
        StringBuffer sb = new StringBuffer();
        if (this.values.length > 0) {
            int i = 0;
            while (i < this.values.length) {
                if (i != 0) {
                    sb.append(",");
                }
                byte[] val = (byte[])this.values[i];
                try {
                    String sval = new String(val, "UTF8");
                    if (sval.length() == 0 && val.length > 0) {
                        sb.append("<binary value, length:");
                        sb.append(val.length);
                        sb.append(">");
                    } else {
                        sb.append(sval);
                    }
                }
                catch (Exception exception) {
                    if (val != null) {
                        sb.append("<binary value, length:");
                        sb.append(val.length);
                        sb.append(">");
                    }
                    sb.append("null value");
                }
                ++i;
            }
        }
        return "{type='" + this.getName() + "', values='" + sb.toString() + "'}";
    }

    public String[] getStringValueArray() {
        String[] s = new String[this.values.length];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                int i = 0;
                while (i < this.values.length) {
                    s[i] = this.values[i] != null ? new String((byte[])this.values[i], "UTF8") : new String("");
                    ++i;
                }
            }
            catch (Exception exception) {
                String[] stringArray = null;
                Object var4_5 = null;
                return stringArray;
            }
        }
        return s;
    }

    public Enumeration getStringValues() {
        Vector<String> v = new Vector<String>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                int i = 0;
                while (i < this.values.length) {
                    if (this.values[i] != null) {
                        v.addElement(new String((byte[])this.values[i], "UTF8"));
                    } else {
                        v.addElement(new String(""));
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                Enumeration enumeration = null;
                Object var4_5 = null;
                return enumeration;
            }
        }
        return v.elements();
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.getName());
    }

    public static String[] getSubtypes(String attrName) {
        StringTokenizer st = new StringTokenizer(attrName, ";");
        if (st.hasMoreElements()) {
            st.nextElement();
            String[] subtypes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                subtypes[i++] = (String)st.nextElement();
            }
            return subtypes;
        }
        return null;
    }

    public boolean hasSubtype(String subtype) {
        String[] mytypes = this.getSubtypes();
        int i = 0;
        while (i < mytypes.length) {
            if (subtype.equalsIgnoreCase(mytypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasSubtypes(String[] subtypes) {
        int i = 0;
        while (i < subtypes.length) {
            if (!this.hasSubtype(subtypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized void removeValue(String attrValue) {
        block2: {
            if (attrValue == null) break block2;
            try {
                byte[] b = attrValue.getBytes("UTF8");
                this.removeValue(b);
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void removeValue(byte[] attrValue) {
        if (attrValue == null || this.values == null || this.values.length < 1) {
            return;
        }
        int ind = -1;
        int i = 0;
        while (i < this.values.length) {
            if (LDAPAttribute.equalValue(attrValue, (byte[])this.values[i])) {
                ind = i;
                break;
            }
            ++i;
        }
        if (ind >= 0) {
            Object[] vals = new Object[this.values.length - 1];
            int j = 0;
            int i2 = 0;
            while (i2 < this.values.length) {
                if (i2 != ind) {
                    vals[j++] = this.values[i2];
                }
                ++i2;
            }
            this.values = vals;
        }
    }

    protected synchronized void setValues(Object[] attrValues) {
        this.values = attrValues;
    }

    protected void setValues(String[] attrValues) {
        Object[] vals;
        if (attrValues != null) {
            vals = new Object[attrValues.length];
            int i = 0;
            while (i < vals.length) {
                try {
                    vals[i] = attrValues[i].getBytes("UTF8");
                }
                catch (Throwable throwable) {
                    vals[i] = new byte[0];
                }
                ++i;
            }
        } else {
            vals = new Object[]{};
        }
        this.setValues(vals);
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        return "LDAPAttribute " + this.getParamString();
    }
}

