/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;

public class LDAPAttributeSet
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5018474561697778100L;
    Hashtable attrHash = null;
    LDAPAttribute[] attrs = new LDAPAttribute[0];
    static final int ATTR_COUNT_REQUIRES_HASH = 5;

    public LDAPAttributeSet() {
    }

    public LDAPAttributeSet(LDAPAttribute[] attrs) {
        this.attrs = attrs;
    }

    public synchronized void add(LDAPAttribute attr) {
        if (attr != null) {
            LDAPAttribute[] vals = new LDAPAttribute[this.attrs.length + 1];
            int i = 0;
            while (i < this.attrs.length) {
                vals[i] = this.attrs[i];
                ++i;
            }
            vals[this.attrs.length] = attr;
            this.attrs = vals;
            if (this.attrHash != null) {
                this.attrHash.put(attr.getName().toLowerCase(), attr);
            }
        }
    }

    public synchronized Object clone() {
        try {
            LDAPAttributeSet attributeSet = new LDAPAttributeSet();
            attributeSet.attrs = new LDAPAttribute[this.attrs.length];
            int i = 0;
            while (i < this.attrs.length) {
                attributeSet.attrs[i] = new LDAPAttribute(this.attrs[i]);
                ++i;
            }
            return attributeSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public LDAPAttribute elementAt(int index) {
        return this.attrs[index];
    }

    public LDAPAttribute getAttribute(String attrName) {
        this.prepareHashtable();
        if (this.attrHash != null) {
            return (LDAPAttribute)this.attrHash.get(attrName.toLowerCase());
        }
        int i = 0;
        while (i < this.attrs.length) {
            if (attrName.equalsIgnoreCase(this.attrs[i].getName())) {
                return this.attrs[i];
            }
            ++i;
        }
        return null;
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        if (lang == null || lang.length() < 1) {
            return this.getAttribute(attrName);
        }
        String langLower = lang.toLowerCase();
        if (langLower.length() < 5 || !langLower.substring(0, 5).equals("lang-")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(langLower, "-");
        st.nextToken();
        String[] langComponents = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            langComponents[i] = st.nextToken();
            ++i;
        }
        String searchBasename = LDAPAttribute.getBaseName(attrName);
        String[] searchTypes = LDAPAttribute.getSubtypes(attrName);
        LDAPAttribute found = null;
        int matchCount = 0;
        i = 0;
        while (i < this.attrs.length) {
            boolean isCandidate = false;
            LDAPAttribute attr = this.attrs[i];
            if (attr.getBaseName().equalsIgnoreCase(searchBasename)) {
                if (searchTypes == null || searchTypes.length < 1) {
                    isCandidate = true;
                } else if (attr.hasSubtypes(searchTypes)) {
                    isCandidate = true;
                }
            }
            String attrLang = null;
            if (isCandidate) {
                attrLang = attr.getLangSubtype();
                if (attrLang == null) {
                    found = attr;
                } else {
                    st = new StringTokenizer(attrLang.toLowerCase(), "-");
                    st.nextToken();
                    if (st.countTokens() <= langComponents.length) {
                        int j = 0;
                        while (st.hasMoreTokens()) {
                            if (!langComponents[j].equals(st.nextToken())) {
                                j = 0;
                                break;
                            }
                            ++j;
                        }
                        if (j > matchCount) {
                            found = attr;
                            matchCount = j;
                        }
                    }
                }
            }
            ++i;
        }
        return found;
    }

    public Enumeration getAttributes() {
        Vector<LDAPAttribute> v = new Vector<LDAPAttribute>();
        LDAPAttributeSet lDAPAttributeSet = this;
        synchronized (lDAPAttributeSet) {
            int i = 0;
            while (i < this.attrs.length) {
                v.addElement(this.attrs[i]);
                ++i;
            }
        }
        return v.elements();
    }

    public LDAPAttributeSet getSubset(String subtype) {
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        if (subtype == null) {
            return attrs;
        }
        StringTokenizer st = new StringTokenizer(subtype, ";");
        if (st.countTokens() < 1) {
            return attrs;
        }
        String[] searchTypes = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            searchTypes[i] = (String)st.nextElement();
            ++i;
        }
        Enumeration attrEnum = this.getAttributes();
        while (attrEnum.hasMoreElements()) {
            LDAPAttribute attr = (LDAPAttribute)attrEnum.nextElement();
            if (!attr.hasSubtypes(searchTypes)) continue;
            attrs.add(new LDAPAttribute(attr));
        }
        return attrs;
    }

    private void prepareHashtable() {
        if (this.attrHash == null && this.attrs.length >= 5) {
            this.attrHash = new Hashtable();
            int j = 0;
            while (j < this.attrs.length) {
                this.attrHash.put(this.attrs[j].getName().toLowerCase(), this.attrs[j]);
                ++j;
            }
        }
    }

    public synchronized void remove(String name) {
        int i = 0;
        while (i < this.attrs.length) {
            if (name.equalsIgnoreCase(this.attrs[i].getName())) {
                this.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    public void removeElementAt(int index) {
        if (index >= 0 && index < this.attrs.length) {
            LDAPAttributeSet lDAPAttributeSet = this;
            synchronized (lDAPAttributeSet) {
                LDAPAttribute[] vals = new LDAPAttribute[this.attrs.length - 1];
                int j = 0;
                int i = 0;
                while (i < this.attrs.length) {
                    if (i != index) {
                        vals[j++] = this.attrs[i];
                    }
                    ++i;
                }
                if (this.attrHash != null) {
                    this.attrHash.remove(this.attrs[index].getName().toLowerCase());
                }
                this.attrs = vals;
            }
        }
    }

    public int size() {
        return this.attrs.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LDAPAttributeSet: ");
        int i = 0;
        while (i < this.attrs.length) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append(this.attrs[i].toString());
            ++i;
        }
        return sb.toString();
    }
}

