/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPSocketFactory;

class LDAPConnSetupMgr
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1519402748245755306L;
    private static final int SERIAL = 0;
    private static final int PARALLEL = 1;
    private static final int CONNECTED = 0;
    private static final int DISCONNECTED = 1;
    private static final int NEVER_USED = 2;
    private static final int INTERRUPTED = 3;
    private static final int FAILED = 4;
    private Socket m_socket = null;
    private LDAPException m_connException = null;
    ServerEntry[] m_dsList;
    private int m_dsIdx = -1;
    LDAPSocketFactory m_factory;
    int m_policy = 0;
    int m_connSetupDelay = -1;
    int m_connectTimeout = 0;
    private transient int m_attemptCnt = 0;
    private static int m_nextId;
    private int m_id;

    LDAPConnSetupMgr(String[] hosts, int[] ports, LDAPSocketFactory factory) {
        this.m_dsList = new ServerEntry[hosts.length];
        int i = 0;
        while (i < hosts.length) {
            this.m_dsList[i] = new ServerEntry(hosts[i], ports[i], 2);
            ++i;
        }
        this.m_factory = factory;
        this.m_id = m_nextId++;
    }

    boolean breakConnection() {
        try {
            this.m_socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void cleanup() {
        Thread currThread = Thread.currentThread();
        int i = 0;
        while (i < this.m_dsList.length) {
            ServerEntry entry = this.m_dsList[i];
            if (entry.connSetupThread != null && entry.connSetupThread != currThread) {
                entry.connSetupStatus = 3;
                entry.connSetupThread.interrupt();
                entry.connSetupThread = null;
            }
            ++i;
        }
    }

    public Object clone() {
        try {
            LDAPConnSetupMgr cloneMgr = (LDAPConnSetupMgr)super.clone();
            cloneMgr.m_dsList = new ServerEntry[this.m_dsList.length];
            int i = 0;
            while (i < this.m_dsList.length) {
                ServerEntry e = this.m_dsList[i];
                cloneMgr.m_dsList[i] = new ServerEntry(e.host, e.port, e.connSetupStatus);
                ++i;
            }
            return cloneMgr;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void connect() {
        if (this.m_policy == 0 || this.m_dsList.length == 1) {
            this.openSerial();
        } else {
            this.openParallel();
        }
    }

    void connectServer(int idx) {
        ServerEntry entry = this.m_dsList[idx];
        Thread currThread = Thread.currentThread();
        Socket sock = null;
        LDAPException conex = null;
        try {
            sock = this.m_factory == null ? new Socket(entry.host, entry.port) : this.m_factory.makeSocket(entry.host, entry.port);
        }
        catch (IOException iOException) {
            conex = new LDAPException("failed to connect to server " + entry.host + ":" + entry.port, 91);
        }
        catch (LDAPException e) {
            conex = e;
        }
        if (currThread.isInterrupted()) {
            return;
        }
        LDAPConnSetupMgr lDAPConnSetupMgr = this;
        synchronized (lDAPConnSetupMgr) {
            if (this.m_socket == null && entry.connSetupThread == currThread) {
                entry.connSetupThread = null;
                if (sock != null) {
                    entry.connSetupStatus = 0;
                    this.m_socket = sock;
                    this.m_dsIdx = idx;
                    this.cleanup();
                } else {
                    entry.connSetupStatus = 4;
                    this.m_connException = conex;
                }
                ++this.m_attemptCnt;
                this.notifyAll();
            }
        }
    }

    void disconnect() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 1;
        }
        this.m_socket = null;
    }

    int getConnSetupDelay() {
        return this.m_connSetupDelay / 1000;
    }

    int getConnectTimeout() {
        return this.m_connectTimeout / 1000;
    }

    String getHost() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].host;
        }
        return this.m_dsList[0].host;
    }

    int getID() {
        return this.m_id;
    }

    String getLDAPUrl() {
        return String.valueOf(this.m_factory == null ? "ldap" : "ldaps") + "://" + this.getHost() + ":" + this.getPort();
    }

    int getPort() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].port;
        }
        return this.m_dsList[0].port;
    }

    private String getServerList() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.m_dsList.length) {
            sb.append(i == 0 ? "" : " ");
            sb.append(this.m_dsList[i].host);
            sb.append(":");
            sb.append(this.m_dsList[i].port);
            ++i;
        }
        return sb.toString();
    }

    Socket getSocket() {
        return this.m_socket;
    }

    synchronized void invalidateConnection() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 4;
            int srvCnt = this.m_dsList.length;
            int j = 0;
            ServerEntry[] newDsList = new ServerEntry[this.m_dsList.length];
            int i = 0;
            while (i < srvCnt) {
                if (i != this.m_dsIdx) {
                    newDsList[j++] = this.m_dsList[i];
                }
                ++i;
            }
            newDsList[j] = this.m_dsList[this.m_dsIdx];
            this.m_dsList = newDsList;
            this.m_dsIdx = j;
        }
        this.m_socket = null;
    }

    boolean isUserDisconnected() {
        return this.m_dsIdx >= 0 && this.m_dsList[this.m_dsIdx].connSetupStatus == 1;
    }

    synchronized Socket openConnection() throws LDAPException {
        long tcur = 0L;
        long tmax = Long.MAX_VALUE;
        Thread th = null;
        this.reset();
        this.sortDsList();
        if (this.m_connectTimeout == 0) {
            this.connect();
        } else {
            tmax = System.currentTimeMillis() + (long)this.m_connectTimeout;
            th = new Thread(new Runnable(){

                public void run() {
                    LDAPConnSetupMgr.this.connect();
                }
            }, "ConnSetupMgr");
            th.setDaemon(true);
            th.start();
            while (this.m_socket == null && this.m_attemptCnt < this.m_dsList.length && (tcur = System.currentTimeMillis()) < tmax) {
                try {
                    this.wait(tmax - tcur);
                }
                catch (InterruptedException interruptedException) {
                    th.interrupt();
                    this.cleanup();
                    throw new LDAPInterruptedException("Interrupted connect operation");
                }
            }
        }
        if (this.m_socket != null) {
            return this.m_socket;
        }
        if (th != null && (tcur = System.currentTimeMillis()) >= tmax) {
            th.interrupt();
            this.cleanup();
            throw new LDAPException("connect timeout, " + this.getServerList() + " might be unreachable", 91);
        }
        if (this.m_connException != null && this.m_dsList.length == 1) {
            throw this.m_connException;
        }
        throw new LDAPException("failed to connect to server " + this.getServerList(), 91);
    }

    private synchronized void openParallel() {
        int i = 0;
        while (this.m_socket == null && i < this.m_dsList.length) {
            Thread t;
            final int dsIdx = i;
            String threadName = "ConnSetupMgr " + this.m_dsList[dsIdx].host + ":" + this.m_dsList[dsIdx].port;
            this.m_dsList[dsIdx].connSetupThread = t = new Thread(new Runnable(){

                public void run() {
                    this.connectServer(dsIdx);
                }
            }, threadName);
            t.setDaemon(true);
            t.start();
            if (this.m_connSetupDelay != 0 && i < this.m_dsList.length - 1) {
                try {
                    this.wait(this.m_connSetupDelay);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            ++i;
        }
        while (this.m_socket == null && this.m_attemptCnt < this.m_dsList.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void openSerial() {
        int i = 0;
        while (i < this.m_dsList.length) {
            this.m_dsList[i].connSetupThread = Thread.currentThread();
            this.connectServer(i);
            if (this.m_socket != null) {
                return;
            }
            ++i;
        }
    }

    private void reset() {
        this.m_socket = null;
        this.m_connException = null;
        this.m_attemptCnt = 0;
        int i = 0;
        while (i < this.m_dsList.length) {
            this.m_dsList[i].connSetupThread = null;
            ++i;
        }
    }

    void setConnSetupDelay(int delay) {
        this.m_policy = delay < 0 ? 0 : 1;
        this.m_connSetupDelay = delay * 1000;
    }

    void setConnectTimeout(int timeout) {
        this.m_connectTimeout = timeout * 1000;
    }

    private void sortDsList() {
        int srvCnt = this.m_dsList.length;
        int i = 1;
        while (i < srvCnt) {
            int j = 0;
            while (j < i) {
                if (this.m_dsList[i].connSetupStatus < this.m_dsList[j].connSetupStatus) {
                    ServerEntry entry = this.m_dsList[j];
                    this.m_dsList[j] = this.m_dsList[i];
                    this.m_dsList[i] = entry;
                }
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        String str = "dsIdx=" + this.m_dsIdx + " dsList=";
        int i = 0;
        while (i < this.m_dsList.length) {
            str = String.valueOf(str) + this.m_dsList[i] + " ";
            ++i;
        }
        return str;
    }

    class ServerEntry {
        String host;
        int port;
        int connSetupStatus;
        Thread connSetupThread;

        ServerEntry(String host, int port, int status) {
            this.host = host;
            this.port = port;
            this.connSetupStatus = status;
            this.connSetupThread = null;
        }

        public String toString() {
            return "{" + this.host + ":" + this.port + " status=" + this.connSetupStatus + "}";
        }
    }
}

