/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseControl;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
extends Thread {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private static final int BACKLOG_CHKCNT = 50;
    private static transient int m_highMsgId;
    private transient InputStream m_serverInput;
    private transient OutputStream m_serverOutput;
    private transient Hashtable m_requests;
    private transient Hashtable m_messages = null;
    private transient Vector m_registered;
    private transient boolean m_disconnected = false;
    private transient LDAPCache m_cache = null;
    private transient boolean m_doRun = true;
    private Socket m_socket = null;
    private transient Thread m_thread = null;
    transient Object m_sendRequestLock = new Object();
    transient LDAPConnSetupMgr m_connMgr = null;
    transient Object m_traceOutput = null;
    private transient int m_backlogCheckCounter = 50;
    static SimpleDateFormat m_timeFormat;

    static {
        m_timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    }

    public LDAPConnThread(LDAPConnSetupMgr connMgr, LDAPCache cache, Object traceOutput) throws LDAPException {
        super("LDAPConnThread " + connMgr.getHost() + ":" + connMgr.getPort());
        this.m_requests = new Hashtable();
        this.m_registered = new Vector();
        this.m_connMgr = connMgr;
        this.m_socket = connMgr.getSocket();
        this.setCache(cache);
        this.setTraceOutput(traceOutput);
        this.setDaemon(true);
        try {
            this.m_serverInput = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_doRun = false;
            this.start();
            throw new LDAPException("failed to connect to server " + this.m_connMgr.getHost(), 91);
        }
        if (traceOutput != null) {
            StringBuffer sb = new StringBuffer(" connected to ");
            sb.append(this.m_connMgr.getLDAPUrl());
            this.logTraceMessage(sb);
        }
        this.start();
    }

    void abandon(int id) {
        if (!this.m_doRun) {
            return;
        }
        LDAPMessageQueue l = (LDAPMessageQueue)this.m_requests.remove(new Integer(id));
        if (this.m_messages != null) {
            this.m_messages.remove(new Integer(id));
        }
        if (l != null) {
            l.removeRequest(id);
        }
        this.resultRetrieved();
    }

    private int allocateId() {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            int n = m_highMsgId = (m_highMsgId + 1) % Integer.MAX_VALUE;
            Object var3_3 = null;
            return n;
        }
    }

    private synchronized void cacheSearchResult(LDAPSearchListener l, LDAPMessage msg, int size) {
        Integer messageID = new Integer(msg.getMessageID());
        Long key = l.getKey();
        Vector v = null;
        if (this.m_cache == null || key == null) {
            return;
        }
        if (msg instanceof LDAPSearchResult) {
            v = (Vector)this.m_messages.get(messageID);
            if (v == null) {
                v = new Vector();
                this.m_messages.put(messageID, v);
                v.addElement(new Long(0L));
            }
            if ((Long)v.firstElement() == -1L) {
                return;
            }
            long entrySize = (Long)v.firstElement() + (long)size;
            if (entrySize > this.m_cache.getSize()) {
                v.removeAllElements();
                v.addElement(new Long(-1L));
                return;
            }
            v.setElementAt(new Long(entrySize), 0);
            v.addElement(((LDAPSearchResult)msg).getEntry());
        } else if (msg instanceof LDAPSearchResultReference) {
            v = (Vector)this.m_messages.get(messageID);
            if (v == null) {
                v = new Vector();
                this.m_messages.put(messageID, v);
            } else {
                v.removeAllElements();
            }
            v.addElement(new Long(-1L));
        } else if (msg instanceof LDAPResponse) {
            boolean fail = ((LDAPResponse)msg).getResultCode() > 0;
            v = (Vector)this.m_messages.remove(messageID);
            if (!fail) {
                if (v == null) {
                    v = new Vector();
                    v.addElement(new Long(0L));
                }
                if ((Long)v.firstElement() != -1L) {
                    this.m_cache.addEntry(key, v);
                }
            }
        }
    }

    LDAPMessageQueue changeListener(int id, LDAPMessageQueue toNotify) {
        if (!this.m_doRun) {
            toNotify.setException(this, new LDAPException("Server or network error", 81));
            return null;
        }
        return this.m_requests.put(new Integer(id), toNotify);
    }

    private void checkBacklog() throws InterruptedException {
        while (this.m_requests.size() != 0) {
            Enumeration listeners = this.m_requests.elements();
            while (listeners.hasMoreElements()) {
                LDAPMessageQueue l = (LDAPMessageQueue)listeners.nextElement();
                if (!(l instanceof LDAPSearchListener)) {
                    return;
                }
                LDAPSearchListener sl = (LDAPSearchListener)l;
                if (sl.getSearchConstraints() == null) {
                    return;
                }
                int slMaxBacklog = sl.getSearchConstraints().getMaxBacklog();
                int slBatchSize = sl.getSearchConstraints().getBatchSize();
                if (slMaxBacklog == 0) {
                    return;
                }
                if (!sl.isAsynchOp() && slBatchSize == 0) {
                    return;
                }
                if (sl.getMessageCount() >= slMaxBacklog) continue;
                return;
            }
            LDAPConnThread lDAPConnThread = this;
            synchronized (lDAPConnThread) {
                this.wait(3000L);
            }
        }
        return;
    }

    private void cleanUp() {
        if (!this.m_disconnected) {
            Object var2_1;
            try {
                try {
                    this.m_serverOutput.close();
                }
                catch (Exception exception) {
                }
                var2_1 = null;
                this.m_serverOutput = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.m_serverOutput = null;
                throw throwable;
            }
            try {
                try {
                    this.m_serverInput.close();
                }
                catch (Exception exception) {
                }
                var2_1 = null;
                this.m_serverInput = null;
            }
            catch (Throwable throwable) {
                var2_1 = null;
                this.m_serverInput = null;
                throw throwable;
            }
            try {
                try {
                    this.m_socket.close();
                }
                catch (Exception exception) {
                }
                var2_1 = null;
                this.m_socket = null;
            }
            catch (Throwable throwable) {
                var2_1 = null;
                this.m_socket = null;
                throw throwable;
            }
            this.m_disconnected = true;
            this.m_connMgr.disconnect();
            if (this.m_requests != null) {
                Enumeration requests = this.m_requests.elements();
                while (requests.hasMoreElements()) {
                    LDAPMessageQueue listener = (LDAPMessageQueue)requests.nextElement();
                    listener.removeAllRequests(this);
                }
            }
            if (this.m_registered != null) {
                Vector registerCopy = (Vector)this.m_registered.clone();
                Enumeration cancelled = registerCopy.elements();
                while (cancelled.hasMoreElements()) {
                    LDAPConnection c = (LDAPConnection)cancelled.nextElement();
                    c.deregisterConnection();
                }
            }
            this.m_registered.clear();
            this.m_requests.clear();
            this.m_messages = null;
            this.m_cache = null;
        }
    }

    public synchronized void deregister(LDAPConnection conn) {
        this.m_registered.removeElement(conn);
        if (this.m_registered.size() == 0) {
            try {
                try {
                    if (!this.m_disconnected) {
                        LDAPSearchConstraints cons = conn.getSearchConstraints();
                        this.sendRequest(null, new JDAPUnbindRequest(), null, cons);
                    }
                    this.m_doRun = false;
                    if (this.m_thread != null && this.m_thread != Thread.currentThread()) {
                        this.m_thread.interrupt();
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception e) {
                    LDAPConnection.printDebug(e.toString());
                }
                Object var3_4 = null;
                this.cleanUp();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.cleanUp();
                throw throwable;
            }
        }
    }

    int getClientCount() {
        return this.m_registered.size();
    }

    InputStream getInputStream() {
        return this.m_serverInput;
    }

    OutputStream getOutputStream() {
        return this.m_serverOutput;
    }

    boolean isRunning() {
        return this.m_doRun;
    }

    void logTraceMessage(StringBuffer msg) {
        String timeStamp = m_timeFormat.format(new Date());
        StringBuffer sb = new StringBuffer(timeStamp);
        sb.append(" ldc=");
        sb.append(this.m_connMgr.getID());
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            if (this.m_traceOutput instanceof PrintWriter) {
                PrintWriter traceOutput = (PrintWriter)this.m_traceOutput;
                traceOutput.print(sb);
                traceOutput.println(msg);
                traceOutput.flush();
            } else if (this.m_traceOutput instanceof LDAPTraceWriter) {
                sb.append((Object)msg);
                ((LDAPTraceWriter)this.m_traceOutput).write(sb.toString());
            }
        }
    }

    private synchronized void networkError(Exception e) {
        this.m_doRun = false;
        this.m_connMgr.invalidateConnection();
        try {
            Enumeration requests = this.m_requests.elements();
            while (requests.hasMoreElements()) {
                LDAPMessageQueue listener = (LDAPMessageQueue)requests.nextElement();
                listener.setException(this, new LDAPException("Server or network error", 81));
            }
        }
        catch (NullPointerException ee) {
            System.err.println("Exception: " + ee.toString());
        }
        this.cleanUp();
    }

    private void processResponse(LDAPMessage msg, int size) {
        int msgid;
        LDAPConnection ldc;
        LDAPControl[] con;
        Integer messageID = new Integer(msg.getMessageID());
        LDAPMessageQueue l = (LDAPMessageQueue)this.m_requests.get(messageID);
        if (l == null) {
            return;
        }
        if (!l.isAsynchOp() && (con = msg.getControls()) != null && (ldc = l.getConnection(msgid = msg.getMessageID())) != null) {
            ldc.setResponseControls(this, new LDAPResponseControl(ldc, msgid, con));
        }
        if (this.m_cache != null && l instanceof LDAPSearchListener) {
            this.cacheSearchResult((LDAPSearchListener)l, msg, size);
        }
        l.addMessage(msg);
        if (msg instanceof LDAPResponse) {
            this.m_requests.remove(messageID);
            if (this.m_requests.size() == 0) {
                this.m_backlogCheckCounter = 50;
            }
        }
    }

    public synchronized void register(LDAPConnection conn) {
        if (!this.m_registered.contains(conn)) {
            this.m_registered.addElement(conn);
        }
    }

    synchronized void resultRetrieved() {
        this.notifyAll();
    }

    public void run() {
        if (!this.m_doRun) {
            return;
        }
        this.m_thread = Thread.currentThread();
        LDAPMessage msg = null;
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        while (this.m_doRun) {
            Thread.yield();
            int[] nread = new int[]{0};
            try {
                if (--this.m_backlogCheckCounter <= 0) {
                    this.m_backlogCheckCounter = 50;
                    this.checkBacklog();
                }
                BERElement element = BERElement.getElement(decoder, this.m_serverInput, nread);
                msg = LDAPMessage.parseMessage(element);
                if (this.m_traceOutput != null) {
                    this.logTraceMessage(msg.toTraceString());
                }
                this.processResponse(msg, nread[0]);
            }
            catch (Exception e) {
                if (this.m_doRun) {
                    this.networkError(e);
                    continue;
                }
                LDAPConnThread lDAPConnThread = this;
                synchronized (lDAPConnThread) {
                    this.m_thread = null;
                    this.notifyAll();
                }
            }
        }
    }

    void sendRequest(LDAPConnection conn, JDAPProtocolOp request, LDAPMessageQueue toNotify, LDAPConstraints cons) throws LDAPException {
        if (!this.m_doRun) {
            throw new LDAPException("not connected to a server", 81);
        }
        LDAPMessage msg = new LDAPMessage(this.allocateId(), request, cons.getServerControls());
        if (toNotify != null) {
            if (!(request instanceof JDAPAbandonRequest) && !(request instanceof JDAPUnbindRequest)) {
                this.m_requests.put(new Integer(msg.getMessageID()), toNotify);
                this.resultRetrieved();
            }
            toNotify.addRequest(msg.getMessageID(), conn, this, cons.getTimeLimit());
        }
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            try {
                if (this.m_traceOutput != null) {
                    this.logTraceMessage(msg.toTraceString());
                }
                msg.write(this.m_serverOutput);
                this.m_serverOutput.flush();
            }
            catch (IOException e) {
                this.networkError(e);
            }
        }
    }

    synchronized void setCache(LDAPCache cache) {
        this.m_cache = cache;
        this.m_messages = this.m_cache != null ? new Hashtable() : null;
    }

    void setInputStream(InputStream is) {
        this.m_serverInput = is;
    }

    void setOutputStream(OutputStream os) {
        this.m_serverOutput = os;
    }

    void setTraceOutput(Object traceOutput) {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            if (traceOutput == null) {
                this.m_traceOutput = null;
            } else if (traceOutput instanceof OutputStream) {
                this.m_traceOutput = new PrintWriter((OutputStream)traceOutput);
            } else if (traceOutput instanceof LDAPTraceWriter) {
                this.m_traceOutput = traceOutput;
            }
        }
    }
}

