/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSyntaxSchemaElement;

public class LDAPMatchingRuleSchema
extends LDAPAttributeSchema {
    static final long serialVersionUID = 6466155218986944131L;
    static final String[] EXPLICIT = new String[]{"OBSOLETE", "SYNTAX"};
    private String[] attributes = null;

    public LDAPMatchingRuleSchema(String raw, String use) {
        String val;
        Vector v;
        this.attrName = "matchingrules";
        if (raw != null) {
            this.parseValue(raw);
        }
        if (use != null) {
            this.parseValue(use);
        }
        if ((v = (Vector)this.properties.get("APPLIES")) != null) {
            this.attributes = new String[v.size()];
            v.copyInto(this.attributes);
            v.removeAllElements();
        }
        if ((val = (String)this.properties.get("SYNTAX")) != null) {
            this.syntaxElement.syntaxString = val;
            this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(val);
        }
    }

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, int syntax) {
        this(name, oid, description, attributes, "1.3.6.1.4.1.1466.115.121.1.15");
        this.syntaxElement.syntax = syntax;
        String syntaxType = LDAPSyntaxSchemaElement.internalSyntaxToString(syntax);
        if (syntaxType != null) {
            this.syntaxElement.syntaxString = syntaxType;
        }
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
    }

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, String syntaxString) {
        this(name, oid, description, attributes, syntaxString, null);
    }

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, String syntaxString, String[] aliases) {
        if (oid == null || oid.trim().length() < 1) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = name;
        this.oid = oid;
        this.description = description;
        this.attrName = "matchingrules";
        this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(syntaxString);
        this.syntaxElement.syntaxString = syntaxString;
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
        this.attributes = new String[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            this.attributes[i] = attributes[i];
            ++i;
        }
        if (aliases != null && aliases.length > 0) {
            this.aliases = aliases;
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getUseValue() {
        String s = this.getValuePrefix();
        if (this.attributes != null && this.attributes.length > 0) {
            s = String.valueOf(s) + "APPLIES ( ";
            int i = 0;
            while (i < this.attributes.length) {
                if (i > 0) {
                    s = String.valueOf(s) + " $ ";
                }
                s = String.valueOf(s) + this.attributes[i];
                ++i;
            }
            s = String.valueOf(s) + " ) ";
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String getValue() {
        return this.getValue(false);
    }

    String getValue(boolean quotingBug) {
        String val;
        String s = this.getValuePrefix();
        if (this.syntaxElement.syntaxString != null) {
            s = String.valueOf(s) + "SYNTAX ";
            if (quotingBug) {
                s = String.valueOf(s) + '\'';
            }
            s = String.valueOf(s) + this.syntaxElement.syntaxString;
            if (quotingBug) {
                s = String.valueOf(s) + '\'';
            }
            s = String.valueOf(s) + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        s = String.valueOf(s) + this.syntaxElement.syntaxToString();
        s = String.valueOf(s) + "; Description: " + this.description;
        if (this.attributes != null) {
            s = String.valueOf(s) + "; Applies to: ";
            int i = 0;
            while (i < this.attributes.length) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + this.attributes[i];
                ++i;
            }
        }
        s = String.valueOf(s) + this.getQualifierString(EXPLICIT);
        s = String.valueOf(s) + this.getAliasString();
        return s;
    }

    protected void update(LDAPConnection ld, int op, String name, String dn) throws LDAPException {
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("matchingRules", this.getValue()), new LDAPAttribute("matchingRuleUse", this.getUseValue())};
        this.update(ld, op, attrs, dn);
    }
}

