/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;

public class LDAPSearchConstraints
extends LDAPConstraints
implements Cloneable {
    private int deref;
    private int maxRes;
    private int batch;
    private int serverTimeLimit;
    private int maxBacklog = 100;

    public LDAPSearchConstraints() {
        this.deref = 0;
        this.maxRes = 1000;
        this.batch = 1;
        this.serverTimeLimit = 0;
    }

    public LDAPSearchConstraints(int msLimit, int timeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPBind bind_proc, int hop_limit) {
        super(msLimit, doReferrals, bind_proc, hop_limit);
        this.serverTimeLimit = timeLimit;
        this.deref = dereference;
        this.maxRes = maxResults;
        this.batch = batchSize;
    }

    public LDAPSearchConstraints(int msLimit, int timeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebind_proc, int hop_limit) {
        super(msLimit, doReferrals, rebind_proc, hop_limit);
        this.serverTimeLimit = timeLimit;
        this.deref = dereference;
        this.maxRes = maxResults;
        this.batch = batchSize;
    }

    public LDAPSearchConstraints(int msLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebind_proc, int hop_limit) {
        super(msLimit, doReferrals, rebind_proc, hop_limit);
        this.deref = dereference;
        this.maxRes = maxResults;
        this.batch = batchSize;
    }

    public Object clone() {
        LDAPControl[] tServerControls;
        LDAPSearchConstraints o = new LDAPSearchConstraints();
        o.serverTimeLimit = this.serverTimeLimit;
        o.deref = this.deref;
        o.maxRes = this.maxRes;
        o.batch = this.batch;
        o.maxBacklog = this.maxBacklog;
        o.setHopLimit(this.getHopLimit());
        o.setReferrals(this.getReferrals());
        o.setTimeLimit(this.getTimeLimit());
        if (this.getBindProc() != null) {
            o.setBindProc(this.getBindProc());
        } else {
            o.setRebindProc(this.getRebindProc());
        }
        LDAPControl[] tClientControls = this.getClientControls();
        if (tClientControls != null && tClientControls.length > 0) {
            LDAPControl[] oClientControls = new LDAPControl[tClientControls.length];
            int i = 0;
            while (i < tClientControls.length) {
                oClientControls[i] = (LDAPControl)tClientControls[i].clone();
                ++i;
            }
            o.setClientControls(oClientControls);
        }
        if ((tServerControls = this.getServerControls()) != null && tServerControls.length > 0) {
            LDAPControl[] oServerControls = new LDAPControl[tServerControls.length];
            int i = 0;
            while (i < tServerControls.length) {
                oServerControls[i] = (LDAPControl)tServerControls[i].clone();
                ++i;
            }
            o.setServerControls(oServerControls);
        }
        return o;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public int getDereference() {
        return this.deref;
    }

    public int getMaxBacklog() {
        return this.maxBacklog;
    }

    public int getMaxResults() {
        return this.maxRes;
    }

    public int getServerTimeLimit() {
        return this.serverTimeLimit;
    }

    public void setBatchSize(int batchSize) {
        this.batch = batchSize;
    }

    public void setDereference(int dereference) {
        this.deref = dereference;
    }

    public void setMaxBacklog(int backlog) {
        this.maxBacklog = backlog;
    }

    public void setMaxResults(int maxResults) {
        this.maxRes = maxResults;
    }

    public void setServerTimeLimit(int limit) {
        this.serverTimeLimit = limit;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LDAPSearchConstraints {");
        sb.append(String.valueOf(super.toString()) + ' ');
        sb.append("size limit " + this.maxRes + ", ");
        sb.append("server time limit " + this.serverTimeLimit + ", ");
        sb.append("aliases " + this.deref + ", ");
        sb.append("batch size " + this.batch + ", ");
        sb.append("max backlog " + this.maxBacklog);
        sb.append('}');
        return sb.toString();
    }
}

