/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;

public class BERReal
extends BERElement {
    public static final float PLUS_INFINITY = Float.POSITIVE_INFINITY;
    public static final float MINUS_INFINITY = Float.NEGATIVE_INFINITY;
    private float m_value = 0.0f;

    public BERReal(float value) {
        this.m_value = value;
    }

    public BERReal(InputStream stream, int[] bytes_read) throws IOException {
        int length = BERElement.readLengthOctets(stream, bytes_read);
        if (length == 0) {
            this.m_value = 0.0f;
        } else {
            int octet = stream.read();
            bytes_read[0] = bytes_read[0] + 1;
            if (octet == 64) {
                this.m_value = Float.POSITIVE_INFINITY;
            } else if (octet == 65) {
                this.m_value = Float.NEGATIVE_INFINITY;
            } else if ((octet & 0x80) > 0) {
                int exponent;
                int num_exponent_octets;
                int sign = (octet & 0x40) > 0 ? -1 : 1;
                int base = (octet & 0x20) > 0 ? ((octet & 0x10) > 0 ? 0 : 16) : ((octet & 0x10) > 0 ? 8 : 2);
                int f = (octet & 8) > 0 ? ((octet & 4) > 0 ? 3 : 2) : ((octet & 4) > 0 ? 1 : 0);
                if ((octet & 2) > 0) {
                    if ((octet & 1) > 0) {
                        num_exponent_octets = stream.read();
                        bytes_read[0] = bytes_read[0] + 1;
                        exponent = this.readTwosComplement(stream, bytes_read, num_exponent_octets);
                    } else {
                        num_exponent_octets = 3;
                        exponent = this.readTwosComplement(stream, bytes_read, num_exponent_octets);
                    }
                } else if ((octet & 1) > 0) {
                    num_exponent_octets = 2;
                    exponent = this.readTwosComplement(stream, bytes_read, num_exponent_octets);
                } else {
                    num_exponent_octets = 1;
                    exponent = this.readTwosComplement(stream, bytes_read, num_exponent_octets);
                }
                int contents_length_left = length - 1 - num_exponent_octets;
                int number = this.readUnsignedBinary(stream, bytes_read, contents_length_left);
                int mantissa = (int)((double)(sign * number) * Math.pow(2.0, f));
                this.m_value = (float)mantissa * (float)Math.pow(base, exponent);
            } else {
                throw new IOException("real ISO6093 not supported. ");
            }
        }
    }

    public int getType() {
        return 9;
    }

    public String toString() {
        return "Real {" + this.m_value + "}";
    }

    public void write(OutputStream stream) throws IOException {
        if (this.m_value == 0.0f) {
            stream.write(9);
            stream.write(0);
        } else if (this.m_value == Float.POSITIVE_INFINITY) {
            stream.write(9);
            stream.write(1);
            stream.write(64);
        } else if (this.m_value == Float.NEGATIVE_INFINITY) {
            stream.write(9);
            stream.write(1);
            stream.write(65);
        }
    }
}

