/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERUTCTime
extends BERElement {
    private String m_value;
    private byte[] byte_buf;

    public BERUTCTime(InputStream stream, int[] bytes_read) throws IOException {
        block3: {
            this.m_value = null;
            int contents_length = BERElement.readLengthOctets(stream, bytes_read);
            if (contents_length <= 0) break block3;
            byte[] byte_buf = new byte[contents_length];
            int i = 0;
            while (i < contents_length) {
                byte_buf[i] = (byte)stream.read();
                ++i;
            }
            bytes_read[0] = bytes_read[0] + contents_length;
            try {
                this.m_value = new String(byte_buf, "UTF8");
            }
            catch (Throwable throwable) {}
        }
    }

    public BERUTCTime(String utc_string) {
        this.m_value = null;
        this.m_value = utc_string;
    }

    public BERUTCTime(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        this.m_value = null;
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        int[] component_length = new int[1];
        BERElement element = null;
        this.m_value = "";
        if (contents_length == -1) {
            component_length[0] = 0;
            element = BERElement.getElement(decoder, stream, component_length);
            if (element != null) {
                BERUTCTime utc_element = (BERUTCTime)element;
                this.m_value = String.valueOf(this.m_value) + utc_element.getValue();
            }
            while (element != null) {
            }
        } else {
            bytes_read[0] = bytes_read[0] + contents_length;
            while (contents_length > 0) {
                component_length[0] = 0;
                element = BERElement.getElement(decoder, stream, component_length);
                if (element != null) {
                    BERUTCTime utc_element = (BERUTCTime)element;
                    this.m_value = String.valueOf(this.m_value) + utc_element.getValue();
                }
                contents_length -= component_length[0];
            }
        }
    }

    public int getType() {
        return 23;
    }

    public String getValue() {
        return this.m_value;
    }

    public String toString() {
        if (this.m_value == null) {
            return "UTCTime (null)";
        }
        return "UTCTime {" + this.m_value + "}";
    }

    public void write(OutputStream stream) throws IOException {
        stream.write((byte)this.getType());
        if (this.m_value == null) {
            BERElement.sendDefiniteLength(stream, 0);
        } else {
            try {
                this.byte_buf = this.m_value.getBytes("UTF8");
                BERElement.sendDefiniteLength(stream, this.byte_buf.length);
            }
            catch (Throwable throwable) {}
            stream.write(this.byte_buf, 0, this.byte_buf.length);
        }
    }
}

