/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResponse
implements JDAPProtocolOp {
    protected String m_object_name = null;
    protected BERElement m_element = null;
    protected LDAPAttribute[] m_attributes = null;

    public JDAPSearchResponse(BERElement element) throws IOException {
        this.m_element = element;
        BERTag tag = (BERTag)element;
        BERSequence seq = (BERSequence)tag.getValue();
        BEROctetString name = (BEROctetString)seq.elementAt(0);
        byte[] buf = null;
        buf = name.getValue();
        if (buf == null) {
            this.m_object_name = null;
        } else {
            try {
                this.m_object_name = new String(buf, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        BERSequence attrs = (BERSequence)seq.elementAt(1);
        if (attrs.size() > 0) {
            this.m_attributes = new LDAPAttribute[attrs.size()];
            int i = 0;
            while (i < attrs.size()) {
                this.m_attributes[i] = new LDAPAttribute(attrs.elementAt(i));
                ++i;
            }
        }
    }

    public LDAPAttribute[] getAttributes() {
        return this.m_attributes;
    }

    public BERElement getBERElement() {
        return this.m_element;
    }

    public String getObjectName() {
        return this.m_object_name;
    }

    public int getType() {
        return 4;
    }

    public String toString() {
        String s = "";
        if (this.m_attributes != null) {
            int i = 0;
            while (i < this.m_attributes.length) {
                if (i != 0) {
                    s = String.valueOf(s) + ",";
                }
                s = String.valueOf(s) + this.m_attributes[i].toString();
                ++i;
            }
        }
        return "SearchResponse {entry='" + this.m_object_name + "', attributes='" + s + "'}";
    }
}

