/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import com.netscape.jss.CryptoManager;
import com.netscape.jss.crypto.AlreadyInitializedException;
import com.netscape.jss.crypto.X509Certificate;
import com.netscape.jss.ssl.SSLCertificateApprovalCallback;
import com.netscape.jss.ssl.SSLSocket;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;

public class JSSSocketFactory
implements Serializable,
LDAPSocketFactory,
SSLCertificateApprovalCallback {
    static final long serialVersionUID = -6926469178017736902L;
    public static final String defaultModDB = "secmod.db";
    public static final String defaultKeyDB = "key3.db";
    public static final String defaultCertDB = "cert7.db";
    private static String moddb;
    private static String keydb;
    private static String certdb;
    private static boolean initialized;

    static {
        initialized = false;
    }

    public JSSSocketFactory() throws LDAPException {
        if (!initialized) {
            JSSSocketFactory.initialize(defaultModDB, defaultKeyDB, defaultCertDB);
        }
    }

    public boolean approve(X509Certificate serverCert, SSLCertificateApprovalCallback.ValidityStatus status) {
        return true;
    }

    public static String getCertDB() {
        return certdb;
    }

    public static String getKeyDB() {
        return keydb;
    }

    public static String getModDB() {
        return moddb;
    }

    public static void initialize(String certdbDir) throws LDAPException {
        String moddb = String.valueOf(certdbDir) + File.separator + defaultModDB;
        String keydb = String.valueOf(certdbDir) + File.separator + defaultKeyDB;
        String certdb = String.valueOf(certdbDir) + File.separator + defaultCertDB;
        JSSSocketFactory.initialize(moddb, keydb, certdb);
    }

    public static void initialize(String moddb, String keydb, String certdb) throws LDAPException {
        if (initialized) {
            throw new LDAPException("JSSSocketFactory is already initialized", 80);
        }
        try {
            JSSSocketFactory.moddb = moddb;
            JSSSocketFactory.keydb = keydb;
            JSSSocketFactory.certdb = certdb;
            initialized = true;
            CryptoManager.initialize((String)moddb, (String)keydb, (String)certdb);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception e) {
            throw new LDAPException("Failed to initialize JSSSocketFactory: " + e.getMessage(), 80);
        }
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        SSLSocket socket = null;
        try {
            socket = new SSLSocket(InetAddress.getByName(host), port, null, 0, true, (SSLCertificateApprovalCallback)this, null);
            socket.forceHandshake();
        }
        catch (Exception e) {
            throw new LDAPException("SSL connection to " + host + ":" + port + ", " + e.getMessage(), 91);
        }
        return socket;
    }
}

