/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.util.LDAPWriter;
import netscape.ldap.util.LDIF;

public class DSMLWriter
extends LDAPWriter {
    public DSMLWriter(PrintWriter pw) {
        super(pw);
    }

    protected void printAttribute(LDAPAttribute attr) {
        String attrName = attr.getName();
        if (attrName.equalsIgnoreCase("objectclass")) {
            Enumeration enumVals = attr.getStringValues();
            if (enumVals != null) {
                while (enumVals.hasMoreElements()) {
                    String s = (String)enumVals.nextElement();
                    this.printString("    <dsml:objectclass>" + s + "</dsml:objectclass>");
                }
            }
            return;
        }
        this.printString("    <dsml:attr name=\"" + attrName + "\">");
        Enumeration enumVals = attr.getByteValues();
        if (enumVals != null) {
            while (enumVals.hasMoreElements()) {
                String s;
                byte[] b = (byte[])enumVals.nextElement();
                if (LDIF.isPrintable(b)) {
                    try {
                        s = new String(b, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        s = "";
                    }
                    this.printEscapedValue("      <dsml:value>", s, "</dsml:value>");
                    continue;
                }
                s = this.getPrintableValue(b);
                if (s.length() <= 0) continue;
                this.printString("      <dsml:value encoding=\"base64\">");
                this.printString("       " + s);
                this.printString("      </dsml:value>");
            }
        }
        this.printString("    </dsml:attr>");
    }

    protected void printAttributeSchema(LDAPSchema schema) {
        Enumeration en = schema.getAttributes();
        while (en.hasMoreElements()) {
            String[] vals;
            LDAPAttributeSchema s = (LDAPAttributeSchema)en.nextElement();
            this.printString("    <dsml:attribute-type");
            this.printString("      id=\"" + s.getName() + "\"");
            this.printString("      oid=\"" + s.getID() + "\"");
            String superior = s.getSuperior();
            if (superior != null) {
                this.printString("      superior=\"#" + superior + "\"");
            }
            if (s.isSingleValued()) {
                this.printString("      single-value=true");
            }
            if (s.isObsolete()) {
                this.printString("      obsolete=true");
            }
            if (s.getQualifier("NO-USER-MODIFICATION") != null) {
                this.printString("      user-modification=false");
            }
            if ((vals = s.getQualifier("EQUALITY")) != null && vals.length > 0) {
                this.printString("      equality=" + vals[0]);
            }
            if ((vals = s.getQualifier("ORDERING")) != null && vals.length > 0) {
                this.printString("      ordering=" + vals[0]);
            }
            if ((vals = s.getQualifier("SUBSTR")) != null && vals.length > 0) {
                this.printString("      substring=" + vals[0]);
            }
            this.printString("      <dsml:name>" + s.getName() + "</dsml:name>");
            this.printString("      <dsml:description>" + s.getDescription() + "</dsml:description>");
            this.printString("      <dsml:syntax>" + s.getSyntaxString() + "</dsml:syntax>");
            this.printString("    </dsml:attribute-type>");
        }
    }

    protected void printEntryEnd(String dn) {
        this.printString("  </dsml:entry>");
    }

    protected void printEntryStart(String dn) {
        if (dn == null) {
            dn = "";
        }
        this.printString("  <dsml:entry dn=\"" + dn + "\">");
    }

    protected void printEscapedValue(String prolog, String value, String epilog) {
        this.m_pw.print(prolog);
        int l = value.length();
        char[] text = new char[l];
        value.getChars(0, l, text, 0);
        int i = 0;
        while (i < l) {
            char c = text[i];
            switch (c) {
                case '<': {
                    this.m_pw.print("&lt;");
                    break;
                }
                case '&': {
                    this.m_pw.print("&amp;");
                    break;
                }
                default: {
                    this.m_pw.print(c);
                }
            }
            ++i;
        }
        this.m_pw.print(epilog);
        this.m_pw.print('\n');
    }

    protected void printObjectClassSchema(LDAPSchema schema) {
        Enumeration en = schema.getObjectClasses();
        while (en.hasMoreElements()) {
            LDAPObjectClassSchema s = (LDAPObjectClassSchema)en.nextElement();
            this.printString("    <dsml:class");
            this.printString("      id=\"" + s.getName() + "\"");
            this.printString("      oid=\"" + s.getID() + "\"");
            String[] superiors = s.getSuperiors();
            if (superiors != null) {
                int i = 0;
                while (i < superiors.length) {
                    this.printString("      superior=\"#" + superiors[i] + "\"");
                    ++i;
                }
            }
            String classType = "structural";
            switch (s.getType()) {
                case 1: {
                    classType = "abstract";
                    break;
                }
                case 2: {
                    classType = "auxiliary";
                    break;
                }
            }
            this.printString("      type=\"" + classType + "\">");
            if (s.isObsolete()) {
                this.printString("      obsolete=true");
            }
            this.printString("      <dsml:name>" + s.getName() + "</dsml:name>");
            this.printString("      <dsml:description>" + s.getDescription() + "</dsml:description>");
            Enumeration attrs = s.getRequiredAttributes();
            while (attrs.hasMoreElements()) {
                this.printString("      <dsml:attribute ref=\"#" + (String)attrs.nextElement() + "\" required=\"true\"/>");
            }
            attrs = s.getOptionalAttributes();
            while (attrs.hasMoreElements()) {
                this.printString("      <dsml:attribute ref=\"#" + (String)attrs.nextElement() + "\" required=\"false\"/>");
            }
            this.printString("    </dsml:class>");
        }
    }

    public void printSchema(LDAPEntry entry) {
        LDAPSchema schema = new LDAPSchema(entry);
        this.printString("  <dsml:directory-schema>");
        this.printObjectClassSchema(schema);
        this.printAttributeSchema(schema);
        this.printString("  </dsml:directory-schema>");
    }

    protected void printString(String value) {
        this.m_pw.print(value);
        this.m_pw.print('\n');
    }
}

