/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.util.LDAPWriter;
import netscape.ldap.util.LDIF;

public class LDIFWriter
extends LDAPWriter {
    private String m_sep;
    private boolean m_foldLines;
    private boolean m_attrsOnly;
    private boolean m_toFiles;
    private static final String DEFAULT_SEPARATOR = ":";
    private static final int MAX_LINE = 77;

    public LDIFWriter(PrintWriter pw) {
        this(pw, false, DEFAULT_SEPARATOR, true, false);
    }

    public LDIFWriter(PrintWriter pw, boolean attrsOnly, String separator, boolean foldLines, boolean toFiles) {
        super(pw);
        this.m_attrsOnly = attrsOnly;
        this.m_sep = separator;
        this.m_foldLines = foldLines;
        this.m_toFiles = toFiles;
    }

    protected FileOutputStream getTempFile(String name) throws IOException {
        String filename;
        File f;
        int num = 0;
        do {
            filename = String.valueOf(name) + '.' + num;
            f = new File(filename);
            ++num;
        } while (f.exists());
        this.printString(String.valueOf(name) + this.m_sep + " " + filename);
        return new FileOutputStream(f);
    }

    /*
     * Unable to fully structure code
     */
    protected void printAttribute(LDAPAttribute attr) {
        attrName = attr.getName();
        if (this.m_attrsOnly) {
            this.printString(String.valueOf(attrName) + this.m_sep);
            return;
        }
        enumVals = attr.getByteValues();
        if (enumVals != null) ** GOTO lbl32
        this.printString(String.valueOf(attrName) + this.m_sep + ' ');
        return;
lbl-1000:
        // 1 sources

        {
            if (this.m_toFiles) {
                try {
                    f = this.getTempFile(attrName);
                    f.write((byte[])enumVals.nextElement());
                }
                catch (Exception e) {
                    System.err.println("Error writing values of " + attrName + ", " + e.toString());
                    System.exit(1);
                }
                continue;
            }
            b = (byte[])enumVals.nextElement();
            if (LDIF.isPrintable(b)) {
                try {
                    s = new String(b, "UTF8");
                }
                catch (UnsupportedEncodingException v0) {
                    s = "";
                }
                this.printString(String.valueOf(attrName) + this.m_sep + " " + s);
                continue;
            }
            s = this.getPrintableValue(b);
            if (s.length() > 0) {
                this.printString(String.valueOf(attrName) + ":: " + s);
                continue;
            }
            this.printString(String.valueOf(attrName) + this.m_sep + ' ');
lbl32:
            // 6 sources

            ** while (enumVals.hasMoreElements())
        }
lbl33:
        // 1 sources

    }

    protected void printEntryEnd(String dn) {
        this.m_pw.println();
    }

    protected void printEntryStart(String dn) {
        if (dn == null) {
            dn = "";
        } else {
            byte[] b = null;
            try {
                b = dn.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (!LDIF.isPrintable(b)) {
                dn = this.getPrintableValue(b);
            }
        }
        this.printString("dn" + this.m_sep + " " + dn);
    }

    protected void printString(String value) {
        if (this.m_foldLines) {
            LDIF.breakString(this.m_pw, value, 77);
        } else {
            this.m_pw.print(value);
            this.m_pw.print('\n');
        }
    }
}

