/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.manager;

import com.sun.apoc.manager.ProfileWindowFramesetViewBean;
import com.sun.apoc.manager.Toolbox2;
import com.sun.apoc.manager.settings.PolicyMgrHelper;
import com.sun.apoc.spi.SPIException;
import com.sun.apoc.spi.cfgtree.property.Property;
import com.sun.apoc.templates.parsing.TemplateProperty;
import com.sun.apoc.templates.parsing.TemplatePropertyConstraint;
import com.sun.web.ui.common.CCDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class ChooserHelper {
    private ArrayList m_elementsList = new ArrayList();
    private ArrayList m_statesList = new ArrayList();
    private TemplateProperty m_chooser = null;
    private TemplateProperty m_definedChooser = null;
    private String m_definedChooserPath = null;
    private boolean m_saveRequired = false;
    public static final String LIST_WIDTH_STRING = "______________________________";
    public static final String SYSTEM_ADDED_FLAG = " (*)";
    public static final String LIST_SEPARATOR = ";";
    private static final String STATELIST_DATAPATH = "_states";

    public ChooserHelper(String string) {
        this.m_definedChooser = this.m_chooser = Toolbox2.getProperty(string);
        this.m_definedChooserPath = string;
        this.initChooserHelper();
    }

    private void initChooserHelper() {
        String string = this.m_chooser.getExtendsChooser();
        if (string != null) {
            this.m_definedChooser = Toolbox2.getProperty(string);
            this.m_definedChooserPath = string;
        }
        try {
            PolicyMgrHelper policyMgrHelper = ProfileWindowFramesetViewBean.getProfileHelper();
            Property property = policyMgrHelper.getProperty(this.m_definedChooser.getChooserPath());
            Property property2 = policyMgrHelper.getProperty(this.m_definedChooser.getChooserPath() + STATELIST_DATAPATH);
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (property != null) {
                stringArray = property.getValue().split(LIST_SEPARATOR);
                stringArray2 = property2.getValue().split(LIST_SEPARATOR);
            } else {
                stringArray = this.getDefaultElementsList();
                stringArray2 = this.getDefaultStatesList(stringArray.length);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_elementsList.add(stringArray[i]);
                this.m_statesList.add(stringArray2[i]);
            }
        }
        catch (SPIException sPIException) {
            CCDebug.trace1((String)"Error initializing chooser settings!", (Throwable)sPIException);
        }
    }

    private String[] getDefaultElementsList() {
        return this.getSortedConstraints(this.m_definedChooser.getConstraints());
    }

    private String[] getDefaultStatesList(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "false";
        }
        return stringArray;
    }

    private String[] getSortedConstraints(Vector vector) {
        String[] stringArray = null;
        if (vector != null) {
            stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                TemplatePropertyConstraint templatePropertyConstraint = (TemplatePropertyConstraint)vector.elementAt(i);
                stringArray[i] = templatePropertyConstraint.getValue();
            }
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void saveChanges() {
        String string = this.m_definedChooser.getChooserPath();
        PolicyMgrHelper policyMgrHelper = ProfileWindowFramesetViewBean.getProfileHelper();
        try {
            Property property = policyMgrHelper.getProperty(string);
            Property property2 = policyMgrHelper.getProperty(string + STATELIST_DATAPATH);
            if (property == null) {
                property = policyMgrHelper.createProperty(string);
                property2 = policyMgrHelper.createProperty(string + STATELIST_DATAPATH);
            }
            property.putString(this.getElementsStringList());
            property2.putString(this.getStatesStringList());
            policyMgrHelper.flushAllChanges();
        }
        catch (SPIException sPIException) {
            CCDebug.trace1((String)"Error saving changes for chooser!", (Throwable)sPIException);
        }
    }

    public String getElementsStringList() {
        String string = "";
        for (int i = 0; i < this.m_elementsList.size(); ++i) {
            string = string.concat((String)this.m_elementsList.get(i)).concat(LIST_SEPARATOR);
        }
        return string;
    }

    public String getStatesStringList() {
        String string = "";
        for (int i = 0; i < this.m_statesList.size(); ++i) {
            string = string.concat((String)this.m_statesList.get(i)).concat(LIST_SEPARATOR);
        }
        return string;
    }

    public ArrayList getElementsList() {
        return this.m_elementsList;
    }

    public ArrayList getStatesList() {
        return this.m_statesList;
    }

    public TemplateProperty getDefiningChooser() {
        return this.m_definedChooser;
    }

    public String getDefiningChooserPath() {
        return this.m_definedChooserPath;
    }

    public String getDefaultElementsStringList() {
        String[] stringArray = this.getDefaultElementsList();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string.concat(stringArray[i]).concat(LIST_SEPARATOR);
        }
        return string;
    }

    public void setElementsList(String string, String string2) {
        this.m_elementsList.clear();
        String[] stringArray = string.split(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_elementsList.add(stringArray[i]);
        }
    }

    public void setStatesList(String string, String string2) {
        this.m_statesList.clear();
        String[] stringArray = string.split(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_statesList.add(stringArray[i]);
        }
    }

    public void setElementsList(ArrayList arrayList) {
        this.m_elementsList.clear();
        this.m_elementsList = arrayList;
    }

    public void setStatesList(ArrayList arrayList) {
        this.m_statesList.clear();
        this.m_statesList = arrayList;
    }

    public void setSystemElements(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            this.addToSortedList(string);
        }
        if (this.m_saveRequired) {
            this.saveChanges();
            this.m_saveRequired = false;
        }
    }

    private void addToSortedList(String string) {
        String string2;
        for (int i = 0; i < this.m_elementsList.size() && string.compareToIgnoreCase(string2 = (String)this.m_elementsList.get(i)) != 0; ++i) {
            if (string.compareToIgnoreCase(string2) < 0) {
                this.m_elementsList.add(i, string);
                this.m_statesList.add(i, "true");
                this.m_saveRequired = true;
                break;
            }
            if (i != this.m_elementsList.size() - 1) continue;
            this.m_elementsList.add(string);
            this.m_statesList.add("true");
            this.m_saveRequired = true;
            break;
        }
    }
}

